/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.property;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.utilShare.CopyUtils;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.ms.file.MSFileInfo;

public class CopyFilesRunnableWithProgress
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(CopyFilesRunnableWithProgress.class);
    private final Entry entry;
    private boolean bSuccess;
    private boolean bCanceled;
    private String msPath;
    private String msEntryPath;
    private List<MSPropertyDataFile> allFiles;

    public CopyFilesRunnableWithProgress(List<MSPropertyDataFile> allFiles, Entry newMSEntry, String sMsPath, String entryPath) {
        this.allFiles = allFiles;
        this.entry = newMSEntry;
        this.bSuccess = false;
        this.bCanceled = false;
        this.msPath = sMsPath;
        this.msEntryPath = entryPath;
    }

    public boolean iCanceled() {
        return this.bCanceled;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                this.bSuccess = false;
                if (monitor != null) {
                    monitor.beginTask("Copying files into workspace....", -1);
                }
                long startTime = System.currentTimeMillis();
                try {
                    this.copyFilesToLocalFolder(this.allFiles, this.entry, this.msPath, this.msEntryPath, monitor);
                    this.bSuccess = true;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                long endTime = System.currentTimeMillis();
                logger.debug((Object)("Time : " + (endTime - startTime)));
                if (monitor != null) {
                    this.bCanceled = monitor.isCanceled();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Error encountered performing annotation.", (Throwable)ex);
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public boolean isSuccessful() {
        return this.bSuccess;
    }

    private void copyFilesToLocalFolder(List<MSPropertyDataFile> allFiles, Entry entry, String msPath, String msEntryPath, IProgressMonitor monitor) {
        boolean bCleanUp = false;
        try {
            if (allFiles == null) {
                return;
            }
            String[] fileNameArray = null;
            for (MSPropertyDataFile dataFile : allFiles) {
                if (monitor == null || !monitor.isCanceled()) {
                    if (dataFile.getName() != null && !dataFile.getName().isEmpty()) {
                        String endWith = MSFileInfo.getMSFormat((String)dataFile.getType());
                        fileNameArray = this.getFilePathsInLocalFolder(dataFile.getName(), "." + endWith, msPath, msEntryPath);
                        this.copyFileToLocalFolder(dataFile.getName(), fileNameArray[0], fileNameArray[1], msPath, monitor);
                        dataFile.setName(fileNameArray[1]);
                    }
                    if (dataFile.getChildren() != null && !dataFile.getChildren().isEmpty()) {
                        for (MSPropertyDataFile child : dataFile.getChildren()) {
                            String endWith = MSFileInfo.getMSFormat((String)child.getType());
                            fileNameArray = this.getFilePathsInLocalFolder(child.getName(), "." + endWith, msPath, msEntryPath);
                            this.copyFileToLocalFolder(child.getName(), fileNameArray[0], fileNameArray[1], msPath, monitor);
                            child.setName(fileNameArray[1]);
                        }
                    }
                }
                if (monitor == null || !monitor.isCanceled()) continue;
                bCleanUp = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            bCleanUp = true;
        }
        if (bCleanUp) {
            for (MSPropertyDataFile dataFile : allFiles) {
                String endWith = MSFileInfo.getMSFormat((String)dataFile.getType());
                String[] fileNameArray = this.getFilePathsInLocalFolder(dataFile.getName(), "." + endWith, msPath, msEntryPath);
                CopyFilesRunnableWithProgress.removeFile(fileNameArray[0]);
            }
        }
    }

    private static void removeFile(String fileName) {
        try {
            if (fileName == null || fileName.equals("")) {
                return;
            }
            File file1 = new File(fileName);
            if (file1.exists()) {
                file1.delete();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private String[] getFilePathsInLocalFolder(String filepath, String endWith, String msPath, String msEntryPath) {
        String oldFilePath = filepath.replace("\\", "/");
        int inx = oldFilePath.lastIndexOf(".");
        if (inx > 0) {
            oldFilePath = String.valueOf(oldFilePath.substring(0, inx)) + endWith;
        }
        String oldFile = oldFilePath.substring(oldFilePath.lastIndexOf("/") + 1);
        String newfileName = String.valueOf(msEntryPath) + File.separator + oldFile;
        String newPath = String.valueOf(msPath) + File.separator + newfileName;
        return new String[]{newPath, newfileName};
    }

    private void copyFileToLocalFolder(String filepath, String newPath, String newFileName, String msPath, IProgressMonitor monitor) throws IOException, JAXBException {
        if (filepath != null && filepath.length() > 0) {
            CopyUtils.copyFilesFromTo((String)filepath, (String)newPath, (IProgressMonitor)monitor);
        }
    }
}

