/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.process.loader;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPrecursorPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMScan;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.entry.ms.dialog.MassSpecPeakIntensityGrid;
import org.grits.toolbox.entry.ms.extquantfiles.process.CorrectedQuantColumnInfo;
import org.grits.toolbox.entry.ms.extquantfiles.process.ExternalQuantColumnInfo;
import org.grits.toolbox.entry.ms.extquantfiles.process.QuantFileProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.StandardQuantColumnInfo;
import org.grits.toolbox.entry.ms.extquantfiles.process.StandardQuantDataProcessor;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationPeak;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantFileToAlias;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.entry.ms.property.datamodel.QuantFilePeaksToCorrectedIntensities;
import org.grits.toolbox.entry.ms.property.datamodel.QuantFileToCorrectedPeaks;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;

public class MassSpecTableDataProcessorUtil {
    private static final Logger logger = Logger.getLogger(MassSpecTableDataProcessorUtil.class);
    public static DecimalFormat formatDec4 = new DecimalFormat("0.0000");
    public static DecimalFormat formatDec2 = new DecimalFormat("0.00");
    public static DecimalFormat formatDec1 = new DecimalFormat("0.0");

    public static int fillMassSpecColumnSettingsScan(TableViewerColumnSettings _columnSettings, int _iMSLevel, boolean bIsPseudoScan, boolean bHasSubScans) {
        try {
            int iNumColumns = 0;
            if (bIsPseudoScan) {
                _columnSettings.addColumn(DMScan.scan_pseudoScanNo.getLabel(), DMScan.scan_pseudoScanNo.name());
                ++iNumColumns;
            } else {
                _columnSettings.addColumn(DMScan.scan_scanNo.getLabel(), DMScan.scan_scanNo.name());
                ++iNumColumns;
            }
            if (_iMSLevel > 1) {
                _columnSettings.addColumn(DMPeak.peak_mz.getLabel(), DMPeak.peak_mz.name());
                _columnSettings.addColumn(DMPeak.peak_intensity.getLabel(), DMPeak.peak_intensity.name());
                _columnSettings.addColumn(DMPeak.peak_relative_intensity.getLabel(), DMPeak.peak_relative_intensity.name());
                _columnSettings.addColumn(DMPrecursorPeak.precursor_peak_mz.getLabel(), DMPrecursorPeak.precursor_peak_mz.name());
                _columnSettings.addColumn(DMPrecursorPeak.precursor_peak_intensity.getLabel(), DMPrecursorPeak.precursor_peak_intensity.name());
                _columnSettings.addColumn(DMPrecursorPeak.precursor_peak_charge.getLabel(), DMPrecursorPeak.precursor_peak_charge.name());
                _columnSettings.addColumn(DMScan.scan_parentScan.getLabel(), DMScan.scan_parentScan.name());
                iNumColumns += 7;
            }
            _columnSettings.addColumn(DMScan.scan_retentionTime.getLabel(), DMScan.scan_retentionTime.name());
            _columnSettings.addColumn(DMScan.scan_scanStart.getLabel(), DMScan.scan_scanStart.name());
            _columnSettings.addColumn(DMScan.scan_scanEnd.getLabel(), DMScan.scan_scanEnd.name());
            _columnSettings.addColumn(DMScan.scan_msLevel.getLabel(), DMScan.scan_msLevel.name());
            _columnSettings.addColumn(DMScan.scan_polarity.getLabel(), DMScan.scan_polarity.name());
            _columnSettings.addColumn(DMScan.scan_activationMethode.getLabel(), DMScan.scan_activationMethode.name());
            iNumColumns += 6;
            if (bHasSubScans) {
                _columnSettings.addColumn(DMScan.scan_numsubscans.getLabel(), DMScan.scan_numsubscans.name());
                ++iNumColumns;
            }
            return iNumColumns;
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Column Settings for Scan.", (Throwable)ex);
            return 0;
        }
    }

    public static int fillMassSpecColumnSettingsExternalQuantWCharge(TableViewerColumnSettings _columnSettings, int _iMSLevel, String _sExtQuantPrefix, String _sExtQuantLabel) {
        try {
            if (_iMSLevel > 1) {
                int iNumColumns = MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsExternalQuant(_columnSettings, _iMSLevel, _sExtQuantPrefix, _sExtQuantLabel);
                CustomExtraData cedCharge = ExternalQuantColumnInfo.getExternalQuantCharge(_sExtQuantPrefix, _sExtQuantLabel);
                _columnSettings.addColumn(cedCharge.getLabel(), cedCharge.getKey());
                return ++iNumColumns;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Column Settings for Extract.", (Throwable)ex);
        }
        return 0;
    }

    public static int fillMassSpecColumnSettingsExternalQuant(TableViewerColumnSettings _columnSettings, int _iMSLevel, String _sExtQuantPrefix, String _sExtQuantLabel) {
        int iNumColumns = 0;
        try {
            if (_iMSLevel > 1) {
                CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity(_sExtQuantPrefix, _sExtQuantLabel);
                CustomExtraData cedCorInt = ExternalQuantColumnInfo.getExternalQuantCorrectedIntensity(_sExtQuantPrefix, _sExtQuantLabel);
                CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz(_sExtQuantPrefix, _sExtQuantLabel);
                CustomExtraData cedTotInt = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity(_sExtQuantPrefix, _sExtQuantLabel);
                _columnSettings.addColumn(cedInt.getLabel(), cedInt.getKey());
                _columnSettings.addColumn(cedCorInt.getLabel(), cedCorInt.getKey());
                _columnSettings.addColumn(cedIntMz.getLabel(), cedIntMz.getKey());
                _columnSettings.addColumn(cedTotInt.getLabel(), cedTotInt.getKey());
                iNumColumns += 4;
            }
            return iNumColumns;
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Column Settings for Full MS.", (Throwable)ex);
            return 0;
        }
    }

    public static int fillMassSpecColumnSettingsExternalQuant(TableViewerColumnSettings _columnSettings, HashMap<String, Integer> htKeyToPos, String _sExtQuantPrefix, String _sExtQuantLabel) {
        try {
            CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity(_sExtQuantPrefix, _sExtQuantLabel);
            CustomExtraData cedCorInt = ExternalQuantColumnInfo.getExternalQuantCorrectedIntensity(_sExtQuantPrefix, _sExtQuantLabel);
            CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz(_sExtQuantPrefix, _sExtQuantLabel);
            CustomExtraData cedTotInt = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity(_sExtQuantPrefix, _sExtQuantLabel);
            if (htKeyToPos != null && htKeyToPos.containsKey(cedIntMz.getKey())) {
                _columnSettings.putColumn(cedIntMz.getLabel(), cedIntMz.getKey(), htKeyToPos.get(cedIntMz.getKey()).intValue());
                htKeyToPos.remove(cedIntMz.getKey());
            } else {
                _columnSettings.addColumn(cedIntMz.getLabel(), cedIntMz.getKey());
            }
            if (htKeyToPos != null && htKeyToPos.containsKey(cedCorInt.getKey())) {
                _columnSettings.putColumn(cedCorInt.getLabel(), cedCorInt.getKey(), htKeyToPos.get(cedCorInt.getKey()).intValue());
                htKeyToPos.remove(cedCorInt.getKey());
            } else {
                _columnSettings.addColumn(cedCorInt.getLabel(), cedCorInt.getKey());
            }
            if (htKeyToPos != null && htKeyToPos.containsKey(cedInt.getKey())) {
                _columnSettings.putColumn(cedInt.getLabel(), cedInt.getKey(), htKeyToPos.get(cedInt.getKey()).intValue());
                htKeyToPos.remove(cedInt.getKey());
            } else {
                _columnSettings.addColumn(cedInt.getLabel(), cedInt.getKey());
            }
            if (htKeyToPos != null && htKeyToPos.containsKey(cedTotInt.getKey())) {
                _columnSettings.putColumn(cedTotInt.getLabel(), cedTotInt.getKey(), htKeyToPos.get(cedTotInt.getKey()).intValue());
                htKeyToPos.remove(cedTotInt.getKey());
            } else {
                _columnSettings.addColumn(cedTotInt.getLabel(), cedTotInt.getKey());
            }
            return 3;
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Column Settings for Full MS Data.", (Throwable)ex);
            return 0;
        }
    }

    public static int fillMassSpecColumnSettingsExternalQuantWCharge(TableViewerColumnSettings _columnSettings, HashMap<String, Integer> htKeyToPos, String _sExtQuantPrefix, String _sExtQuantLabel) {
        try {
            int iNumColumns = MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsExternalQuant(_columnSettings, htKeyToPos, _sExtQuantPrefix, _sExtQuantLabel);
            CustomExtraData cedCharge = ExternalQuantColumnInfo.getExternalQuantCharge(_sExtQuantPrefix, _sExtQuantLabel);
            if (htKeyToPos != null && htKeyToPos.containsKey(cedCharge.getKey())) {
                _columnSettings.putColumn(cedCharge.getLabel(), cedCharge.getKey(), htKeyToPos.get(cedCharge.getKey()).intValue());
                htKeyToPos.remove(cedCharge.getKey());
            } else {
                _columnSettings.addColumn(cedCharge.getLabel(), cedCharge.getKey());
            }
            return ++iNumColumns;
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Column Settings for Extract Data.", (Throwable)ex);
            return 0;
        }
    }

    public static Double getFormattedMZValue(double dMz) {
        return new Double(formatDec4.format(dMz));
    }

    public static Double getFormattedRetentionTime(double dRT) {
        return new Double(formatDec2.format(dRT / 60.0));
    }

    public static Double getUnFormattedRetentionTime(double dRT) {
        return new Double(formatDec4.format(dRT * 60.0));
    }

    public static void fillMassSpecScanData(Scan a_scan, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings) {
        try {
            MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMScan.scan_scanNo.name()), a_scan.getScanNo(), _tableRow);
            if (a_scan.getMsLevel() > 1 && a_scan.getPrecursor() != null) {
                if (a_scan.getPrecursor().getMz() != null) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPeak.peak_mz.name()), new Double(formatDec4.format(a_scan.getPrecursor().getMz())), _tableRow);
                }
                if (a_scan.getPrecursor().getIntensity() != null) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPeak.peak_intensity.name()), new Double(formatDec1.format(a_scan.getPrecursor().getIntensity())), _tableRow);
                }
                if (a_scan.getPrecursor().getRelativeIntensity() != null) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPeak.peak_relative_intensity.name()), new Double(formatDec4.format(a_scan.getPrecursor().getRelativeIntensity())), _tableRow);
                }
                if (a_scan.getPrecursor().getPrecursorMz() != null) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_mz.name()), new Double(formatDec4.format(a_scan.getPrecursor().getPrecursorMz())), _tableRow);
                }
                if (a_scan.getPrecursor().getPrecursorIntensity() != null) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_intensity.name()), new Double(formatDec1.format(a_scan.getPrecursor().getPrecursorIntensity())), _tableRow);
                }
                if (a_scan.getPrecursor().getPrecursorCharge() != null) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_charge.name()), a_scan.getPrecursor().getPrecursorCharge(), _tableRow);
                }
                if (a_scan.getParentScan() != null) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMScan.scan_parentScan.name()), a_scan.getParentScan(), _tableRow);
                }
            }
            if (a_scan.getRetentionTime() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMScan.scan_retentionTime.name()), MassSpecTableDataProcessorUtil.getFormattedRetentionTime(a_scan.getRetentionTime()), _tableRow);
            }
            if (a_scan.getScanStart() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMScan.scan_scanStart.name()), new Double(formatDec4.format(a_scan.getScanStart())), _tableRow);
            }
            if (a_scan.getScanEnd() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMScan.scan_scanEnd.name()), new Double(formatDec4.format(a_scan.getScanEnd())), _tableRow);
            }
            if (a_scan.getMsLevel() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMScan.scan_msLevel.name()), a_scan.getMsLevel(), _tableRow);
            }
            if (a_scan.getPolarity() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMScan.scan_polarity.name()), a_scan.getPolarity(), _tableRow);
            }
            if (a_scan.getActivationMethode() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMScan.scan_activationMethode.name()), a_scan.getActivationMethode(), _tableRow);
            }
            if (a_scan.getSubScans() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMScan.scan_numsubscans.name()), a_scan.getSubScans() != null ? a_scan.getSubScans().size() : 0, _tableRow);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Row Data for Scan.", (Throwable)ex);
        }
    }

    public static void fillMassSpecScanDataExternalQuantWCharge(Scan a_scan, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings, Peak _externalPeak, String _sExtQuantPrefix, String _sExtQuantLabel) {
        if (a_scan.getMsLevel() > 1 && a_scan.getPrecursor() != null) {
            MassSpecTableDataProcessorUtil.fillMassSpecScanDataExternalQuant(a_scan, _tableRow, _columnSettings, _externalPeak, _sExtQuantPrefix, _sExtQuantLabel);
            CustomExtraData cedCharge = ExternalQuantColumnInfo.getExternalQuantCharge(_sExtQuantPrefix, _sExtQuantLabel);
            if (_externalPeak != null && _externalPeak.getIntegerProp() != null && _externalPeak.getIntegerProp().containsKey(cedCharge.getKey())) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(cedCharge.getKey()), _externalPeak.getIntegerProp().get(cedCharge.getKey()), _tableRow);
            }
        }
    }

    public static void fillMassSpecScanDataExternalQuant(Scan a_scan, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings, Peak _externalPeak, String _sExtQuantPrefix, String _sExtQuantLabel) {
        try {
            if (a_scan.getMsLevel() > 1 && a_scan.getPrecursor() != null) {
                CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity(_sExtQuantPrefix, _sExtQuantLabel);
                CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz(_sExtQuantPrefix, _sExtQuantLabel);
                CustomExtraData cedTotInt = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity(_sExtQuantPrefix, _sExtQuantLabel);
                if (_externalPeak != null && _externalPeak.getDoubleProp() != null && _externalPeak.getDoubleProp().containsKey(cedIntMz.getKey())) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(cedIntMz.getKey()), new Double(cedIntMz.getDoubleFormat().format(_externalPeak.getDoubleProp().get(cedIntMz.getKey()))), _tableRow);
                }
                if (_externalPeak != null && _externalPeak.getDoubleProp() != null && _externalPeak.getDoubleProp().containsKey(cedInt.getKey())) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(cedInt.getKey()), new Double(cedInt.getDoubleFormat().format(_externalPeak.getDoubleProp().get(cedInt.getKey()))), _tableRow);
                }
                if (_externalPeak != null && _externalPeak.getDoubleProp() != null && _externalPeak.getDoubleProp().containsKey(cedTotInt.getKey())) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(cedTotInt.getKey()), new Double(cedTotInt.getDoubleFormat().format(_externalPeak.getDoubleProp().get(cedTotInt.getKey()))), _tableRow);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Row Data for Full MS.", (Throwable)ex);
        }
    }

    public static void updateMassSpecScanData(Scan a_scan, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings, int _iMSLevel) {
        try {
            if (_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_scanNo.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_scanNo.name())).equals(a_scan.getScanNo())) {
                a_scan.setScanNo((Integer)_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_scanNo.name())));
            }
            if (_iMSLevel > 1) {
                if (_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_mz.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_mz.name())).equals(a_scan.getPrecursor().getMz())) {
                    a_scan.getPrecursor().setMz((Double)_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_mz.name())));
                }
                if (_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_intensity.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_intensity.name())).equals(a_scan.getPrecursor().getIntensity())) {
                    a_scan.getPrecursor().setIntensity((Double)_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_intensity.name())));
                }
                if (_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_relative_intensity.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_relative_intensity.name())).equals(a_scan.getPrecursor().getRelativeIntensity())) {
                    a_scan.getPrecursor().setRelativeIntensity((Double)_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_relative_intensity.name())));
                }
                if (_tableRow.get(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_mz.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_mz.name())).equals(a_scan.getPrecursor().getPrecursorMz())) {
                    a_scan.getPrecursor().setPrecursorMz((Double)_tableRow.get(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_mz.name())));
                }
                if (_tableRow.get(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_intensity.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_intensity.name())).equals(a_scan.getPrecursor().getPrecursorIntensity())) {
                    a_scan.getPrecursor().setPrecursorIntensity((Double)_tableRow.get(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_intensity.name())));
                }
                if (_tableRow.get(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_charge.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_charge.name())).equals(a_scan.getPrecursor().getPrecursorCharge())) {
                    a_scan.getPrecursor().setPrecursorCharge((Integer)_tableRow.get(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_charge.name())));
                }
                if (_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_parentScan.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_parentScan.name())).equals(a_scan.getParentScan())) {
                    a_scan.setParentScan((Integer)_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_parentScan.name())));
                }
            }
            if (_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_retentionTime.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_retentionTime.name())).equals(a_scan.getRetentionTime())) {
                a_scan.setRetentionTime(MassSpecTableDataProcessorUtil.getUnFormattedRetentionTime((Double)_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_retentionTime.name()))));
            }
            if (_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_scanEnd.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_scanEnd.name())).equals(a_scan.getScanStart())) {
                a_scan.setScanStart((Double)_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_scanEnd.name())));
            }
            if (_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_scanEnd.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_scanEnd.name())).equals(a_scan.getScanEnd())) {
                a_scan.setScanEnd((Double)_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_scanEnd.name())));
            }
            if (_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_msLevel.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_msLevel.name())).equals(a_scan.getMsLevel())) {
                a_scan.setMsLevel((Integer)_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_msLevel.name())));
            }
            if (_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_polarity.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_polarity.name())).equals(a_scan.getPolarity())) {
                a_scan.setPolarity((Boolean)_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_polarity.name())));
            }
            if (_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_activationMethode.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_activationMethode.name())).equals(a_scan.getActivationMethode())) {
                a_scan.setActivationMethode((String)_tableRow.get(_columnSettings.getColumnPosition(DMScan.scan_activationMethode.name())));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error updating Mass Spec Row Data for Scan.", (Throwable)ex);
        }
    }

    public static int fillMassSpecColumnSettingsPeakList(TableViewerColumnSettings _columnSettings) {
        try {
            _columnSettings.addColumn(DMPeak.peak_id.getLabel(), DMPeak.peak_id.name());
            _columnSettings.addColumn(DMPeak.peak_mz.getLabel(), DMPeak.peak_mz.name());
            _columnSettings.addColumn(DMPeak.peak_intensity.getLabel(), DMPeak.peak_intensity.name());
            _columnSettings.addColumn(DMPeak.peak_relative_intensity.getLabel(), DMPeak.peak_relative_intensity.name());
            _columnSettings.addColumn(DMPeak.peak_charge.getLabel(), DMPeak.peak_charge.name());
            _columnSettings.addColumn(DMPeak.peak_is_precursor.getLabel(), DMPeak.peak_is_precursor.name());
            return 6;
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Column Settings for Peak List.", (Throwable)ex);
            return 0;
        }
    }

    public static void fillMassSpecPeakListData(Scan a_scan, Peak a_peak, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings) {
        try {
            MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPeak.peak_id.name()), a_peak.getId(), _tableRow);
            MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPeak.peak_mz.name()), new Double(formatDec4.format(a_peak.getMz())), _tableRow);
            if (a_peak.getIntensity() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPeak.peak_intensity.name()), new Double(formatDec1.format(a_peak.getIntensity())), _tableRow);
            }
            if (a_peak.getRelativeIntensity() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPeak.peak_relative_intensity.name()), new Double(formatDec4.format(a_peak.getRelativeIntensity())), _tableRow);
            }
            MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPeak.peak_charge.name()), a_peak.getCharge(), _tableRow);
            MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPeak.peak_is_precursor.name()), a_peak.getIsPrecursor() ? "Yes" : "No", _tableRow);
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Row Data for Peak List.", (Throwable)ex);
        }
    }

    public static void updateMassSpecPeakListData(Scan a_scan, Peak a_peak, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings) {
        try {
            if (_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_id.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_id.name())).equals(a_peak.getId())) {
                a_peak.setId((Integer)_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_id.name())));
            }
            if (_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_charge.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_charge.name())).equals(a_peak.getCharge())) {
                a_peak.setCharge((Integer)_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_charge.name())));
            }
            if (_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_intensity.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_intensity.name())).equals(a_peak.getIntensity())) {
                a_peak.setIntensity((Double)_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_intensity.name())));
            }
            if (_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_relative_intensity.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_relative_intensity.name())).equals(a_peak.getRelativeIntensity())) {
                a_peak.setRelativeIntensity((Double)_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_relative_intensity.name())));
            }
            if (_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_mz.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_mz.name())).equals(a_peak.getMz())) {
                a_peak.setMz((Double)_tableRow.get(_columnSettings.getColumnPosition(DMPeak.peak_mz.name())));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error updating Mass Spec Row Data for Peak List.", (Throwable)ex);
        }
    }

    public static int fillMassSpecColumnSettingsPeakWithFeatures(TableViewerColumnSettings _columnSettings, boolean bIsPseudoScan) {
        try {
            if (bIsPseudoScan) {
                _columnSettings.addColumn(DMScan.scan_pseudoScanNo.getLabel(), DMScan.scan_pseudoScanNo.name());
            } else {
                _columnSettings.addColumn(DMScan.scan_scanNo.getLabel(), DMScan.scan_scanNo.name());
            }
            _columnSettings.addColumn(DMScan.scan_retentionTime.getLabel(), DMScan.scan_retentionTime.name());
            _columnSettings.addColumn(DMScan.scan_parentScan.getLabel(), DMScan.scan_parentScan.name());
            _columnSettings.addColumn(DMPeak.peak_id.getLabel(), DMPeak.peak_id.name());
            _columnSettings.addColumn(DMPeak.peak_mz.getLabel(), DMPeak.peak_mz.name());
            _columnSettings.addColumn(DMPeak.peak_intensity.getLabel(), DMPeak.peak_intensity.name());
            _columnSettings.addColumn(DMPeak.peak_relative_intensity.getLabel(), DMPeak.peak_relative_intensity.name());
            _columnSettings.addColumn(DMPrecursorPeak.precursor_peak_mz.getLabel(), DMPrecursorPeak.precursor_peak_mz.name());
            _columnSettings.addColumn(DMPrecursorPeak.precursor_peak_intensity.getLabel(), DMPrecursorPeak.precursor_peak_intensity.name());
            _columnSettings.addColumn(DMPrecursorPeak.precursor_peak_charge.getLabel(), DMPrecursorPeak.precursor_peak_charge.name());
            return 10;
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Column Settings for Peak List with Features.", (Throwable)ex);
            return 0;
        }
    }

    public static int fillMassSpecColumnSettingsPeakWithFeaturesExternalQuantWCharge(TableViewerColumnSettings _columnSettings, String _sExtQuantPrefix, String _sExtQuantLabel) {
        try {
            int iNumColumns = MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsPeakWithFeaturesExternalQuant(_columnSettings, _sExtQuantPrefix, _sExtQuantLabel);
            CustomExtraData cedCharge = ExternalQuantColumnInfo.getExternalQuantCharge(_sExtQuantPrefix, _sExtQuantLabel);
            _columnSettings.addColumn(cedCharge.getLabel(), cedCharge.getKey());
            return ++iNumColumns;
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Column Settings for Peak Features with Extract.", (Throwable)ex);
            return 0;
        }
    }

    public static int fillMassSpecColumnSettingsPeakWithFeaturesExternalQuant(TableViewerColumnSettings _columnSettings, String _sExtQuantPrefix, String _sExtQuantLabel) {
        try {
            CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity(_sExtQuantPrefix, _sExtQuantLabel);
            CustomExtraData cedCorInt = ExternalQuantColumnInfo.getExternalQuantCorrectedIntensity(_sExtQuantPrefix, _sExtQuantLabel);
            CustomExtraData cedTotInt = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity(_sExtQuantPrefix, _sExtQuantLabel);
            CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz(_sExtQuantPrefix, _sExtQuantLabel);
            _columnSettings.addColumn(cedIntMz.getLabel(), cedIntMz.getKey());
            _columnSettings.addColumn(cedCorInt.getLabel(), cedCorInt.getKey());
            _columnSettings.addColumn(cedInt.getLabel(), cedInt.getKey());
            _columnSettings.addColumn(cedTotInt.getLabel(), cedTotInt.getKey());
            return 3;
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Column Settings for Peak List with Features Full MS.", (Throwable)ex);
            return 0;
        }
    }

    public static void fillMassSpecPeakWithFeaturesData(Integer a_parentScanInt, Scan a_scan, Peak a_peak, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings, boolean bIsPseudoScan) {
        try {
            if (a_parentScanInt != null && a_parentScanInt != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMScan.scan_parentScan.name()), a_parentScanInt, _tableRow);
            }
            if (a_scan != null) {
                if (bIsPseudoScan) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMScan.scan_pseudoScanNo.name()), a_scan.getScanNo(), _tableRow);
                } else {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMScan.scan_scanNo.name()), a_scan.getScanNo(), _tableRow);
                }
                if (a_scan.getRetentionTime() != null) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMScan.scan_retentionTime.name()), MassSpecTableDataProcessorUtil.getFormattedRetentionTime(a_scan.getRetentionTime()), _tableRow);
                }
            }
            if (a_peak.getId() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPeak.peak_id.name()), a_peak.getId(), _tableRow);
            }
            if (a_peak.getMz() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPeak.peak_mz.name()), new Double(formatDec4.format(a_peak.getMz())), _tableRow);
            }
            if (a_peak.getIntensity() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPeak.peak_intensity.name()), new Double(formatDec1.format(a_peak.getIntensity())), _tableRow);
            }
            if (a_peak.getRelativeIntensity() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPeak.peak_relative_intensity.name()), new Double(formatDec4.format(a_peak.getRelativeIntensity())), _tableRow);
            }
            if (a_peak.getPrecursorMz() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_mz.name()), new Double(formatDec4.format(a_peak.getPrecursorMz())), _tableRow);
            }
            if (a_peak.getPrecursorIntensity() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_intensity.name()), new Double(formatDec1.format(a_peak.getPrecursorIntensity())), _tableRow);
            }
            if (a_peak.getPrecursorCharge() != null) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(DMPrecursorPeak.precursor_peak_charge.name()), a_peak.getPrecursorCharge(), _tableRow);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Row Data for Peak List with Features.", (Throwable)ex);
        }
    }

    public static void fillMassSpecPeakWithFeaturesDataExternalQuantWCharge(Scan a_scan, Peak _peak, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings, String _sExtQuantPrefix, String _sExtQuantLabel) {
        try {
            MassSpecTableDataProcessorUtil.fillMassSpecPeakWithFeaturesDataExternalQuant(a_scan, _peak, _tableRow, _columnSettings, _sExtQuantPrefix, _sExtQuantLabel);
            CustomExtraData cedCharge = ExternalQuantColumnInfo.getExternalQuantCharge(_sExtQuantPrefix, _sExtQuantLabel);
            if (a_scan != null && a_scan.getMsLevel() > 1 && _peak != null && _peak.getIntegerProp() != null && _peak.getIntegerProp().containsKey(cedCharge.getKey())) {
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(cedCharge.getKey()), _peak.getIntegerProp().get(cedCharge.getKey()), _tableRow);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Row Data for Peak List with Features Extract.", (Throwable)ex);
        }
    }

    public static void fillMassSpecPeakWithFeaturesDataExternalQuant(Scan a_scan, Peak _peak, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings, String _sExtQuantPrefix, String _sExtQuantLabel) {
        try {
            CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity(_sExtQuantPrefix, _sExtQuantLabel);
            CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz(_sExtQuantPrefix, _sExtQuantLabel);
            CustomExtraData cedTotInt = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity(_sExtQuantPrefix, _sExtQuantLabel);
            if (a_scan != null && a_scan.getMsLevel() > 1) {
                if (_peak != null && _peak.getDoubleProp() != null && _peak.getDoubleProp().containsKey(cedIntMz.getKey())) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(cedIntMz.getKey()), new Double(cedIntMz.getDoubleFormat().format(_peak.getDoubleProp().get(cedIntMz.getKey()))), _tableRow);
                }
                if (_peak != null && _peak.getDoubleProp() != null && _peak.getDoubleProp().containsKey(cedInt.getKey()) && _peak.getDoubleProp().get(cedInt.getKey()) != null) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(cedInt.getKey()), new Double(cedInt.getDoubleFormat().format(_peak.getDoubleProp().get(cedInt.getKey()))), _tableRow);
                }
                if (_peak != null && _peak.getDoubleProp() != null && _peak.getDoubleProp().containsKey(cedTotInt.getKey())) {
                    MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(cedTotInt.getKey()), new Double(cedTotInt.getDoubleFormat().format(_peak.getDoubleProp().get(cedTotInt.getKey()))), _tableRow);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Row Data for Peak List with Features Full MS.", (Throwable)ex);
        }
    }

    public static void fillMassSpecScanDataStandardQuant(Scan a_scan, Peak _externalPeak, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings, StandardQuantDataProcessor sqdp) {
        try {
            if (a_scan.getMsLevel() > 1 && a_scan.getPrecursor() != null && sqdp != null && sqdp != null) {
                List<Peak> peaks = sqdp.getSourcePeakListToMatch();
                if (peaks == null || peaks.isEmpty()) {
                    return;
                }
                for (Peak peak : peaks) {
                    Double dVal;
                    int iColPos;
                    Double dMz = peak.getMz();
                    String sKey = String.valueOf(sqdp.getKeyID()) + "-" + dMz.toString();
                    String sLabel = dMz.toString();
                    if (sqdp.getLabelAlias() != null && !sqdp.getLabelAlias().equals("")) {
                        sLabel = String.valueOf(sqdp.getLabelAlias()) + "-" + dMz.toString();
                    }
                    CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity(sKey, sLabel);
                    CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sKey, sLabel);
                    CustomExtraData cedDeconvoInt = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity(sKey, sLabel);
                    if (_externalPeak != null && _externalPeak.getDoubleProp() != null && _externalPeak.getDoubleProp().containsKey(cedIntMz.getKey())) {
                        iColPos = _columnSettings.getColumnPosition(cedIntMz.getKey());
                        dVal = new Double(cedIntMz.getDoubleFormat().format(_externalPeak.getDoubleProp().get(cedIntMz.getKey())));
                        MassSpecTableDataProcessorUtil.setRowValue(iColPos, dVal, _tableRow);
                    }
                    if (_externalPeak != null && _externalPeak.getDoubleProp() != null && _externalPeak.getDoubleProp().containsKey(cedInt.getKey())) {
                        iColPos = _columnSettings.getColumnPosition(cedInt.getKey());
                        dVal = new Double(cedInt.getDoubleFormat().format(_externalPeak.getDoubleProp().get(cedInt.getKey())));
                        MassSpecTableDataProcessorUtil.setRowValue(iColPos, dVal, _tableRow);
                    }
                    if (_externalPeak == null || _externalPeak.getDoubleProp() == null || !_externalPeak.getDoubleProp().containsKey(cedDeconvoInt.getKey())) continue;
                    iColPos = _columnSettings.getColumnPosition(cedDeconvoInt.getKey());
                    dVal = new Double(cedDeconvoInt.getDoubleFormat().format(_externalPeak.getDoubleProp().get(cedDeconvoInt.getKey())));
                    MassSpecTableDataProcessorUtil.setRowValue(iColPos, dVal, _tableRow);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Row Data for Full MS.", (Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int fillMassSpecColumnSettingsStandardQuantitation(TableViewerColumnSettings _columnSettings, StandardQuantDataProcessor sqdp) {
        List<Peak> peaks;
        int iNumColumns;
        block5: {
            iNumColumns = 0;
            if (sqdp == null || sqdp == null) return iNumColumns;
            peaks = sqdp.getSourcePeakListToMatch();
            if (peaks != null && !peaks.isEmpty()) break block5;
            return 0;
        }
        try {
            for (Peak peak : peaks) {
                Double dMz = peak.getMz();
                String sKey = String.valueOf(sqdp.getKeyID()) + "-" + dMz.toString();
                String sLabel = dMz.toString();
                if (sqdp.getLabelAlias() != null && !sqdp.getLabelAlias().equals("")) {
                    sLabel = String.valueOf(sqdp.getLabelAlias()) + "-" + dMz.toString();
                }
                CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity(sKey, sLabel);
                CustomExtraData cedCorInt = ExternalQuantColumnInfo.getExternalQuantCorrectedIntensity(sKey, sLabel);
                CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sKey, sLabel);
                CustomExtraData cedDeconvoInt = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity(sKey, sLabel);
                CustomExtraData cedRelInt = StandardQuantColumnInfo.getStandardQuantRelativeIntensity(sKey, sLabel);
                _columnSettings.addColumn(cedInt.getLabel(), cedInt.getKey());
                _columnSettings.addColumn(cedCorInt.getLabel(), cedCorInt.getKey());
                _columnSettings.addColumn(cedIntMz.getLabel(), cedIntMz.getKey());
                _columnSettings.addColumn(cedDeconvoInt.getLabel(), cedDeconvoInt.getKey());
                _columnSettings.addColumn(cedRelInt.getLabel(), cedRelInt.getKey());
                iNumColumns += 5;
            }
            return iNumColumns;
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Column Settings for Special Peaks.", (Throwable)ex);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int fillMassSpecColumnSettingsStandardQuantitation(TableViewerColumnSettings _columnSettings, HashMap<String, Integer> htKeyToPos, StandardQuantDataProcessor sqdp) {
        List<Peak> peaks;
        int iNumColumns;
        block9: {
            iNumColumns = 0;
            if (sqdp == null || sqdp == null) return iNumColumns;
            peaks = sqdp.getSourcePeakListToMatch();
            if (peaks != null && !peaks.isEmpty()) break block9;
            return 0;
        }
        try {
            for (Peak peak : peaks) {
                Double dMz = peak.getMz();
                String sKey = String.valueOf(sqdp.getKeyID()) + "-" + dMz.toString();
                String sLabel = dMz.toString();
                if (sqdp.getLabelAlias() != null && !sqdp.getLabelAlias().equals("")) {
                    sLabel = String.valueOf(sqdp.getLabelAlias()) + "-" + dMz.toString();
                }
                CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity(sKey, sLabel);
                CustomExtraData cedCorInt = ExternalQuantColumnInfo.getExternalQuantCorrectedIntensity(sKey, sLabel);
                CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sKey, sLabel);
                CustomExtraData cedDeconvoInt = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity(sKey, sLabel);
                CustomExtraData cedRelInt = StandardQuantColumnInfo.getStandardQuantRelativeIntensity(sKey, sLabel);
                if (htKeyToPos != null && htKeyToPos.containsKey(cedIntMz.getKey())) {
                    _columnSettings.putColumn(cedIntMz.getLabel(), cedIntMz.getKey(), htKeyToPos.get(cedIntMz.getKey()).intValue());
                    htKeyToPos.remove(cedIntMz.getKey());
                    ++iNumColumns;
                }
                if (htKeyToPos != null && htKeyToPos.containsKey(cedInt.getKey())) {
                    _columnSettings.putColumn(cedInt.getLabel(), cedInt.getKey(), htKeyToPos.get(cedInt.getKey()).intValue());
                    htKeyToPos.remove(cedInt.getKey());
                    ++iNumColumns;
                }
                if (htKeyToPos != null && htKeyToPos.containsKey(cedCorInt.getKey())) {
                    _columnSettings.putColumn(cedCorInt.getLabel(), cedCorInt.getKey(), htKeyToPos.get(cedCorInt.getKey()).intValue());
                    htKeyToPos.remove(cedCorInt.getKey());
                    ++iNumColumns;
                }
                if (htKeyToPos != null && htKeyToPos.containsKey(cedDeconvoInt.getKey())) {
                    _columnSettings.putColumn(cedDeconvoInt.getLabel(), cedDeconvoInt.getKey(), htKeyToPos.get(cedDeconvoInt.getKey()).intValue());
                    htKeyToPos.remove(cedDeconvoInt.getKey());
                    ++iNumColumns;
                }
                if (htKeyToPos == null || !htKeyToPos.containsKey(cedInt.getKey())) continue;
                _columnSettings.putColumn(cedRelInt.getLabel(), cedRelInt.getKey(), htKeyToPos.get(cedRelInt.getKey()).intValue());
                htKeyToPos.remove(cedRelInt.getKey());
                ++iNumColumns;
            }
            return iNumColumns;
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Column Settings for Special Peaks Data.", (Throwable)ex);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int fillMassSpecColumnSettingsCustomAnnotation(TableViewerColumnSettings _columnSettings, int _iMSLevel, MassSpecCustomAnnotation msca) {
        Collection<MassSpecCustomAnnotationPeak> annotatedPeaks;
        int iNumColumns;
        block5: {
            iNumColumns = 0;
            if (msca == null || msca == null) return iNumColumns;
            annotatedPeaks = msca.getAnnotatedPeaks().values();
            if (annotatedPeaks != null && !annotatedPeaks.isEmpty()) break block5;
            return 0;
        }
        try {
            for (MassSpecCustomAnnotationPeak mscap : annotatedPeaks) {
                Integer iMSLevel = mscap.getMSLevel();
                if (iMSLevel != _iMSLevel) continue;
                Double dMz = mscap.getPeakMz();
                String sKey = dMz.toString();
                String sLabel = dMz.toString();
                if (mscap.getPeakLabel() != null && !mscap.getPeakLabel().equals("")) {
                    sLabel = String.valueOf(sKey) + " - " + mscap.getPeakLabel();
                }
                CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity(sKey, sLabel);
                CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sKey, sLabel);
                _columnSettings.addColumn(cedInt.getLabel(), cedInt.getKey());
                _columnSettings.addColumn(cedIntMz.getLabel(), cedIntMz.getKey());
                iNumColumns += 2;
            }
            return iNumColumns;
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Column Settings for Special Peaks.", (Throwable)ex);
            return 0;
        }
    }

    public static int fillMassSpecColumnSettingsCorrectedPeakScanData(TableViewerColumnSettings _columnSettings, MassSpecEntityProperty msep) {
        QuantFileToCorrectedPeaks dataFileQFCP;
        MassSpecMetaData metaData;
        int iNumCols;
        block6: {
            if (msep.getMsLevel() == 1) {
                return 0;
            }
            iNumCols = 0;
            metaData = msep.getMassSpecParentProperty().getMassSpecMetaData();
            dataFileQFCP = null;
            if (metaData.getAnnotationFiles() != null && metaData.getQuantFileToCorrectedPeaks() != null) break block6;
            return 0;
        }
        try {
            for (MSPropertyDataFile mspdf : metaData.getAnnotationFiles()) {
                CustomExtraData cedCorInt;
                GRITSColumnHeader header;
                if (!metaData.getQuantFileToCorrectedPeaks().containsKey(mspdf.getName()) || (dataFileQFCP = metaData.getQuantFileToCorrectedPeaks().get(mspdf.getName())) == null) continue;
                if (dataFileQFCP.getPeakTypeToMZs().containsKey(MassSpecPeakIntensityGrid.TYPE_PRE)) {
                    header = _columnSettings.getColumnHeader(DMPrecursorPeak.precursor_peak_intensity.name());
                    cedCorInt = CorrectedQuantColumnInfo.getCorrectedQuantIntensity(header.getKeyValue(), header.getLabel());
                    _columnSettings.addColumn(cedCorInt.getLabel(), cedCorInt.getKey());
                    ++iNumCols;
                }
                if (!dataFileQFCP.getPeakTypeToMZs().containsKey(MassSpecPeakIntensityGrid.TYPE_PEAK)) continue;
                header = _columnSettings.getColumnHeader(DMPeak.peak_intensity.name());
                cedCorInt = CorrectedQuantColumnInfo.getCorrectedQuantIntensity(header.getKeyValue(), header.getLabel());
                _columnSettings.addColumn(cedCorInt.getLabel(), cedCorInt.getKey());
                ++iNumCols;
            }
        }
        catch (Exception e) {
            logger.error((Object)"addScanData: error adding scans data to table model.", (Throwable)e);
        }
        return iNumCols;
    }

    public static boolean removeMassSpecScanDataStandardQuantPeakScanData(Peak _quantPeak, StandardQuantDataProcessor qfp) {
        boolean bUpdated = false;
        try {
            String sStdQuantKeyId = qfp.getKeyID();
            String sStdQuantLabel = qfp.getLabelAlias();
            for (Peak peak : qfp.getSourcePeakListToMatch()) {
                Double dStdPeakMz = peak.getMz();
                String sStdPeakKeyId = String.valueOf(sStdQuantKeyId) + "-" + dStdPeakMz.toString();
                String sStdPeakLabel = dStdPeakMz.toString();
                if (sStdQuantLabel != null && !sStdQuantLabel.equals("")) {
                    sStdPeakLabel = String.valueOf(sStdQuantLabel) + "-" + dStdPeakMz.toString();
                }
                String sStdPeakMzKeyId = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sStdPeakKeyId, sStdPeakLabel).getKey();
                if (!_quantPeak.getDoubleProp().containsKey(sStdPeakMzKeyId)) continue;
                CustomExtraData cedQuantRelInt = StandardQuantColumnInfo.getStandardQuantRelativeIntensity(sStdPeakKeyId, sStdQuantLabel);
                if (!_quantPeak.getDoubleProp().containsKey(cedQuantRelInt.getKey())) continue;
                _quantPeak.getDoubleProp().remove(cedQuantRelInt.getKey());
                bUpdated = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"addScanData: error adding scans data to table model.", (Throwable)e);
        }
        return bUpdated;
    }

    private static Double getCorrectedIntensity(MassSpecEntityProperty msep, StandardQuantDataProcessor qfp, Double dStdPeakMz) {
        try {
            MassSpecMetaData metaData = msep.getMassSpecParentProperty().getMassSpecMetaData();
            MassSpecUISettings msAnnotSettings = msep.getMassSpecUISettings();
            QuantFileToCorrectedPeaks dataFileQFCP = null;
            if (metaData.getQuantFileToCorrectedPeaks() != null) {
                for (String sFileName : metaData.getQuantFileToCorrectedPeaks().keySet()) {
                    QuantFilePeaksToCorrectedIntensities qfpci;
                    if (!qfp.getSettings().getCorrectedFile().getFileName().endsWith(sFileName) || (dataFileQFCP = metaData.getQuantFileToCorrectedPeaks().get(sFileName)) == null || !dataFileQFCP.getPeakTypeToMZs().containsKey(MassSpecPeakIntensityGrid.TYPE_EXT) || (qfpci = dataFileQFCP.getPeakTypeToMZs().get(MassSpecPeakIntensityGrid.TYPE_EXT)) == null || qfpci.getPeakMzToIntensity() == null || !qfpci.getPeakMzToIntensity().containsKey(dStdPeakMz)) continue;
                    boolean bOk = false;
                    for (String sType : msAnnotSettings.getQuantTypeToExternalQuant().keySet()) {
                        ExternalQuantFileToAlias eqfa = msAnnotSettings.getQuantTypeToExternalQuant().get(sType);
                        if (eqfa == null || !eqfa.getSourceDataFileNameToAlias().containsKey(sFileName)) continue;
                        bOk = true;
                        break;
                    }
                    if (!bOk) continue;
                    Double dCorrectedInt = qfpci.getPeakMzToIntensity().get(dStdPeakMz);
                    return dCorrectedInt;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public static boolean fillMassSpecScanDataStandardQuantPeakScanData(Peak _quantPeak, ArrayList<Object> _tableRow, TableViewerColumnSettings _settings, MassSpecEntityProperty msep, StandardQuantDataProcessor qfp) {
        boolean bUpdated = false;
        try {
            String sStdQuantKeyId = qfp.getKeyID();
            String sStdQuantLabel = qfp.getLabelAlias();
            for (Peak peak : qfp.getSourcePeakListToMatch()) {
                String sStdPeakIntKeyId;
                GRITSColumnHeader stdPeakIntHeader;
                Double dStdPeakMz = peak.getMz();
                String sStdPeakKeyId = String.valueOf(sStdQuantKeyId) + "-" + dStdPeakMz.toString();
                String sStdPeakLabel = dStdPeakMz.toString();
                if (sStdQuantLabel != null && !sStdQuantLabel.equals("")) {
                    sStdPeakLabel = String.valueOf(sStdQuantLabel) + "-" + dStdPeakMz.toString();
                }
                String sStdPeakMzKeyId = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sStdPeakKeyId, sStdPeakLabel).getKey();
                if (!_quantPeak.getDoubleProp().containsKey(sStdPeakMzKeyId) || (stdPeakIntHeader = _settings.getColumnHeader(sStdPeakIntKeyId = ExternalQuantColumnInfo.getExternalQuantIntensity(sStdPeakKeyId, sStdPeakLabel).getKey())) == null) continue;
                Double dStdPeakInt = (Double)_quantPeak.getDoubleProp().get(sStdPeakIntKeyId);
                String sStdPeakCorIntKey = ExternalQuantColumnInfo.getExternalQuantCorrectedIntensity(sStdPeakKeyId, sStdPeakLabel).getKey();
                Double dStdPeakCorInt = (Double)_quantPeak.getDoubleProp().get(sStdPeakCorIntKey);
                Double dStdPeakRelQuantInt = dStdPeakCorInt != null ? dStdPeakCorInt : dStdPeakInt;
                QuantFileProcessor quantProc = qfp.getQuantFileProcessor();
                String sQuantKey = quantProc.getKeyID();
                String sQuantLabel = quantProc.getLabelAlias();
                String sQuantPeakIntKey = ExternalQuantColumnInfo.getExternalQuantIntensity(sQuantKey, sQuantLabel).getKey();
                Double dQuantPeakInt = (Double)_quantPeak.getDoubleProp().get(sQuantPeakIntKey);
                if (dQuantPeakInt == null) continue;
                CustomExtraData cedPeakInt = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sQuantKey, sQuantLabel);
                Double dQuantPeakCorInt = null;
                if (_quantPeak.getDoubleProp().containsKey(cedPeakInt.getKey())) {
                    Double dFormattedPeakMz = new Double(cedPeakInt.getDoubleFormat().format(_quantPeak.getDoubleProp().get(cedPeakInt.getKey())));
                    dQuantPeakCorInt = MassSpecTableDataProcessorUtil.getCorrectedIntensity(msep, qfp, dFormattedPeakMz);
                }
                Double dQuantPeakRelQuantInt = dQuantPeakCorInt != null ? dQuantPeakCorInt : dQuantPeakInt;
                Double dRelInt = dQuantPeakRelQuantInt / dStdPeakRelQuantInt;
                CustomExtraData cedQuantRelInt = StandardQuantColumnInfo.getStandardQuantRelativeIntensity(sStdPeakKeyId, sStdQuantLabel);
                if (!_quantPeak.getDoubleProp().containsKey(cedQuantRelInt.getKey()) || Double.compare((Double)_quantPeak.getDoubleProp().get(cedQuantRelInt.getKey()), dRelInt) != 0) {
                    _quantPeak.getDoubleProp().put(cedQuantRelInt.getKey(), dRelInt);
                    bUpdated = true;
                }
                MassSpecTableDataProcessorUtil.setRowValue(_settings.getColumnPosition(cedQuantRelInt.getKey()), new Double(cedQuantRelInt.getDoubleFormat().format(dRelInt)), _tableRow);
            }
        }
        catch (Exception e) {
            logger.error((Object)"addScanData: error adding scans data to table model.", (Throwable)e);
        }
        return bUpdated;
    }

    public static boolean fillMassSpecScanDataCorrectedPeakScanData(Peak _quantPeak, ArrayList<Object> _tableRow, TableViewerColumnSettings _settings, MassSpecEntityProperty msep, QuantFileProcessor qfp) {
        boolean bUpdated;
        block10: {
            bUpdated = false;
            try {
                MassSpecMetaData metaData = msep.getMassSpecParentProperty().getMassSpecMetaData();
                QuantFileToCorrectedPeaks dataFileQFCP = null;
                if (_quantPeak == null || metaData.getQuantFileToCorrectedPeaks() == null) break block10;
                String sQuantKeyId = qfp.getKeyID();
                String sQuantLabel = qfp.getLabelAlias();
                for (String sFileName : metaData.getQuantFileToCorrectedPeaks().keySet()) {
                    String sStdPeakIntKeyId;
                    GRITSColumnHeader peakIntHeader;
                    QuantFilePeaksToCorrectedIntensities qfpci;
                    if (!qfp.getSettings().getCorrectedFile().getFileName().endsWith(sFileName) || (dataFileQFCP = metaData.getQuantFileToCorrectedPeaks().get(sFileName)) == null) continue;
                    if (qfp instanceof StandardQuantDataProcessor && dataFileQFCP.getPeakTypeToMZs().containsKey(MassSpecPeakIntensityGrid.TYPE_STD)) {
                        qfpci = dataFileQFCP.getPeakTypeToMZs().get(MassSpecPeakIntensityGrid.TYPE_STD);
                        for (Double dStdPeakMz : qfpci.getPeakMzToIntensity().keySet()) {
                            String sStdPeakIntKeyId2;
                            GRITSColumnHeader stdPeakIntHeader;
                            String sStdPeakKeyId = String.valueOf(sQuantKeyId) + "-" + dStdPeakMz.toString();
                            String sStdPeakLabel = dStdPeakMz.toString();
                            if (sQuantLabel != null && !sQuantLabel.equals("")) {
                                sStdPeakLabel = String.valueOf(sQuantLabel) + "-" + dStdPeakMz.toString();
                            }
                            String sStdPeakMzKeyId = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sStdPeakKeyId, sStdPeakLabel).getKey();
                            if (!_quantPeak.getDoubleProp().containsKey(sStdPeakMzKeyId) || qfpci == null || qfpci.getPeakMzToIntensity() == null || !qfpci.getPeakMzToIntensity().containsKey(dStdPeakMz) || (stdPeakIntHeader = _settings.getColumnHeader(sStdPeakIntKeyId2 = ExternalQuantColumnInfo.getExternalQuantIntensity(sStdPeakKeyId, sStdPeakLabel).getKey())) == null) continue;
                            CustomExtraData cedStdPeakCorInt = CorrectedQuantColumnInfo.getCorrectedQuantIntensity(stdPeakIntHeader.getKeyValue(), stdPeakIntHeader.getLabel());
                            Double dCorrectedInt = qfpci.getPeakMzToIntensity().get(dStdPeakMz);
                            if (dCorrectedInt != null) {
                                if (!_quantPeak.getDoubleProp().containsKey(cedStdPeakCorInt.getKey()) || Double.compare((Double)_quantPeak.getDoubleProp().get(cedStdPeakCorInt.getKey()), dCorrectedInt) != 0) {
                                    _quantPeak.getDoubleProp().put(cedStdPeakCorInt.getKey(), dCorrectedInt);
                                    bUpdated = true;
                                }
                                MassSpecTableDataProcessorUtil.setRowValue(_settings.getColumnPosition(cedStdPeakCorInt.getKey()), new Double(cedStdPeakCorInt.getDoubleFormat().format(dCorrectedInt)), _tableRow);
                                continue;
                            }
                            _quantPeak.getDoubleProp().remove(cedStdPeakCorInt.getKey());
                            MassSpecTableDataProcessorUtil.setRowValue(_settings.getColumnPosition(cedStdPeakCorInt.getKey()), null, _tableRow);
                        }
                        continue;
                    }
                    if (!dataFileQFCP.getPeakTypeToMZs().containsKey(MassSpecPeakIntensityGrid.TYPE_EXT)) continue;
                    qfpci = dataFileQFCP.getPeakTypeToMZs().get(MassSpecPeakIntensityGrid.TYPE_EXT);
                    CustomExtraData cedPeakInt = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sQuantKeyId, sQuantLabel);
                    if (_quantPeak.getDoubleProp().get(cedPeakInt.getKey()) == null) continue;
                    Double dFormattedPeakMz = new Double(cedPeakInt.getDoubleFormat().format(_quantPeak.getDoubleProp().get(cedPeakInt.getKey())));
                    if (qfpci == null || qfpci.getPeakMzToIntensity() == null || !qfpci.getPeakMzToIntensity().containsKey(dFormattedPeakMz) || (peakIntHeader = _settings.getColumnHeader(sStdPeakIntKeyId = ExternalQuantColumnInfo.getExternalQuantIntensity(sQuantKeyId, sQuantLabel).getKey())) == null) continue;
                    CustomExtraData cedPeakCorInt = CorrectedQuantColumnInfo.getCorrectedQuantIntensity(peakIntHeader.getKeyValue(), peakIntHeader.getLabel());
                    Double dCorrectedInt = qfpci.getPeakMzToIntensity().get(dFormattedPeakMz);
                    if (dCorrectedInt != null) {
                        if (!_quantPeak.getDoubleProp().containsKey(cedPeakCorInt.getKey()) || Double.compare((Double)_quantPeak.getDoubleProp().get(cedPeakCorInt.getKey()), dCorrectedInt) != 0) {
                            _quantPeak.getDoubleProp().put(cedPeakCorInt.getKey(), dCorrectedInt);
                            bUpdated = true;
                        }
                        MassSpecTableDataProcessorUtil.setRowValue(_settings.getColumnPosition(cedPeakCorInt.getKey()), new Double(cedPeakCorInt.getDoubleFormat().format(dCorrectedInt)), _tableRow);
                        continue;
                    }
                    _quantPeak.getDoubleProp().remove(cedPeakCorInt.getKey());
                    MassSpecTableDataProcessorUtil.setRowValue(_settings.getColumnPosition(cedPeakCorInt.getKey()), null, _tableRow);
                    qfpci.getPeakMzToIntensity().remove(dFormattedPeakMz);
                }
            }
            catch (Exception e) {
                logger.error((Object)"addScanData: error adding scans data to table model.", (Throwable)e);
            }
        }
        return bUpdated;
    }

    public static boolean fillMassSpecScanDataCorrectedPeakScanData(Peak _quantPeak, ArrayList<Object> _tableRow, TableViewerColumnSettings _settings, MassSpecEntityProperty msep) {
        QuantFileToCorrectedPeaks dataFileQFCP;
        MassSpecMetaData metaData;
        boolean bUpdated;
        block11: {
            bUpdated = false;
            metaData = msep.getMassSpecParentProperty().getMassSpecMetaData();
            dataFileQFCP = null;
            if (_quantPeak != null && metaData.getAnnotationFiles() != null && metaData.getQuantFileToCorrectedPeaks() != null) break block11;
            return false;
        }
        try {
            for (MSPropertyDataFile mspdf : metaData.getAnnotationFiles()) {
                Double dCorrectedInt;
                CustomExtraData cedCorInt;
                GRITSColumnHeader header;
                Double dPeakMz;
                QuantFilePeaksToCorrectedIntensities qfpci;
                if (!metaData.getQuantFileToCorrectedPeaks().containsKey(mspdf.getName()) || (dataFileQFCP = metaData.getQuantFileToCorrectedPeaks().get(mspdf.getName())) == null) continue;
                if (dataFileQFCP.getPeakTypeToMZs().containsKey(MassSpecPeakIntensityGrid.TYPE_PRE)) {
                    qfpci = dataFileQFCP.getPeakTypeToMZs().get(MassSpecPeakIntensityGrid.TYPE_PRE);
                    dPeakMz = MassSpecTableDataProcessorUtil.getFormattedMZValue(_quantPeak.getPrecursorMz());
                    if (qfpci != null && qfpci.getPeakMzToIntensity() != null && qfpci.getPeakMzToIntensity().containsKey(dPeakMz) && (header = _settings.getColumnHeader(DMPrecursorPeak.precursor_peak_intensity.name())) != null) {
                        cedCorInt = CorrectedQuantColumnInfo.getCorrectedQuantIntensity(header.getKeyValue(), header.getLabel());
                        dCorrectedInt = qfpci.getPeakMzToIntensity().get(dPeakMz);
                        if (dCorrectedInt != null) {
                            if (!_quantPeak.getDoubleProp().containsKey(cedCorInt.getKey()) || Double.compare((Double)_quantPeak.getDoubleProp().get(cedCorInt.getKey()), dCorrectedInt) != 0) {
                                _quantPeak.getDoubleProp().put(cedCorInt.getKey(), dCorrectedInt);
                                bUpdated = true;
                            }
                            MassSpecTableDataProcessorUtil.setRowValue(_settings.getColumnPosition(cedCorInt.getKey()), new Double(cedCorInt.getDoubleFormat().format(dCorrectedInt)), _tableRow);
                        } else {
                            _quantPeak.getDoubleProp().remove(cedCorInt.getKey());
                            MassSpecTableDataProcessorUtil.setRowValue(_settings.getColumnPosition(cedCorInt.getKey()), null, _tableRow);
                            qfpci.getPeakMzToIntensity().remove(dPeakMz);
                        }
                    }
                }
                if (!dataFileQFCP.getPeakTypeToMZs().containsKey(MassSpecPeakIntensityGrid.TYPE_PEAK)) continue;
                qfpci = dataFileQFCP.getPeakTypeToMZs().get(MassSpecPeakIntensityGrid.TYPE_PEAK);
                dPeakMz = MassSpecTableDataProcessorUtil.getFormattedMZValue(_quantPeak.getMz());
                if (qfpci == null || qfpci.getPeakMzToIntensity() == null || !qfpci.getPeakMzToIntensity().containsKey(dPeakMz) || (header = _settings.getColumnHeader(DMPeak.peak_intensity.name())) == null) continue;
                cedCorInt = CorrectedQuantColumnInfo.getCorrectedQuantIntensity(header.getKeyValue(), header.getLabel());
                dCorrectedInt = qfpci.getPeakMzToIntensity().get(dPeakMz);
                if (dCorrectedInt != null) {
                    if (!_quantPeak.getDoubleProp().containsKey(cedCorInt.getKey()) || Double.compare((Double)_quantPeak.getDoubleProp().get(cedCorInt.getKey()), dCorrectedInt) != 0) {
                        _quantPeak.getDoubleProp().put(cedCorInt.getKey(), dCorrectedInt);
                        bUpdated = true;
                    }
                    MassSpecTableDataProcessorUtil.setRowValue(_settings.getColumnPosition(cedCorInt.getKey()), new Double(cedCorInt.getDoubleFormat().format(dCorrectedInt)), _tableRow);
                    continue;
                }
                _quantPeak.getDoubleProp().remove(cedCorInt.getKey());
                MassSpecTableDataProcessorUtil.setRowValue(_settings.getColumnPosition(cedCorInt.getKey()), null, _tableRow);
                qfpci.getPeakMzToIntensity().remove(dPeakMz);
            }
        }
        catch (Exception e) {
            logger.error((Object)"addScanData: error adding scans data to table model.", (Throwable)e);
        }
        return bUpdated;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int fillMassSpecColumnSettingsCustomAnnotation(TableViewerColumnSettings _columnSettings, HashMap<String, Integer> htKeyToPos, int _iMSLevel, MassSpecCustomAnnotation msca) {
        Collection<MassSpecCustomAnnotationPeak> annotatedPeaks;
        int iNumColumns;
        block6: {
            iNumColumns = 0;
            if (msca == null || msca == null) return iNumColumns;
            annotatedPeaks = msca.getAnnotatedPeaks().values();
            if (annotatedPeaks != null && !annotatedPeaks.isEmpty()) break block6;
            return 0;
        }
        try {
            for (MassSpecCustomAnnotationPeak mscap : annotatedPeaks) {
                Integer iMSLevel = mscap.getMSLevel();
                if (iMSLevel != _iMSLevel) continue;
                Double dMz = mscap.getPeakMz();
                String sKey = dMz.toString();
                String sLabel = dMz.toString();
                if (mscap.getPeakLabel() != null && !mscap.getPeakLabel().equals("")) {
                    sLabel = String.valueOf(sKey) + " - " + mscap.getPeakLabel();
                }
                CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity(sKey, sLabel);
                CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sKey, sLabel);
                if (htKeyToPos != null && htKeyToPos.containsKey(cedIntMz.getKey())) {
                    _columnSettings.putColumn(cedIntMz.getLabel(), cedIntMz.getKey(), htKeyToPos.get(cedIntMz.getKey()).intValue());
                    htKeyToPos.remove(cedIntMz.getKey());
                    ++iNumColumns;
                }
                if (htKeyToPos == null || !htKeyToPos.containsKey(cedInt.getKey())) continue;
                _columnSettings.putColumn(cedInt.getLabel(), cedInt.getKey(), htKeyToPos.get(cedInt.getKey()).intValue());
                htKeyToPos.remove(cedInt.getKey());
                ++iNumColumns;
            }
            return iNumColumns;
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Column Settings for Special Peaks Data.", (Throwable)ex);
            return 0;
        }
    }

    public static boolean fillMassSpecScanDataCustomAnnotation(Peak _precursorPeak, Peak _subscanPeak, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings, HashMap<Double, MassSpecCustomAnnotationPeak> hmAnnotatedPeaks) {
        Collection<MassSpecCustomAnnotationPeak> annotatedPeaks;
        boolean bUpdated;
        block11: {
            block10: {
                block9: {
                    block8: {
                        bUpdated = false;
                        if (_subscanPeak != null && _subscanPeak.getDoubleProp() != null) break block8;
                        return false;
                    }
                    if (!_subscanPeak.getDoubleProp().isEmpty()) break block9;
                    return false;
                }
                if (hmAnnotatedPeaks != null) break block10;
                return false;
            }
            annotatedPeaks = hmAnnotatedPeaks.values();
            if (annotatedPeaks != null && !annotatedPeaks.isEmpty()) break block11;
            return false;
        }
        try {
            for (MassSpecCustomAnnotationPeak mscap : annotatedPeaks) {
                Double dMz = mscap.getPeakMz();
                String sKey = dMz.toString();
                String sLabel = dMz.toString();
                if (mscap.getPeakLabel() != null && !mscap.getPeakLabel().equals("")) {
                    sLabel = String.valueOf(sKey) + " - " + mscap.getPeakLabel();
                }
                CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity(sKey, sLabel);
                CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sKey, sLabel);
                if (_subscanPeak == null || _subscanPeak.getDoubleProp() == null || _subscanPeak.getDoubleProp().isEmpty()) continue;
                Double dMatchedMz = (Double)_subscanPeak.getDoubleProp().get(cedIntMz.getKey());
                Double dMatchedInt = (Double)_subscanPeak.getDoubleProp().get(cedInt.getKey());
                if (dMatchedMz == null || dMatchedInt == null || !_subscanPeak.getMz().equals(dMatchedMz)) continue;
                bUpdated = true;
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(cedIntMz.getKey()), new Double(cedIntMz.getDoubleFormat().format(dMatchedMz)), _tableRow);
                _precursorPeak.addDoubleProp(cedIntMz.getKey(), dMatchedMz);
                MassSpecTableDataProcessorUtil.setRowValue(_columnSettings.getColumnPosition(cedInt.getKey()), new Double(cedInt.getDoubleFormat().format(dMatchedInt)), _tableRow);
                _precursorPeak.addDoubleProp(cedInt.getKey(), dMatchedInt);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error filling Mass Spec Row Data for Peak List with Features Special Peaks.", (Throwable)ex);
        }
        return bUpdated;
    }

    public static void setHeaderValue(int iColNum, GRITSColumnHeader headerVal, ArrayList<GRITSColumnHeader> alList) {
        try {
            if (headerVal == null) {
                return;
            }
            if (alList == null) {
                alList = new ArrayList();
            }
            if (alList.size() <= iColNum) {
                int i = alList.size();
                while (i <= iColNum) {
                    alList.add(new GRITSColumnHeader("", ""));
                    ++i;
                }
            }
            alList.set(iColNum, headerVal);
        }
        catch (Exception ex) {
            logger.error((Object)"Error setting header value.", (Throwable)ex);
        }
    }

    public static void setRowValue(int iColNum, Object objVal, ArrayList<Object> alList) {
        try {
            if (iColNum < 0) {
                return;
            }
            if (objVal == null) {
                return;
            }
            if (alList == null) {
                alList = new ArrayList();
            }
            if (alList.size() <= iColNum) {
                int i = alList.size();
                while (i <= iColNum) {
                    alList.add("");
                    ++i;
                }
            }
            if (objVal instanceof Boolean) {
                alList.set(iColNum, (Boolean)objVal != false ? "Yes" : "No");
            } else {
                alList.set(iColNum, objVal);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error setting row value.", (Throwable)ex);
        }
    }

    protected static void errorMessage(String a_message) {
        logger.error((Object)a_message);
    }
}

