/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.property.io;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanCustomAnnotationPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.property.MSGlycanAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.property.datamodel.MSGlycanAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.ms.file.FileCategory;
import org.jdom.Element;

public class MSGlycanAnnotationReaderVersion1_1 {
    private static PropertyDataFile getArchiveFile(MSGlycanAnnotationProperty msAnnotProperty) {
        if (msAnnotProperty.getDataFiles() == null || msAnnotProperty.getDataFiles().isEmpty()) {
            return null;
        }
        for (PropertyDataFile pdf : msAnnotProperty.getDataFiles()) {
            if (!pdf.getType().equals("file") || !pdf.getName().endsWith(msAnnotProperty.getArchiveExtension())) continue;
            msAnnotProperty.getDataFiles().remove(pdf);
            return pdf;
        }
        return null;
    }

    private static MSPropertyDataFile getNewMSPropertyDataFile(String sAnnotationFile) {
        File file = new File(sAnnotationFile);
        MSPropertyDataFile pdf = null;
        pdf = file.isFile() ? new MSPropertyDataFile(sAnnotationFile, "1.0", "file", FileCategory.ANNOTATION_CATEGORY, "GELATO", sAnnotationFile, new ArrayList()) : new MSPropertyDataFile(sAnnotationFile, "1.0", "folder", FileCategory.ANNOTATION_CATEGORY, "GELATO", sAnnotationFile, new ArrayList());
        return pdf;
    }

    public static Property read(Element propertyElement, MSGlycanAnnotationProperty msProperty) {
        msProperty.adjustPropertyFilePaths();
        Element entryElement = propertyElement.getDocument().getRootElement().getChild("entry");
        String projectName = entryElement == null ? null : entryElement.getAttributeValue("name");
        String workspaceFolder = PropertyHandler.getVariable((String)"workspace_location");
        String msFolder = String.valueOf(workspaceFolder.substring(0, workspaceFolder.length() - 1)) + File.separator + projectName + File.separator + msProperty.getArchiveFolder();
        String msFile = msProperty.getMetaDataFile().getName();
        String fullPath = String.valueOf(msFolder) + File.separator + msFile;
        MSAnnotationMetaData msMetaData = MSGlycanAnnotationProperty.unmarshallSettingsFile(fullPath);
        if (msMetaData == null || !(msMetaData instanceof MSGlycanAnnotationMetaData)) {
            msProperty.setMSAnnotationMetaData(msMetaData);
            return msProperty;
        }
        List<MassSpecCustomAnnotation> ca = MSGlycanCustomAnnotationPreference.unmarshalCustomAnnotationsList(((MSGlycanAnnotationMetaData)msMetaData).getCustomAnnotationText());
        ((MSGlycanAnnotationMetaData)msMetaData).setCustomAnnotations(ca);
        msProperty.setMSAnnotationMetaData(msMetaData);
        return msProperty;
    }

    public static void updateMSAnnotationMetaData(Element propertyElement, MSGlycanAnnotationProperty msProperty) {
        PropertyDataFile pdf;
        Element entryElement = propertyElement.getDocument().getRootElement().getChild("entry");
        String projectName = entryElement == null ? null : entryElement.getAttributeValue("name");
        String workspaceFolder = PropertyHandler.getVariable((String)"workspace_location");
        String msFolder = String.valueOf(workspaceFolder.substring(0, workspaceFolder.length() - 1)) + File.separator + projectName + File.separator + msProperty.getArchiveFolder();
        String msFile = msProperty.getMetaDataFile().getName();
        String fullPath = String.valueOf(msFolder) + File.separator + msFile;
        MSAnnotationMetaData msMetaData = msProperty.getMSAnnotationMetaData();
        boolean bWriteSettings = false;
        if (msMetaData == null || !(msMetaData instanceof MSGlycanAnnotationMetaData) || msMetaData.getAnnotationId() == null) {
            MSGlycanAnnotationMetaData msGlycanMetaData = new MSGlycanAnnotationMetaData();
            if (msMetaData != null) {
                msGlycanMetaData.clone(msMetaData);
            }
            msMetaData = msGlycanMetaData;
            msProperty.setMSAnnotationMetaData(msMetaData);
            bWriteSettings = true;
        }
        if (msMetaData.getAnnotationId() == null) {
            String[] sToks = msFile.split("\\.");
            try {
                Integer.parseInt(sToks[0]);
                msMetaData.setAnnotationId(sToks[0]);
                bWriteSettings = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (msMetaData.getName() == null) {
            msMetaData.setName(msFile);
            bWriteSettings = true;
        }
        if (msMetaData.getDescription() == null) {
            msMetaData.setDescription("");
            bWriteSettings = true;
        }
        if ((pdf = MSGlycanAnnotationReaderVersion1_1.getArchiveFile(msProperty)) != null) {
            MSPropertyDataFile mspdf = MSGlycanAnnotationReaderVersion1_1.getNewMSPropertyDataFile(pdf.getName());
            msMetaData.addFile(mspdf);
            bWriteSettings = true;
        }
        if (bWriteSettings) {
            MSGlycanAnnotationProperty.marshallSettingsFile((String)fullPath, (MSAnnotationMetaData)msMetaData);
        }
    }
}

