/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.KCF;

public enum IUPACAglyconDescriptor {
    LIPIDA("LipidA"),
    R("R"),
    NTYPE("Asn"),
    OTYPE("Ser/Thr"),
    SERINE("Ser"),
    PDOLICHOL("P-Dol"),
    PPDOLICHOL("PP-Dol"),
    PPUND("PP-Und"),
    PHOSPHATE("P"),
    PHOSPHOETANE("PE"),
    CERAMIDE("Cer"),
    MYOINO("myo-Ino"),
    INOACYLP("Ino(acyl)-P"),
    INOP("Ino-P"),
    INO("Ino"),
    SPHNGOLIPID("Sph");

    String notation;

    private IUPACAglyconDescriptor(String _notation) {
        this.notation = _notation;
    }

    public static IUPACAglyconDescriptor forNotation(String _notation) {
        IUPACAglyconDescriptor[] iUPACAglyconDescriptorArray = IUPACAglyconDescriptor.values();
        int n = iUPACAglyconDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUPACAglyconDescriptor e = iUPACAglyconDescriptorArray[n2];
            if (e.notation.equals(_notation)) {
                return e;
            }
            ++n2;
        }
        return null;
    }
}

