/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.JSON;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.LinkageType;
import org.json.JSONArray;
import org.json.JSONObject;

public class GCJSONLinkageParser {
    public Linkage parsePosition(JSONObject _position) throws GlycanException {
        if (_position.length() == 0) {
            return null;
        }
        Linkage ret = new Linkage();
        Iterator iterator = _position.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "Position": {
                    ret = this.extractPosition(_position.getJSONObject(key), ret);
                    break;
                }
                case "Probability": {
                    ret = this.extractProbability(_position.getJSONObject(key), ret);
                    break;
                }
                case "LinkageType": {
                    ret = this.extractLinkageType(_position.getJSONObject(key), ret);
                }
            }
        }
        return ret;
    }

    public Linkage extractPosition(JSONObject _position, Linkage _lin) {
        Iterator iterator = _position.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "ChildSide": {
                    _lin.setChildLinkages(this.openPositions(_position.getJSONArray(key)));
                    break;
                }
                case "ParentSide": {
                    _lin.setParentLinkages(this.openPositions(_position.getJSONArray(key)));
                }
            }
        }
        return _lin;
    }

    public Linkage extractLinkageType(JSONObject _linkageType, Linkage _lin) throws GlycanException {
        Iterator iterator = _linkageType.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "ChildSide": {
                    _lin.setChildLinkageType(this.parseLinkageType(_linkageType.getString(key)));
                    break;
                }
                case "ParentSide": {
                    _lin.setParentLinkageType(this.parseLinkageType(_linkageType.getString(key)));
                }
            }
        }
        return _lin;
    }

    public Linkage extractProbability(JSONObject _probability, Linkage _lin) {
        for (String key : _probability.keySet()) {
            JSONObject probability = _probability.getJSONObject(key);
            switch (key) {
                case "ChildSide": {
                    _lin.setChildProbabilityLower(probability.getDouble("High"));
                    _lin.setChildProbabilityUpper(probability.getDouble("Low"));
                    break;
                }
                case "ParentSide": {
                    _lin.setProbabilityLower(probability.getDouble("High"));
                    _lin.setProbabilityUpper(probability.getDouble("Low"));
                }
            }
        }
        return _lin;
    }

    private Collection<Integer> openPositions(JSONArray _positions) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Object pos : _positions) {
            ret.add((Integer)pos);
        }
        return ret;
    }

    private LinkageType parseLinkageType(String _type) {
        LinkageType[] linkageTypeArray = LinkageType.values();
        int n = linkageTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LinkageType value = linkageTypeArray[n2];
            if (_type.equals(value.toString())) {
                return value;
            }
            ++n2;
        }
        return null;
    }
}

