/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACLinkageParser;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACNotationParser;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACStacker;
import org.glycoinfo.GlycanFormatconverter.util.GlyContainerOptimizer;

public class IUPACExtendedImporter {
    /*
     * WARNING - void declaration
     */
    public GlyContainer start(String _iupac) throws GlycanException, GlyCoImporterException {
        GlyContainer glyCo = new GlyContainer();
        LinkedHashMap<Node, String> nodeIndex = new LinkedHashMap<Node, String>();
        ArrayList<Object> notations = new ArrayList();
        if (_iupac.indexOf("$,") != -1) {
            String[] stringArray = _iupac.split("\\$,");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                void var5_10;
                String string = stringArray[n2];
                if (string.matches(".+=[\\d?]+")) {
                    String string2 = String.valueOf(string) + "$,";
                }
                notations.add(var5_10);
                ++n2;
            }
            Collections.reverse(notations);
        }
        if (_iupac.matches(".*}\\d+")) {
            notations = this.parseCompositionUnits(_iupac);
        }
        if (notations.isEmpty()) {
            notations.add(_iupac);
        }
        for (String string : notations) {
            void var5_17;
            IUPACStacker stacker = new IUPACStacker();
            Matcher matComp = Pattern.compile("^\\{.+}(\\d+)+$").matcher(string);
            if (matComp.find()) {
                String count = matComp.group(1);
                String string4 = string.replaceFirst("\\{", "");
                string4 = string4.substring(0, string4.indexOf("}" + count));
                stacker.setNumOfNode(Integer.parseInt(count));
                stacker.setComposition();
            }
            stacker.setNotations(this.parseNotation((String)var5_17));
            if (var5_17.endsWith("$,")) {
                stacker.setFragment();
            }
            for (String unit : stacker.getNotations()) {
                if (stacker.isComposition()) {
                    int i = stacker.getNumOfNode();
                    while (i != 0) {
                        Node node = this.makeNode(unit);
                        nodeIndex.put(node, unit);
                        stacker.addNode(node);
                        --i;
                    }
                    continue;
                }
                Node node = this.makeNode(unit);
                nodeIndex.put(node, unit);
                stacker.addNode(node);
            }
            this.parseChildren(stacker, nodeIndex);
            IUPACLinkageParser iupacLP = new IUPACLinkageParser(glyCo, nodeIndex, stacker);
            iupacLP.start();
            glyCo = iupacLP.getGlyCo();
        }
        GlyContainerOptimizer glyContainerOptimizer = new GlyContainerOptimizer();
        glyContainerOptimizer.start(glyCo);
        return glyCo;
    }

    private Node makeNode(String _notation) throws GlycanException, GlyCoImporterException {
        IUPACNotationParser iupacNP = new IUPACNotationParser();
        Node ret = iupacNP.parseMonosaccharide(_notation);
        return ret;
    }

    private ArrayList<String> parseNotation(String _iupac) {
        ArrayList<String> ret = new ArrayList<String>();
        String mono = "";
        boolean isLinkage = false;
        boolean isRepeat = false;
        boolean isbisect = false;
        boolean isMultipleParent = false;
        int i = 0;
        while (i < _iupac.length()) {
            block12: {
                block17: {
                    block16: {
                        block13: {
                            block15: {
                                block14: {
                                    block10: {
                                        block11: {
                                            mono = String.valueOf(mono) + _iupac.charAt(i);
                                            if (_iupac.charAt(i) == '(') {
                                                isLinkage = true;
                                            }
                                            if (isbisect && _iupac.charAt(i) == ']') {
                                                ret.add(mono);
                                                mono = "";
                                                isbisect = false;
                                            }
                                            if (!isMultipleParent || _iupac.charAt(i) != ')') break block10;
                                            if (_iupac.charAt(i + 1) != ']' || _iupac.charAt(i + 2) == '-') break block11;
                                            isbisect = true;
                                            isMultipleParent = false;
                                            break block12;
                                        }
                                        ret.add(mono);
                                        mono = "";
                                        isMultipleParent = false;
                                    }
                                    if (!isLinkage || _iupac.charAt(i) != ')') break block13;
                                    if (_iupac.charAt(i + 1) != '=') break block14;
                                    isLinkage = false;
                                    break block12;
                                }
                                if (_iupac.charAt(i + 1) != ']' || _iupac.charAt(i + 2) == '-') break block15;
                                isbisect = true;
                                isLinkage = false;
                                break block12;
                            }
                            if (String.valueOf(_iupac.charAt(i + 1)).matches("[a-zA-Z,]")) break block12;
                            ret.add(mono);
                            mono = "";
                            isLinkage = false;
                        }
                        if (!isLinkage || _iupac.charAt(i) != ']') break block16;
                        isLinkage = false;
                        isRepeat = true;
                        break block12;
                    }
                    if (_iupac.length() - 1 == i) {
                        ret.add(mono);
                        break;
                    }
                    if (!isRepeat) break block12;
                    if (!String.valueOf(_iupac.charAt(i)).matches("[\\dn]")) break block17;
                    if (String.valueOf(_iupac.charAt(i + 1)).matches("\\d") || _iupac.charAt(i + 1) == '-' && String.valueOf(_iupac.charAt(i + 2)).matches("[\\dn\\(]") || _iupac.charAt(i - 1) == '(' && _iupac.charAt(i + 1) == '\u2192') break block12;
                    isRepeat = false;
                }
                if (_iupac.charAt(i + 1) == ':') {
                    isMultipleParent = true;
                } else if (!isRepeat) {
                    ret.add(mono);
                    mono = "";
                }
            }
            ++i;
        }
        return ret;
    }

    private void parseChildren(IUPACStacker _stacker, LinkedHashMap<Node, String> _index) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(_stacker.getNodes());
        Collections.reverse(nodes);
        for (Node node : nodes) {
            Node child;
            int childIndex;
            String current = _index.get(node);
            if (this.haveChild(current)) {
                childIndex = nodes.indexOf(node) + 1;
                child = (Node)nodes.get(childIndex);
                _stacker.addFamily(child, node);
            }
            if (!this.isStartOfBranch(current)) continue;
            childIndex = nodes.indexOf(node) + 1;
            child = (Node)nodes.get(childIndex);
            _stacker.addFamily(child, node);
            for (Node cNode : this.pickChildren(nodes, node, _index)) {
                _stacker.addFamily(cNode, node);
            }
        }
    }

    private ArrayList<String> parseCompositionUnits(String _iupac) {
        ArrayList<String> ret = new ArrayList<String>();
        String notation = "";
        boolean isEndBracket = false;
        int i = 0;
        while (i < _iupac.length()) {
            if (isEndBracket && _iupac.charAt(i) == ',') {
                ret.add(notation);
                notation = "";
                isEndBracket = false;
            } else {
                notation = String.valueOf(notation) + _iupac.charAt(i);
                if (i + 1 == _iupac.length()) {
                    ret.add(notation);
                }
                if (i > 0 && _iupac.charAt(i) == '}') {
                    isEndBracket = true;
                }
            }
            ++i;
        }
        return ret;
    }

    private ArrayList<Node> pickChildren(ArrayList<Node> _nodes, Node _branch, LinkedHashMap<Node, String> _index) {
        ArrayList<Node> children = new ArrayList<Node>();
        int count = 0;
        boolean isChild = false;
        if (this.isStartOfBranch(_index.get(_branch))) {
            count = -1;
        }
        for (Node node : _nodes.subList(_nodes.indexOf(_branch) + 1, _nodes.size())) {
            String notation = _index.get(node);
            if (isChild) {
                children.add(node);
            }
            if (count == 0 && !this.isBisecting(notation) && (this.isStartOfBranch(notation) || this.isEndOfBranch(notation) || this.haveChild(notation))) break;
            if (this.isStartOfBranch(notation)) {
                --count;
            }
            if (this.isEndOfBranch(notation)) {
                ++count;
            }
            if (this.isBisecting(notation)) {
                --count;
            }
            if (count == 0) {
                if (this.isBisecting(notation)) {
                    isChild = true;
                }
                if (!this.isEndOfBranch(notation)) continue;
                isChild = true;
                continue;
            }
            isChild = false;
        }
        return children;
    }

    private boolean isBisecting(String _notation) {
        return _notation.endsWith("]");
    }

    private boolean haveChild(String _notation) {
        return _notation.startsWith("-");
    }

    private boolean isStartOfBranch(String _notation) {
        return _notation.startsWith("]-");
    }

    private boolean isEndOfBranch(String _notation) {
        if (_notation.matches("\\[\\d\\).+")) {
            return false;
        }
        return _notation.startsWith("[");
    }
}

