/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACCondensedLinkageParser;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACCondensedNotationParser;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACStacker;
import org.glycoinfo.GlycanFormatconverter.util.GlyContainerOptimizer;

public class IUPACCondensedImporter {
    private GlyContainer glyCo = new GlyContainer();

    public GlyContainer getGlyContainer() {
        return this.glyCo;
    }

    public void start(String _iupac) throws GlyCoImporterException, GlycanException {
        _iupac = _iupac.replaceAll("[\\xc2\\xa0]", "");
        _iupac = _iupac.replaceAll(" ", "");
        if ((_iupac = _iupac.trim()).indexOf("[") != -1) {
            _iupac = this.replaceBlockBrakcets(_iupac);
        }
        LinkedHashMap<Node, String> nodeIndex = new LinkedHashMap<Node, String>();
        ArrayList<String> notations = new ArrayList<String>();
        String[] stringArray = _iupac.split("\\$,");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            if (unit.matches(".+=[\\d?]")) {
                unit = String.valueOf(unit) + "$,";
            }
            notations.add(unit);
            ++n2;
        }
        Collections.reverse(notations);
        for (String subst : notations) {
            IUPACStacker stacker = new IUPACStacker();
            stacker.setNotations(this.parseNotation(subst));
            IUPACCondensedNotationParser iupacNP = new IUPACCondensedNotationParser();
            for (String unit : stacker.getNotations()) {
                Node node = iupacNP.parseMonosaccharide(unit);
                if (node == null) continue;
                nodeIndex.put(node, unit);
                stacker.addNode(node);
            }
            this.parseChildren(stacker, nodeIndex, subst);
            IUPACCondensedLinkageParser iclp = new IUPACCondensedLinkageParser(this.glyCo, nodeIndex, stacker);
            this.glyCo = iclp.start();
        }
        GlyContainerOptimizer gcOpt = new GlyContainerOptimizer();
        gcOpt.start(this.glyCo);
    }

    private ArrayList<String> parseNotation(String _iupac) {
        ArrayList<String> ret = new ArrayList<String>();
        boolean isLinkage = false;
        boolean isSub = false;
        String node = "";
        int i = 0;
        while (i < _iupac.length()) {
            char item = _iupac.charAt(i);
            node = String.valueOf(node) + item;
            if (i == _iupac.length() - 1) {
                ret.add(node);
                break;
            }
            if (!isLinkage && String.valueOf(item).matches("[\\d?]")) {
                isSub = true;
            }
            if (isSub && item == ')') {
                ret.add(node);
                node = "";
                isSub = false;
                isLinkage = false;
            } else {
                char linkage = _iupac.charAt(i + 1);
                if ((item == 'a' || item == 'b' || item == '?') && String.valueOf(linkage).matches("[\\d?-]")) {
                    isLinkage = true;
                }
                if (isLinkage && item == ')') {
                    ret.add(node);
                    isLinkage = false;
                    node = "";
                }
                char nextItem = _iupac.charAt(i + 1);
                if (isLinkage && String.valueOf(nextItem).matches("[A-Z(\\[]")) {
                    ret.add(node);
                    isLinkage = false;
                    node = "";
                }
            }
            ++i;
        }
        return ret;
    }

    private String replaceBlockBrakcets(String _iupac) {
        StringBuilder ret = new StringBuilder(_iupac);
        int i = 0;
        while (i < _iupac.length()) {
            char item = _iupac.charAt(i);
            if (item == '[' && _iupac.charAt(i + 2) != ')') {
                ret.replace(i, i + 1, "(");
            }
            if (item == ']' && _iupac.charAt(i - 1) != '-') {
                ret.replace(i, i + 1, ")");
            }
            ++i;
        }
        return ret.toString();
    }

    private void parseChildren(IUPACStacker _stacker, LinkedHashMap<Node, String> _index, String _subst) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(_stacker.getNodes());
        Collections.reverse(nodes);
        for (Node node : nodes) {
            Node child;
            int childIndex;
            if (this.haveChild(node, _index)) {
                childIndex = nodes.indexOf(node) + 1;
                child = (Node)nodes.get(childIndex);
                _stacker.addFamily(child, node);
            }
            if (!this.isStartOfBranch(node, _index)) continue;
            childIndex = nodes.indexOf(node) + 1;
            child = (Node)nodes.get(childIndex);
            _stacker.addFamily(child, node);
            for (Node cNode : this.pickChildren(nodes, node, _index, _subst)) {
                _stacker.addFamily(cNode, node);
            }
        }
    }

    private ArrayList<Node> pickChildren(ArrayList<Node> _nodes, Node _branch, LinkedHashMap<Node, String> _index, String _subst) {
        ArrayList<Node> children = new ArrayList<Node>();
        int count = 0;
        boolean isChild = false;
        if (this.isStartOfBranch(_branch, _index)) {
            count = -1;
        }
        for (Node node : _nodes.subList(_nodes.indexOf(_branch) + 1, _nodes.size())) {
            if (isChild) {
                children.add(node);
            }
            if (count == 0 && !this.isBisecting(node, _index) && (this.isStartOfBranch(node, _index) || this.isEndOfBranch(node, _index) || this.haveChild(node, _index))) break;
            if (this.isStartOfBranch(node, _index)) {
                --count;
            }
            if (this.isEndOfBranch(node, _index)) {
                ++count;
            }
            if (this.isBisecting(node, _index)) {
                --count;
            }
            if (count == 0) {
                if (this.isBisecting(node, _index)) {
                    isChild = true;
                }
                if (!this.isEndOfBranch(node, _index)) continue;
                isChild = true;
                continue;
            }
            isChild = false;
        }
        return children;
    }

    private boolean isBisecting(Node _node, LinkedHashMap<Node, String> _index) {
        int currentIndex = new ArrayList<Node>(_index.keySet()).indexOf(_node);
        if (currentIndex == 0) {
            return false;
        }
        if (!_index.get(_node).endsWith(")")) {
            return false;
        }
        Node next = new ArrayList<Node>(_index.keySet()).get(currentIndex + 1);
        return _index.get(next).startsWith("(");
    }

    private boolean haveChild(Node _node, LinkedHashMap<Node, String> _index) {
        int currentIndex = new ArrayList<Node>(_index.keySet()).indexOf(_node);
        if (currentIndex == 0) {
            return false;
        }
        return !_index.get(_node).startsWith("(");
    }

    private boolean isStartOfBranch(Node _node, LinkedHashMap<Node, String> _index) {
        int currentIndex = new ArrayList<Node>(_index.keySet()).indexOf(_node);
        if (currentIndex == 0) {
            return false;
        }
        if (_index.get(_node).startsWith("(")) {
            return false;
        }
        Node next = new ArrayList<Node>(_index.keySet()).get(currentIndex - 1);
        return _index.get(next).endsWith(")");
    }

    private boolean isEndOfBranch(Node _node, LinkedHashMap<Node, String> _index) {
        return _index.get(_node).startsWith("(");
    }
}

