/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.exec;

import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.CondensedConverter;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameException;
import org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer.WURCSGraphToGlyContainer;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.WURCSFactory;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;

public class execConverterResidueCode {
    public static void main(String[] args) {
        try {
            if (args.length == 1) {
                System.out.println(execConverterResidueCode.WURCSToTrivialName(args[0]));
            } else if (args.length > 1) {
                int i = 0;
                while (i < args.length) {
                    System.out.println(execConverterResidueCode.WURCSToTrivialName(args[i]));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String WURCSToTrivialName(String _input) throws WURCSException, TrivialNameException, GlycanException {
        if (!_input.startsWith("WURCS")) {
            if (!_input.startsWith("[") && !_input.equalsIgnoreCase("]")) {
                _input = "[" + _input + "]";
            }
            if (_input.startsWith("[") && !_input.endsWith("]")) {
                _input = "[" + _input;
            }
            if (!_input.startsWith("[") && _input.endsWith("]")) {
                _input = String.valueOf(_input) + "]";
            }
            _input = "WURCS=2.0/1,1,0/" + _input + "/1/";
        }
        WURCSFactory wf = new WURCSFactory(_input);
        WURCSGraph graph = wf.getGraph();
        WURCSGraphToGlyContainer wg2gc = new WURCSGraphToGlyContainer();
        wg2gc.start(graph);
        GlyContainer gc = wg2gc.getGlycan();
        CondensedConverter condConv = new CondensedConverter();
        String ret = "";
        for (Node node : gc.getNodes()) {
            ret = condConv.start(node, false);
        }
        return ret;
    }
}

