/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.wizard.lipidgeneration;

import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.tools.gsl.database.lipid.LipidDatabase;
import org.grits.toolbox.tools.gsl.util.generator.CeramideDatabaseGenerator;
import org.grits.toolbox.tools.gsl.util.generator.LipidDatabaseGeneratorAbstract;
import org.grits.toolbox.tools.gsl.util.generator.SphingosineDatabaseGenerator;
import org.grits.toolbox.tools.gsl.util.io.lipid.LipidDatabaseExporterXLSXForGRITSProgressDialog;
import org.grits.toolbox.tools.gsl.util.io.lipid.LipidDatabaseFileHandler;
import org.grits.toolbox.tools.gsl.wizard.lipidgeneration.DataEntryPage;
import org.grits.toolbox.tools.gsl.wizard.lipidgeneration.LipidGenerationSettingPage;
import org.grits.toolbox.widgets.processDialog.GRITSProgressDialog;
import org.grits.toolbox.widgets.progress.CancelableThread;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.GRITSWorker;

public class LipidDatabaseGenerationWizard
extends Wizard {
    private static Logger logger = Logger.getLogger(LipidDatabaseGenerationWizard.class);
    private DataEntryPage m_pageEntry;
    private LipidGenerationSettingPage m_pageLipidParam;

    public LipidDatabaseGenerationWizard() {
        this.setWindowTitle("Lipid Database Generation");
    }

    public void addPages() {
        this.m_pageEntry = new DataEntryPage();
        this.m_pageLipidParam = new LipidGenerationSettingPage();
        this.addPage((IWizardPage)this.m_pageEntry);
        this.addPage((IWizardPage)this.m_pageLipidParam);
    }

    public boolean performFinish() {
        final LipidDatabaseGeneratorAbstract t_genDatabase = this.setParametersForLipidDatabase();
        final String t_strFileName = this.m_pageEntry.getOutputFileName();
        final GRITSProgressDialog t_progressDialog = new GRITSProgressDialog(this.getShell(), 1, true);
        t_progressDialog.open();
        t_progressDialog.getMajorProgressBarListener().setMaxValue(2);
        t_progressDialog.setGritsWorker(new GRITSWorker(){

            public int doWork() {
                try {
                    this.updateListeners("Generating and exporting database...", 1);
                    CancelableThread t_thread = new CancelableThread(){

                        public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                            LipidDatabaseExporterXLSXForGRITSProgressDialog t_exportExcel;
                            block4: {
                                t_progressDialog.getMinorProgressBarListener(0).setMaxValue(1);
                                t_progressDialog.getMinorProgressBarListener(0).setProgressValue(0);
                                t_progressDialog.getMinorProgressBarListener(0).setProgressMessage("Generating lipid database...");
                                t_genDatabase.generate();
                                t_progressDialog.getMinorProgressBarListener(0).setProgressValue(1);
                                t_progressDialog.getMinorProgressBarListener(0).setProgressMessage("Done!");
                                LipidDatabase t_ldOutput = t_genDatabase.getLipidDatabase();
                                if (t_ldOutput.getLipidData().isEmpty()) {
                                    return false;
                                }
                                t_progressDialog.getMinorProgressBarListener(0).setMaxValue(1);
                                t_progressDialog.getMinorProgressBarListener(0).setProgressValue(0);
                                t_progressDialog.getMinorProgressBarListener(0).setProgressMessage("Output XML file...");
                                LipidDatabaseFileHandler.exportXML(t_strFileName, t_ldOutput);
                                t_progressDialog.getMinorProgressBarListener(0).setProgressValue(1);
                                t_progressDialog.getMinorProgressBarListener(0).setProgressMessage("Done!");
                                try {
                                    String t_strXLSXFileName = t_strFileName.replace(".xml", ".xlsx");
                                    t_exportExcel = new LipidDatabaseExporterXLSXForGRITSProgressDialog(t_ldOutput, t_strXLSXFileName, t_progressDialog);
                                    if (t_exportExcel.createBook()) break block4;
                                    return false;
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                    return false;
                                }
                            }
                            t_exportExcel.write();
                            return true;
                        }
                    };
                    t_thread.setProgressThreadHandler((IProgressThreadHandler)t_progressDialog);
                    t_progressDialog.setThread(t_thread);
                    t_progressDialog.getMinorProgressBarListener(0).setProgressType(IProgressListener.ProgressType.Determinant);
                    t_thread.start();
                    while (!t_thread.isCanceled() && !t_thread.isFinished() && t_thread.isAlive()) {
                        Display.getDefault().readAndDispatch();
                    }
                    if (t_thread.isCanceled()) {
                        t_thread.interrupt();
                        return GRITSProcessStatus.CANCEL;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                this.updateListeners("Done", 2);
                return GRITSProcessStatus.OK;
            }
        });
        t_progressDialog.startWorker();
        return true;
    }

    private LipidDatabaseGeneratorAbstract setParametersForLipidDatabase() {
        LipidDatabaseGeneratorAbstract t_genDatabase;
        if (this.m_pageLipidParam.isSelectedCeramide()) {
            CeramideDatabaseGenerator t_genCerDatabase = new CeramideDatabaseGenerator();
            t_genCerDatabase.setCarbonLengthesForSphingosine(this.m_pageLipidParam.getCarbonLengthForSphingosine());
            t_genCerDatabase.setNumbersOfHydrxylGroupsForSphingosine(this.m_pageLipidParam.getNumberOfHydroxyGroupsForSphingosine());
            t_genCerDatabase.setNumbersOfUnsaturationsForSphingosine(this.m_pageLipidParam.getNumberOfUnsaturationForSphingosine());
            t_genCerDatabase.allowOnlyEvenNumberedCarbonLengthOfSphingosine(this.m_pageLipidParam.isSelectedOnlyEvenNumbersForSphingosine());
            t_genCerDatabase.setCarbonLengthesForFattyAcid(this.m_pageLipidParam.getCarbonLengthForFattyAcid());
            t_genCerDatabase.setNumbersOfHydrxylGroupsForFattyAcid(this.m_pageLipidParam.getNumberOfHydroxyGroupsForFattyAcid());
            t_genCerDatabase.setNumbersOfUnsaturationsForFattyAcid(this.m_pageLipidParam.getNumberOfUnsaturationForFattyAcid());
            t_genCerDatabase.allowOnlyEvenNumberedCarbonLengthOfFattyAcid(this.m_pageLipidParam.isSelectedOnlyEvenNumbersForFattyAcid());
            t_genDatabase = t_genCerDatabase;
        } else {
            SphingosineDatabaseGenerator t_genSphDatabase = new SphingosineDatabaseGenerator();
            t_genSphDatabase.setCarbonLengths(this.m_pageLipidParam.getCarbonLengthForSphingosine());
            t_genSphDatabase.setNumbersOfHydroxylGroups(this.m_pageLipidParam.getNumberOfHydroxyGroupsForSphingosine());
            t_genSphDatabase.setNumbersOfDoubleBonds(this.m_pageLipidParam.getNumberOfUnsaturationForSphingosine());
            t_genSphDatabase.allowOnlyEvenNumberedCarbonLength(this.m_pageLipidParam.isSelectedOnlyEvenNumbersForSphingosine());
            t_genDatabase = t_genSphDatabase;
        }
        t_genDatabase.setLipidDatabaseName(this.m_pageEntry.getDatabaseTitle());
        t_genDatabase.setDescription(this.m_pageEntry.getDatabaseDescription());
        t_genDatabase.setVersion(this.m_pageEntry.getVersion());
        t_genDatabase.setCreatorName(this.m_pageEntry.getCreatorName());
        t_genDatabase.setCreatorInstitution(this.m_pageEntry.getCreatorInstitution());
        t_genDatabase.setGeneratedBy("Lipid Database Generation Wizard");
        return t_genDatabase;
    }
}

