/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.GlyContainerToWURCSGraph;

import java.util.LinkedList;
import java.util.TreeMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseTypeDictionary;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.WURCSFramework.util.exchange.WURCSExchangeException;

public class MonosaccharideAnalyzer {
    private Monosaccharide mono = null;
    private boolean isAldose = true;
    private int anomericPos = 0;
    private char anomericSymbol = (char)120;
    private int numOfAtom = 0;
    private char configuration = (char)88;
    private String skeletonCode = "";
    private LinkedList<Integer> anomericPositions;
    private TreeMap<Integer, Character> posToChar = new TreeMap();
    private LinkedList<String> unknownPosMap = new LinkedList();

    public MonosaccharideAnalyzer() {
        this.anomericPositions = new LinkedList();
    }

    public int getAnomericPosition() {
        return this.anomericPos;
    }

    public char getAnomericSymbol() {
        return this.anomericSymbol;
    }

    public int getNumberOfCarbons() {
        return this.numOfAtom;
    }

    public char getConfiguration() {
        return this.configuration;
    }

    public String getSkeletonCode() {
        return this.skeletonCode;
    }

    public LinkedList<String> getCoreModificationUnknownPosiiton() {
        return this.unknownPosMap;
    }

    public boolean isAldose() {
        return this.isAldose;
    }

    public void analyze(Node _node) throws WURCSExchangeException, GlycanException {
        this.mono = (Monosaccharide)_node;
        this.anomericPos = this.mono.getRingStart();
        this.anomericSymbol = this.mono.getAnomer().getAnomericState();
        if (this.anomericPos == 0) {
            this.anomericSymbol = (char)111;
        }
        if (this.anomericSymbol == 'o') {
            this.anomericPos = 0;
        }
        this.numOfAtom = this.mono.getSuperClass().getSize();
        this.posToChar.put(1, Character.valueOf('h'));
        this.posToChar.put(this.numOfAtom, Character.valueOf('h'));
        LinkedList<GlyCoModification> mods = new LinkedList<GlyCoModification>();
        for (GlyCoModification mod : this.mono.getModifications()) {
            if (mod.hasPositionTwo()) {
                if (!this.isDoublebond(mod)) continue;
                mods.add(mod);
                continue;
            }
            this.ModificationToCarbonDescriptor(mod);
        }
        if (!this.anomericPositions.isEmpty() && this.anomericPositions.getFirst() != 1) {
            this.isAldose = false;
        }
        if (this.isAldose) {
            this.posToChar.put(1, Character.valueOf('o'));
            this.anomericPositions.addFirst(1);
        }
        if (this.anomericPositions.isEmpty()) {
            this.anomericPos = 0;
            this.anomericSymbol = (char)111;
        }
        if (this.anomericPos != 0 && this.anomericPos != -1) {
            if (!this.posToChar.containsKey(this.anomericPos)) {
                throw new WURCSExchangeException("Illegal structure is found at ring start position.");
            }
            char carbonDescriptor = this.posToChar.get(this.anomericPos).charValue();
            if (carbonDescriptor == 'o' || carbonDescriptor == 'O') {
                this.posToChar.put(this.anomericPos, Character.valueOf('a'));
            }
        }
        for (GlyCoModification carbonDescriptor : mods) {
        }
        int brankPosition = 0;
        int i = 2;
        while (i < this.numOfAtom) {
            if (!this.posToChar.containsKey(i)) {
                ++brankPosition;
            }
            ++i;
        }
        String stereo = this.convertBaseTypesToSkeletonCode(this.mono.getStereos());
        if (!stereo.equals("") && stereo.length() != brankPosition) {
            throw new WURCSExchangeException("There is the excess or shortage of the stereo information.");
        }
        int j = 0;
        int i2 = 2;
        while (i2 < this.numOfAtom) {
            if (!this.posToChar.containsKey(i2)) {
                char carbonDescriptor = stereo.equals("") ? (char)'x' : (char)stereo.charAt(j);
                this.posToChar.put(i2, Character.valueOf(carbonDescriptor));
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.numOfAtom) {
            this.skeletonCode = String.valueOf(this.skeletonCode) + this.posToChar.get(i2 + 1);
            ++i2;
        }
    }

    private String convertBaseTypesToSkeletonCode(LinkedList<String> _stereos) throws GlycanException {
        String stereoCode = "";
        LinkedList<String> configurations = new LinkedList<String>();
        for (String stereo : _stereos) {
            BaseTypeDictionary baseDict = BaseTypeDictionary.forName(stereo);
            if (baseDict == null) {
                throw new GlycanException(String.valueOf(stereo) + " could not found!");
            }
            String code = baseDict.getStereoCode();
            if (code.endsWith("1")) {
                configurations.add("L");
            }
            if (code.endsWith("2")) {
                configurations.add("D");
            }
            stereoCode = String.valueOf(code) + stereoCode;
        }
        String configuration = "X";
        if (configurations.size() > 0) {
            configuration = (String)configurations.getLast();
        }
        this.configuration = configuration.charAt(0);
        return stereoCode;
    }

    private void ModificationToCarbonDescriptor(GlyCoModification _glyCoMod) throws WURCSExchangeException {
        int pos = _glyCoMod.getPositionOne();
        boolean isTerminal = pos == 1 || pos == this.numOfAtom;
        char carbonDescriptor = this.ModificationTempalteToCarbonDescriptor(_glyCoMod.getModificationTemplate());
        if (carbonDescriptor == 'd' && isTerminal) {
            carbonDescriptor = 'm';
        }
        if (carbonDescriptor == 'O') {
            this.anomericPositions.add(pos);
            if (isTerminal) {
                carbonDescriptor = 'o';
            }
        }
        if (pos == 1) {
            this.isAldose = false;
        }
        if (pos == 0) {
            this.unknownPosMap.add("*");
        }
        if (carbonDescriptor == 'h' && !isTerminal) {
            throw new WURCSExchangeException("Modification \"aldi\" is must set to first carbon.");
        }
        if (carbonDescriptor == 'A' && !isTerminal) {
            throw new WURCSExchangeException("Can not do carboxylation to non-terminal carbon.");
        }
        if (carbonDescriptor == ' ') {
            throw new WURCSExchangeException("Unknown modification is found.");
        }
        this.posToChar.put(pos, Character.valueOf(carbonDescriptor));
    }

    private boolean isDoublebond(GlyCoModification _glyCoMod) {
        ModificationTemplate modT = _glyCoMod.getModificationTemplate();
        if (modT.equals((Object)ModificationTemplate.UNSATURATION_EL)) {
            return true;
        }
        if (modT.equals((Object)ModificationTemplate.UNSATURATION_FL)) {
            return true;
        }
        if (modT.equals((Object)ModificationTemplate.UNSATURATION_ZL)) {
            return true;
        }
        if (modT.equals((Object)ModificationTemplate.UNSATURATION_EU)) {
            return true;
        }
        if (modT.equals((Object)ModificationTemplate.UNSATURATION_FU)) {
            return true;
        }
        return modT.equals((Object)ModificationTemplate.UNSATURATION_ZU);
    }

    private char ModificationTempalteToCarbonDescriptor(ModificationTemplate _modT) {
        if (_modT.equals((Object)ModificationTemplate.KETONE_U)) {
            return 'O';
        }
        return _modT.getCarbon();
    }
}

