/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.IGritsPreferenceStore;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.entry.qrtpcr.editor.IQrtPCRPart;
import org.grits.toolbox.entry.qrtpcr.editor.MasterTablePage;
import org.grits.toolbox.entry.qrtpcr.editor.OverviewPage;
import org.grits.toolbox.entry.qrtpcr.editor.PlateTablePage;
import org.grits.toolbox.entry.qrtpcr.model.CtHistory;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRRun;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRTable;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRGeneListTablePreference;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRMasterTablePreference;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRMergeTablePreference;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRPreference;
import org.grits.toolbox.entry.qrtpcr.property.QrtPCRProperty;
import org.grits.toolbox.entry.qrtpcr.table.QrtPCRNatTable;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;

public class QrtPCRTableEditor
implements IQrtPCRPart {
    private static final Logger logger = Logger.getLogger(QrtPCRTableEditor.class);
    public static final String ID = "org.grits.toolbox.entry.qrtpcr.editor";
    public static final String LOWER_THRESHOLD_CONTEXT = "lowerThresholdContext";
    public static final String STDEV_CONTEXT = "stDevContext";
    public static final String RAW_CONTEXT = "rawContext";
    public static final String RUNID_CONTEXT = "runIdContext";
    private QrtPCRRun pcrRun;
    private String fileLocation = null;
    OverviewPage overviewPage;
    private MasterTablePage masterTablePage;
    Composite parent;
    private CTabFolder cTabFolder = null;
    private Map<CTabItem, IQrtPCRPart> cTabItemToPartTabMap = new HashMap<CTabItem, IQrtPCRPart>();
    Entry entry;
    @Inject
    private MDirtyable dirtyable = null;
    @Inject
    IGritsPreferenceStore gritsPreferenceStore;

    @Inject
    public QrtPCRTableEditor(@Named(value="org.eclipse.ui.selection") Entry entry, @Named(value="e4ActivePart") MPart part, @Named(value="workspace_location") String workspaceLocation) {
        try {
            this.entry = entry;
            String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + entry.getParent().getParent().getDisplayName();
            String qrtPCRFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "qrtPCR";
            QrtPCRProperty qPCRProperty = (QrtPCRProperty)entry.getProperty();
            String fileName = qPCRProperty.getFilename();
            this.fileLocation = String.valueOf(qrtPCRFolderLocation) + File.separator + fileName;
            File experimentFile = new File(this.fileLocation);
            FileInputStream inputStream = new FileInputStream(experimentFile.getAbsolutePath());
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{QrtPCRRun.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            this.pcrRun = (QrtPCRRun)unmarshaller.unmarshal((Reader)reader);
            part.getContext().set(QrtPCRRun.class, (Object)this.pcrRun);
            reader.close();
            inputStream.close();
            part.setLabel(entry.getDisplayName());
        }
        catch (IOException e) {
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot create the  QrtPCR Table", (Exception)e);
            logger.error((Object)"org.grits.toolbox.entry.qrtpcr Cannot create the QrtPCR Table", (Throwable)e);
        }
        catch (JAXBException e) {
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot Load the  QrtPCR Table", (Exception)((Object)e));
            logger.warn((Object)"org.grits.toolbox.entry.qrtpcr Cannot Load the  QrtPCR Table", (Throwable)e);
        }
    }

    @Persist
    public void doSave() {
        if (this.updateFile()) {
            this.resetDirtyFlag();
        }
    }

    private boolean updateFile() {
        boolean updated = false;
        try {
            FileUtils.saveQrtPCRRun(this.pcrRun, this.fileLocation);
            updated = true;
        }
        catch (IOException e) {
            logger.error((Object)"The changes made could not be written to the file.", (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Writing File", (String)"The changes made could not be written to the file.");
        }
        catch (JAXBException e) {
            logger.error((Object)"The changes made could not be serialized as xml.", (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Parsing File", (String)"The changes made could not be serialized to xml.");
        }
        return updated;
    }

    @Focus
    public void onFocus() {
        if (this.overviewPage != null) {
            this.overviewPage.setFocus();
        }
    }

    public void refreshInput(QrtPCRRun newRun) {
        this.pcrRun = newRun;
        if (this.masterTablePage != null) {
            this.masterTablePage.refreshInput(newRun.getFirstRun());
        }
        if (this.overviewPage != null) {
            this.overviewPage.refreshInput(newRun);
        }
    }

    @PostConstruct
    public void postConstruct(Composite parent, final MPart part) {
        this.parent = parent;
        parent.setLayout((Layout)new FillLayout());
        logger.info((Object)"Creating tabs");
        this.cTabFolder = new CTabFolder(parent, 0);
        this.cTabFolder.setTabPosition(1024);
        this.cTabFolder.setSimple(false);
        part.getContext().set(CTabFolder.class, (Object)this.cTabFolder);
        part.getContext().set(QrtPCRTableEditor.class, (Object)this);
        try {
            this.cTabFolder.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.changeTab(e);
                }

                private void changeTab(SelectionEvent e) {
                    int selectionIndex = QrtPCRTableEditor.this.cTabFolder.getSelectionIndex();
                    logger.info((Object)("Tab changed to " + selectionIndex));
                    selectionIndex = selectionIndex < 0 ? 0 : selectionIndex;
                    IQrtPCRPart currentTab = QrtPCRTableEditor.this.getcTabItemToPartTabMap().get(QrtPCRTableEditor.this.cTabFolder.getSelection());
                    part.getContext().set(IQrtPCRPart.class, (Object)currentTab);
                    QrtPCRTableEditor.this.cTabFolder.getSelection().notifyListeners(13, new Event());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.changeTab(e);
                }
            });
            this.addPages(part);
            this.cTabFolder.setSelection(0);
            this.cTabFolder.notifyListeners(13, new Event());
        }
        catch (Exception e) {
            logger.fatal((Object)("Error while adding tabs to the qrtpcr editor.\n" + e.getMessage()), (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Creating Page", (String)"Some unexpected error occurred while opening the editor. Please contact developers for further information/help.");
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)"END   : Creating QrtPCRTableEditor. ");
    }

    protected void addPages(MPart part) {
        logger.info((Object)"Adding overview tabs");
        CTabItem cTabItem = new CTabItem(this.cTabFolder, 0);
        cTabItem.setText("Overview");
        cTabItem.setShowClose(false);
        part.getContext().set(QrtPCRRun.class, (Object)this.pcrRun);
        part.getContext().set(CTabItem.class, (Object)cTabItem);
        this.overviewPage = (OverviewPage)ContextInjectionFactory.make(OverviewPage.class, (IEclipseContext)part.getContext());
        this.getcTabItemToPartTabMap().put(cTabItem, this.overviewPage);
        cTabItem = new CTabItem(this.cTabFolder, 0);
        cTabItem.setText("Master Table");
        cTabItem.setShowClose(false);
        part.getContext().set(QrtPCRTable.class, (Object)this.pcrRun.getFirstRun());
        part.getContext().set(CTabItem.class, (Object)cTabItem);
        part.getContext().set(LOWER_THRESHOLD_CONTEXT, (Object)this.pcrRun.getThreshold());
        part.getContext().set(STDEV_CONTEXT, (Object)this.pcrRun.getStDevCutOff());
        this.masterTablePage = (MasterTablePage)ContextInjectionFactory.make(MasterTablePage.class, (IEclipseContext)part.getContext());
        this.getcTabItemToPartTabMap().put(cTabItem, this.masterTablePage);
    }

    public void addPlatePage(Integer runId, String plateId, String filename, boolean raw) {
        if (this.overviewPage != null) {
            this.overviewPage.addPageToPlateTable(runId, plateId, filename, raw);
        }
    }

    public int getNumberOfPages() {
        return this.cTabFolder.getItemCount();
    }

    private void resetDirtyFlag() {
        this.dirtyable.setDirty(false);
    }

    public void markDirty() {
        this.dirtyable.setDirty(true);
        if (this.masterTablePage != null) {
            this.masterTablePage.refreshInput();
        }
    }

    public void setOriginalForRun(Integer runId) {
        if (runId != null) {
            QrtPCRTable table = this.pcrRun.getRun(runId);
            table.setOriginal(false);
        }
    }

    public void updateFirstRun(QrtPCRData qrtPCRData, Integer runId) {
        if (runId == 0) {
            return;
        }
        QrtPCRTable firstRun = this.pcrRun.getFirstRun();
        for (QrtPCRData data : firstRun.getPlateDataMap().values()) {
            block1: for (Gene gene2 : qrtPCRData.getGenes()) {
                for (Gene gene : data.getGenes()) {
                    List<GeneData> geneDataList;
                    if (!gene.getGeneIdentifier().equals(gene2.getGeneIdentifier()) || (geneDataList = gene.getDataMap().get(runId)) == null) continue;
                    int i = 0;
                    for (GeneData geneData : geneDataList) {
                        Double newValue = gene2.getDataMap().get(0).get(i++).getCt();
                        if (newValue == null || newValue.equals(geneData.getCt())) continue;
                        geneData.addPreviousValue(geneData.getCt(), CtHistory.Reason.RERUN.getReason());
                        geneData.setCt(newValue);
                    }
                    continue block1;
                }
            }
        }
    }

    public void updateFirstRun(Gene gene2, Integer runId) {
        if (runId == 0) {
            return;
        }
        QrtPCRTable firstRun = this.pcrRun.getFirstRun();
        block0: for (QrtPCRData data : firstRun.getPlateDataMap().values()) {
            for (Gene gene : data.getGenes()) {
                List<GeneData> geneDataList;
                if (!gene.getGeneIdentifier().equals(gene2.getGeneIdentifier()) || (geneDataList = gene.getDataMap().get(runId)) == null) continue;
                int i = 0;
                for (GeneData geneData : geneDataList) {
                    geneData.addPreviousValue(geneData.getCt(), CtHistory.Reason.RERUN.getReason());
                    geneData.setCt(gene2.getDataMap().get(0).get(i++).getCt());
                }
                continue block0;
            }
        }
    }

    public void switchToLast() {
        this.cTabFolder.setSelection(this.getNumberOfPages() - 1);
    }

    public Entry getEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    @Optional
    @Inject
    public void updatePreferences(@UIEventTopic(value="preference_value_changed_in_grits") String preferenceName) {
        if (QrtPCRPreference.getPreferenceID().equals(preferenceName)) {
            try {
                PreferenceEntity preferenceEntity = this.gritsPreferenceStore.getPreferenceEntity(preferenceName);
                QrtPCRPreference updatePref = (QrtPCRPreference)TableViewerPreference.getTableViewerPreference((PreferenceEntity)preferenceEntity, QrtPCRPreference.class);
                this.updateColumnPreferences(updatePref);
            }
            catch (UnsupportedVersionException e) {
                logger.error((Object)"Error updating column visibility", (Throwable)e);
            }
        } else if (QrtPCRMergeTablePreference.getPreferenceID().equals(preferenceName)) {
            try {
                PreferenceEntity preferenceEntity = this.gritsPreferenceStore.getPreferenceEntity(preferenceName);
                QrtPCRMergeTablePreference updatePref = (QrtPCRMergeTablePreference)TableViewerPreference.getTableViewerPreference((PreferenceEntity)preferenceEntity, QrtPCRMergeTablePreference.class);
                this.updateColumnPreferences(updatePref);
            }
            catch (UnsupportedVersionException e) {
                logger.error((Object)"Error updating column visibility", (Throwable)e);
            }
        } else if (QrtPCRGeneListTablePreference.getPreferenceID().equals(preferenceName)) {
            try {
                PreferenceEntity preferenceEntity = this.gritsPreferenceStore.getPreferenceEntity(preferenceName);
                QrtPCRGeneListTablePreference updatePref = (QrtPCRGeneListTablePreference)TableViewerPreference.getTableViewerPreference((PreferenceEntity)preferenceEntity, QrtPCRGeneListTablePreference.class);
                this.updateColumnPreferences(updatePref);
            }
            catch (UnsupportedVersionException e) {
                logger.error((Object)"Error updating column visibility after preference change", (Throwable)e);
            }
        } else if (QrtPCRMasterTablePreference.getPreferenceID().equals(preferenceName)) {
            try {
                PreferenceEntity preferenceEntity = this.gritsPreferenceStore.getPreferenceEntity(preferenceName);
                QrtPCRMasterTablePreference updatePref = (QrtPCRMasterTablePreference)TableViewerPreference.getTableViewerPreference((PreferenceEntity)preferenceEntity, QrtPCRMasterTablePreference.class);
                this.updateColumnPreferences(updatePref);
            }
            catch (UnsupportedVersionException e) {
                logger.error((Object)"Error updating column visibility after preference change", (Throwable)e);
            }
        }
    }

    private void updateColumnPreferences(QrtPCRPreference updatePref) {
        IQrtPCRPart activePage = this.getcTabItemToPartTabMap().get(this.cTabFolder.getSelection());
        if (activePage instanceof PlateTablePage) {
            this.updateColumnPreferences(((PlateTablePage)activePage).getTable(), (QrtPCRPreference)((PlateTablePage)activePage).getTable().getTablePreference(), updatePref);
        } else if (activePage instanceof MasterTablePage) {
            this.updateColumnPreferences(((MasterTablePage)activePage).getTable(), (QrtPCRPreference)((MasterTablePage)activePage).getTable().getTablePreference(), updatePref);
        }
    }

    protected void updateColumnPreferences(QrtPCRNatTable table, QrtPCRPreference curPref, QrtPCRPreference updatePref) {
        if (((Object)((Object)curPref)).getClass().equals(((Object)((Object)updatePref)).getClass()) && !updatePref.getColumnSettings().equals(curPref.getColumnSettings())) {
            table.setTablePreference(updatePref);
            table.updateViewFromPreferenceSettings();
        }
    }

    public Map<CTabItem, IQrtPCRPart> getcTabItemToPartTabMap() {
        return this.cTabItemToPartTabMap;
    }

    public void setcTabItemToPartTabMap(Map<CTabItem, IQrtPCRPart> cTabItemToPartTabMap) {
        this.cTabItemToPartTabMap = cTabItemToPartTabMap;
    }

    public boolean isDirty() {
        return this.dirtyable.isDirty();
    }
}

