/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.editor;

import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ProjectExplorerDialog;
import org.grits.toolbox.core.utilShare.EntrySelectionAdapter;

public class QrtPCREntrySelectionAdapter
extends EntrySelectionAdapter {
    private Table entryDialogTable;
    private Map<String, String> listEntries;
    private List<Entry> entries;

    public QrtPCREntrySelectionAdapter(String a_propertyType, String a_dialogTitle, String a_dialogMessage) {
        super(a_propertyType, a_dialogTitle, a_dialogMessage);
    }

    public void setList(Table entryDialogTable) {
        this.entryDialogTable = entryDialogTable;
    }

    public void setListEntries(Map<String, String> listEntries2) {
        this.listEntries = listEntries2;
    }

    public void setEntries(List<Entry> entryList) {
        this.entries = entryList;
    }

    public void widgetSelected(SelectionEvent event) {
        Entry entry;
        Shell newShell = new Shell(this.parent.getShell(), 0x10008000);
        ProjectExplorerDialog dlg = new ProjectExplorerDialog(newShell);
        dlg.addFilter("org.grits.toolbox.property.qrtpcr");
        dlg.setTitle("qRT-PCR entry selection");
        dlg.setMessage("Choose an entry to add");
        if (dlg.open() == 0 && (entry = dlg.getEntry()) != null) {
            String displayName = entry.getDisplayName();
            if (this.listEntries.isEmpty()) {
                this.addToList(entry, displayName);
            } else if (!this.listEntries.containsKey(displayName)) {
                this.addToList(entry, displayName);
            }
        }
    }

    private void addToList(Entry entry, String displayName) {
        this.listEntries.put(displayName, displayName);
        TableItem item = new TableItem(this.entryDialogTable, 0);
        item.setText(0, displayName);
        item.setText(1, displayName);
        this.entryDialogTable.setSelection(this.entryDialogTable.getItemCount() - 1);
        this.entryDialogTable.notifyListeners(24, null);
        this.entries.add(entry);
    }
}

