/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.jrap.grits.stax;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.systemsbiology.jrap.grits.stax.EndPatternStringIterator;
import org.systemsbiology.jrap.grits.stax.FileHeaderParser;
import org.systemsbiology.jrap.grits.stax.IndexParser;
import org.systemsbiology.jrap.grits.stax.MLScanAndHeaderParser;
import org.systemsbiology.jrap.grits.stax.MZXMLFileInfo;
import org.systemsbiology.jrap.grits.stax.Scan;
import org.systemsbiology.jrap.grits.stax.ScanAndHeaderParser;
import org.systemsbiology.jrap.grits.stax.ScanHeader;

public final class MSXMLParser {
    protected String fileName = null;
    protected Map<Integer, Long> offsets;
    protected int maxScan;
    protected long chrogramIndex;
    protected boolean isXML = false;
    protected boolean isML = false;
    int currentScanIndex;
    EndPatternStringIterator epsi = null;

    public void setEpsi(EndPatternStringIterator e) {
        this.epsi = e;
    }

    public EndPatternStringIterator getEpsi() {
        return this.epsi;
    }

    public static boolean isMzXML(String fn) {
        return fn.toLowerCase().indexOf("mzxml") != -1;
    }

    private void commonInits(String fileName) {
        if (MSXMLParser.isMzXML(fileName)) {
            this.isXML = true;
        } else {
            this.isML = true;
        }
        this.fileName = fileName;
    }

    private void sequentialInits() throws IOException {
        String leftPat = "<msRun";
        String rightPat = ">";
        String attr = "scanCount";
        String nextLeftPat = "<scan";
        String nextRightPat = "</peaks>";
        if (this.isML) {
            leftPat = "<spectrumList";
            rightPat = ">";
            attr = "count";
            nextLeftPat = "<spectrum";
            nextRightPat = "</spectrum>";
        }
        this.setEpsi(new EndPatternStringIterator(leftPat, rightPat, this.fileName));
        XMLStreamReader xmlSR = this.epsi.xmlsrNext();
        try {
            xmlSR.next();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        try {
            this.maxScan = Integer.parseInt(xmlSR.getAttributeValue(null, attr));
        }
        catch (NumberFormatException ex) {
            this.maxScan = -1;
        }
        this.offsets = new HashMap<Integer, Long>();
        this.setEpsi(new EndPatternStringIterator(nextLeftPat, nextRightPat, this.fileName));
        try {
            ScanHeader header = this.nextHeader();
            while (header != null) {
                header = this.nextHeader();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.maxScan < this.currentScanIndex) {
            this.maxScan = this.currentScanIndex;
        }
        this.currentScanIndex = 0;
    }

    private void randomInits() {
        IndexParser indexParser = new IndexParser(this.fileName);
        indexParser.parseIndexes();
        this.offsets = indexParser.getOffsetMap();
        this.maxScan = indexParser.getMaxScan();
        this.chrogramIndex = indexParser.getChrogramIndex();
    }

    public MSXMLParser(String fn, boolean isSequential) throws IOException {
        this.commonInits(fn);
        if (isSequential) {
            this.sequentialInits();
        } else {
            this.randomInits();
        }
    }

    public MSXMLParser(String fileName) {
        this.commonInits(fileName);
        try {
            this.randomInits();
        }
        catch (Exception ex) {
            try {
                this.sequentialInits();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.maxScan <= 0) {
            try {
                this.sequentialInits();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public MZXMLFileInfo rapFileHeader() {
        FileHeaderParser fileParser = new FileHeaderParser(this.fileName);
        fileParser.parseFileHeader();
        return fileParser.getInfo();
    }

    public ScanHeader rapHeader(int scanNumber) {
        FileInputStream fileIN = null;
        long scanOffset = -1L;
        try {
            fileIN = new FileInputStream(this.fileName);
            scanOffset = this.getScanOffset(scanNumber);
            if (scanOffset == -1L) {
                this.closeFile(fileIN);
                return null;
            }
            fileIN.skip(scanOffset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ScanHeader scanHeader = null;
        if (this.isXML) {
            ScanAndHeaderParser headerParser = new ScanAndHeaderParser();
            headerParser.setIsScan(false);
            headerParser.setFileInputStream(fileIN);
            headerParser.parseScanAndHeader();
            this.closeFile(fileIN);
            scanHeader = headerParser.getHeader();
        } else {
            MLScanAndHeaderParser headerParser = new MLScanAndHeaderParser();
            headerParser.setIsScan(false);
            headerParser.setFileInputStream(fileIN);
            headerParser.parseMLScanAndHeader();
            this.closeFile(fileIN);
            scanHeader = headerParser.getHeader();
        }
        scanHeader.setScanOffset(scanOffset);
        return scanHeader;
    }

    public ScanHeader nextHeader() {
        ScanHeader scanHeader = null;
        StringBuilder curScanInfo = this.epsi.next();
        if (curScanInfo == null || curScanInfo.length() == 0 || curScanInfo.charAt(0) != '<') {
            return null;
        }
        ++this.currentScanIndex;
        if (this.isXML) {
            ScanAndHeaderParser headerParser = new ScanAndHeaderParser();
            headerParser.setIsScan(false);
            try {
                headerParser.parseScanAndHeader(this.epsi.xmlsrCur());
            }
            catch (Exception exception) {
                // empty catch block
            }
            scanHeader = headerParser.getHeader();
        } else {
            MLScanAndHeaderParser headerParser = new MLScanAndHeaderParser();
            headerParser.setIsScan(false);
            try {
                headerParser.parseMLScanAndHeader(this.epsi.xmlsrCur());
            }
            catch (Exception exception) {
                // empty catch block
            }
            scanHeader = headerParser.getHeader();
        }
        this.offsets.put(scanHeader.getNum(), this.epsi.getFilePos());
        scanHeader.setScanOffset(this.epsi.getFilePos());
        return scanHeader;
    }

    public Map<Integer, Long> getOffsets() {
        return this.offsets;
    }

    private void closeFile(FileInputStream fileIN) {
        if (fileIN != null) {
            try {
                fileIN.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Scan rap(int scanNumber) {
        FileInputStream fileIN = null;
        try {
            fileIN = new FileInputStream(this.fileName);
            long scanOffset = this.getScanOffset(scanNumber);
            if (scanOffset == -1L) {
                this.closeFile(fileIN);
                return null;
            }
            fileIN.skip(scanOffset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.isXML) {
            ScanAndHeaderParser scanParser = new ScanAndHeaderParser();
            scanParser.setIsScan(true);
            scanParser.setFileInputStream(fileIN);
            scanParser.parseScanAndHeader();
            this.closeFile(fileIN);
            return scanParser.getScan();
        }
        MLScanAndHeaderParser scanParser = new MLScanAndHeaderParser();
        scanParser.setIsScan(true);
        scanParser.setFileInputStream(fileIN);
        scanParser.parseMLScanAndHeader();
        this.closeFile(fileIN);
        return scanParser.getScan();
    }

    public int getScanCount() {
        if (this.epsi != null) {
            return this.maxScan;
        }
        return this.offsets.size();
    }

    public int getMaxScanNumber() {
        return this.maxScan;
    }

    public long getScanOffset(int scanNumber) {
        if (scanNumber > 0 && this.offsets.containsKey(scanNumber)) {
            return this.offsets.get(scanNumber);
        }
        return -1L;
    }
}

