/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXUtils {
    private SAXUtils() {
    }

    public static void read(InputStream is, DefaultHandler h) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(is, h);
    }

    public static void write(OutputStream os, SAXWriter w) throws Exception {
        StreamResult streamResult = new StreamResult(os);
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler hd = tf.newTransformerHandler();
        Transformer serializer = hd.getTransformer();
        serializer.setOutputProperty("encoding", "ISO-8859-1");
        serializer.setOutputProperty("indent", "yes");
        hd.setResult(streamResult);
        hd.startDocument();
        w.write(hd);
        hd.endDocument();
    }

    public static interface SAXWriter {
        public void write(TransformerHandler var1) throws SAXException;
    }

    private static class DocumentHandler
    extends ObjectTreeHandler {
        private ObjectTreeHandler root_handler = null;

        public DocumentHandler(ObjectTreeHandler _root) {
            this.root_handler = _root;
        }

        public ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (this.root_handler != null && this.root_handler.isElement(namespaceURI, localName, qName)) {
                return this.root_handler;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectTreeHandler
    extends DefaultHandler {
        protected Locator theLocator = null;
        protected LinkedList<ObjectTreeHandler> handlers_stack = new LinkedList();
        protected Object object = null;
        protected StringBuilder text = new StringBuilder();
        protected HashMap<String, Vector<Object>> sub_objects = new HashMap();

        public String getText() {
            return this.text.toString();
        }

        public Object getObject() {
            return this.object;
        }

        protected boolean isElement(String namespaceURI, String localName, String qName) {
            return false;
        }

        protected ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) throws SAXException {
            return null;
        }

        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.object = null;
            this.text = new StringBuilder();
            this.sub_objects = new HashMap();
        }

        protected void addText(char[] buf, int start, int length) throws SAXException {
            for (int i = 0; i < length; ++i) {
                this.text.append(buf[start + i]);
            }
        }

        protected void addWhiteSpace() throws SAXException {
            this.text.append(' ');
        }

        protected void addObject(String name, Object o) {
            if (o != null) {
                Vector<Object> v = this.sub_objects.get(name);
                if (v == null) {
                    v = new Vector();
                    this.sub_objects.put(name, v);
                }
                v.add(o);
            }
        }

        protected Object getSubObject(String name, boolean assert_non_null) throws SAXException {
            Vector<Object> v = this.sub_objects.get(name);
            if (v == null) {
                if (assert_non_null) {
                    throw new SAXException(this.createMessage("Cannot find object with name " + name));
                }
                return null;
            }
            if (v.size() > 1) {
                throw new SAXException(this.createMessage("Multiple objects with name " + name));
            }
            return v.get(0);
        }

        protected Object getSubObject(String name, Object default_value) throws SAXException {
            Vector<Object> v = this.sub_objects.get(name);
            if (v == null) {
                return default_value;
            }
            if (v.size() > 1) {
                throw new SAXException(this.createMessage("Multiple objects with name " + name));
            }
            return v.get(0);
        }

        protected Vector<Object> getSubObjects(String name) {
            Vector<Object> v = this.sub_objects.get(name);
            if (v == null) {
                return new Vector<Object>();
            }
            return v;
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            return this.object;
        }

        protected String stringAttribute(Attributes atts, String name, String default_value) {
            if (atts == null || name == null) {
                return default_value;
            }
            if (atts.getValue(name) == null) {
                return default_value;
            }
            return atts.getValue(name);
        }

        protected String stringAttribute(Attributes atts, String name) {
            return this.stringAttribute(atts, name, null);
        }

        protected Double doubleAttribute(Attributes atts, String name, Double default_value) {
            if (atts == null || name == null) {
                return default_value;
            }
            if (atts.getValue(name) == null) {
                return default_value;
            }
            return Double.valueOf(atts.getValue(name));
        }

        protected Double doubleAttribute(Attributes atts, String name) {
            return this.doubleAttribute(atts, name, null);
        }

        protected Integer integerAttribute(Attributes atts, String name, Integer default_value) {
            if (atts == null || name == null) {
                return default_value;
            }
            if (atts.getValue(name) == null) {
                return default_value;
            }
            return Integer.valueOf(atts.getValue(name));
        }

        protected Integer integerAttribute(Attributes atts, String name) {
            return this.integerAttribute(atts, name, null);
        }

        protected Boolean booleanAttribute(Attributes atts, String name, Boolean default_value) {
            if (atts == null || name == null) {
                return default_value;
            }
            if (atts.getValue(name) == null) {
                return default_value;
            }
            return Boolean.valueOf(atts.getValue(name));
        }

        protected Boolean booleanAttribute(Attributes atts, String name) {
            return this.booleanAttribute(atts, name, null);
        }

        protected String createMessage(String message) {
            if (this.theLocator == null) {
                return message;
            }
            return message + " at line " + this.theLocator.getLineNumber() + " column " + this.theLocator.getColumnNumber();
        }

        protected String createMessage(Exception e) {
            if (e == null) {
                return this.createMessage("Exception");
            }
            return this.createMessage(e.getMessage());
        }

        @Override
        public void startDocument() throws SAXException {
            if (this.handlers_stack.size() != 0) {
                throw new SAXException(this.createMessage("Unexpected start of document"));
            }
            this.pushHandler(new DocumentHandler(this));
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            ObjectTreeHandler handler;
            if (this.handlers_stack.size() == 0) {
                new SAXException(this.createMessage("Unexpected start of element"));
            }
            if ((handler = this.currentHandler().getHandler(namespaceURI, localName, qName)) == null) {
                handler = new ObjectTreeHandler();
            }
            handler.initContent(namespaceURI, localName, qName, atts);
            this.pushHandler(handler);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.handlers_stack.size() == 0) {
                new SAXException(this.createMessage("Unexpected character content"));
            }
            this.currentHandler().addText(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.handlers_stack.size() == 0) {
                new SAXException(this.createMessage("Unexpected character content"));
            }
            this.currentHandler().addWhiteSpace();
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.handlers_stack.size() == 0) {
                new SAXException(this.createMessage("Unexpected end of element"));
            }
            Object sub_object = this.currentHandler().finalizeContent(namespaceURI, localName, qName);
            this.popHandler();
            if (sub_object != null) {
                this.currentHandler().addObject(qName, sub_object);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.handlers_stack.size() == 0) {
                new SAXException(this.createMessage("Unexpected end of document"));
            }
            this.popHandler();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.theLocator = locator;
        }

        private void pushHandler(ObjectTreeHandler handler) throws SAXException {
            if (handler == null) {
                throw new SAXException(this.createMessage("Invalid null handler"));
            }
            this.handlers_stack.addFirst(handler);
        }

        private void popHandler() throws SAXException {
            if (this.handlers_stack.size() == 0) {
                throw new SAXException(this.createMessage("Empty stack"));
            }
            this.handlers_stack.removeFirst();
        }

        private ObjectTreeHandler currentHandler() throws SAXException {
            if (this.handlers_stack.size() == 0) {
                throw new SAXException(this.createMessage("Empty stack"));
            }
            return this.handlers_stack.getFirst();
        }
    }
}

