/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utilShare.validator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Image;

public class DateValidator
implements ICellEditorValidator {
    private static String DATE_FORMAT = "MM/dd/yyyy";
    private SimpleDateFormat simpleDateFormat = null;
    private ControlDecoration controlDecoration = null;

    public DateValidator(ControlDecoration controlDecoration) {
        this.controlDecoration = controlDecoration;
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.controlDecoration.setMarginWidth(2);
        this.controlDecoration.setImage(errorImage);
        this.setSimpleDateFormat();
    }

    public DateValidator(ControlDecoration controlDecoration, String dateFormat) {
        this(controlDecoration);
        DATE_FORMAT = dateFormat;
        this.setSimpleDateFormat();
    }

    private void setSimpleDateFormat() {
        this.simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        this.simpleDateFormat.setLenient(false);
    }

    public String isValid(Object value) {
        String stringValue;
        String inValidMessage = null;
        this.controlDecoration.hide();
        if (value != null && !(stringValue = (String)value).isEmpty()) {
            try {
                this.simpleDateFormat.parse(stringValue);
            }
            catch (ParseException parseException) {
                inValidMessage = "Not in Correct Date Format - " + DATE_FORMAT;
                this.controlDecoration.setDescriptionText(inValidMessage);
                this.controlDecoration.show();
            }
        }
        return inValidMessage;
    }
}

