/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import org.grits.toolbox.core.utilShare.TextFieldUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.FragmentPerActivation;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.FragmentPerMsLevelForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MSGlycanAnnotationWizard;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Fragment;
import org.grits.toolbox.ms.om.data.FragmentPerActivationMethod;
import org.grits.toolbox.ms.om.data.FragmentPerMsLevel;
import org.grits.toolbox.ms.om.data.GlycanSettings;
import org.grits.toolbox.ms.om.data.Method;

public class FragmentSettingsForm
extends WizardPage {
    private Text txtDefMaxNumClvg;
    private Text txtDefMaxNumCR;
    private Button btnB;
    private Button btnY;
    private Button btnC;
    private Button btnZ;
    private Button btnA;
    private Button btnX;
    private Grid gridActivation;
    private Grid gridMs;
    GridColumn clmnActivationMethod;
    GridColumn clmnFragSettings;
    GridColumn clmnEnabled;
    private HashMap<String, FragmentPerActivationMethod> fpa = null;
    private HashMap<Integer, FragmentPerMsLevel> fpml = null;
    private List<GridItem> activationGridItems = new ArrayList<GridItem>();
    private List<GridItem> msGridItems = new ArrayList<GridItem>();
    private HashMap<String, GridItem> filter = new HashMap();
    private HashMap<Integer, GridItem> filterMsLevel = new HashMap();
    private boolean readyToFinish = false;
    private Method method;
    private Label lblNewLabel;
    private ModifyListener maxNumClvgModifyListener;
    private ModifyListener maxNumCRModifyListener;
    private SelectionAdapter btnSelectionAdapter;

    public FragmentSettingsForm(Method method) {
        super("wizardPage");
        this.setTitle("Fragment Settings");
        this.setDescription("Choose the fragment settings from different options");
        this.method = method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblDefaultSettings_1 = new Label(container, 0);
        lblDefaultSettings_1.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        lblDefaultSettings_1.setText("Default Settings");
        new Label(container, 0);
        Label lblMaxNumOf = new Label(container, 0);
        lblMaxNumOf.setText("Max Num of Cleavages");
        this.txtDefMaxNumClvg = new Text(container, 2048);
        this.txtDefMaxNumClvg.setText("2");
        this.maxNumClvgModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FragmentSettingsForm.this.validateInput()) {
                    FragmentSettingsForm.this.canFlipToNextPage();
                    FragmentSettingsForm.this.getWizard().getContainer().updateButtons();
                } else {
                    FragmentSettingsForm.this.readyToFinish = false;
                    FragmentSettingsForm.this.canFlipToNextPage();
                    FragmentSettingsForm.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        this.txtDefMaxNumClvg.addModifyListener(this.maxNumClvgModifyListener);
        this.txtDefMaxNumClvg.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblMaxNumOf_1 = new Label(container, 0);
        lblMaxNumOf_1.setText("Max Num of CrossRing Cleavages");
        this.txtDefMaxNumCR = new Text(container, 2048);
        this.txtDefMaxNumCR.setText("0");
        this.maxNumCRModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FragmentSettingsForm.this.validateInput()) {
                    FragmentSettingsForm.this.canFlipToNextPage();
                    FragmentSettingsForm.this.getWizard().getContainer().updateButtons();
                } else {
                    FragmentSettingsForm.this.readyToFinish = false;
                    FragmentSettingsForm.this.canFlipToNextPage();
                    FragmentSettingsForm.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        this.txtDefMaxNumCR.addModifyListener(this.maxNumCRModifyListener);
        this.txtDefMaxNumCR.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblGlycoCleavages = new Label(container, 0);
        lblGlycoCleavages.setText("Glycosidic Cleavages");
        this.btnB = new Button(container, 32);
        this.btnB.setSelection(true);
        this.btnSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FragmentSettingsForm.this.validateInput()) {
                    FragmentSettingsForm.this.canFlipToNextPage();
                    FragmentSettingsForm.this.getWizard().getContainer().updateButtons();
                } else {
                    FragmentSettingsForm.this.readyToFinish = false;
                    FragmentSettingsForm.this.canFlipToNextPage();
                    FragmentSettingsForm.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        this.btnB.addSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnB.setText("B");
        new Label(container, 0);
        this.btnY = new Button(container, 32);
        this.btnY.setSelection(true);
        this.btnY.addSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnY.setText("Y");
        new Label(container, 0);
        this.btnC = new Button(container, 32);
        this.btnC.addSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnC.setText("C");
        new Label(container, 0);
        this.btnZ = new Button(container, 32);
        this.btnZ.addSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnZ.setText("Z");
        Label lblCrossRingCleavages = new Label(container, 0);
        lblCrossRingCleavages.setText("Cross Ring Cleavages");
        this.btnA = new Button(container, 32);
        this.btnA.addSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnA.setText("A");
        new Label(container, 0);
        this.btnX = new Button(container, 32);
        this.btnX.addSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnX.setText("X");
        Button btnFragmentsPerActivation = new Button(container, 0);
        btnFragmentsPerActivation.addSelectionListener((SelectionListener)new FragmentSelectionAdapter(this, this){

            public void widgetSelected(SelectionEvent e) {
                FragmentPerActivation dialog = new FragmentPerActivation(this.getShell(), this.getParentForm());
                int result = dialog.open();
            }
        });
        btnFragmentsPerActivation.setText("Fragments Per Activation Method");
        this.gridActivation = new Grid(container, 2048);
        this.gridActivation.setHeaderVisible(true);
        this.gridActivation.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.clmnActivationMethod = new GridColumn(this.gridActivation, 0);
        this.clmnActivationMethod.setText("Activation Method");
        this.clmnActivationMethod.setWidth(150);
        this.clmnFragSettings = new GridColumn(this.gridActivation, 0);
        this.clmnFragSettings.setText("Fragment Settings");
        this.clmnFragSettings.setWidth(150);
        this.clmnEnabled = new GridColumn(this.gridActivation, 32);
        this.clmnEnabled.setText("Enabled");
        this.clmnEnabled.setWidth(150);
        Button btnFragmentsPerMs = new Button(container, 0);
        btnFragmentsPerMs.addSelectionListener((SelectionListener)new FragmentSelectionAdapter(this, this){

            public void widgetSelected(SelectionEvent e) {
                FragmentPerMsLevelForm dialog = new FragmentPerMsLevelForm(this.getShell(), this.getParentForm());
                int result = dialog.open();
            }
        });
        btnFragmentsPerMs.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnFragmentsPerMs.setText("Fragments Per Ms Level");
        this.gridMs = new Grid(container, 2048);
        this.gridMs.setHeaderVisible(true);
        this.gridMs.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridColumn clmnMsLevel = new GridColumn(this.gridMs, 0);
        clmnMsLevel.setText("MS Level");
        clmnMsLevel.setWidth(150);
        GridColumn clmnMsFragSettings = new GridColumn(this.gridMs, 0);
        clmnMsFragSettings.setText("Fragment Settings");
        clmnMsFragSettings.setWidth(150);
        GridColumn clmnMsEnabled = new GridColumn(this.gridMs, 32);
        clmnMsEnabled.setText("Enabled");
        clmnMsEnabled.setWidth(150);
        this.setControl((Control)container);
        this.lblNewLabel = new Label(container, 64);
        GridData gd_lblNewLabel = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_lblNewLabel.widthHint = 567;
        this.lblNewLabel.setLayoutData((Object)gd_lblNewLabel);
        this.lblNewLabel.setText("*If more than one fragment settings given, the per-activation settings will overwrite the others if it is given, otherwise the per-MS level settings will be used if it is given, in the other cases the default settings will be used");
        this.fpa = new HashMap();
        this.fpml = new HashMap();
        this.updateControlsFromPreferences();
        this.setPageComplete(false);
        if (this.validateInput()) {
            this.canFlipToNextPage();
        } else {
            this.readyToFinish = false;
            this.canFlipToNextPage();
        }
    }

    public boolean canFlipToNextPage() {
        return this.readyToFinish;
    }

    public boolean canFinish() {
        return this.readyToFinish;
    }

    public boolean addToGrid(FragmentPerActivationMethod method) {
        if (this.filter.get(method.getActivationMethod()) == null) {
            GridItem item = new GridItem(this.gridActivation, 0);
            item.setText(0, method.getActivationMethod());
            StringBuilder builder = new StringBuilder();
            builder.append("max clvg: " + method.getMaxNumOfCleavages() + ",");
            builder.append("max CR: " + method.getMaxNumOfCrossRingCleavages() + ",");
            builder.append("fragment types: ");
            for (Fragment f : method.getFragments()) {
                builder.append(String.valueOf(f.getType()) + " ");
            }
            item.setText(1, builder.toString());
            item.setChecked(2, true);
            this.activationGridItems.add(item);
            this.filter.put(method.getActivationMethod(), item);
        } else {
            int index = 0;
            int i = 0;
            while (i < this.gridActivation.getItems().length) {
                if (this.gridActivation.getItem(i).getText(0).trim().equals(method.getActivationMethod())) {
                    index = i;
                }
                ++i;
            }
            this.gridActivation.remove(index);
            GridItem item = new GridItem(this.gridActivation, 0);
            item.setText(0, method.getActivationMethod());
            StringBuilder builder = new StringBuilder();
            builder.append("max clvg: " + method.getMaxNumOfCleavages() + ",");
            builder.append("max CR: " + method.getMaxNumOfCrossRingCleavages() + ",");
            builder.append("fragment types: ");
            for (Fragment f : method.getFragments()) {
                builder.append(String.valueOf(f.getType()) + " ");
            }
            item.setText(1, builder.toString());
            item.setChecked(2, true);
            this.activationGridItems.add(item);
            this.filter.put(method.getActivationMethod(), item);
        }
        this.fpa.put(method.getActivationMethod(), method);
        return true;
    }

    public boolean addToMsLevelGrid(FragmentPerMsLevel method) {
        if (this.filterMsLevel.get(method.getMsLevel()) == null) {
            GridItem item = new GridItem(this.gridMs, 0);
            item.setText(0, "" + method.getMsLevel());
            StringBuilder builder = new StringBuilder();
            builder.append("max clvg: " + method.getM_maxNumOfCleavages() + ",");
            builder.append("max CR: " + method.getM_maxNumOfCrossRingCleavages() + ",");
            builder.append("fragment types: ");
            for (Fragment f : method.getFragments()) {
                builder.append(String.valueOf(f.getType()) + " ");
            }
            item.setText(1, builder.toString());
            item.setChecked(2, true);
            this.msGridItems.add(item);
            this.filterMsLevel.put(method.getMsLevel(), item);
        } else {
            int index = 0;
            int i = 0;
            while (i < this.gridMs.getItems().length) {
                if (this.gridMs.getItem(i).getText(0).trim().equals("" + method.getMsLevel())) {
                    index = i;
                }
                ++i;
            }
            this.gridMs.remove(index);
            GridItem item = new GridItem(this.gridMs, 0);
            item.setText(0, "" + method.getMsLevel());
            StringBuilder builder = new StringBuilder();
            builder.append("max clvg: " + method.getM_maxNumOfCleavages() + ",");
            builder.append("max CR: " + method.getM_maxNumOfCrossRingCleavages() + ",");
            builder.append("fragment types: ");
            for (Fragment f : method.getFragments()) {
                builder.append(String.valueOf(f.getType()) + " ");
            }
            item.setText(1, builder.toString());
            item.setChecked(2, true);
            this.activationGridItems.add(item);
            this.filterMsLevel.put(method.getMsLevel(), item);
        }
        this.fpml.put(method.getMsLevel(), method);
        return true;
    }

    public void save() {
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        Fragment f = null;
        if (this.btnB.getSelection()) {
            f = new Fragment();
            f.setNumber("-1");
            f.setType("B");
            fragments.add(f);
        }
        if (this.btnY.getSelection()) {
            f = new Fragment();
            f.setNumber("-1");
            f.setType("Y");
            fragments.add(f);
        }
        if (this.btnC.getSelection()) {
            f = new Fragment();
            f.setNumber("-1");
            f.setType("C");
            fragments.add(f);
        }
        if (this.btnZ.getSelection()) {
            f = new Fragment();
            f.setNumber("-1");
            f.setType("Z");
            fragments.add(f);
        }
        if (this.btnA.getSelection()) {
            f = new Fragment();
            f.setNumber("-1");
            f.setType("A");
            fragments.add(f);
        }
        if (this.btnX.getSelection()) {
            f = new Fragment();
            f.setNumber("-1");
            f.setType("X");
            fragments.add(f);
        }
        for (AnalyteSettings analyte : this.method.getAnalyteSettings()) {
            if (analyte.getGlycanSettings() == null) continue;
            analyte.getGlycanSettings().setMaxNumOfCleavages(Integer.parseInt(this.txtDefMaxNumClvg.getText()));
            analyte.getGlycanSettings().setMaxNumOfCrossRingCleavages(Integer.parseInt(this.txtDefMaxNumCR.getText()));
            analyte.getGlycanSettings().setGlycanFragments(fragments);
            analyte.getGlycanSettings().getPerActivation().clear();
            if (this.fpa != null && !this.fpa.isEmpty()) {
                for (GridItem item : this.activationGridItems) {
                    if (item.isDisposed() || !item.getChecked(2)) continue;
                    FragmentPerActivationMethod activationMethodFragments = this.fpa.get(item.getText(0).trim());
                    analyte.getGlycanSettings().getPerActivation().add(activationMethodFragments);
                }
            }
            analyte.getGlycanSettings().getPerMsLevel().clear();
            if (this.fpml == null || this.fpml.isEmpty()) continue;
            for (GridItem item : this.msGridItems) {
                if (item.isDisposed() || !item.getChecked(2)) continue;
                FragmentPerMsLevel msLevelFragments = this.fpml.get(Integer.parseInt(item.getText(0).trim()));
                analyte.getGlycanSettings().getPerMsLevel().add(msLevelFragments);
            }
        }
    }

    public boolean validateInput() {
        if (!TextFieldUtils.isNonZero((Text)this.txtDefMaxNumClvg)) {
            this.setErrorMessage("Please enter a valid number");
            return false;
        }
        if (!(this.btnB.getSelection() || this.btnY.getSelection() || this.btnC.getSelection() || this.btnZ.getSelection() || this.btnA.getSelection() || this.btnX.getSelection())) {
            this.setErrorMessage("Please select at least one glyco cleavage type or cross ring type");
            return false;
        }
        if (TextFieldUtils.isNonZero((Text)this.txtDefMaxNumCR) && !this.btnA.getSelection() && !this.btnX.getSelection()) {
            this.setErrorMessage("Please select at least one cross ring cleavage type ");
            return false;
        }
        if (!TextFieldUtils.isNonZero((Text)this.txtDefMaxNumCR) && (this.btnA.getSelection() || this.btnX.getSelection())) {
            this.setErrorMessage("Please enter Max cross ring value ");
            return false;
        }
        if (!TextFieldUtils.isNonZero((Text)this.txtDefMaxNumClvg) && (this.btnB.getSelection() || this.btnY.getSelection() || this.btnC.getSelection() || this.btnZ.getSelection())) {
            this.setErrorMessage("Please enter Max Cleavge value ");
            return false;
        }
        this.setErrorMessage(null);
        this.readyToFinish = true;
        return true;
    }

    public void updateControlsFromPreferences() {
        block26: {
            block27: {
                AnalyteSettings analyteSetting;
                GlycanSettings glycanSettings;
                Iterator iterator;
                if (!(this.getWizard() instanceof MSGlycanAnnotationWizard)) {
                    return;
                }
                MSGlycanAnnotationWizard myWizard = (MSGlycanAnnotationWizard)this.getWizard();
                if (myWizard.getPreferences() == null || myWizard.getPreferences().getMethod() == null) break block26;
                this.removeListeners();
                if (myWizard.getPreferences().getMethod().getAnalyteSettings() == null || !(iterator = myWizard.getPreferences().getMethod().getAnalyteSettings().iterator()).hasNext() || (glycanSettings = (analyteSetting = (AnalyteSettings)iterator.next()).getGlycanSettings()) == null) break block27;
                this.txtDefMaxNumClvg.setText(String.valueOf(glycanSettings.getMaxNumOfCleavages()));
                this.txtDefMaxNumCR.setText(String.valueOf(glycanSettings.getMaxNumOfCrossRingCleavages()));
                List fragments = glycanSettings.getGlycanFragments();
                for (Fragment fragment : fragments) {
                    switch (fragment.getType()) {
                        case "A": {
                            this.btnA.setSelection(true);
                            break;
                        }
                        case "B": {
                            this.btnB.setSelection(true);
                            break;
                        }
                        case "C": {
                            this.btnC.setSelection(true);
                            break;
                        }
                        case "X": {
                            this.btnX.setSelection(true);
                            break;
                        }
                        case "Y": {
                            this.btnY.setSelection(true);
                            break;
                        }
                        case "Z": {
                            this.btnZ.setSelection(true);
                        }
                    }
                }
                List perActivationList = glycanSettings.getPerActivation();
                for (FragmentPerActivationMethod fpa : perActivationList) {
                    this.addToGrid(fpa);
                }
                List perMSLevelList = glycanSettings.getPerMsLevel();
                for (FragmentPerMsLevel fragmentPerMsLevel : perMSLevelList) {
                    this.addToMsLevelGrid(fragmentPerMsLevel);
                }
            }
            this.addListeners();
        }
    }

    private void addListeners() {
        this.txtDefMaxNumClvg.addModifyListener(this.maxNumClvgModifyListener);
        this.txtDefMaxNumCR.addModifyListener(this.maxNumCRModifyListener);
        this.btnA.addSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnB.addSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnC.addSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnX.addSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnY.addSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnZ.addSelectionListener((SelectionListener)this.btnSelectionAdapter);
    }

    private void removeListeners() {
        this.txtDefMaxNumClvg.removeModifyListener(this.maxNumClvgModifyListener);
        this.txtDefMaxNumCR.removeModifyListener(this.maxNumCRModifyListener);
        this.btnA.removeSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnB.removeSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnC.removeSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnX.removeSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnY.removeSelectionListener((SelectionListener)this.btnSelectionAdapter);
        this.btnZ.removeSelectionListener((SelectionListener)this.btnSelectionAdapter);
    }

    class FragmentSelectionAdapter
    extends SelectionAdapter {
        FragmentSettingsForm parentForm = null;

        public FragmentSelectionAdapter(FragmentSettingsForm parentForm) {
            this.parentForm = parentForm;
        }

        public FragmentSettingsForm getParentForm() {
            return this.parentForm;
        }
    }
}

