/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.treeview;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.Field;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.treeview.TreeNodeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeViewRequest {
    private final TreeNodeFactory factory;
    private final String path;
    private final ArtifactInfoFilter artifactInfoFilter;
    private final Map<Field, String> fieldHints;
    private final IndexingContext indexingContext;

    public TreeViewRequest(TreeNodeFactory factory, String path, IndexingContext ctx) {
        this(factory, path, null, null, ctx);
    }

    public TreeViewRequest(TreeNodeFactory factory, String path, Map<Field, String> hints, ArtifactInfoFilter artifactInfoFilter, IndexingContext ctx) {
        this.factory = factory;
        this.path = path;
        this.fieldHints = new HashMap<Field, String>();
        if (hints != null && hints.size() != 0) {
            this.fieldHints.putAll(hints);
        }
        this.artifactInfoFilter = artifactInfoFilter;
        this.indexingContext = ctx;
    }

    public TreeNodeFactory getFactory() {
        return this.factory;
    }

    public String getPath() {
        return this.path;
    }

    public ArtifactInfoFilter getArtifactInfoFilter() {
        return this.artifactInfoFilter;
    }

    public void addFieldHint(Field field, String hint) {
        this.fieldHints.put(field, hint);
    }

    public void removeFieldHint(Field field) {
        this.fieldHints.remove(field);
    }

    public boolean hasFieldHints() {
        return this.fieldHints.size() > 0 && this.hasFieldHint(MAVEN.GROUP_ID);
    }

    public boolean hasFieldHint(Field ... fields) {
        for (Field f : fields) {
            if (this.fieldHints.containsKey(f)) continue;
            return false;
        }
        return true;
    }

    public String getFieldHint(Field field) {
        return this.fieldHints.get(field);
    }

    public Map<Field, String> getFieldHints() {
        return this.fieldHints;
    }

    public IndexingContext getIndexingContext() {
        return this.indexingContext;
    }
}

