/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.TextFieldUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.FragmentPerOptionForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.FragmentSettingsForm;
import org.grits.toolbox.ms.om.data.FragmentPerMsLevel;

public class FragmentPerMsLevelForm
extends FragmentPerOptionForm {
    private Text txtMaxClvg;
    private Text txtMaxCR;
    Combo cmbMsLevel;

    public FragmentPerMsLevelForm(Shell parentShell, FragmentSettingsForm parentForm) {
        super(parentShell, parentForm);
    }

    @Override
    protected String getFormTitle() {
        return "Fragment Settings Per MS Level";
    }

    @Override
    protected void addPreFragmentControls(Composite container) {
        Label lblMsLevel = new Label(container, 0);
        lblMsLevel.setText("MS Level");
        this.cmbMsLevel = new Combo(container, 0);
        this.cmbMsLevel.setItems(new String[]{"MS2", "MS3", "MS4", "MS5", "MS6"});
        this.cmbMsLevel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmbMsLevel.select(0);
        this.cmbMsLevel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FragmentPerMsLevelForm.this.setDirty(true, FragmentPerMsLevelForm.this.validatInput());
            }
        });
        Label label = new Label(container, 0);
        label.setText("Max Num of Cleavages");
        this.txtMaxClvg = new Text(container, 2048);
        this.txtMaxClvg.setText("2");
        this.txtMaxClvg.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FragmentPerMsLevelForm.this.setDirty(true, FragmentPerMsLevelForm.this.validatInput());
            }
        });
        this.txtMaxClvg.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label_1 = new Label(container, 0);
        label_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label_1.setText("Max Num of CrossRing Cleavages");
        this.txtMaxCR = new Text(container, 2048);
        this.txtMaxCR.setText("0");
        this.txtMaxCR.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FragmentPerMsLevelForm.this.setDirty(true, FragmentPerMsLevelForm.this.validatInput());
            }
        });
        this.txtMaxCR.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    @Override
    protected void addButtonEventListeners() {
        this.btnAdd.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                FragmentPerMsLevel method = new FragmentPerMsLevel();
                method.setMsLevel(Integer.valueOf(FragmentPerMsLevelForm.this.cmbMsLevel.getSelectionIndex() + 2));
                method.setFragments(FragmentPerMsLevelForm.this.getFragments());
                method.setM_maxNumOfCleavages(Integer.parseInt(FragmentPerMsLevelForm.this.txtMaxClvg.getText()));
                method.setM_maxNumOfCrossRingCleavages(Integer.parseInt(FragmentPerMsLevelForm.this.txtMaxCR.getText()));
                FragmentPerMsLevelForm.this.parentForm.addToMsLevelGrid(method);
                FragmentPerMsLevelForm.this.setMessage("Added Successfully");
                FragmentPerMsLevelForm.this.setDirty(false, true);
            }
        });
    }

    @Override
    public boolean validatInput() {
        boolean bVal = super.validatInput();
        if (!bVal) {
            return false;
        }
        if (!TextFieldUtils.isNonZero((Text)this.txtMaxClvg)) {
            this.setErrorMessage("Please enter a valid number");
            return false;
        }
        if (TextFieldUtils.isNonZero((Text)this.txtMaxCR) && !this.btnA.getSelection() && !this.btnX.getSelection()) {
            this.setErrorMessage("Please select at least one cross ring cleavage type ");
            return false;
        }
        if (!TextFieldUtils.isNonZero((Text)this.txtMaxCR) && (this.btnA.getSelection() || this.btnX.getSelection())) {
            this.setErrorMessage("Please enter Max cross ring value ");
            return false;
        }
        if (!TextFieldUtils.isNonZero((Text)this.txtMaxClvg) && (this.btnB.getSelection() || this.btnY.getSelection() || this.btnC.getSelection() || this.btnZ.getSelection())) {
            this.setErrorMessage("Please enter Max Cleavage value ");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    @Override
    protected void addPostFragmentControls(Composite container) {
    }
}

