/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.processDialog;

import org.apache.log4j.Logger;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.widgets.processDialog.TextProgressBar;
import org.grits.toolbox.widgets.progress.IProgressListener;

public class ProgressBarListener
implements IProgressListener {
    private static final Logger logger = Logger.getLogger(ProgressBarListener.class);
    protected int iMax = 0;
    private int iCurValue = -1;
    protected String sCurText = null;
    protected TextProgressBar curProgressBar = null;
    protected TextProgressBar progressBarIndeterminant = null;
    protected TextProgressBar progressBarDeterminant = null;
    protected Composite minorContainer = null;
    protected StackLayout stackLayout = null;
    protected Display display = null;
    protected Shell shell = null;

    public ProgressBarListener(TextProgressBar progressBar, Display display) {
        this.curProgressBar = progressBar;
        this.display = display;
    }

    public ProgressBarListener(TextProgressBar progressBarDeterminant, TextProgressBar progressBarIndeterminant, IProgressListener.ProgressType progressType, StackLayout stackLayout, Display display, Shell shell) {
        this.progressBarDeterminant = progressBarDeterminant;
        this.progressBarIndeterminant = progressBarIndeterminant;
        this.display = display;
        this.shell = shell;
        this.stackLayout = stackLayout;
        this.setProgressType(progressType);
    }

    public void setProgressMessage(final String _sMessage) {
        if (this.display.isDisposed()) {
            return;
        }
        try {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProgressBarListener.this.curProgressBar.isDisposed()) {
                        return;
                    }
                    ProgressBarListener.this.curProgressBar.setText("");
                    ProgressBarListener.this.curProgressBar.update();
                    ProgressBarListener.this.curProgressBar.setText(_sMessage);
                    ProgressBarListener.this.sCurText = _sMessage;
                    ProgressBarListener.this.curProgressBar.update();
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void setProgressValue(final int _iValue) {
        if (this.display.isDisposed()) {
            return;
        }
        try {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProgressBarListener.this.curProgressBar.isDisposed()) {
                        return;
                    }
                    int iCount = (int)((double)_iValue / (double)ProgressBarListener.this.iMax * 100.0);
                    ProgressBarListener.this.curProgressBar.setSelection(iCount - 1);
                    ProgressBarListener.this.curProgressBar.update();
                    ProgressBarListener.this.curProgressBar.setSelection(iCount);
                    ProgressBarListener.this.curProgressBar.update();
                    ProgressBarListener.this.iCurValue = _iValue;
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void setMaxValue(int _iValue) {
        if (this.display.isDisposed()) {
            return;
        }
        try {
            this.iMax = _iValue;
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProgressBarListener.this.curProgressBar.isDisposed()) {
                        return;
                    }
                    ProgressBarListener.this.curProgressBar.setSelection(1);
                    ProgressBarListener.this.curProgressBar.setSelection(0);
                    ProgressBarListener.this.curProgressBar.setMaximum(100);
                    ProgressBarListener.this.iCurValue = 0;
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void setMinValue(final int _iValue) {
        if (this.display.isDisposed()) {
            return;
        }
        try {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProgressBarListener.this.curProgressBar.isDisposed()) {
                        return;
                    }
                    ProgressBarListener.this.curProgressBar.setSelection(0);
                    ProgressBarListener.this.iCurValue = 0;
                    ProgressBarListener.this.curProgressBar.setMinimum(_iValue);
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void setDeterminant(final TextProgressBar pbD, final TextProgressBar pbI, final StackLayout sl) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                pbI.setVisible(false);
                sl.topControl = pbD;
                pbD.setVisible(true);
                ProgressBarListener.this.shell.layout();
            }
        });
    }

    protected void setIndeterminant(final TextProgressBar pbD, final TextProgressBar pbI, final StackLayout sl) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                pbD.setVisible(false);
                sl.topControl = pbI;
                pbI.setVisible(true);
                ProgressBarListener.this.shell.layout();
                ProgressBarListener.this.shell.pack();
            }
        });
    }

    public int getCurValue() {
        return this.iCurValue;
    }

    public String getCurText() {
        return this.sCurText;
    }

    public void setError(String _sMessage) {
    }

    public void setError(String _sMessage, Throwable _t) {
    }

    public void setProgressType(IProgressListener.ProgressType progressType) {
        if (progressType == IProgressListener.ProgressType.Determinant) {
            this.setDeterminant(this.progressBarDeterminant, this.progressBarIndeterminant, this.stackLayout);
            this.curProgressBar = this.progressBarDeterminant;
        } else {
            this.setIndeterminant(this.progressBarDeterminant, this.progressBarIndeterminant, this.stackLayout);
            this.curProgressBar = this.progressBarIndeterminant;
        }
    }
}

