/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.peakpicker;

import java.util.Map;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.Param;

public class DefaultParamHandler {
    protected Param param_ = new Param();
    protected Param defaults_ = new Param();
    protected Vector<String> subsections_ = new Vector();
    protected String error_name_;
    protected boolean check_defaults_;

    public DefaultParamHandler(String name) {
        this.error_name_ = name;
        this.check_defaults_ = true;
    }

    public DefaultParamHandler clone() {
        DefaultParamHandler ret = new DefaultParamHandler(this.error_name_);
        ret.copy(this);
        return ret;
    }

    public void copy(DefaultParamHandler rhs) {
        this.param_.copy(rhs.param_);
        this.defaults_.copy(rhs.defaults_);
        this.subsections_ = (Vector)rhs.subsections_.clone();
        this.error_name_ = rhs.error_name_;
        this.check_defaults_ = rhs.check_defaults_;
    }

    public boolean equals(DefaultParamHandler rhs) {
        return this.param_.equals(rhs.param_) && this.defaults_.equals(rhs.defaults_) && this.subsections_.equals(rhs.subsections_) && this.error_name_.equals(rhs.error_name_) && this.check_defaults_ == rhs.check_defaults_;
    }

    public void setParameters(Param param) {
        Param tmp = param.clone();
        tmp.setDefaults(this.defaults_);
        this.param_ = tmp;
        if (this.check_defaults_) {
            if (this.defaults_.size() == 0) {
                System.out.println("Warning: no default parameters for DefaultParameterHandler '" + this.error_name_ + "' specified!");
            }
            for (String s : this.subsections_) {
                tmp.remove(s + ':');
            }
            tmp.checkDefaults(this.error_name_, this.defaults_);
        }
        this.updateMembers_();
    }

    public Param getParameters() {
        return this.param_;
    }

    public Param getDefaults() {
        return this.defaults_;
    }

    public String getName() {
        return this.error_name_;
    }

    public void setName(String name) {
        this.error_name_ = name;
    }

    public Vector<String> getSubsections() {
        return this.subsections_;
    }

    protected void updateMembers_() {
    }

    protected void defaultsToParam_() {
        boolean description_missing = false;
        String missing_parameters = "";
        for (Map.Entry<String, Object> e : this.defaults_.getValues().entrySet()) {
            if (this.defaults_.getDescription(e.getKey()).length() != 0) continue;
            description_missing = true;
            missing_parameters = missing_parameters + e.getKey() + ",";
            break;
        }
        if (description_missing) {
            System.out.println("Warning: no default parameter description for parameters '" + missing_parameters + "' of DefaultParameterHandler '" + this.error_name_ + "' given!");
        }
        this.param_.setDefaults(this.defaults_);
        this.updateMembers_();
    }

    public void store(Configuration config) {
        this.param_.store(this.error_name_, config);
    }

    public void retrieve(Configuration config) {
        this.param_.retrieve(this.error_name_, config);
        this.updateMembers_();
    }
}

