/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.plugin.DocumentPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.GlycanTable;

public abstract class TablePanel<DT>
extends DocumentPanel<DT>
implements TableModel,
ListSelectionListener {
    protected GlycanTable theTable;
    protected Vector<TableModelListener> tm_listeners;

    @Override
    protected void initSingletons() {
        super.initSingletons();
        this.tm_listeners = new Vector();
    }

    @Override
    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.theTable = new GlycanTable();
        this.theTable.setGlycanRenderer(this.theWorkspace.getGlycanRenderer());
        this.theTable.setShowVerticalLines(true);
        this.theTable.getSelectionModel().addListSelectionListener(this);
        this.theTable.setPopupMenu(this.createPopupMenu());
        this.theTable.setModel(this);
        this.add((Component)this.theTable.getScrollPane(), "Center");
    }

    @Override
    public void setWorkspace(GlycanWorkspace workspace) {
        if (this.theTable != null && workspace != null) {
            this.theTable.setGlycanRenderer(workspace.getGlycanRenderer());
        }
        super.setWorkspace(workspace);
    }

    protected JPopupMenu createPopupMenu() {
        return null;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (l != null) {
            this.tm_listeners.add(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tm_listeners.remove(l);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    protected void updateView() {
        this.fireTableChanged();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateActions();
    }

    public void fireTableStructureChanged() {
        Iterator<TableModelListener> i = this.tm_listeners.iterator();
        while (i.hasNext()) {
            i.next().tableChanged(new TableModelEvent(this, -1));
        }
    }

    public void fireTableChanged() {
        Iterator<TableModelListener> i = this.tm_listeners.iterator();
        while (i.hasNext()) {
            i.next().tableChanged(new TableModelEvent(this));
        }
    }

    public void fireRowChanged(int row) {
        Iterator<TableModelListener> i = this.tm_listeners.iterator();
        while (i.hasNext()) {
            i.next().tableChanged(new TableModelEvent(this, row));
        }
    }

    public void fireRowsChanged(int from, int to) {
        Iterator<TableModelListener> i = this.tm_listeners.iterator();
        while (i.hasNext()) {
            i.next().tableChanged(new TableModelEvent(this, from, to));
        }
    }

    public void fireRowsChanged(int[] ind) {
        for (int l = 0; l < ind.length; ++l) {
            Iterator<TableModelListener> i = this.tm_listeners.iterator();
            while (i.hasNext()) {
                i.next().tableChanged(new TableModelEvent(this, ind[l]));
            }
        }
    }

    public void fireRowsChanged(Collection<Integer> indexes) {
        for (Integer ind : indexes) {
            Iterator<TableModelListener> i = this.tm_listeners.iterator();
            while (i.hasNext()) {
                i.next().tableChanged(new TableModelEvent(this, ind));
            }
        }
    }

    public void fireRowDeleted(int ind) {
        Iterator<TableModelListener> i = this.tm_listeners.iterator();
        while (i.hasNext()) {
            i.next().tableChanged(new TableModelEvent(this, ind, ind, -1, -1));
        }
    }

    public void fireRowsDeleted(int[] ind) {
        for (int l = 0; l < ind.length; ++l) {
            Iterator<TableModelListener> i = this.tm_listeners.iterator();
            while (i.hasNext()) {
                i.next().tableChanged(new TableModelEvent(this, ind[l], ind[l], -1, -1));
            }
        }
    }

    public void fireRowsDeleted(Collection<Integer> indexes) {
        for (Integer ind : indexes) {
            Iterator<TableModelListener> i = this.tm_listeners.iterator();
            while (i.hasNext()) {
                i.next().tableChanged(new TableModelEvent(this, ind, ind, -1, -1));
            }
        }
    }
}

