/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.EscapeDialog;
import org.eurocarbdb.application.glycoworkbench.plugin.ProfilerPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureDictionary;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureType;
import org.jdesktop.layout.GroupLayout;

public class StoreStructuresDialog
extends EscapeDialog
implements ActionListener {
    private ProfilerPlugin theProfiler;
    private StructureDictionary theDictionary;
    private StructureType tomodify;
    private String dict_name;
    private String type;
    private String source;
    private JButton button_cancel;
    private JButton button_ok;
    private JComboBox field_dictionaries;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSeparator jSeparator1;
    private JTextField field_type;
    private JTextField field_source;

    public StoreStructuresDialog(Frame parent, ProfilerPlugin profiler, StructureDictionary dict) {
        super(parent, true);
        this.theProfiler = profiler;
        this.tomodify = null;
        this.theDictionary = dict;
        this.initComponents();
        this.setTraversal();
        this.setData();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
    }

    public StoreStructuresDialog(Frame parent, StructureType st, ProfilerPlugin profiler) {
        super(parent, true);
        this.theProfiler = profiler;
        this.tomodify = st;
        this.theDictionary = null;
        this.initComponents();
        this.setTraversal();
        this.setData();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent((Component)this.field_dictionaries);
        tp.addComponent((Component)this.field_type);
        tp.addComponent((Component)this.field_source);
        tp.addComponent((Component)this.button_ok);
        tp.addComponent((Component)this.button_cancel);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setDictionaries() {
        if (this.theProfiler.getUserDictionaries().size() > 0) {
            this.field_dictionaries.setModel(new DefaultComboBoxModel<Object>(this.theProfiler.getUserDictionaryNames().toArray()));
        } else {
            this.field_dictionaries.setModel(new DefaultComboBoxModel<String>(new String[]{"Create one..."}));
        }
        if (this.tomodify == null) {
            this.field_dictionaries.setSelectedItem(this.theProfiler.getOptions().LAST_DICT_NAME);
        } else if (this.theDictionary == null) {
            this.field_dictionaries.setSelectedItem(this.tomodify.getDatabase());
        } else {
            this.field_dictionaries.setSelectedItem(this.theDictionary.getDictionaryName());
        }
    }

    private void setData() {
        this.setDictionaries();
        if (this.tomodify == null) {
            this.field_type.setText(this.theProfiler.getOptions().LAST_TYPE);
            this.field_source.setText(this.theProfiler.getOptions().LAST_SOURCE);
        } else {
            this.field_type.setText(this.tomodify.getType());
            this.field_source.setText(this.tomodify.getSource());
        }
    }

    private void setActions() {
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void enableItems() {
        this.field_dictionaries.setEnabled(this.tomodify == null && this.theDictionary == null && this.theProfiler.getUserDictionaries().size() > 0);
    }

    public void retrieveData() {
        this.dict_name = (String)this.field_dictionaries.getSelectedItem();
        if (this.dict_name != null) {
            this.theProfiler.getOptions().LAST_DICT_NAME = this.dict_name;
        }
        this.type = this.field_type.getText();
        if (this.type == null || this.type.length() == 0) {
            this.type = "unknown";
        }
        this.theProfiler.getOptions().LAST_TYPE = this.type;
        this.source = this.field_source.getText();
        if (this.source == null || this.source.length() == 0) {
            this.source = "unknown";
        }
        this.theProfiler.getOptions().LAST_SOURCE = this.source;
    }

    public String getDictionaryName() {
        return this.dict_name;
    }

    public String getStructureType() {
        return this.type;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("OK")) {
            this.return_status = "OK";
            this.retrieveData();
            this.closeDialog();
        } else if (action.equals("Cancel")) {
            this.return_status = "Cancel";
            this.closeDialog();
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.field_dictionaries = new JComboBox();
        this.jLabel2 = new JLabel();
        this.field_type = new JTextField();
        this.jLabel3 = new JLabel();
        this.field_source = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StoreStructuresDialog.this.closeDialog();
            }
        });
        this.jLabel1.setText("Database");
        this.field_dictionaries.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("Type");
        this.field_type.setText("field_type");
        this.jLabel3.setText("Source");
        this.field_source.setText("field_source");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jSeparator1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.field_source).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.field_dictionaries, -2, 140, -2)).add((Component)this.field_type))))).add((GroupLayout.Group)layout.createSequentialGroup().add(65, 65, 65).add((Component)this.button_ok).addPreferredGap(0).add((Component)this.button_cancel))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.field_dictionaries, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.field_type, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.field_source, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_ok).add((Component)this.button_cancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

