/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ResizingTable
extends JTable {
    protected ResizingTable this_object = this;
    protected JScrollPane theTableScroll = new JScrollPane(this);
    protected Vector<Vector<Integer>> col_widths;
    protected int default_row_height;
    protected int default_row_margin;

    public ResizingTable() {
        this.theTableScroll.setColumnHeaderView(this.getTableHeader());
        this.theTableScroll.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (ResizingTable.this.getPreferredSize().width <= ResizingTable.this.theTableScroll.getViewport().getExtentSize().width) {
                    ResizingTable.this.setAutoResizeMode(2);
                } else {
                    ResizingTable.this.setAutoResizeMode(0);
                }
            }
        });
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
        this.setAutoResizeMode(0);
        this.setAutoscrolls(true);
        this.col_widths = new Vector();
        this.default_row_height = this.getRowHeight();
        this.default_row_margin = this.getRowMargin();
        this.initWidths();
    }

    public JScrollPane getScrollPane() {
        return this.theTableScroll;
    }

    protected void initWidths() {
        this.col_widths = new Vector();
        this.col_widths.setSize(this.getModel().getRowCount());
        for (int i = 0; i < this.col_widths.size(); ++i) {
            Vector v = new Vector();
            v.setSize(this.getModel().getColumnCount());
            this.col_widths.setElementAt(v, i);
        }
    }

    protected void addWidths(int f, int l) {
        for (int i = f; i <= l; ++i) {
            Vector v = new Vector();
            v.setSize(this.getModel().getColumnCount());
            this.col_widths.insertElementAt(v, i);
        }
    }

    protected void removeWidths(int f, int l) {
        for (int i = 0; i <= l - f; ++i) {
            this.col_widths.removeElementAt(f);
        }
    }

    protected int getColWidth(int r, int c) {
        return this.col_widths.elementAt(r).elementAt(c);
    }

    protected void setColWidth(int r, int c, int v) {
        this.col_widths.elementAt(r).setElementAt(v, c);
    }

    protected int getMaxWidth(int c) {
        int max_colwidth = 0;
        for (int r = 0; r < this.col_widths.size(); ++r) {
            max_colwidth = Math.max(this.getColWidth(r, c), max_colwidth);
        }
        return max_colwidth;
    }

    public Dimension getHeaderDimension(int colIndex) {
        TableColumn column = this.getColumnModel().getColumn(colIndex);
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, -1, colIndex);
        Dimension pref_dim = comp.getPreferredSize();
        int cell_height = pref_dim.height + 2 * this.default_row_margin;
        int cell_width = pref_dim.width + 8;
        return new Dimension(cell_width, cell_height);
    }

    public Dimension getCellDimension(int rowIndex, int colIndex) {
        TableCellRenderer renderer = this.getCellRenderer(rowIndex, colIndex);
        Component comp = this.prepareRenderer(renderer, rowIndex, colIndex);
        Dimension pref_dim = comp.getPreferredSize();
        int cell_height = pref_dim.height + 2 * this.default_row_margin;
        int cell_width = pref_dim.width + 8;
        return new Dimension(cell_width, cell_height);
    }

    protected void updateDimensions(int first, int last) {
        for (int i = first; i <= last; ++i) {
            int row_height = this.default_row_height;
            for (int c = 0; c < this.getColumnCount(); ++c) {
                Dimension d = this.getCellDimension(i, c);
                row_height = Math.max(row_height, d.height);
                this.setColWidth(i, c, d.width);
            }
            this.setRowHeight(i, row_height);
        }
        this.updateColumnWidths();
    }

    protected void updateColumnWidths() {
        this.setAutoResizeMode(0);
        for (int c = 0; c < this.getColumnCount(); ++c) {
            int header_width = this.getHeaderDimension((int)c).width;
            int pref_width = this.getMaxWidth(c);
            this.getColumnModel().getColumn(c).setPreferredWidth(Math.max(header_width, pref_width));
        }
        if (this.theTableScroll != null && this.getPreferredSize().width <= this.theTableScroll.getViewport().getExtentSize().width) {
            this.setAutoResizeMode(2);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getFirstRow() == -1 || e.getLastRow() == Integer.MAX_VALUE) {
            this.initWidths();
            this.updateDimensions(0, this.col_widths.size() - 1);
        } else if (e.getType() == 1) {
            this.addWidths(e.getFirstRow(), e.getLastRow());
            this.updateDimensions(e.getFirstRow(), e.getLastRow());
        } else if (e.getType() == -1) {
            this.removeWidths(e.getFirstRow(), e.getLastRow());
            this.updateColumnWidths();
        } else if (e.getType() == 0) {
            this.updateDimensions(e.getFirstRow(), e.getLastRow());
        }
    }
}

