/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.Annotation;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PeakAnnotationCollection
implements SAXUtils.SAXWriter {
    private double max_intensity = 0.0;
    private Vector<PeakAnnotation> peak_annotations = new Vector();

    public PeakAnnotationCollection clone() {
        PeakAnnotationCollection ret = new PeakAnnotationCollection();
        for (PeakAnnotation pa : this.peak_annotations) {
            ret.addPeakAnnotation(pa);
        }
        return ret;
    }

    public void clear() {
        this.max_intensity = 0.0;
        this.peak_annotations.clear();
    }

    public void clearAnnotations(Peak p) {
        if (p == null) {
            return;
        }
        Iterator<PeakAnnotation> i = this.peak_annotations.iterator();
        while (i.hasNext()) {
            PeakAnnotation pa = i.next();
            if (!p.equals(pa.getPeak())) continue;
            i.remove();
        }
        this.addPeakAnnotation(p);
    }

    public void clearAnnotations(Collection<Peak> peaks) {
        TreeSet<Peak> removed = new TreeSet<Peak>();
        Iterator<PeakAnnotation> i = this.peak_annotations.iterator();
        block0: while (i.hasNext()) {
            PeakAnnotation pa = i.next();
            for (Peak p : peaks) {
                if (!p.equals(pa.getPeak())) continue;
                removed.add(pa.getPeak());
                i.remove();
                continue block0;
            }
        }
        for (Peak p : removed) {
            this.addPeakAnnotation(p);
        }
    }

    public Vector<PeakAnnotation> getPeakAnnotations() {
        return this.peak_annotations;
    }

    public Vector<PeakAnnotation> getPeakAnnotations(Peak p) {
        Vector<PeakAnnotation> ret = new Vector<PeakAnnotation>();
        for (PeakAnnotation pa : this.peak_annotations) {
            if (!pa.getPeak().equals(p)) continue;
            ret.add(pa);
        }
        return ret;
    }

    public Collection<PeakAnnotation> getPeakAnnotations(double mz_ratio) {
        double mz_tol = 1.0E-6;
        Vector<PeakAnnotation> ret = new Vector<PeakAnnotation>();
        for (PeakAnnotation pa : this.peak_annotations) {
            if (pa.getPeak().getMZ() > mz_ratio + mz_tol) {
                return ret;
            }
            if (!(pa.getPeak().getMZ() > mz_ratio - mz_tol)) continue;
            ret.add(pa);
        }
        return ret;
    }

    public boolean contains(PeakAnnotation pa) {
        return this.peak_annotations.contains(pa);
    }

    public Iterator<PeakAnnotation> iterator() {
        return this.peak_annotations.iterator();
    }

    public PeakAnnotation elementAt(int ind) {
        return this.peak_annotations.elementAt(ind);
    }

    public int size() {
        return this.peak_annotations.size();
    }

    public boolean isProfile() {
        for (PeakAnnotation pa : this.peak_annotations) {
            if (pa.getFragment() == null || !pa.getFragment().isFragment()) continue;
            return false;
        }
        return true;
    }

    public boolean addPeakAnnotation(Peak p) {
        if (p == null) {
            return false;
        }
        return this.addPeakAnnotation(new PeakAnnotation(p));
    }

    public boolean addPeakAnnotation(Peak p, FragmentEntry f) {
        if (p == null) {
            return false;
        }
        return this.addPeakAnnotation(new PeakAnnotation(p, f));
    }

    public boolean addPeakAnnotation(Peak p, FragmentEntry f, IonCloud c) {
        if (p == null) {
            return false;
        }
        return this.addPeakAnnotation(new PeakAnnotation(p, f, c));
    }

    public boolean addPeakAnnotation(Peak p, FragmentEntry f, IonCloud c, IonCloud e) {
        if (p == null) {
            return false;
        }
        return this.addPeakAnnotation(new PeakAnnotation(p, f, c, e));
    }

    public boolean addPeakAnnotation(PeakAnnotation toadd) {
        if (toadd == null) {
            return false;
        }
        this.max_intensity = Math.max(this.max_intensity, toadd.getPeak().getIntensity());
        for (int i = this.peak_annotations.size() - 1; i >= 0; --i) {
            PeakAnnotation cur = this.peak_annotations.elementAt(i);
            if (!toadd.isAnnotated() && cur.getPeak().equals(toadd.getPeak())) {
                return false;
            }
            int comparison = cur.compareTo(toadd);
            if (comparison < 0) {
                this.peak_annotations.insertElementAt(toadd, i + 1);
                if (!cur.isAnnotated() && cur.getPeak().equals(toadd.getPeak())) {
                    this.peak_annotations.removeElementAt(i);
                }
                return true;
            }
            if (comparison != 0) continue;
            return false;
        }
        this.peak_annotations.insertElementAt(toadd, 0);
        return true;
    }

    public boolean addPeakAnnotations(PeakAnnotationCollection pac) {
        if (pac == null) {
            return false;
        }
        boolean added = false;
        int i = this.peak_annotations.size() - 1;
        for (int l = pac.peak_annotations.size() - 1; l >= 0; --l) {
            PeakAnnotation toadd = pac.peak_annotations.elementAt(l);
            this.max_intensity = Math.max(this.max_intensity, toadd.getPeak().getIntensity());
            int comparison = 0;
            PeakAnnotation cur = null;
            while (i >= 0) {
                cur = this.peak_annotations.elementAt(i);
                if (!toadd.isAnnotated() && cur.getPeak().equals(toadd.getPeak())) {
                    comparison = 0;
                    break;
                }
                comparison = cur.compareTo(toadd);
                if (comparison <= 0) break;
                --i;
            }
            if (i >= 0 && comparison >= 0) continue;
            this.peak_annotations.insertElementAt(toadd, i + 1);
            if (i >= 0 && !cur.isAnnotated() && cur.getPeak().equals(toadd.getPeak())) {
                this.peak_annotations.removeElementAt(i);
                --i;
            }
            added = true;
        }
        return added;
    }

    public boolean removeAllPeakAnnotations(Peak p) {
        boolean removed = false;
        for (int i = 0; i < this.peak_annotations.size(); ++i) {
            PeakAnnotation pa = this.peak_annotations.elementAt(i);
            if (pa.getPeak().compareTo(p) > 0) {
                return removed;
            }
            if (!pa.getPeak().equals(p)) continue;
            this.peak_annotations.removeElementAt(i);
            --i;
        }
        return removed;
    }

    public int removePeakAnnotation(PeakAnnotation pa, boolean leave_empty) {
        if (pa == null) {
            return -1;
        }
        for (int i = 0; i < this.peak_annotations.size(); ++i) {
            PeakAnnotation e = this.peak_annotations.elementAt(i);
            if (!e.equals(pa)) continue;
            this.peak_annotations.removeElementAt(i);
            if (i > 0 && this.peak_annotations.elementAt(i - 1).getPeak().equals(pa.getPeak()) || i < this.peak_annotations.size() && this.peak_annotations.elementAt(i).getPeak().equals(pa.getPeak())) {
                return i;
            }
            if (leave_empty) {
                this.peak_annotations.insertElementAt(new PeakAnnotation(pa.getPeak()), i);
            }
            return i;
        }
        return -1;
    }

    public void updateIntensities() {
        this.max_intensity = 0.0;
        for (PeakAnnotation pa : this.peak_annotations) {
            this.max_intensity = Math.max(this.max_intensity, pa.getPeak().getIntensity());
        }
    }

    public boolean isAnnotated(Peak p) {
        for (PeakAnnotation pa : this.peak_annotations) {
            if (!pa.getPeak().equals(p)) continue;
            return true;
        }
        return false;
    }

    public PeakAnnotation getPeakAnnotation(int ind) {
        return this.elementAt(ind);
    }

    public int indexOf(double mz) {
        int ind = 0;
        double last_err = Double.POSITIVE_INFINITY;
        for (PeakAnnotation pa : this.peak_annotations) {
            double err = Math.abs(mz - pa.getPeak().getMZ());
            if (err > last_err) {
                return ind - 1;
            }
            last_err = err;
            ++ind;
        }
        return ind - 1;
    }

    public int indexOf(PeakAnnotation pa) {
        return this.peak_annotations.indexOf(pa);
    }

    public double[][] getPeakData() {
        return this.getPeakData(0.0, false);
    }

    public double[][] getPeakData(boolean rel_int) {
        return this.getPeakData(0.0, rel_int);
    }

    public double[][] getPeakData(double add_boundaries, boolean rel_int) {
        int no_peaks = this.size();
        int added = add_boundaries > 0.0 ? 2 : 0;
        double[][] ret = new double[][]{new double[no_peaks + added], new double[no_peaks + added]};
        double div = 1.0;
        if (rel_int) {
            div = this.getMaxIntensity() / 100.0;
        }
        for (int i = 0; i < no_peaks; ++i) {
            Peak p = this.elementAt(i).getPeak();
            ret[0][i + added / 2] = p.getMZ();
            ret[1][i + added / 2] = p.getIntensity() / div;
        }
        if (add_boundaries > 0.0) {
            ret[0][0] = ret[0][1] - add_boundaries;
            ret[1][0] = 0.0;
            ret[0][no_peaks + 1] = ret[0][no_peaks] + add_boundaries;
            ret[1][no_peaks + 1] = 0.0;
        }
        return ret;
    }

    public double[][] getPeakData(double from_mz, double to_mz) {
        return this.getPeakData(from_mz, to_mz, 0.0, false);
    }

    public double[][] getPeakData(double from_mz, double to_mz, boolean rel_int) {
        return this.getPeakData(from_mz, to_mz, 0.0, rel_int);
    }

    public double[][] getPeakData(double from_mz, double to_mz, double add_boundaries, boolean rel_int) {
        int no_peaks = 0;
        for (PeakAnnotation pa : this.peak_annotations) {
            if (!(pa.getPeak().getMZ() >= from_mz) || !(pa.getPeak().getMZ() <= to_mz)) continue;
            ++no_peaks;
        }
        int added = add_boundaries > 0.0 ? 2 : 0;
        double[][] ret = new double[][]{new double[no_peaks + added], new double[no_peaks + added]};
        double div = 1.0;
        if (rel_int) {
            div = this.getMaxIntensity(from_mz, to_mz) / 100.0;
        }
        int i = 0;
        for (PeakAnnotation pa : this.peak_annotations) {
            Peak p = pa.getPeak();
            if (!(pa.getPeak().getMZ() >= from_mz) || !(pa.getPeak().getMZ() <= to_mz)) continue;
            ret[0][i + added / 2] = p.getMZ();
            ret[1][i + added / 2] = p.getIntensity() / div;
            ++i;
        }
        if (add_boundaries > 0.0) {
            ret[0][0] = ret[0][1] - add_boundaries;
            ret[1][0] = 0.0;
            ret[0][no_peaks + 1] = ret[0][no_peaks] + add_boundaries;
            ret[1][no_peaks + 1] = 0.0;
        }
        return ret;
    }

    public Peak getPeak(int ind) {
        return this.elementAt(ind).getPeak();
    }

    public Annotation getAnnotation(int ind) {
        return this.elementAt(ind).getAnnotation();
    }

    public FragmentEntry getFragmentEntry(int ind) {
        return this.elementAt(ind).getAnnotation().getFragmentEntry();
    }

    public IonCloud getIons(int ind) {
        return this.elementAt(ind).getAnnotation().getIons();
    }

    public IonCloud getNeutralExchanges(int ind) {
        return this.elementAt(ind).getAnnotation().getNeutralExchanges();
    }

    public double getMZ(int ind) {
        return this.elementAt(ind).getPeak().getMZ();
    }

    public double getIntensity(int ind) {
        return this.elementAt(ind).getPeak().getIntensity();
    }

    public double getRelativeIntensity(int ind) {
        if (this.max_intensity == 0.0) {
            return this.getIntensity(ind);
        }
        return 100.0 * this.getIntensity(ind) / this.max_intensity;
    }

    public double getMaxIntensity() {
        return this.max_intensity;
    }

    public double getMaxIntensity(double from_mz, double to_mz) {
        double ret = 0.0;
        for (PeakAnnotation pa : this.peak_annotations) {
            if (!(pa.getPeak().getMZ() >= from_mz) || !(pa.getPeak().getMZ() <= to_mz)) continue;
            ret = Math.max(pa.getPeak().getIntensity(), ret);
        }
        return ret;
    }

    public double getMinAccuracy() {
        double min_acc = Double.MAX_VALUE;
        for (PeakAnnotation pa : this.peak_annotations) {
            if (!pa.isAnnotated()) continue;
            min_acc = Math.min(pa.getAccuracy(), min_acc);
        }
        return min_acc;
    }

    public double getMaxAccuracy() {
        double max_acc = Double.MIN_VALUE;
        for (PeakAnnotation pa : this.peak_annotations) {
            if (!pa.isAnnotated()) continue;
            max_acc = Math.max(pa.getAccuracy(), max_acc);
        }
        return max_acc;
    }

    public double getMinAccuracyPPM() {
        double min_acc = Double.MAX_VALUE;
        for (PeakAnnotation pa : this.peak_annotations) {
            if (!pa.isAnnotated()) continue;
            min_acc = Math.min(pa.getAccuracyPPM(), min_acc);
        }
        return min_acc;
    }

    public double getMaxAccuracyPPM() {
        double max_acc = Double.MIN_VALUE;
        for (PeakAnnotation pa : this.peak_annotations) {
            if (!pa.isAnnotated()) continue;
            max_acc = Math.max(pa.getAccuracyPPM(), max_acc);
        }
        return max_acc;
    }

    public double getAccuracy(int ind) {
        if (!this.isAnnotated(ind)) {
            return 0.0;
        }
        return this.elementAt(ind).getAccuracy();
    }

    public double getAccuracyPPM(int ind) {
        if (!this.isAnnotated(ind)) {
            return 0.0;
        }
        return this.elementAt(ind).getAccuracyPPM();
    }

    public boolean isAnnotated(int ind) {
        return this.elementAt(ind).isAnnotated();
    }

    public Glycan getFragment(int ind) {
        return this.elementAt(ind).getAnnotation().getFragmentEntry().getFragment();
    }

    public String getFragmentType(int ind) {
        return this.elementAt(ind).getAnnotation().getFragmentEntry().getName();
    }

    public double getFragmentScore(int ind) {
        return this.elementAt(ind).getAnnotation().getFragmentEntry().getScore();
    }

    public double getFragmentMass(int ind) {
        return this.elementAt(ind).getAnnotation().getFragmentEntry().getMass();
    }

    public double getAnnotationMZ(int ind) {
        return this.elementAt(ind).getAnnotationMZ();
    }

    public int getAnnotationZ(int ind) {
        return this.elementAt(ind).getAnnotationZ();
    }

    public static PeakAnnotationCollection fromXML(Node pac_node) throws Exception {
        PeakAnnotationCollection ret = new PeakAnnotationCollection();
        if (pac_node == null) {
            return ret;
        }
        Vector pa_nodes = XMLUtils.findAllChildren((Node)pac_node, (String)"PeakAnnotation");
        for (Node pa_node : pa_nodes) {
            ret.addPeakAnnotation(PeakAnnotation.fromXML(pa_node));
        }
        return ret;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element pac_node = document.createElement("PeakAnnotationCollection");
        if (pac_node == null) {
            return null;
        }
        for (PeakAnnotation pa : this.peak_annotations) {
            Element pa_node = pa.toXML(document);
            if (pa_node == null) continue;
            pac_node.appendChild(pa_node);
        }
        return pac_node;
    }

    public void write(TransformerHandler th) throws SAXException {
        th.startElement("", "", "PeakAnnotationCollection", new AttributesImpl());
        for (PeakAnnotation pa : this.peak_annotations) {
            pa.write(th);
        }
        th.endElement("", "", "PeakAnnotationCollection");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "PeakAnnotationCollection";
        }

        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (qName.equals(PeakAnnotation.SAXHandler.getNodeElementName())) {
                return new PeakAnnotation.SAXHandler();
            }
            return null;
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) {
            PeakAnnotationCollection ret = new PeakAnnotationCollection();
            for (Object o : this.getSubObjects(PeakAnnotation.SAXHandler.getNodeElementName())) {
                ret.addPeakAnnotation((PeakAnnotation)o);
            }
            this.object = ret;
            return this.object;
        }
    }
}

