/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.representation;

public enum ResidueRepresentationType {
    CFG_SYMBOL("cfg_symbol", "graphic", "icon used in the sugar graphs of the CFG"),
    CFG_SYMBOL_BW("cfg_symbol_bw", "graphic", "icon used in the sugar graphs of the CFG (grayscale version)"),
    OXFORD_SYMBOL("oxford_symbol", "graphic", "icon used in the sugar graphs of the Oxford encoding scheme"),
    HAWORTH("haworth", "graphic", "Haworth formula"),
    FISCHER("fischer", "graphic", "Fischer formula"),
    COORDINATES("coordinates", "3d structure", "3d structural coordinates");

    private String typeName;
    private String formatType;
    private String description;

    private ResidueRepresentationType(String nameStr, String formatTypeStr, String desc) {
        this.setTypeName(nameStr);
        this.setFormatType(formatTypeStr);
        this.setDescription(desc);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getTypeName() {
        return this.typeName;
    }

    private void setTypeName(String nameStr) {
        this.typeName = nameStr;
    }

    public String getFormatType() {
        return this.formatType;
    }

    private void setFormatType(String formatTypeStr) {
        this.formatType = formatTypeStr;
    }

    public static ResidueRepresentationType forName(String nameStr) {
        for (ResidueRepresentationType rrt : ResidueRepresentationType.values()) {
            if (!rrt.getTypeName().equalsIgnoreCase(nameStr)) continue;
            return rrt;
        }
        return null;
    }
}

