/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Modification;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;

public class CoreModification
extends Modification
implements Cloneable {
    private boolean isSubstitutable;
    private CoreModificationTemplate template;
    private int dbId;

    public CoreModification() {
        this.init();
    }

    public CoreModification(CoreModificationTemplate template, int position) throws MonosaccharideException {
        this.setModification(template, position);
    }

    public CoreModification(CoreModificationTemplate template, int position1, int position2) throws MonosaccharideException {
        this.setDivalentModification(template, position1, position2);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (name == null) {
            this.setTemplate(null);
        } else if (this.getTemplate() == null || !this.getTemplate().getName().equals(name)) {
            try {
                this.setTemplate(CoreModificationTemplate.forName(name));
            }
            catch (MonosaccharideException me) {
                this.setTemplate(null);
            }
        }
    }

    public boolean isSubstitutable() {
        return this.isSubstitutable;
    }

    public void setSubstitutable(boolean isSubstitutable) {
        this.isSubstitutable = isSubstitutable;
    }

    public CoreModificationTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(CoreModificationTemplate template) {
        if (template == null) {
            super.setName(null);
        } else {
            super.setName(template.getName());
        }
        this.template = template;
    }

    public int getDbId() {
        return this.dbId;
    }

    public void setDbId(int dbId) {
        this.dbId = dbId;
    }

    public void setModification(CoreModificationTemplate template, int position) throws MonosaccharideException {
        if (template == null) {
            this.setTemplate(null);
            this.setPosition1(new ArrayList<Integer>());
        } else {
            this.setValence(template.getValence());
            this.setSubstitutable(template.isSubstitutable());
            this.setTemplate(template);
            this.setPosition1(position);
        }
    }

    public void setDivalentModification(CoreModificationTemplate template, int position1, int position2) throws MonosaccharideException {
        this.setTemplate(template);
        this.setPosition1(position1);
        this.setPosition2(position2);
        this.setValence(template.getValence());
        this.setSubstitutable(template.isSubstitutable());
    }

    public void changeType(CoreModificationTemplate newTemplate) throws MonosaccharideException {
        if (this.getTemplate().getValence() != newTemplate.getValence()) {
            throw new MonosaccharideException("cannot change modification of valence " + this.getTemplate().getValence() + " to one of valence " + newTemplate.getValence());
        }
        this.setTemplate(newTemplate);
    }

    @Override
    public void init() {
        try {
            this.setModification(null, 0);
        }
        catch (MonosaccharideException me) {
            System.err.println("Internal error: Exception in CoreModification.init(): " + me.getMessage());
        }
    }

    @Override
    public CoreModification clone() {
        CoreModification modClone = new CoreModification();
        modClone.setName(this.getName());
        modClone.setTemplate(this.getTemplate());
        modClone.setValence(this.getValence());
        modClone.setSubstitutable(this.isSubstitutable());
        modClone.setPosition1(this.getPosition1Clone());
        modClone.setPosition2(this.getPosition2Clone());
        return modClone;
    }
}

