/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.share;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.PreferenceHandler;
import org.grits.toolbox.core.preference.project.UtilityPreferenceValue;
import org.grits.toolbox.core.preference.share.IGritsPreferenceStore;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.jdom.Element;

public class SingleChoicePreference {
    private static final Logger logger = Logger.getLogger(SingleChoicePreference.class);
    private IGritsPreferenceStore gritsPreferenceStore = null;
    private String preferenceName = null;
    private Set<String> allValues = new HashSet<String>();
    private String defaultValue = null;
    private boolean dirty = false;

    SingleChoicePreference(IGritsPreferenceStore gritsPreferenceStore, ProjectPreferenceStore.Preference preference) {
        logger.info((Object)("Creating single selection type preference : " + preference.getPreferenceName()));
        this.gritsPreferenceStore = gritsPreferenceStore;
        this.preferenceName = preference.getPreferenceName();
        this.initializeValues(preference);
        if (this.dirty) {
            this.savePreference();
        }
    }

    protected void initializeValues(ProjectPreferenceStore.Preference preference) {
        Map<String, Boolean> valueSelectionMap = this.getValueSelectionMap(this.preferenceName);
        int index = 0;
        while (valueSelectionMap == null && index < preference.previousNames.length) {
            valueSelectionMap = this.getPreversioningValues(preference.previousNames[index++]);
        }
        if (valueSelectionMap == null) {
            valueSelectionMap = this.loadDefaultValues(preference);
            this.dirty = true;
        }
        this.loadFromMap(valueSelectionMap);
    }

    private void loadFromMap(Map<String, Boolean> valueSelectionMap) {
        for (String value : valueSelectionMap.keySet()) {
            this.allValues.add(value);
            if (!valueSelectionMap.get(value).booleanValue()) continue;
            this.defaultValue = value;
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        if (defaultValue != null && !this.allValues.contains(defaultValue)) {
            this.addValue(defaultValue);
        }
        this.defaultValue = defaultValue;
    }

    public Set<String> getAllValues() {
        return this.allValues;
    }

    public void setAllValues(Set<String> allValues) {
        this.allValues = allValues;
    }

    public boolean addValue(String value) {
        return this.allValues.add(value);
    }

    public boolean savePreference() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(this.preferenceName);
        preferenceEntity.setValue(UtilityPreferenceValue.getPreferenceValueString(this.allValues, this.defaultValue));
        return this.gritsPreferenceStore.savePreference(preferenceEntity);
    }

    public Map<String, Boolean> loadDefaultValues(ProjectPreferenceStore.Preference preference) {
        return preference.getDefaultFileName() == null ? new HashMap() : PreferenceHandler.getPreferenceValues(preference.getDefaultFileName());
    }

    protected Map<String, Boolean> getValueSelectionMap(String preferenceName) {
        Map<String, Boolean> valueSelectionMap = null;
        try {
            PreferenceEntity preferenceEntity = this.gritsPreferenceStore.getPreferenceEntity(preferenceName);
            if (preferenceEntity != null) {
                logger.info((Object)("Preference found : " + preferenceName));
                valueSelectionMap = UtilityPreferenceValue.getPreferenceValuesWithSelection(preferenceEntity);
            }
        }
        catch (UnsupportedVersionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return valueSelectionMap;
    }

    protected Map<String, Boolean> getPreversioningValues(String previousName) {
        HashMap<String, Boolean> valueSelectionMap = null;
        Element preferenceElement = this.gritsPreferenceStore.getPreferenceElement(this.preferenceName);
        if (preferenceElement != null) {
            logger.info((Object)("Preference found : " + this.preferenceName));
            valueSelectionMap = new HashMap<String, Boolean>();
            for (String v : UtilityPreferenceValue.getPreversioningValues(preferenceElement)) {
                valueSelectionMap.put(v, false);
            }
            String selectedValue = UtilityPreferenceValue.getPreversioningSelected(preferenceElement);
            if (selectedValue != null && !selectedValue.trim().isEmpty()) {
                valueSelectionMap.put(selectedValue.trim(), true);
            }
            this.gritsPreferenceStore.removePreference(previousName);
            this.dirty = true;
        }
        return valueSelectionMap;
    }
}

