/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.property.project.ProjectCollaborator;
import org.grits.toolbox.core.part.toolitem.SaveCollaborator;
import org.grits.toolbox.core.preference.project.FundingPreference;
import org.grits.toolbox.core.preference.project.PositionPreference;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.typeahead.NamespaceHandler;
import org.grits.toolbox.core.typeahead.PatriciaTrieContentProposalProvider;

public class CollaboratorPart {
    private static Logger logger = Logger.getLogger(CollaboratorPart.class);
    public static final String PART_ID = "org.grits.toolbox.core.part.project.collaborator";
    public static final String EVENT_TOPIC_VALUE_MODIFIED = "EventTopic_CollabPart_Modified";
    private static final String ADD_NEW_TO_PREFERENCE = "Add New ...";
    private Text nameText = null;
    private Text groupPIText = null;
    private ComboViewer positionCombo = null;
    private Text departmentText = null;
    private Text institutionText = null;
    private Text addressText = null;
    private Text countryText = null;
    private Text emailText = null;
    private Text phoneText = null;
    private Text faxText = null;
    private ComboViewer fundingCombo = null;
    private Text grantText = null;
    protected ControlDecoration nameErrorDecoration = null;
    private NamespaceHandler handler = null;
    private PatriciaTrie<String> trie = null;
    private PatriciaTrieContentProposalProvider contentProposalProvider = null;
    private ContentProposalAdapter contentProposalAdapter = null;
    @Inject
    IEventBroker eventBroker;
    @Inject
    ECommandService commandService;
    @Inject
    EHandlerService handlerService;
    private ProjectCollaborator collaborator = null;
    private MPart collabPart = null;

    @Inject
    public CollaboratorPart() {
    }

    @Optional
    @Inject
    void setCollaborator(@UIEventTopic(value="grits_project_some_field_selected") ProjectCollaborator collaborator, EPartService partService, EModelService modelService) {
        MPart collabPart;
        MPart mPart = collabPart = partService == null ? null : partService.findPart(PART_ID);
        if (collabPart != null && collabPart.getObject() != null) {
            this.clearAll();
            if (collaborator != null) {
                this.nameText.setText(collaborator.getName());
                String value = collaborator.getGroupOrPIName() == null ? "" : collaborator.getGroupOrPIName();
                this.groupPIText.setText(value);
                value = collaborator.getDepartment() == null ? "" : collaborator.getDepartment();
                this.departmentText.setText(value);
                value = collaborator.getInstitution() == null ? "" : collaborator.getInstitution();
                this.institutionText.setText(value);
                value = collaborator.getAddress() == null ? "" : collaborator.getAddress();
                this.addressText.setText(value);
                value = collaborator.getCountry() == null ? "" : collaborator.getCountry();
                this.countryText.setText(value);
                value = collaborator.getEmail() == null ? "" : collaborator.getEmail();
                this.emailText.setText(value);
                value = collaborator.getPhone() == null ? "" : collaborator.getPhone();
                this.phoneText.setText(value);
                value = collaborator.getFax() == null ? "" : collaborator.getFax();
                this.faxText.setText(value);
                value = collaborator.getGrantNumber() == null ? "" : collaborator.getGrantNumber();
                this.grantText.setText(value);
                this.selectValueInCombo(this.positionCombo, collaborator.getPosition());
                this.selectValueInCombo(this.fundingCombo, collaborator.getFundingAgency());
                this.collabPart = collabPart;
                this.collaborator = collaborator;
                this.enableToolItem();
                this.makeEditable(true);
                modelService.bringToTop((MUIElement)collabPart);
            }
        }
    }

    private void enableToolItem() {
        ((MDirectToolItem)this.collabPart.getToolbar().getChildren().iterator().next()).setEnabled(SaveCollaborator.isUnique(this.collaborator));
    }

    private void clearAll() {
        this.collaborator = null;
        this.nameText.setText("");
        this.groupPIText.setText("");
        this.departmentText.setText("");
        this.institutionText.setText("");
        this.addressText.setText("");
        this.countryText.setText("");
        this.emailText.setText("");
        this.phoneText.setText("");
        this.faxText.setText("");
        this.grantText.setText("");
        this.positionCombo.getCombo().deselectAll();
        this.fundingCombo.getCombo().deselectAll();
        this.makeEditable(false);
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        logger.debug((Object)"START : Creating Collaborator View");
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 10;
        layout.marginTop = 30;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.nameText = this.createTextLine(composite, "Name*");
        this.nameErrorDecoration = new ControlDecoration((Control)this.nameText, 16384);
        this.nameErrorDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        this.nameErrorDecoration.hide();
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name;
                CollaboratorPart.this.nameErrorDecoration.hide();
                if (CollaboratorPart.this.collaborator != null && !Objects.equals(name = ((Text)e.getSource()).getText().trim(), CollaboratorPart.this.collaborator.getName())) {
                    String invalidMessage = CollaboratorPart.this.validate(name);
                    if (invalidMessage == null) {
                        CollaboratorPart.this.collaborator.setName(name);
                        CollaboratorPart.this.enableToolItem();
                    } else {
                        CollaboratorPart.this.nameErrorDecoration.show();
                    }
                    CollaboratorPart.this.nameErrorDecoration.setDescriptionText(invalidMessage);
                    CollaboratorPart.this.eventBroker.post(CollaboratorPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)CollaboratorPart.this.collaborator);
                }
            }
        });
        this.groupPIText = this.createTextLine(composite, "Group/P.I.");
        this.groupPIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String groupPI;
                if (CollaboratorPart.this.collaborator != null && !Objects.equals(groupPI = ((Text)e.getSource()).getText().trim(), CollaboratorPart.this.collaborator.getGroupOrPIName())) {
                    CollaboratorPart.this.collaborator.setGroupOrPIName(groupPI);
                    CollaboratorPart.this.eventBroker.post(CollaboratorPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)CollaboratorPart.this.collaborator);
                }
            }
        });
        this.positionCombo = this.createComboLine(composite, "Position");
        this.positionCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setInputInCombo(this.positionCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.POSITION).getAllValues());
        this.positionCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection;
                if (CollaboratorPart.this.collaborator != null && (selection = (StructuredSelection)event.getSelection()).getFirstElement() != null) {
                    String position = (String)selection.getFirstElement();
                    if (position.equals(CollaboratorPart.ADD_NEW_TO_PREFERENCE)) {
                        HashMap<String, String> preferencePageParams = new HashMap<String, String>();
                        preferencePageParams.put("org.grits.toolbox.core.commandparameter.preference.pageid", "org.grits.toolbox.core.preference.project.collaborator.position");
                        CollaboratorPart.this.handlerService.executeHandler(CollaboratorPart.this.commandService.createCommand("org.grits.toolbox.core.command.preference.open", preferencePageParams));
                        CollaboratorPart.this.setInputInCombo(CollaboratorPart.this.positionCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.POSITION).getAllValues());
                        CollaboratorPart.this.positionCombo.getCombo().deselectAll();
                        int comboSelection = CollaboratorPart.this.getIndexOf(CollaboratorPart.this.positionCombo, PositionPreference.lastSelection);
                        if (comboSelection >= 0) {
                            CollaboratorPart.this.positionCombo.setSelection((ISelection)new StructuredSelection((Object)PositionPreference.lastSelection));
                        }
                    } else if (!Objects.equals(position, CollaboratorPart.this.collaborator.getPosition())) {
                        CollaboratorPart.this.collaborator.setPosition(position);
                        CollaboratorPart.this.eventBroker.post(CollaboratorPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)CollaboratorPart.this.collaborator);
                    }
                }
            }
        });
        this.departmentText = this.createTextLine(composite, "Department");
        this.departmentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String department;
                if (CollaboratorPart.this.collaborator != null && !Objects.equals(department = ((Text)e.getSource()).getText().trim(), CollaboratorPart.this.collaborator.getDepartment())) {
                    CollaboratorPart.this.collaborator.setDepartment(department);
                    CollaboratorPart.this.eventBroker.post(CollaboratorPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)CollaboratorPart.this.collaborator);
                }
            }
        });
        this.institutionText = this.createTextLine(composite, "Institution");
        this.institutionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String institution;
                if (CollaboratorPart.this.collaborator != null && !Objects.equals(institution = ((Text)e.getSource()).getText().trim(), CollaboratorPart.this.collaborator.getInstitution())) {
                    CollaboratorPart.this.collaborator.setInstitution(institution);
                    CollaboratorPart.this.eventBroker.post(CollaboratorPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)CollaboratorPart.this.collaborator);
                }
            }
        });
        this.addressText = this.createTextLine(composite, "Address", 2562);
        ((GridData)this.addressText.getLayoutData()).heightHint = 50;
        this.addressText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String address;
                if (CollaboratorPart.this.collaborator != null && !Objects.equals(address = ((Text)e.getSource()).getText().trim(), CollaboratorPart.this.collaborator.getAddress())) {
                    CollaboratorPart.this.collaborator.setAddress(address);
                    CollaboratorPart.this.eventBroker.post(CollaboratorPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)CollaboratorPart.this.collaborator);
                }
            }
        });
        this.countryText = this.createTextLine(composite, "Country");
        this.countryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String country;
                if (CollaboratorPart.this.collaborator != null && !Objects.equals(country = ((Text)e.getSource()).getText().trim(), CollaboratorPart.this.collaborator.getCountry())) {
                    CollaboratorPart.this.collaborator.setCountry(country);
                    CollaboratorPart.this.eventBroker.post(CollaboratorPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)CollaboratorPart.this.collaborator);
                }
            }
        });
        try {
            this.handler = new NamespaceHandler("country", "preference", "countries.txt");
            this.trie = this.handler.getTrieForNamespace();
            this.contentProposalProvider = new PatriciaTrieContentProposalProvider(this.trie);
            this.contentProposalAdapter = new ContentProposalAdapter((Control)this.countryText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.contentProposalProvider, null, null);
            this.contentProposalAdapter.setProposalAcceptanceStyle(2);
        }
        catch (Exception ex) {
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
        }
        this.countryText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 27) {
                    e.doit = false;
                    if (CollaboratorPart.this.collaborator != null && CollaboratorPart.this.contentProposalAdapter != null && CollaboratorPart.this.contentProposalAdapter.isProposalPopupOpen()) {
                        CollaboratorPart.this.countryText.setText("");
                    }
                    e.detail = 0;
                }
            }
        });
        this.emailText = this.createTextLine(composite, "Email");
        this.emailText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String email;
                if (CollaboratorPart.this.collaborator != null && !Objects.equals(email = ((Text)e.getSource()).getText().trim(), CollaboratorPart.this.collaborator.getEmail())) {
                    CollaboratorPart.this.collaborator.setEmail(email);
                    CollaboratorPart.this.eventBroker.post(CollaboratorPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)CollaboratorPart.this.collaborator);
                }
            }
        });
        this.phoneText = this.createTextLine(composite, "Phone");
        this.phoneText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String phone;
                if (CollaboratorPart.this.collaborator != null && !Objects.equals(phone = ((Text)e.getSource()).getText().trim(), CollaboratorPart.this.collaborator.getPhone())) {
                    CollaboratorPart.this.collaborator.setPhone(phone);
                    CollaboratorPart.this.eventBroker.post(CollaboratorPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)CollaboratorPart.this.collaborator);
                }
            }
        });
        this.faxText = this.createTextLine(composite, "Fax");
        this.faxText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String fax;
                if (CollaboratorPart.this.collaborator != null && !Objects.equals(fax = ((Text)e.getSource()).getText().trim(), CollaboratorPart.this.collaborator.getFax())) {
                    CollaboratorPart.this.collaborator.setFax(fax);
                    CollaboratorPart.this.eventBroker.post(CollaboratorPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)CollaboratorPart.this.collaborator);
                }
            }
        });
        this.fundingCombo = this.createComboLine(composite, "Funding");
        this.fundingCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setInputInCombo(this.fundingCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.FUNDING).getAllValues());
        this.fundingCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection;
                if (CollaboratorPart.this.collaborator != null && (selection = (StructuredSelection)event.getSelection()).getFirstElement() != null) {
                    String funding = (String)selection.getFirstElement();
                    if (funding.equals(CollaboratorPart.ADD_NEW_TO_PREFERENCE)) {
                        HashMap<String, String> preferencePageParams = new HashMap<String, String>();
                        preferencePageParams.put("org.grits.toolbox.core.commandparameter.preference.pageid", "org.grits.toolbox.core.preference.project.collaborator.funding");
                        CollaboratorPart.this.handlerService.executeHandler(CollaboratorPart.this.commandService.createCommand("org.grits.toolbox.core.command.preference.open", preferencePageParams));
                        CollaboratorPart.this.setInputInCombo(CollaboratorPart.this.fundingCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.FUNDING).getAllValues());
                        CollaboratorPart.this.fundingCombo.getCombo().deselectAll();
                        int comboSelection = CollaboratorPart.this.getIndexOf(CollaboratorPart.this.fundingCombo, FundingPreference.lastSelection);
                        if (comboSelection >= 0) {
                            CollaboratorPart.this.fundingCombo.setSelection((ISelection)new StructuredSelection((Object)FundingPreference.lastSelection));
                        }
                    } else if (!Objects.equals(funding, CollaboratorPart.this.collaborator.getFundingAgency())) {
                        CollaboratorPart.this.collaborator.setFundingAgency(funding);
                        CollaboratorPart.this.enableToolItem();
                        CollaboratorPart.this.eventBroker.post(CollaboratorPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)CollaboratorPart.this.collaborator);
                    }
                }
            }
        });
        this.grantText = this.createTextLine(composite, "Grant No.");
        this.grantText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String grantNumber;
                if (CollaboratorPart.this.collaborator != null && !Objects.equals(grantNumber = ((Text)e.getSource()).getText().trim(), CollaboratorPart.this.collaborator.getGrantNumber())) {
                    CollaboratorPart.this.collaborator.setGrantNumber(grantNumber);
                    CollaboratorPart.this.enableToolItem();
                    CollaboratorPart.this.eventBroker.post(CollaboratorPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)CollaboratorPart.this.collaborator);
                }
            }
        });
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.grabExcessHorizontalSpace = true;
        compositeLayoutData.grabExcessVerticalSpace = false;
        compositeLayoutData.horizontalSpan = 3;
        compositeLayoutData.verticalSpan = 1;
        composite.setLayoutData((Object)compositeLayoutData);
        this.makeEditable(false);
        logger.debug((Object)"END   : Creating Collaborator View");
    }

    private Text createTextLine(Composite composite, String label) {
        return this.createTextLine(composite, label, 2048);
    }

    private Text createTextLine(Composite composite, String label, int style) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(label);
        GridData createNewData = new GridData(32);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
        Text text = new Text(composite, style);
        GridData newCollaboratorData = new GridData(768);
        newCollaboratorData.grabExcessHorizontalSpace = true;
        newCollaboratorData.horizontalSpan = 1;
        newCollaboratorData.verticalSpan = 1;
        text.setLayoutData((Object)newCollaboratorData);
        return text;
    }

    private ComboViewer createComboLine(Composite composite, String label) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(label);
        GridData createNewData = new GridData(32);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        GridData newCollaboratorData = new GridData(768);
        newCollaboratorData.grabExcessHorizontalSpace = true;
        newCollaboratorData.horizontalSpan = 1;
        newCollaboratorData.verticalSpan = 1;
        comboViewer.getCombo().setLayoutData((Object)newCollaboratorData);
        return comboViewer;
    }

    private void setInputInCombo(ComboViewer comboViewer, Set<String> values) {
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.addAll(values);
        Collections.sort(valueList);
        String[] items = new String[valueList.size() + 1];
        int i = 0;
        for (String value : valueList) {
            items[i++] = value;
        }
        items[i] = ADD_NEW_TO_PREFERENCE;
        comboViewer.setInput((Object)items);
    }

    private void selectValueInCombo(ComboViewer comboViewer, String value) {
        int selectionIndex;
        comboViewer.getCombo().deselectAll();
        if (value != null && (selectionIndex = this.getIndexOf(comboViewer, value)) >= 0) {
            comboViewer.getCombo().select(selectionIndex);
            comboViewer.setSelection(comboViewer.getSelection());
        }
    }

    private int getIndexOf(ComboViewer comboViewer, String value) {
        int selectionIndex = -1;
        if (comboViewer != null && comboViewer.getCombo().getItems() != null && value != null) {
            selectionIndex = comboViewer.getCombo().indexOf(value);
        }
        return selectionIndex;
    }

    private void makeEditable(boolean editable) {
        this.nameText.setEnabled(editable);
        this.groupPIText.setEnabled(editable);
        this.departmentText.setEnabled(editable);
        this.institutionText.setEnabled(editable);
        this.addressText.setEnabled(editable);
        this.countryText.setEnabled(editable);
        this.emailText.setEnabled(editable);
        this.phoneText.setEnabled(editable);
        this.faxText.setEnabled(editable);
        this.grantText.setEnabled(editable);
        this.positionCombo.getCombo().setEnabled(editable);
        this.fundingCombo.getCombo().setEnabled(editable);
    }

    private String validate(String value) {
        return value.isEmpty() ? "Value is empty" : null;
    }

    @Focus
    public void onFocus() {
    }

    @Persist
    public void save() {
    }

    public ProjectCollaborator getCollaborator() {
        return this.collaborator;
    }
}

