/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.tablehelpers;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.resize.action.ColumnResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEventMatcher;
import org.eclipse.nebula.widgets.nattable.resize.mode.ColumnResizeDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.ClearCursorAction;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.MSGlycanAnnotationTableDataObject;
import org.grits.toolbox.entry.ms.annotation.glycan.tablehelpers.CellPopupMenuAction;
import org.grits.toolbox.entry.ms.annotation.glycan.tablehelpers.MSGlycanAnnotationTable;
import org.grits.toolbox.utils.image.GlycanImageProvider;

public class GlycanStructureExportConfiguration
extends AbstractUiBindingConfiguration {
    static final Logger logger = Logger.getLogger(GlycanStructureExportConfiguration.class);
    private Menu bodyMenu;
    private List<Integer> cartoonCols = null;
    private MSGlycanAnnotationTable nattable;
    private DataLayer bodyLayer;

    public GlycanStructureExportConfiguration(List<Integer> cartoonCols, MSGlycanAnnotationTable nattable) {
        this.cartoonCols = cartoonCols;
        this.nattable = nattable;
        this.bodyLayer = nattable.getBottomDataLayer();
        this.bodyMenu = this.createBodyMenu((NatTable)nattable).build();
        nattable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GlycanStructureExportConfiguration.this.bodyMenu.dispose();
            }
        });
    }

    private PopupMenuBuilder createBodyMenu(NatTable natTable) {
        Menu menu = new Menu((Control)natTable);
        final MenuItem item1 = new MenuItem(menu, 8);
        item1.setText("Export Structure as an image");
        item1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String sequence = (String)item1.getData();
                if (sequence == null) {
                    return;
                }
                GlycanImageProvider.GlycanImageObject gio = MSGlycanAnnotationTableDataObject.glycanImageProvider.getImage(sequence);
                FileDialog dialog = new FileDialog(new Shell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.png", "*.svg", "*.jpg"});
                dialog.setFilterNames(new String[]{"PNG (*.png)", "SVG (*.svg)", "JPEG (*.jpg)"});
                dialog.setOverwrite(true);
                String result = dialog.open();
                if (result != null) {
                    File file = new File(result);
                    try {
                        if (result.endsWith("jpg")) {
                            BufferedImage image = gio.getAwtBufferedImage();
                            BufferedImage imageRGB = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                            imageRGB.createGraphics().drawImage(image, 0, 0, Color.WHITE, null);
                            ImageIO.write((RenderedImage)imageRGB, "jpg", file);
                        } else if (result.endsWith("png")) {
                            ImageIO.write((RenderedImage)gio.getAwtBufferedImage(), "png", file);
                        } else if (result.endsWith("svg")) {
                            gio.exportSVG(file);
                        }
                    }
                    catch (IOException e1) {
                        logger.error((Object)"Error writing the sequence to the file", (Throwable)e1);
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Error exporting the structure to the selected file. Reason: " + e1.getMessage()));
                    }
                    catch (Exception e1) {
                        logger.error((Object)"Error writing the sequence to the file in the specified format", (Throwable)e1);
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Error exporting the structure to the selected file in the specified format. Reason: " + e1.getMessage()));
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final MenuItem item2 = new MenuItem(menu, 8);
        item2.setText("Export as GlycoWorkbench Sequence");
        item2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String sequence = (String)item2.getData();
                if (sequence == null) {
                    return;
                }
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.gws"});
                dialog.setFilterNames(new String[]{"GlycoWorkbench (*.gws)"});
                dialog.setOverwrite(true);
                String result = dialog.open();
                if (result != null) {
                    File file = new File(result);
                    try {
                        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                        writer.write(sequence);
                        writer.close();
                    }
                    catch (IOException e1) {
                        logger.error((Object)"Error writing the sequence to the file", (Throwable)e1);
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Error exporting the structure to the selected file. Reason: " + e1.getMessage()));
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return new PopupMenuBuilder(natTable, menu);
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        MouseEventMatcher matcher = new MouseEventMatcher(0, "BODY", 3){

            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                if (super.matches(natTable, event, regionLabels)) {
                    int columnPosition = natTable.getColumnPositionByX(event.x);
                    int rowPosition = natTable.getRowPositionByY(event.y);
                    int columnIndex = LayerUtil.convertColumnPosition((ILayer)natTable, (int)columnPosition, (IUniqueIndexLayer)GlycanStructureExportConfiguration.this.bodyLayer);
                    int rowIndex = LayerUtil.convertRowPosition((ILayer)natTable, (int)rowPosition, (IUniqueIndexLayer)GlycanStructureExportConfiguration.this.bodyLayer);
                    if (GlycanStructureExportConfiguration.this.cartoonCols.contains(columnIndex)) {
                        String sCartoonID = (String)GlycanStructureExportConfiguration.this.bodyLayer.getDataValueByPosition(columnIndex, rowIndex);
                        if (sCartoonID == null || sCartoonID.equals("")) {
                            return false;
                        }
                        if (((MSGlycanAnnotationTableDataObject)GlycanStructureExportConfiguration.this.nattable.getGRITSTableDataObject()).getSequenceCols() == null || ((MSGlycanAnnotationTableDataObject)GlycanStructureExportConfiguration.this.nattable.getGRITSTableDataObject()).getSequenceCols().isEmpty()) {
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Cannot find the glycan sequence");
                            return false;
                        }
                        Integer sequenceCol = (Integer)((MSGlycanAnnotationTableDataObject)GlycanStructureExportConfiguration.this.nattable.getGRITSTableDataObject()).getSequenceCols().get(0);
                        String sequence = (String)GlycanStructureExportConfiguration.this.bodyLayer.getDataValueByPosition(sequenceCol.intValue(), rowIndex);
                        GlycanStructureExportConfiguration.this.bodyMenu.getItems()[0].setData((Object)sequence);
                        GlycanStructureExportConfiguration.this.bodyMenu.getItems()[1].setData((Object)sequence);
                        return true;
                    }
                }
                return false;
            }
        };
        uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)matcher, (IMouseAction)new CellPopupMenuAction(this.bodyMenu));
        uiBindingRegistry.registerMouseMoveBinding((IMouseEventMatcher)new MouseEventMatcher(), (IMouseAction)new ClearCursorAction());
        uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "CORNER", 0), (IMouseAction)new ColumnResizeCursorAction());
        uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "CORNER", 1), (IDragMode)new ColumnResizeDragMode());
    }
}

