/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.database;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.util.structure.glycan.database.GlycanDatabase;
import org.grits.toolbox.util.structure.glycan.database.GlycanStructure;

public class GlycanDatabaseUtils {
    public static final Logger logger = Logger.getLogger(GlycanDatabaseUtils.class);
    private static String m_strGDB = "";
    private static GlycanDatabase m_gDB = null;

    public static GlycanDatabase loadGlycanDatabase() {
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog fd = new FileDialog(shell, 4096);
        fd.setText("Load glycan database");
        fd.setFilterNames(new String[]{"Glycan database file (*.xml)"});
        fd.setFilterExtensions(new String[]{"*.xml"});
        String strFilepath = fd.open();
        return GlycanDatabaseUtils.loadGlycanDatabase(strFilepath);
    }

    public static GlycanDatabase loadGlycanDatabase(String strGDBFilepath) {
        if (strGDBFilepath == null) {
            return null;
        }
        if (m_strGDB.equals(strGDBFilepath)) {
            return m_gDB;
        }
        m_strGDB = strGDBFilepath;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            m_gDB = (GlycanDatabase)jaxbUnmarshaller.unmarshal((InputStream)new FileInputStream(strGDBFilepath));
            return m_gDB;
        }
        catch (JAXBException e) {
            logger.error((Object)"An error during deserializing GlycanDatabase object.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"GlycanDatabase XML file not found.", (Throwable)e);
        }
        return null;
    }

    public static void saveGlycanDatabase(GlycanDatabase database) {
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setText("Save glycan database");
        fd.setOverwrite(true);
        fd.setFilterNames(new String[]{"Glycan database file (*.xml)"});
        fd.setFilterExtensions(new String[]{"*.xml"});
        String strFilepath = fd.open();
        GlycanDatabaseUtils.saveGlycanDatabase(database, strFilepath);
    }

    public static void saveGlycanDatabase(GlycanDatabase database, String strGDBFilepath) {
        if (strGDBFilepath == null) {
            return;
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)database, new File(strGDBFilepath));
        }
        catch (JAXBException e) {
            logger.error((Object)"An error during deserializing GlycanDatabase object.", (Throwable)e);
        }
    }

    public static List<String> extractGlycanSequences(GlycanDatabase database) {
        ArrayList<String> lSequences = new ArrayList<String>();
        for (GlycanStructure structure : database.getStructures()) {
            lSequences.add(structure.getGWBSequence());
        }
        return lSequences;
    }

    public static GlycanDatabase createGlycanDatabase(List<String> lSequences, String strPrefix, String strSufix, boolean bTrimSameStructure) {
        if (lSequences == null || lSequences.isEmpty()) {
            return null;
        }
        HashSet<String> lStoredSequences = new HashSet<String>();
        int i = 1;
        GlycanDatabase database = new GlycanDatabase();
        for (String sequence : lSequences) {
            if (bTrimSameStructure && lStoredSequences.contains(sequence)) continue;
            lStoredSequences.add(sequence);
            GlycanStructure structure = new GlycanStructure();
            structure.setGWBSequence(sequence);
            String strID = String.valueOf(strPrefix == null ? "" : strPrefix) + i + (strSufix == null ? "" : strSufix);
            structure.setId(strID);
            database.addStructure(structure);
            ++i;
        }
        return database;
    }
}

