/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.merge.om.data;

import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.ms.om.data.ReducingEnd;
import org.grits.toolbox.ms.om.io.xml.StringBooleanMapAdapter;
import org.grits.toolbox.ms.om.io.xml.StringDoubleMapAdapter;
import org.grits.toolbox.ms.om.io.xml.StringIntegerMapAdapter;
import org.grits.toolbox.ms.om.io.xml.StringStringMapAdapter;

public class ExtGlycanFeature {
    private int expAnotationId;
    public static final String ExpAnnotationId = "ExpAnnotationId";
    private Integer annotationId = null;
    public static final String AnnotationId = "AnnotationId";
    private String stringAnnotationId = null;
    public static final String StringAnnotationId = "StringAnnotationId";
    private String featureId;
    public static final String FeatureId = "FeatureId";
    private int peakId;
    public static final String PeakId = "PeakId";
    private String sequenceGWB;
    public static final String SequenceGWB = "SequenceGWB";
    private String sequence;
    public static final String Sequence = "Sequence";
    private String sequenceFormat;
    public static final String SequenceFormat = "SequenceFormat";
    private double featureMz;
    public static final String FeatureMz = "FeatureMz";
    private double intensity;
    public static final String Intensity = "Intensity";
    private int charge;
    public static final String Charge = "Charge";
    private boolean selected = true;
    @XmlElement(name="reducingEnd")
    private ReducingEnd m_reducingEnd = null;
    private HashMap<String, Integer> m_featureIntegerProp = new HashMap();
    private HashMap<String, Double> m_featureDoubleProp = new HashMap();
    private HashMap<String, String> m_featureStringProp = new HashMap();
    private HashMap<String, Boolean> m_featureBooleanProp = new HashMap();
    private HashMap<String, Integer> m_annotationIntegerProp = new HashMap();
    private HashMap<String, Double> m_annotationDoubleProp = new HashMap();
    private HashMap<String, String> m_annotationStringProp = new HashMap();
    private HashMap<String, Boolean> m_annotationBooleanProp = new HashMap();
    public static final String COMBO_DATA_SEPARATOR = ", ";

    public boolean equals(Object obj) {
        if (!(obj instanceof ExtGlycanFeature)) {
            return false;
        }
        return this.getExpAnotationId() == ((ExtGlycanFeature)obj).getExpAnotationId() && this.getStringAnnotationId().equals(((ExtGlycanFeature)obj).getStringAnnotationId());
    }

    private static Object getExtGlycanFeatureData(ExtGlycanFeature _glycanFeature, String sCurKey) {
        switch (sCurKey) {
            case "ExpAnnotationId": {
                return _glycanFeature.getExpAnotationId();
            }
            case "AnnotationId": {
                return _glycanFeature.getAnnotationId();
            }
            case "StringAnnotationId": {
                return _glycanFeature.getStringAnnotationId();
            }
            case "FeatureId": {
                return _glycanFeature.getFeatureId();
            }
            case "PeakId": {
                return _glycanFeature.getPeakId();
            }
            case "SequenceGWB": {
                return _glycanFeature.getSequenceGWB();
            }
            case "Sequence": {
                return _glycanFeature.getSequence();
            }
            case "SequenceFormat": {
                return _glycanFeature.getSequenceFormat();
            }
            case "FeatureMz": {
                return _glycanFeature.getFeatureMz();
            }
            case "Intensity": {
                return _glycanFeature.getIntensity();
            }
            case "Charge": {
                return _glycanFeature.getCharge();
            }
        }
        return null;
    }

    private static Object getExtGlycanFeatureData(ExtGlycanFeature _glycanFeature, CustomExtraData _ced) {
        String sCurKey = _ced.getKey();
        for (String sKey2 : _glycanFeature.getFeatureBooleanProp().keySet()) {
            if (!sCurKey.equals(sKey2)) continue;
            Boolean bVal = _glycanFeature.getFeatureBooleanProp().get(sKey2);
            if (bVal == null) {
                bVal = Boolean.FALSE;
            }
            return bVal != false ? "Yes" : "No";
        }
        for (String sKey2 : _glycanFeature.getFeatureDoubleProp().keySet()) {
            if (!sCurKey.equals(sKey2)) continue;
            Double dOrigVal = _glycanFeature.getFeatureDoubleProp().get(sKey2);
            if (dOrigVal == null) {
                return null;
            }
            Double dFormatVal = new Double(_ced.getDoubleFormat().format(dOrigVal));
            return dFormatVal;
        }
        for (String sKey2 : _glycanFeature.getFeatureIntegerProp().keySet()) {
            if (!sCurKey.equals(sKey2)) continue;
            return _glycanFeature.getFeatureIntegerProp().get(sKey2);
        }
        for (String sKey2 : _glycanFeature.getFeatureStringProp().keySet()) {
            if (!sCurKey.equals(sKey2)) continue;
            return _glycanFeature.getFeatureStringProp().get(sKey2);
        }
        for (String sKey2 : _glycanFeature.getAnnotationBooleanProp().keySet()) {
            if (!sCurKey.equals(sKey2)) continue;
            Boolean bVal = _glycanFeature.getAnnotationBooleanProp().get(sKey2);
            if (bVal == null) {
                bVal = Boolean.FALSE;
            }
            return bVal != false ? "Yes" : "No";
        }
        for (String sKey2 : _glycanFeature.getAnnotationDoubleProp().keySet()) {
            if (!sCurKey.equals(sKey2)) continue;
            Double dOrigVal = _glycanFeature.getAnnotationDoubleProp().get(sKey2);
            if (dOrigVal == null) {
                return null;
            }
            Double dFormatVal = new Double(_ced.getDoubleFormat().format(dOrigVal));
            return dFormatVal;
        }
        for (String sKey2 : _glycanFeature.getAnnotationIntegerProp().keySet()) {
            if (!sCurKey.equals(sKey2)) continue;
            return _glycanFeature.getAnnotationIntegerProp().get(sKey2);
        }
        for (String sKey2 : _glycanFeature.getAnnotationStringProp().keySet()) {
            if (!sCurKey.equals(sKey2)) continue;
            return _glycanFeature.getAnnotationStringProp().get(sKey2);
        }
        return null;
    }

    public static Object getCombinedData(List<ExtGlycanFeature> _lFeatures, String _sKey, String _sDelimiter) {
        if (_lFeatures.size() == 1) {
            return ExtGlycanFeature.getExtGlycanFeatureData(_lFeatures.get(0), _sKey);
        }
        StringBuilder sbCombined = new StringBuilder();
        boolean iCnt = false;
        for (ExtGlycanFeature egf : _lFeatures) {
            if (!egf.getSelected()) continue;
            if (!sbCombined.toString().equals("")) {
                sbCombined.append(_sDelimiter);
            }
            sbCombined.append(ExtGlycanFeature.getExtGlycanFeatureData(egf, _sKey));
        }
        return sbCombined.toString();
    }

    public static Object getCombinedData(List<ExtGlycanFeature> _lFeatures, CustomExtraData _ced, String _sDelimiter) {
        if (_lFeatures.size() == 1) {
            return ExtGlycanFeature.getExtGlycanFeatureData(_lFeatures.get(0), _ced);
        }
        StringBuilder sbCombined = new StringBuilder();
        boolean iCnt = false;
        for (ExtGlycanFeature egf : _lFeatures) {
            if (!egf.getSelected()) continue;
            if (!sbCombined.toString().equals("")) {
                sbCombined.append(_sDelimiter);
            }
            sbCombined.append(ExtGlycanFeature.getExtGlycanFeatureData(egf, _ced));
        }
        return sbCombined.toString();
    }

    public Integer getAnnotationId() {
        return this.annotationId;
    }

    @XmlAttribute(name="annotationId")
    public void setAnnotationId(Integer annotationId) {
        this.annotationId = annotationId;
    }

    public String getStringAnnotationId() {
        return this.stringAnnotationId;
    }

    @XmlAttribute(name="glycanAnnotationId")
    public void setStringAnnotationId(String glycanAnnotationId) {
        this.stringAnnotationId = glycanAnnotationId;
    }

    public double getIntensity() {
        return this.intensity;
    }

    @XmlAttribute(name="intensity")
    public void setIntensity(double intensity) {
        this.intensity = intensity;
    }

    public int getCharge() {
        return this.charge;
    }

    @XmlAttribute(name="charge")
    public void setCharge(int charge) {
        this.charge = charge;
    }

    public String getSequenceGWB() {
        return this.sequenceGWB;
    }

    @XmlAttribute(name="seqGWB")
    public void setSequenceGWB(String sequence) {
        this.sequenceGWB = sequence;
    }

    public String getSequence() {
        return this.sequence;
    }

    @XmlAttribute(name="seq")
    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getSequenceFormat() {
        return this.sequenceFormat;
    }

    @XmlAttribute(name="seqFormat")
    public void setSequenceFormat(String sequenceFormat) {
        this.sequenceFormat = sequenceFormat;
    }

    public double getFeatureMz() {
        return this.featureMz;
    }

    @XmlAttribute(name="featureMz")
    public void setFeatureMz(double featureMz) {
        this.featureMz = featureMz;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    @XmlAttribute(name="featureId")
    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public int getPeakId() {
        return this.peakId;
    }

    @XmlAttribute(name="annotatedPeakId")
    public void setPeakId(int peakId) {
        this.peakId = peakId;
    }

    public int getExpAnotationId() {
        return this.expAnotationId;
    }

    @XmlAttribute(name="entryId")
    public void setExpAnotationId(int expAnotationId) {
        this.expAnotationId = expAnotationId;
    }

    public boolean getSelected() {
        return this.selected;
    }

    @XmlAttribute(name="selected")
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @XmlJavaTypeAdapter(value=StringIntegerMapAdapter.class)
    public HashMap<String, Integer> getFeatureIntegerProp() {
        return this.m_featureIntegerProp;
    }

    public void setFeatureIntegerProp(HashMap<String, Integer> a_integerProp) {
        this.m_featureIntegerProp = a_integerProp;
    }

    @XmlJavaTypeAdapter(value=StringDoubleMapAdapter.class)
    public HashMap<String, Double> getFeatureDoubleProp() {
        return this.m_featureDoubleProp;
    }

    public void setFeatureDoubleProp(HashMap<String, Double> a_doubleProp) {
        this.m_featureDoubleProp = a_doubleProp;
    }

    @XmlJavaTypeAdapter(value=StringStringMapAdapter.class)
    public HashMap<String, String> getFeatureStringProp() {
        return this.m_featureStringProp;
    }

    public void setFeatureStringProp(HashMap<String, String> a_stringProp) {
        this.m_featureStringProp = a_stringProp;
    }

    @XmlJavaTypeAdapter(value=StringBooleanMapAdapter.class)
    public HashMap<String, Boolean> getFeatureBooleanProp() {
        return this.m_featureBooleanProp;
    }

    public void setFeatureBooleanProp(HashMap<String, Boolean> a_booleanProp) {
        this.m_featureBooleanProp = a_booleanProp;
    }

    @XmlJavaTypeAdapter(value=StringIntegerMapAdapter.class)
    public HashMap<String, Integer> getAnnotationIntegerProp() {
        return this.m_annotationIntegerProp;
    }

    public void setAnnotationIntegerProp(HashMap<String, Integer> a_integerProp) {
        this.m_annotationIntegerProp = a_integerProp;
    }

    @XmlJavaTypeAdapter(value=StringDoubleMapAdapter.class)
    public HashMap<String, Double> getAnnotationDoubleProp() {
        return this.m_annotationDoubleProp;
    }

    public void setAnnotationDoubleProp(HashMap<String, Double> a_doubleProp) {
        this.m_annotationDoubleProp = a_doubleProp;
    }

    @XmlJavaTypeAdapter(value=StringStringMapAdapter.class)
    public HashMap<String, String> getAnnotationStringProp() {
        return this.m_annotationStringProp;
    }

    public void setAnnotationStringProp(HashMap<String, String> a_stringProp) {
        this.m_annotationStringProp = a_stringProp;
    }

    @XmlJavaTypeAdapter(value=StringBooleanMapAdapter.class)
    public HashMap<String, Boolean> getAnnotationBooleanProp() {
        return this.m_annotationBooleanProp;
    }

    public void setAnnotationBooleanProp(HashMap<String, Boolean> a_booleanProp) {
        this.m_annotationBooleanProp = a_booleanProp;
    }

    @XmlTransient
    public ReducingEnd getReducingEnd() {
        return this.m_reducingEnd;
    }

    public void setReducingEnd(ReducingEnd a_reducingEnd) {
        this.m_reducingEnd = a_reducingEnd;
    }
}

