/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.dialog;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.DataModelHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.projectexplorer.part.ProjectExplorerLabelProvider;
import org.grits.toolbox.core.projectexplorer.part.ProjectExplorerViewContentProvider;
import org.grits.toolbox.core.utilShare.sort.EntryComparator;

public class CopyEntryDialog
extends TitleAreaDialog {
    private Entry currentEntry = null;
    private Entry destinationParentEntry = null;
    private TreeViewer treeViewer = null;

    public CopyEntryDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
        this.setTitle("Select the entry where you want to copy");
    }

    public Control createDialogArea(Composite parent) {
        this.getShell().setText("Select Entry");
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new TreeViewer(parent, 2820);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ProjectExplorerLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new ProjectExplorerViewContentProvider());
        this.treeViewer.setComparator((ViewerComparator)new EntryComparator());
        GridData treeData = new GridData();
        treeData.minimumHeight = 300;
        treeData.grabExcessHorizontalSpace = true;
        treeData.grabExcessVerticalSpace = true;
        treeData.horizontalAlignment = 4;
        this.treeViewer.getTree().setLayoutData((Object)treeData);
        this.treeViewer.setInput((Object)DataModelHandler.instance().getRoot());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection treeSelection;
                CopyEntryDialog.this.setErrorMessage(null);
                CopyEntryDialog.this.getButton(0).setEnabled(false);
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && (treeSelection = (TreeSelection)selection).size() == 1) {
                    Entry selectedEntry = (Entry)treeSelection.getFirstElement();
                    if (selectedEntry.getProperty() instanceof ProjectProperty && !((ProjectProperty)selectedEntry.getProperty()).isOpen()) {
                        CopyEntryDialog.this.setErrorMessage("Cannot copy here. The selected project is closed.");
                    } else if (CopyEntryDialog.this.currentEntry.getParent().getProperty().getType().equals(selectedEntry.getProperty().getType())) {
                        boolean uniqueName = true;
                        for (Entry child : selectedEntry.getChildren()) {
                            if (!child.getDisplayName().equals(CopyEntryDialog.this.currentEntry.getDisplayName())) continue;
                            uniqueName = false;
                            break;
                        }
                        if (uniqueName) {
                            CopyEntryDialog.this.getButton(0).setEnabled(true);
                            CopyEntryDialog.this.destinationParentEntry = selectedEntry;
                        } else {
                            CopyEntryDialog.this.setErrorMessage("There is already an entry with this name in the selected parent.");
                        }
                    } else {
                        CopyEntryDialog.this.setErrorMessage("Cannot copy here.");
                    }
                }
            }
        });
        this.treeViewer.getTree().setFocus();
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public void cancelPressed() {
        super.cancelPressed();
    }

    public Entry getCurrentEntry() {
        return this.currentEntry;
    }

    public void setCurrentEntry(Entry currentEntry) {
        this.currentEntry = currentEntry;
    }

    public Entry getDestinationParentEntry() {
        return this.destinationParentEntry;
    }

    public void setDestinationParentEntry(Entry destinationParentEntry) {
        this.destinationParentEntry = destinationParentEntry;
    }
}

