/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.datamodel.property;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.grits.toolbox.core.Activator;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.io.project.ProjectPropertyWriter;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.utilShare.DeleteUtils;

public class ProjectProperty
extends Property {
    public static final String CURRENT_VERSION = "1.0";
    public static final String TYPE = "org.grits.toolbox.property.project";
    public static final String PROJECT_DETAILS_XML = "project_details.xml";
    public static final String DETAILS_TYPE = "details";
    protected static PropertyWriter writer = new ProjectPropertyWriter();
    protected static ImageDescriptor imageDescriptorOpen = Activator.imageDescriptorFromPlugin("org.grits.toolbox.core", "icons/project.png");
    protected static ImageDescriptor imageDescriptorClose = Activator.imageDescriptorFromPlugin("org.grits.toolbox.core", "icons/folder_closed.png");
    protected boolean isOpen = true;

    public PropertyDataFile getDetailsFile() {
        PropertyDataFile detailsFile = null;
        for (PropertyDataFile dataFile : this.dataFiles) {
            if (!DETAILS_TYPE.equals(dataFile.getType())) continue;
            detailsFile = dataFile;
            break;
        }
        return detailsFile;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public PropertyWriter getWriter() {
        return writer;
    }

    public boolean getOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    @Override
    public ImageDescriptor getImage() {
        if (this.getOpen()) {
            return imageDescriptorOpen;
        }
        return imageDescriptorClose;
    }

    @Override
    public void delete(Entry entry) throws IOException {
        String workspaceLocation = PropertyHandler.getVariable("workspace_location");
        DeleteUtils.delete(new File(String.valueOf(workspaceLocation) + entry.getDisplayName() + "/.project.xml"));
        DeleteUtils.delete(new File(String.valueOf(workspaceLocation) + entry.getDisplayName()));
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public Property getParentProperty() {
        return null;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public boolean directCopyEnabled() {
        return false;
    }
}

