/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.property.io;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.UnsupportedTypeException;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.jdom.Element;

public class MSAnnotationReaderVersion0 {
    private static final Logger logger = Logger.getLogger(MSAnnotationReaderVersion0.class);

    public static Property read(Element propertyElement, MSAnnotationProperty msAnnotProperty) throws IOException, UnsupportedVersionException, UnsupportedTypeException {
        Element descriptionElement;
        String t_attributeValue = null;
        Element entryElement = propertyElement.getDocument().getRootElement().getChild("entry");
        String projectName = entryElement == null ? null : entryElement.getAttributeValue("name");
        String workspaceFolder = PropertyHandler.getVariable((String)"workspace_location");
        String msFolder = String.valueOf(workspaceFolder.substring(0, workspaceFolder.length() - 1)) + File.separator + projectName + File.separator + msAnnotProperty.getArchiveFolder();
        Entry msEntry = new Entry();
        MSAnnotationMetaData model = new MSAnnotationMetaData();
        msAnnotProperty.setMSAnnotationMetaData(model);
        msEntry.setProperty((Property)msAnnotProperty);
        Element child = propertyElement.getChild("ms-annotation");
        if (child != null) {
            t_attributeValue = child.getAttributeValue("id");
            model.setAnnotationId(t_attributeValue);
        }
        String description = (descriptionElement = propertyElement.getChild("descripton")) == null ? "" : descriptionElement.getValue();
        model.setDescription(description);
        MSAnnotationProperty.marshallSettingsFile(String.valueOf(msFolder) + File.separator + msAnnotProperty.getMetaDataFileName(), model);
        model.setVersion("1.0");
        model.setName(msAnnotProperty.getMetaDataFileName());
        PropertyDataFile msMetaData = MSAnnotationProperty.getNewSettingsFile(msAnnotProperty.getMetaDataFileName(), model);
        msAnnotProperty.getDataFiles().add(msMetaData);
        String sAnnotationFile = String.valueOf(model.getAnnotationId()) + ".zip";
        File file = new File(String.valueOf(msFolder) + File.separator + sAnnotationFile);
        PropertyDataFile pdf = null;
        if (file.exists()) {
            pdf = new PropertyDataFile(sAnnotationFile, "1.0", "file");
        } else {
            String sAnnotationFolder = model.getAnnotationId();
            file = new File(String.valueOf(msFolder) + File.separator + sAnnotationFolder);
            if (file.exists()) {
                pdf = new PropertyDataFile(sAnnotationFolder, "1.0", "folder");
            }
        }
        if (pdf == null) {
            throw new UnsupportedVersionException("Expecting an archive file or folder. Not found.", "Preversion");
        }
        msAnnotProperty.getDataFiles().add(pdf);
        return msAnnotProperty;
    }
}

