/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.oldUtil.Carbbank;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.oldUtil.WURCSSequence2ToResidueContainer;
import org.glycoinfo.WURCSFramework.util.residuecontainer.LinkageBlock;
import org.glycoinfo.WURCSFramework.util.residuecontainer.ResidueContainer;
import org.glycoinfo.WURCSFramework.util.residuecontainer.ResidueContainerException;
import org.glycoinfo.WURCSFramework.util.residuecontainer.ResidueContainerUtility;
import org.glycoinfo.WURCSFramework.util.residuecontainer.RootStatusDescriptor;

public class WURCSToCarbBank {
    private StringBuilder str_CarbBank;
    private LinkedHashMap<String, String> map_node;
    private ResidueContainerUtility a_uRCU;

    public String getCarbBank() {
        return this.str_CarbBank.toString();
    }

    public void start(String str_WURCS) throws Exception {
        this.init();
        LinkedList<ResidueContainer> lst_RC = new WURCSSequence2ToResidueContainer().start(str_WURCS);
        this.a_uRCU.setResidueList(lst_RC);
        this.extractMonosaccharideName();
        this.addNode(this.a_uRCU.getRoot());
    }

    private void extractMonosaccharideName() throws WURCSFormatException {
        for (ResidueContainer a_objRC : this.a_uRCU.getResidueContainers()) {
            StringBuilder str_tmp = new StringBuilder();
            LinkageBlock a_objLB = a_objRC.getLinkage();
            String str_IUPAC = a_objRC.getIUPACExtendedNotation();
            if (str_IUPAC.contains("beta-")) {
                str_IUPAC = str_IUPAC.replace("beta", "b");
            }
            if (a_objRC.getIUPACExtendedNotation().contains("alpha-")) {
                str_IUPAC = str_IUPAC.replace("alpha", "a");
            }
            str_tmp.append(str_IUPAC);
            if (a_objLB.getAcceptors().size() > 0) {
                str_tmp.append("-(");
                if (a_objRC.getAnomerPosition() != -1) {
                    str_tmp.append(a_objRC.getAnomerPosition());
                } else {
                    str_tmp.append("?");
                }
                str_tmp.append("-");
                if (a_objLB.getAcceptors().size() == 1) {
                    if (a_objLB.getAcceptors().getLast() == -1) {
                        str_tmp.append("?");
                    } else {
                        str_tmp.append(a_objLB.getAcceptors().getLast());
                    }
                }
                if (a_objLB.getAcceptors().size() > 1) {
                    Iterator i = a_objLB.getAcceptors().iterator();
                    while (i.hasNext()) {
                        str_tmp.append(i.next());
                        if (!i.hasNext()) continue;
                        str_tmp.append("/");
                    }
                }
                str_tmp.append(")");
            }
            this.map_node.put(a_objRC.getNodeIndex(), str_tmp.toString());
        }
    }

    private void addNode(ResidueContainer a_objRC) throws ResidueContainerException {
        if (a_objRC == null) {
            return;
        }
        String cID = a_objRC.getNodeIndex();
        LinkageBlock a_objLB = a_objRC.getLinkage();
        if (!this.map_node.containsKey(a_objRC.getNodeIndex())) {
            return;
        }
        if (this.str_CarbBank.indexOf(")") == 0 || cID.equals("a")) {
            this.str_CarbBank.insert(0, this.map_node.get(cID));
        } else {
            this.str_CarbBank.insert(0, String.valueOf(this.map_node.get(cID)) + "-");
        }
        this.map_node.remove(cID);
        if (a_objLB.getChild().size() == 0 && this.isYoungestChild(a_objRC)) {
            this.str_CarbBank.insert(0, "(");
        }
        if (a_objLB.getChild().size() == 1) {
            this.addNode(this.a_uRCU.getIndex(a_objLB.getChild().getLast()));
        }
        if (a_objLB.getChild().size() > 1) {
            int i = a_objLB.getChild().size() - 1;
            while (i >= 0) {
                String childID = a_objLB.getChild().get(i);
                if (i != 0) {
                    this.str_CarbBank.insert(0, ")-");
                }
                this.addNode(this.a_uRCU.getIndex(childID));
                --i;
            }
        }
    }

    private boolean isYoungestChild(ResidueContainer a_objRC) throws ResidueContainerException {
        if (!a_objRC.getRootStatusDescriptor().equals((Object)RootStatusDescriptor.NON)) {
            return false;
        }
        String str_parent = a_objRC.getLinkage().getParent().getLast();
        String str_child = a_objRC.getNodeIndex();
        ResidueContainer Node2 = this.a_uRCU.getIndex(str_parent);
        while (Node2.getRootStatusDescriptor().equals((Object)RootStatusDescriptor.NON) && Node2.getLinkage().getChild().size() == 1) {
            str_parent = Node2.getLinkage().getParent().getLast();
            str_child = Node2.getNodeIndex();
            Node2 = this.a_uRCU.getIndex(str_parent);
        }
        LinkedList<String> lst_child = Node2.getLinkage().getChild();
        if (lst_child.size() <= 1) {
            return false;
        }
        if (lst_child.indexOf(str_child) != 0) {
            return true;
        }
        if (Node2.getRootStatusDescriptor().equals((Object)RootStatusDescriptor.NON) && lst_child.indexOf(str_child) == 0 && this.a_uRCU.getIndex(str_parent).getLinkage().getChild().size() > 1) {
            return this.isYoungestChild(Node2);
        }
        return false;
    }

    private void init() {
        this.a_uRCU = new ResidueContainerUtility();
        this.str_CarbBank = new StringBuilder();
        this.map_node = new LinkedHashMap();
    }
}

