/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneCarbon;
import org.glycoinfo.WURCSFramework.wurcs.graph.InterfaceRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class Backbone_TBD
extends Backbone {
    private int m_iAnomericPosition = 0;
    private char m_iAnomericSymbol = (char)120;

    public void setAnomericPosition(int a_iAnomPos) {
        this.m_iAnomericPosition = a_iAnomPos;
    }

    public void setAnomericSymbol(char a_cAnomSymbol) {
        this.m_iAnomericSymbol = a_cAnomSymbol;
    }

    @Override
    public int getAnomericPosition() {
        return this.m_iAnomericPosition;
    }

    @Override
    public char getAnomericSymbol() {
        return this.m_iAnomericSymbol;
    }

    @Override
    public WURCSEdge getAnomericEdge() {
        if (this.m_iAnomericPosition == 0) {
            return null;
        }
        for (WURCSEdge edge : this.getEdges()) {
            if (edge.getLinkages().size() > 1 || edge.getLinkages().get(0).getBackbonePosition() != this.m_iAnomericPosition || edge.getModification() == null || !edge.getModification().isGlycosidic() || edge.getModification() instanceof InterfaceRepeat) continue;
            return edge;
        }
        return null;
    }

    @Override
    public boolean hasParent() {
        WURCSEdge t_objAnomEdge = this.getAnomericEdge();
        if (t_objAnomEdge == null) {
            return false;
        }
        if (t_objAnomEdge.getModification().isGlycosidic()) {
            return true;
        }
        return !t_objAnomEdge.getModification().isAglycone();
    }

    @Override
    public int getBackboneScore() {
        int score = 0;
        score += 20 * this.m_iAnomericPosition;
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            score += (i + 1) * this.getBackboneCarbons().get(i).getDesctriptor().getCarbonScore();
        }
        return score;
    }

    @Override
    public Backbone_TBD copy() {
        Backbone_TBD copy = new Backbone_TBD();
        for (BackboneCarbon bc : this.getBackboneCarbons()) {
            copy.addBackboneCarbon(bc.copy(copy));
        }
        copy.setAnomericPosition(this.m_iAnomericPosition);
        copy.setAnomericSymbol(this.m_iAnomericSymbol);
        copy.removeAllEdges();
        return copy;
    }

    @Override
    public void invert() {
        super.invert();
        if (this.m_iAnomericPosition != 0 && this.m_iAnomericPosition != -1) {
            this.m_iAnomericPosition = this.getLength() + 1 - this.m_iAnomericPosition;
        }
    }
}

