/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.map.analysis;

import java.util.HashMap;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtomAbstract;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtomCyclic;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPConnection;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPGraph;

public class MorganAlgorithmForMAP {
    private MAPGraph m_oGraph;
    private HashMap<MAPAtomAbstract, Integer> m_mapAtomToMorganNumber = new HashMap();

    public MorganAlgorithmForMAP(MAPGraph a_oGraph) {
        this.m_oGraph = a_oGraph;
    }

    public HashMap<MAPAtomAbstract, Integer> getAtomToMorganNumber() {
        HashMap<MAPAtomAbstract, Integer> t_mapAtomToMorganNumberCopy = new HashMap<MAPAtomAbstract, Integer>();
        for (MAPAtomAbstract t_oAtom : this.m_mapAtomToMorganNumber.keySet()) {
            t_mapAtomToMorganNumberCopy.put(t_oAtom, this.m_mapAtomToMorganNumber.get(t_oAtom));
        }
        return t_mapAtomToMorganNumberCopy;
    }

    public int getMorganNumber(MAPAtomAbstract a_oAtom) {
        if (this.m_mapAtomToMorganNumber.get(a_oAtom) == null) {
            return 0;
        }
        return this.m_mapAtomToMorganNumber.get(a_oAtom);
    }

    public void calcMorganNumber(LinkedList<MAPAtomAbstract> a_oIgnoreAtoms, LinkedList<MAPConnection> a_oIgnoreConns) {
        HashMap<MAPAtomAbstract, Integer> t_mapAtomToMorganNum = new HashMap<MAPAtomAbstract, Integer>();
        LinkedList<MAPAtomAbstract> t_aTargetAtoms = this.m_oGraph.getAtoms();
        LinkedList<MAPAtomCyclic> t_aCyclics = new LinkedList<MAPAtomCyclic>();
        for (MAPAtomAbstract t_oAtom : t_aTargetAtoms) {
            if (t_oAtom instanceof MAPAtomCyclic) {
                t_aCyclics.add((MAPAtomCyclic)t_oAtom);
                continue;
            }
            t_mapAtomToMorganNum.put(t_oAtom, this.getAtomWeight(t_oAtom));
        }
        int t_iUniqCountPrev = 1;
        while (true) {
            for (MAPAtomAbstract t_oAtom : t_aTargetAtoms) {
                this.m_mapAtomToMorganNumber.put(t_oAtom, (Integer)t_mapAtomToMorganNum.get(t_oAtom));
            }
            for (MAPAtomAbstract t_oAtom : t_aTargetAtoms) {
                t_mapAtomToMorganNum.put(t_oAtom, 0);
            }
            for (MAPAtomAbstract t_oAtom : this.m_oGraph.getAtoms()) {
                LinkedList<MAPConnection> t_aConnections = new LinkedList<MAPConnection>();
                if (t_oAtom.getParentConnection() != null) {
                    t_aConnections.add(t_oAtom.getParentConnection());
                }
                t_aConnections.addAll(t_oAtom.getChildConnections());
                if (t_oAtom instanceof MAPAtomCyclic) {
                    t_oAtom = ((MAPAtomCyclic)t_oAtom).getCyclicAtom();
                }
                if (a_oIgnoreAtoms != null && a_oIgnoreAtoms.contains(t_oAtom)) continue;
                int t_iNum = t_mapAtomToMorganNum.get(t_oAtom);
                for (MAPConnection t_oConn : t_aConnections) {
                    Integer t_iConnNum;
                    MAPAtomAbstract t_oConnAtom = t_oConn.getAtom();
                    if (t_oConnAtom instanceof MAPAtomCyclic) {
                        t_oConnAtom = ((MAPAtomCyclic)t_oConnAtom).getCyclicAtom();
                    }
                    if (a_oIgnoreConns != null && a_oIgnoreConns.contains(t_oConn) || a_oIgnoreAtoms != null && a_oIgnoreAtoms.contains(t_oConnAtom) || (t_iConnNum = this.m_mapAtomToMorganNumber.get(t_oConnAtom)) == null) continue;
                    t_iNum += t_iConnNum.intValue();
                }
                t_mapAtomToMorganNum.put(t_oAtom, t_iNum);
            }
            int t_iUniqCount = this.countUniqueNumber(t_mapAtomToMorganNum);
            if (t_iUniqCount <= t_iUniqCountPrev) break;
            t_iUniqCountPrev = t_iUniqCount;
        }
    }

    protected int getAtomWeight(MAPAtomAbstract a_oAtom) {
        return 1;
    }

    private int countUniqueNumber(HashMap<MAPAtomAbstract, Integer> a_mapAtomToMorganNum) {
        LinkedList<Integer> t_aUniqNums = new LinkedList<Integer>();
        for (Integer t_iNum : a_mapAtomToMorganNum.values()) {
            if (t_iNum == null || t_aUniqNums.contains(t_iNum)) continue;
            t_aUniqNums.add(t_iNum);
        }
        return t_aUniqNums.size();
    }
}

