/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference.viewer;

import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.entry.ms.preference.GlycresoftPreference;
import org.grits.toolbox.entry.ms.preference.viewer.MSConvertPreferencePage;

public class GlycresoftPreferencePage
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(MSConvertPreferencePage.class);
    GlycresoftPreference preferences;
    private Text programLocation;

    public GlycresoftPreferencePage() {
        try {
            this.preferences = GlycresoftPreference.loadPreferences();
        }
        catch (UnsupportedVersionException e) {
            logger.error((Object)"Error loading Glycresoft preferences: ", (Throwable)e);
            this.preferences = new GlycresoftPreference();
        }
    }

    protected Control createContents(Composite parent) {
        final Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        container.setLayout((Layout)gridLayout);
        Label locationLabel = new Label(container, 0);
        locationLabel.setText("Program Location");
        this.programLocation = new Text(container, 2048);
        this.programLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.programLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GlycresoftPreferencePage.this.setValid(GlycresoftPreferencePage.this.isReadyToFinish());
            }
        });
        if (this.preferences != null && this.preferences.getLocation() != null) {
            this.programLocation.setText(this.preferences.getLocation());
        }
        Button browseButton = new Button(container, 8);
        browseButton.setText("Browse");
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(container.getShell());
                String selectedDir = dialog.open();
                if (selectedDir != null) {
                    String cmdName = System.getProperty("os.name").startsWith("Windows") ? "glycresoft-cli.exe" : "glycresoft-cli";
                    File glycresoft = new File(String.valueOf(selectedDir) + File.separator + cmdName);
                    if (!glycresoft.exists()) {
                        MessageDialog.openWarning((Shell)GlycresoftPreferencePage.this.getShell(), (String)"Not Found", (String)("Could not locate " + cmdName + " in the selected folder. Please make sure to select the correct folder"));
                        return;
                    }
                    GlycresoftPreferencePage.this.programLocation.setText(selectedDir);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        int i = 0;
        while (i < 9) {
            new Label(container, 0);
            ++i;
        }
        Link helpLink = new Link(container, 0);
        helpLink.setLayoutData((Object)new GridData(16384, 128, true, true, 3, 3));
        helpLink.setText("Please check <A>http://www.bumc.bu.edu/msr/glycresoft/</A> for more information.");
        helpLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"http://www.bumc.bu.edu/msr/glycresoft");
            }
        });
        return container;
    }

    protected void performApply() {
        this.save();
    }

    public boolean isReadyToFinish() {
        if (this.programLocation != null && this.programLocation.getText() != null && !this.programLocation.getText().isEmpty()) {
            this.setMessage(null);
            return true;
        }
        this.setMessage("Please enter the location for the MSConvert tool");
        return false;
    }

    public boolean performOk() {
        boolean valid = this.isReadyToFinish();
        this.setValid(valid);
        if (valid) {
            this.save();
        }
        return valid;
    }

    private void save() {
        this.preferences.setLocation(this.programLocation.getText());
        this.preferences.saveValues();
    }
}

