/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.heatmap.gui;

import java.util.Arrays;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScale;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.widgets.heatmap.AxisDataSet;
import org.grits.toolbox.widgets.heatmap.gui.GritsHeatMapFigure;
import org.grits.toolbox.widgets.heatmap.gui.GritsTickLabels;

public class GritsAxis
extends Axis {
    private static final int SPACE_BTW_MARK_LABEL = 2;
    GritsTickLabels tickLabels;
    private int margin;
    private int length;

    public GritsAxis(String title, boolean yAxis) {
        super(title, yAxis);
        this.removeAll();
        this.tickLabels = new GritsTickLabels(this);
        this.add((IFigure)this.tickLabels);
        Font sysFont = Display.getCurrent().getSystemFont();
        this.setFont(XYGraphMediaFactory.getInstance().getFont(new FontData(sysFont.getFontData()[0].getName(), 11, 0)));
    }

    protected void layout() {
        this.updateTick();
        Rectangle area = this.getClientArea();
        Dimension newSize = this.adjustForRotatedTickLabels(area.getSize());
        if (newSize.height > area.height) {
            area.setSize(this.adjustForRotatedTickLabels(area.getSize()));
            ((GritsHeatMapFigure)this.getParent()).layout();
        }
        if (this.isHorizontal() && this.getTickLabelSide() == AbstractScale.LabelSide.Primary) {
            this.tickLabels.setBounds(new Rectangle(area.x, area.y + 2, area.width, area.height));
        } else if (this.isHorizontal() && this.getTickLabelSide() == AbstractScale.LabelSide.Secondary) {
            this.tickLabels.setBounds(new Rectangle(area.x, area.y + area.height - this.tickLabels.getTickLabelMaxHeight() - 2, area.width, this.tickLabels.getTickLabelMaxHeight()));
        } else if (this.getTickLabelSide() == AbstractScale.LabelSide.Primary) {
            this.tickLabels.setBounds(new Rectangle(area.x + area.width - this.tickLabels.getTickLabelMaxLength() - 2, area.y, this.tickLabels.getTickLabelMaxLength(), area.height));
        } else {
            this.tickLabels.setBounds(new Rectangle(area.x + 2, area.y, this.tickLabels.getTickLabelMaxLength(), area.height));
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension size = new Dimension(wHint, hHint);
        GritsTickLabels fakeTickLabels = new GritsTickLabels(this);
        AxisDataSet dataSet = new AxisDataSet();
        dataSet.setValues(Arrays.asList("Label112"));
        fakeTickLabels.setLabelData(dataSet);
        if (this.isHorizontal()) {
            fakeTickLabels.update(wHint - 2 * this.getMargin());
            size.height = fakeTickLabels.getTickLabelMaxHeight() + 2;
        } else {
            fakeTickLabels.update(hHint - 2 * this.getMargin());
            size.width = fakeTickLabels.getTickLabelMaxLength() + 2;
        }
        if (this.isVisible()) {
            if (this.isHorizontal()) {
                size.height += FigureUtilities.getTextExtents((String)this.getTitle(), (Font)this.getTitleFont()).height;
            } else {
                size.width += FigureUtilities.getTextExtents((String)this.getTitle(), (Font)this.getTitleFont()).height;
            }
        } else if (this.isHorizontal()) {
            size.height = 0;
        } else {
            size.width = 0;
        }
        return size;
    }

    public GritsTickLabels getTickLabels() {
        return this.tickLabels;
    }

    public void setFont(Font font) {
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.tickLabels.setFont(font);
        super.setFont(font);
    }

    public void setForegroundColor(Color color) {
        this.tickLabels.setForegroundColor(color);
        super.setForegroundColor(color);
    }

    public void updateTick() {
        if (this.isDirty()) {
            this.calcMargin();
            this.setDirty(false);
            int n = this.length = this.isHorizontal() ? this.getClientArea().width : this.getClientArea().height;
            if (this.length > 2 * this.margin) {
                this.tickLabels.update(this.length - 2 * this.margin);
            }
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getMargin() {
        this.updateTick();
        return this.margin;
    }

    public int getTickLength() {
        return this.length - 2 * this.getMargin();
    }

    public int getValuePosition(double value, boolean relative) {
        if (this.dirty) {
            this.updateTick();
        }
        int pixelsToStart = 0;
        if (this.isLogScaleEnabled()) {
            if (value <= 0.0) {
                value = this.min;
            }
            pixelsToStart = (int)((Math.log10(value) - Math.log10(this.min)) / (Math.log10(this.max) - Math.log10(this.min)) * (double)(this.length - 2 * this.margin)) + this.margin;
        } else {
            pixelsToStart = (int)((value - this.min) / (this.max - this.min) * (double)(this.length - 2 * this.margin)) + this.margin;
        }
        if (relative) {
            if (this.getOrientation() == LinearScale.Orientation.HORIZONTAL) {
                return pixelsToStart;
            }
            return this.length - pixelsToStart;
        }
        if (this.getOrientation() == LinearScale.Orientation.HORIZONTAL) {
            return pixelsToStart + this.bounds.x;
        }
        return this.length - pixelsToStart + this.bounds.y;
    }

    public double getPositionValue(int position, boolean relative) {
        this.updateTick();
        double min = this.getRange().getLower();
        double max = this.getRange().getUpper();
        int pixelsToStart = relative ? (this.isHorizontal() ? position : this.length - position) : (this.isHorizontal() ? position - this.bounds.x : this.length + this.bounds.y - position);
        double value = this.isLogScaleEnabled() ? Math.pow(10.0, (double)(pixelsToStart - this.margin) * (Math.log10(max) - Math.log10(min)) / (double)(this.length - 2 * this.margin) + Math.log10(min)) : (double)(pixelsToStart - this.margin) * (max - min) / (double)(this.length - 2 * this.margin) + min;
        return value;
    }

    private void calcMargin() {
        if (this.isHorizontal()) {
            AxisDataSet labels = this.tickLabels.getLabelData();
            double max = 0.0;
            double i = this.getRange().getLower();
            while (i < this.getRange().getUpper()) {
                double width;
                String label = labels.getLabel(i);
                if (label != null && (width = (double)FigureUtilities.getTextExtents((String)label, (Font)this.getFont()).width) > max) {
                    max = width;
                }
                i += 1.0;
            }
            this.margin = (int)Math.ceil(max / 2.0);
        } else {
            this.margin = (int)Math.ceil((double)Math.max(FigureUtilities.getTextExtents((String)this.tickLabels.getLabelData().getLabel((double)this.getRange().getLower()), (Font)this.getFont()).height, FigureUtilities.getTextExtents((String)this.tickLabels.getLabelData().getLabel((double)this.getRange().getUpper()), (Font)this.getFont()).height) / 2.0);
        }
    }

    public void setLabelData(AxisDataSet labelData) {
        this.tickLabels.setLabelData(labelData);
    }

    public Dimension adjustForRotatedTickLabels(Dimension xAxisSize) {
        if (!this.isHorizontal()) {
            return xAxisSize;
        }
        double angle = this.tickLabels.getTickLabelAngle();
        if (angle == 0.0) {
            return xAxisSize;
        }
        int tickLabelMaxLength = this.getTickLabels().getTickLabelMaxLength();
        int height = this.getMargin() + (int)((double)tickLabelMaxLength * Math.sin(Math.toRadians(angle)) + (double)FigureUtilities.getTextExtents((String)this.tickLabels.getLabelData().getLabel((double)this.getRange().getLower()), (Font)this.getFont()).height * Math.cos(Math.toRadians(angle)));
        int delta = height - xAxisSize.height;
        xAxisSize.height += delta;
        return xAxisSize;
    }
}

