/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference;

import org.apache.log4j.Logger;
import org.grits.toolbox.core.preference.project.UtilityPreferenceValue;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.jdom.Element;

public class MassSpecPreferencePreVersion {
    private static final Logger logger = Logger.getLogger(MassSpecPreferencePreVersion.class);
    private static final String PREVIOUS_ADDUCT_FILE = "org.grits.toolbox.entry.ms.preference.type.Types.adductType";
    private static final String PREVIOUS_COLLISION_FILE = "org.grits.toolbox.entry.ms.preference.type.Types.collisionType";
    private static final String PREVIOUS_DERIVITIZATION_FILE = "org.grits.toolbox.entry.ms.preference.type.Types.derivType";
    private static final String PREVIOUS_GLYCAN_FILE = "org.grits.toolbox.entry.ms.preference.type.Types.glycanType";
    private static final String PREVIOUS_RELEASE_FILE = "org.grits.toolbox.entry.ms.preference.type.Types.releaseType";

    public static boolean removeElements() {
        try {
            PreferenceWriter.deletePreference((String)PREVIOUS_ADDUCT_FILE);
            PreferenceWriter.deletePreference((String)PREVIOUS_COLLISION_FILE);
            PreferenceWriter.deletePreference((String)PREVIOUS_DERIVITIZATION_FILE);
            PreferenceWriter.deletePreference((String)PREVIOUS_GLYCAN_FILE);
            PreferenceWriter.deletePreference((String)PREVIOUS_RELEASE_FILE);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public static MassSpecPreference getMassSpecPreference(PreferenceEntity preferenceEntity) {
        MassSpecPreference previousPreferences = null;
        try {
            String selected;
            previousPreferences = new MassSpecPreference();
            previousPreferences.loadDefaultOptions();
            Element preferenceElement = PreferenceReader.getPreferenceElement((String)PREVIOUS_ADDUCT_FILE);
            if (preferenceElement != null && preferenceElement.getAttributeValue("values") != null && preferenceElement.getAttributeValue("values").length() != 0) {
                previousPreferences.setAllAdductTypes(UtilityPreferenceValue.getPreversioningValues((Element)preferenceElement));
                selected = UtilityPreferenceValue.getPreversioningSelected((Element)preferenceElement);
                previousPreferences.setAdductType(selected);
            }
            if ((preferenceElement = PreferenceReader.getPreferenceElement((String)PREVIOUS_COLLISION_FILE)) != null && preferenceElement.getAttributeValue("values") != null && preferenceElement.getAttributeValue("values").length() != 0) {
                previousPreferences.setAllCollisionTypes(UtilityPreferenceValue.getPreversioningValues((Element)preferenceElement));
                selected = UtilityPreferenceValue.getPreversioningSelected((Element)preferenceElement);
                previousPreferences.setCollisionType(selected);
            }
            if ((preferenceElement = PreferenceReader.getPreferenceElement((String)PREVIOUS_DERIVITIZATION_FILE)) != null && preferenceElement.getAttributeValue("values") != null && preferenceElement.getAttributeValue("values").length() != 0) {
                previousPreferences.setAllDerivatizationTypes(UtilityPreferenceValue.getPreversioningValues((Element)preferenceElement));
                selected = UtilityPreferenceValue.getPreversioningSelected((Element)preferenceElement);
                previousPreferences.setDerivatizationType(selected);
            }
            if ((preferenceElement = PreferenceReader.getPreferenceElement((String)PREVIOUS_GLYCAN_FILE)) != null && preferenceElement.getAttributeValue("values") != null && preferenceElement.getAttributeValue("values").length() != 0) {
                previousPreferences.setAllGlycanTypes(UtilityPreferenceValue.getPreversioningValues((Element)preferenceElement));
                selected = UtilityPreferenceValue.getPreversioningSelected((Element)preferenceElement);
                previousPreferences.setGlycanType(selected);
            }
            if ((preferenceElement = PreferenceReader.getPreferenceElement((String)PREVIOUS_RELEASE_FILE)) != null && preferenceElement.getAttributeValue("values") != null && preferenceElement.getAttributeValue("values").length() != 0) {
                previousPreferences.setAllReleaseTypes(UtilityPreferenceValue.getPreversioningValues((Element)preferenceElement));
                selected = UtilityPreferenceValue.getPreversioningSelected((Element)preferenceElement);
                previousPreferences.setReleaseType(selected);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            previousPreferences = null;
        }
        return previousPreferences;
    }
}

