/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridEditor;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.ms.dialog.MassSpecCustomAnnotationDialog;
import org.grits.toolbox.entry.ms.preference.IMSPreferenceWithCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.MassSpecCustomAnnotationFile;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.grits.toolbox.entry.ms.preference.MassSpecPreferenceLoader;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationPeak;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MassSpecCustomAnnotationsPreferenceUI
extends Composite {
    protected static final Logger logger = Logger.getLogger(MassSpecCustomAnnotationsPreferenceUI.class);
    public static final String PAGE_COMPLETE_PROPERTY = "Page Complete";
    protected boolean isComplete = true;
    protected String errorMessage = null;
    protected IPropertyChangeListener listener = null;
    protected GridLayout gridLayout = null;
    protected Label lblSelectAnnotation = null;
    protected Combo cmbSelectAnnotation = null;
    protected String sCurrentAnnotation = null;
    protected Button btnExportXML = null;
    protected Button btnImportXML = null;
    protected Button btnCreateNew = null;
    protected Button btnEditCurrent = null;
    protected Button btnDeleteCurrent = null;
    protected Button btnResetCurrent = null;
    protected Label lblSeparator = null;
    protected Label lblAnnotatioName = null;
    protected Text txtAnnotationName = null;
    protected String sAnnotationName = null;
    protected Label lblDescription = null;
    protected Text txtDescription = null;
    protected String sDescription = null;
    protected Label lblMassTolerance = null;
    protected String sMSLevel = null;
    protected Text txtMassTolerance = null;
    protected Double dMassTolerance = null;
    protected Label lblToleranceType = null;
    protected Button btnTolerancePPM = null;
    protected Button btnToleranceDalton = null;
    protected Boolean bIsPPM = false;
    protected Grid gridSpecialPeaksGrid = null;
    protected Point gridSpecialPeaksGridSize = null;
    protected List<GridItem> gridItemsSpecialPeaks = null;
    protected MassSpecCustomAnnotation currentCustomAnnotation = null;
    protected Button btnRemoveSelected = null;
    protected Button btnRemoveAllRows = null;
    protected Label lblAddAnnotationsFromFile = null;
    protected Text txtAddAnnotationsFromFile = null;
    protected Button btnAddAnnotationsFromFile = null;
    protected String sAnnotationFilePath = null;
    protected Button btnSaveAsDefault = null;
    protected boolean bAddSaveAsDefault = false;
    protected boolean bIsDirty = false;
    protected boolean bIsEditingTable = false;
    protected GridEditor editor = null;
    protected IMSPreferenceWithCustomAnnotation localAnnotations = null;
    protected IMSPreferenceWithCustomAnnotation storedAnnotations = null;
    protected IMSPreferenceWithCustomAnnotation entryAnnotations = null;
    protected Entry massSpecEntry = null;
    protected MassSpecMultiPageViewer contextViewer = null;

    public MassSpecCustomAnnotationsPreferenceUI(Composite parent, int style, IPropertyChangeListener listener, boolean bAddSaveAsDefault) {
        super(parent, style);
        this.listener = listener;
        this.bAddSaveAsDefault = bAddSaveAsDefault;
        this.initStoredAnnotations();
    }

    public static IMSPreferenceWithCustomAnnotation loadWorkspacePreferences() {
        try {
            return MassSpecPreferenceLoader.getMassSpecPreferences();
        }
        catch (Exception ex) {
            logger.error((Object)"Error getting the mass spec preferences", (Throwable)ex);
            return null;
        }
    }

    public void initLocalAnnotations() {
        this.localAnnotations = new MassSpecPreference();
        MassSpecCustomAnnotationsPreferenceUI.initAnnotationFromEntry(this.massSpecEntry, this.localAnnotations);
        this.entryAnnotations = new MassSpecPreference();
        MassSpecCustomAnnotationsPreferenceUI.initAnnotationFromEntry(this.massSpecEntry, this.entryAnnotations);
    }

    public static void initAnnotationFromEntry(Entry entry, IMSPreferenceWithCustomAnnotation annotations) {
        Property p;
        ((MassSpecPreference)annotations).setCustomAnnotations(new ArrayList<MassSpecCustomAnnotation>());
        ArrayList<String> localAnnotsAdded = new ArrayList<String>();
        if (entry != null && (p = entry.getProperty()) != null) {
            List<MassSpecCustomAnnotation> l = ((MassSpecEntityProperty)p).getMassSpecParentProperty().getMassSpecMetaData().getCustomAnnotations();
            if (l != null && !l.isEmpty()) {
                for (MassSpecCustomAnnotation curAnnot : l) {
                    annotations.getCustomAnnotations().add((MassSpecCustomAnnotation)curAnnot.clone());
                    localAnnotsAdded.add(curAnnot.getAnnotationName());
                }
            }
            ((MassSpecPreference)annotations).setCustomAnnotationText(MassSpecPreference.createCustomAnnotationsText(annotations.getCustomAnnotations()));
        }
    }

    public void initStoredAnnotations() {
        this.storedAnnotations = MassSpecCustomAnnotationsPreferenceUI.loadWorkspacePreferences();
    }

    public IMSPreferenceWithCustomAnnotation getStoredAnnotations() {
        return this.storedAnnotations;
    }

    public void setEntry(Entry massSpecEntry) {
        this.massSpecEntry = massSpecEntry;
    }

    public Entry getEntry() {
        return this.massSpecEntry;
    }

    public void setLocalAnnotations(IMSPreferenceWithCustomAnnotation localAnnotations) {
        this.localAnnotations = localAnnotations;
    }

    public IMSPreferenceWithCustomAnnotation getLocalAnnotations() {
        return this.localAnnotations;
    }

    public void setEntryAnnotations(IMSPreferenceWithCustomAnnotation entryAnnotations) {
        this.entryAnnotations = entryAnnotations;
    }

    public IMSPreferenceWithCustomAnnotation getEntryAnnotations() {
        return this.entryAnnotations;
    }

    public MassSpecMultiPageViewer getContextViewer() {
        return this.contextViewer;
    }

    public void setContextViewer(MassSpecMultiPageViewer contextViewer) {
        this.contextViewer = contextViewer;
    }

    public void initComponents() {
        this.initGridLayout();
        this.setLayout((Layout)this.gridLayout);
        this.addSelectAnnotationItem(this);
        this.addDeleteCurrent(this);
        this.addResetCurrent(this);
        this.addImportXML(this);
        this.addExportXML(this);
        this.addEditCurrent(this);
        this.addCreateNewItem(this);
        this.addSeparatorLine1(this);
        this.addAnnotationNameItem(this);
        this.addDescriptionItem(this);
        this.addMassToleranceItem(this);
        this.addToleranceTypeItem(this);
        this.addPeakListItem(this);
        this.addRemoveRowComponents(this);
        this.addRemoveAllRowsComponents(this);
        this.addAnnotationsFileItem(this);
        this.addSaveSettingsItem(this, this.bAddSaveAsDefault);
        this.setEditEnabled(false);
        this.setResetEnabled();
    }

    protected Entry getEntryForCurrentViewer() {
        MassSpecMultiPageViewer viewer = this.getCurrentViewer();
        if (viewer == null) {
            return null;
        }
        return viewer.getEntry();
    }

    public MassSpecMultiPageViewer getCurrentViewer() {
        if (this.getContextViewer() == null) {
            return null;
        }
        try {
            MassSpecMultiPageViewer viewer;
            EPartService partService = this.getContextViewer().getPartService();
            MPart mPart = partService.getActivePart();
            if (mPart != null && mPart.getParent() != null && mPart.equals(mPart.getParent().getSelectedElement()) && mPart.getObject() instanceof MassSpecMultiPageViewer && (viewer = (MassSpecMultiPageViewer)((Object)mPart.getObject())).getEntry().getProperty() != null && viewer.getEntry().getProperty() instanceof MassSpecEntityProperty) {
                return viewer;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected void mergePreferences() {
        if (this.getStoredAnnotations() != null && this.getStoredAnnotations().getCustomAnnotations() != null) {
            int i = 0;
            while (i < this.getStoredAnnotations().getCustomAnnotations().size()) {
                MassSpecCustomAnnotation storedAnnot = this.getStoredAnnotations().getCustomAnnotations().get(i);
                boolean bFound = false;
                int j = 0;
                while (j < this.getLocalAnnotations().getCustomAnnotations().size()) {
                    MassSpecCustomAnnotation localAnnot = this.getLocalAnnotations().getCustomAnnotations().get(j);
                    if (storedAnnot.getAnnotationName().equals(localAnnot.getAnnotationName())) {
                        bFound = true;
                        break;
                    }
                    ++j;
                }
                if (!bFound) {
                    this.getLocalAnnotations().getCustomAnnotations().add(storedAnnot);
                }
                ++i;
            }
        }
    }

    public boolean getSaveAsDefault() {
        return this.bAddSaveAsDefault && this.btnSaveAsDefault.getSelection();
    }

    public void save() {
        this.mergePreferences();
        this.getLocalAnnotations().saveValues();
        this.initStoredAnnotations();
        this.initLocalAnnotations();
    }

    protected void initGridLayout() {
        this.gridLayout = new GridLayout(6, false);
    }

    public void setSelectedItem(String _sAnnotName) {
        int i = 0;
        while (i < this.cmbSelectAnnotation.getItemCount()) {
            String sText = this.cmbSelectAnnotation.getItem(i);
            if (sText.trim().equals(_sAnnotName.trim())) {
                this.cmbSelectAnnotation.select(i);
                if (this.cmbSelectAnnotation.getText().trim().equals("")) break;
                String selAnnotName = this.cmbSelectAnnotation.getText().trim();
                MassSpecCustomAnnotation selAnnot = null;
                MassSpecCustomAnnotation prefAnnot = MassSpecCustomAnnotationDialog.getCurrentAnnot(selAnnotName, this.storedAnnotations);
                MassSpecCustomAnnotation localAnnot = MassSpecCustomAnnotationDialog.getCurrentAnnot(selAnnotName, this.localAnnotations);
                if (localAnnot != null) {
                    selAnnot = localAnnot;
                } else if (prefAnnot != null) {
                    selAnnot = prefAnnot;
                } else {
                    return;
                }
                this.processSelection(selAnnot);
                break;
            }
            ++i;
        }
    }

    public void processSelection(MassSpecCustomAnnotation desiredPreferences) {
        if (this.cancelIfDirty()) {
            return;
        }
        this.setEditEnabled(false);
        this.currentCustomAnnotation = null;
        if (desiredPreferences != null) {
            this.btnEditCurrent.setEnabled(true);
            this.btnExportXML.setEnabled(true);
            this.btnDeleteCurrent.setEnabled(true);
            this.setCurrentAnnotationValues(desiredPreferences);
            this.setResetEnabled();
        } else {
            this.setPageComplete(true);
        }
    }

    protected void addSelectAnnotationItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 2, 1);
        this.lblSelectAnnotation = new Label(parent, 0);
        this.lblSelectAnnotation.setText("Current Custom Annotations");
        this.lblSelectAnnotation.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 4, 1);
        this.cmbSelectAnnotation = new Combo(parent, 8);
        this.cmbSelectAnnotation.setLayoutData((Object)gd2);
        this.sCurrentAnnotation = null;
        this.initStoredAnnotationsList();
        this.cmbSelectAnnotation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!MassSpecCustomAnnotationsPreferenceUI.this.cmbSelectAnnotation.getText().trim().equals("")) {
                    String selAnnotName = MassSpecCustomAnnotationsPreferenceUI.this.cmbSelectAnnotation.getText().trim();
                    MassSpecCustomAnnotation selAnnot = null;
                    MassSpecCustomAnnotation prefAnnot = MassSpecCustomAnnotationDialog.getCurrentAnnot(selAnnotName, MassSpecCustomAnnotationsPreferenceUI.this.storedAnnotations);
                    MassSpecCustomAnnotation localAnnot = MassSpecCustomAnnotationDialog.getCurrentAnnot(selAnnotName, MassSpecCustomAnnotationsPreferenceUI.this.localAnnotations);
                    if (localAnnot != null) {
                        selAnnot = localAnnot;
                    } else if (prefAnnot != null) {
                        selAnnot = prefAnnot;
                    } else {
                        return;
                    }
                    MassSpecCustomAnnotationsPreferenceUI.this.processSelection(selAnnot);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cmbSelectAnnotation.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
        if (this.getContextViewer() != null) {
            this.cmbSelectAnnotation.addPaintListener((PaintListener)new CustomAnnotationPaintListener(this));
        }
    }

    protected boolean cancelIfDirty() {
        boolean bContinue;
        return this.bIsDirty && !(bContinue = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Values Changed", (String)"The values in the current selection have changed. Discard?"));
    }

    protected boolean confirmRestore() {
        boolean bContinue = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Reset Peaks", (String)"This will reload values in preferences. Local changes will be lost. Continue?");
        return bContinue;
    }

    protected List<MassSpecCustomAnnotation> getPreferenceCustomAnnotations(Object preferences) {
        return ((MassSpecPreference)preferences).getCustomAnnotations();
    }

    protected void setPreferenceCustomAnnotations(Object preferences, List<MassSpecCustomAnnotation> annotations) {
        ((MassSpecPreference)preferences).setCustomAnnotations(annotations);
    }

    public void initStoredAnnotationsList() {
        int iItemCount;
        MassSpecCustomAnnotation annot;
        int i;
        String sToSelect = "";
        if (this.cmbSelectAnnotation.getItems().length != 0) {
            this.cmbSelectAnnotation.removeAll();
        }
        this.cmbSelectAnnotation.add("");
        if (this.getStoredAnnotations() != null && this.getStoredAnnotations().getCustomAnnotations() != null) {
            i = 0;
            while (i < this.getStoredAnnotations().getCustomAnnotations().size()) {
                annot = this.getStoredAnnotations().getCustomAnnotations().get(i);
                this.cmbSelectAnnotation.add(annot.getAnnotationName());
                if (this.currentCustomAnnotation != null && annot.getAnnotationName().equals(this.currentCustomAnnotation.getAnnotationName())) {
                    iItemCount = this.cmbSelectAnnotation.getItemCount();
                    sToSelect = this.cmbSelectAnnotation.getItem(iItemCount - 1);
                }
                ++i;
            }
        }
        if (this.getContextViewer() != null && this.getLocalAnnotations() != null && this.getPreferenceCustomAnnotations(this.getLocalAnnotations()) != null) {
            i = 0;
            while (i < this.getPreferenceCustomAnnotations(this.getLocalAnnotations()).size()) {
                annot = this.getPreferenceCustomAnnotations(this.getLocalAnnotations()).get(i);
                MassSpecCustomAnnotationDialog.setComboEntryForTempAnnotation(annot, this.cmbSelectAnnotation, this.entryAnnotations.getCustomAnnotations(), this.storedAnnotations.getCustomAnnotations());
                if (this.currentCustomAnnotation != null && annot.getAnnotationName().equals(this.currentCustomAnnotation.getAnnotationName())) {
                    iItemCount = this.cmbSelectAnnotation.getItemCount();
                    sToSelect = this.cmbSelectAnnotation.getItem(iItemCount - 1);
                }
                ++i;
            }
        }
        int iPrevSelInx = this.cmbSelectAnnotation.indexOf(sToSelect);
        this.cmbSelectAnnotation.select(iPrevSelInx);
    }

    protected void addDeleteCurrent(Composite parent) {
        GridData gd3 = new GridData(4, 4, false, false, 1, 1);
        this.btnDeleteCurrent = new Button(parent, 0);
        this.btnDeleteCurrent.setText("Delete Selected");
        this.btnDeleteCurrent.setLayoutData((Object)gd3);
        this.btnDeleteCurrent.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                boolean bVal = MessageDialog.openConfirm((Shell)MassSpecCustomAnnotationsPreferenceUI.this.getShell(), (String)"Delete Selected?", (String)"Delete selected. Are you sure?");
                if (bVal) {
                    int iSelInx = MassSpecCustomAnnotationsPreferenceUI.this.cmbSelectAnnotation.getSelectionIndex();
                    MassSpecCustomAnnotation localAnnot = MassSpecCustomAnnotationDialog.getCurrentAnnot(MassSpecCustomAnnotationsPreferenceUI.this.cmbSelectAnnotation.getItem(iSelInx), MassSpecCustomAnnotationsPreferenceUI.this.localAnnotations);
                    MassSpecCustomAnnotationsPreferenceUI.this.getPreferenceCustomAnnotations(MassSpecCustomAnnotationsPreferenceUI.this.getLocalAnnotations()).remove(localAnnot);
                    MassSpecCustomAnnotationsPreferenceUI.this.cmbSelectAnnotation.remove(iSelInx);
                    MassSpecCustomAnnotationsPreferenceUI.this.clearValues();
                    MassSpecCustomAnnotationsPreferenceUI.this.setEditEnabled(false);
                    MassSpecCustomAnnotationsPreferenceUI.this.currentCustomAnnotation = null;
                    MassSpecCustomAnnotationsPreferenceUI.this.setPageComplete(true);
                    MassSpecCustomAnnotationsPreferenceUI.this.setResetEnabled();
                    MassSpecCustomAnnotationsPreferenceUI.this.setRemoveAllRowsEnabled();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnDeleteCurrent.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected void addResetCurrent(Composite parent) {
        GridData gd3 = new GridData(4, 4, false, false, 1, 1);
        this.btnResetCurrent = new Button(parent, 0);
        this.btnResetCurrent.setText("Restore Preferences");
        this.btnResetCurrent.setLayoutData((Object)gd3);
        this.btnResetCurrent.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                boolean bVal = MassSpecCustomAnnotationsPreferenceUI.this.confirmRestore();
                if (bVal) {
                    int iSelInx = MassSpecCustomAnnotationsPreferenceUI.this.cmbSelectAnnotation.getSelectionIndex();
                    MassSpecCustomAnnotation prefAnnot = MassSpecCustomAnnotationDialog.getCurrentAnnot(MassSpecCustomAnnotationsPreferenceUI.this.cmbSelectAnnotation.getItem(iSelInx), MassSpecCustomAnnotationsPreferenceUI.this.getStoredAnnotations());
                    MassSpecCustomAnnotation localAnnot = MassSpecCustomAnnotationDialog.getCurrentAnnot(MassSpecCustomAnnotationsPreferenceUI.this.cmbSelectAnnotation.getItem(iSelInx), MassSpecCustomAnnotationsPreferenceUI.this.getLocalAnnotations());
                    localAnnot.setAnnotatedPeaks(prefAnnot.getAnnotatedPeaks());
                    if (!MassSpecCustomAnnotationsPreferenceUI.this.cmbSelectAnnotation.getText().trim().equals("")) {
                        String selAnnotName = MassSpecCustomAnnotationsPreferenceUI.this.cmbSelectAnnotation.getText().trim();
                        MassSpecCustomAnnotation storedAnnot = MassSpecCustomAnnotationDialog.getCurrentAnnot(selAnnotName, MassSpecCustomAnnotationsPreferenceUI.this.getStoredAnnotations());
                        MassSpecCustomAnnotationsPreferenceUI.this.processSelection(storedAnnot);
                    }
                    MassSpecCustomAnnotationsPreferenceUI.this.initStoredAnnotationsList();
                    MassSpecCustomAnnotationsPreferenceUI.this.setRemoveAllRowsEnabled();
                    MassSpecCustomAnnotationsPreferenceUI.this.setPageComplete(true);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnDeleteCurrent.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected void addExportXML(Composite parent) {
        GridData gd3 = new GridData(4, 4, false, false, 1, 1);
        this.btnExportXML = new Button(parent, 0);
        this.btnExportXML.setText("    Export    ");
        this.btnExportXML.setLayoutData((Object)gd3);
        this.btnExportXML.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FileDialog fd = new FileDialog(MassSpecCustomAnnotationsPreferenceUI.this.getShell(), 8192);
                fd.setText("Please select file for export");
                fd.setFilterNames(new String[]{"GRITS Custom Annotation XML (.xml)", "All files"});
                fd.setFilterExtensions(new String[]{"*.xml", "*.*"});
                String sPath = fd.open();
                if (sPath != null) {
                    if (!sPath.endsWith(".xml")) {
                        sPath = String.valueOf(sPath) + ".xml";
                    }
                    MassSpecCustomAnnotationsPreferenceUI.this.writeXMLFile(sPath);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnExportXML.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected void addImportXML(Composite parent) {
        GridData gd3 = new GridData(4, 4, false, false, 1, 1);
        this.btnImportXML = new Button(parent, 0);
        this.btnImportXML.setText("    Import    ");
        this.btnImportXML.setLayoutData((Object)gd3);
        this.btnImportXML.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FileDialog fd = new FileDialog(MassSpecCustomAnnotationsPreferenceUI.this.getShell(), 4096);
                fd.setText("Please select file for import");
                fd.setFilterNames(new String[]{"GRITS Custom Annotation XML (.xml)", "All files"});
                fd.setFilterExtensions(new String[]{"*.xml", "*.*"});
                String sPath = fd.open();
                if (sPath != null) {
                    if (!sPath.endsWith(".xml")) {
                        sPath = String.valueOf(sPath) + ".xml";
                    }
                    MassSpecCustomAnnotationsPreferenceUI.this.readXMLFile(sPath);
                    if (MassSpecCustomAnnotationsPreferenceUI.this.currentCustomAnnotation != null) {
                        MassSpecCustomAnnotationsPreferenceUI.this.cmbSelectAnnotation.add(MassSpecCustomAnnotationsPreferenceUI.this.currentCustomAnnotation.getAnnotationName());
                        MassSpecCustomAnnotationsPreferenceUI.this.cmbSelectAnnotation.select(MassSpecCustomAnnotationsPreferenceUI.this.cmbSelectAnnotation.getItemCount() - 1);
                        MassSpecCustomAnnotationsPreferenceUI.this.processSelection(MassSpecCustomAnnotationsPreferenceUI.this.currentCustomAnnotation);
                    } else {
                        MassSpecCustomAnnotationsPreferenceUI.this.showInvalidImportFileMessage();
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnImportXML.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected void showInvalidImportFileMessage() {
        ErrorUtils.createErrorMessageBox((Shell)this.getShell(), (String)"Not a valid Mass Spec Custom Annotation XML file.");
    }

    protected void writeXMLFile(String sPath) {
        MassSpecCustomAnnotationFile.writeXMLFile(this.currentCustomAnnotation, sPath);
    }

    protected void addEditCurrent(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnEditCurrent = new Button(parent, 0);
        this.btnEditCurrent.setText("Edit Selected");
        this.btnEditCurrent.setLayoutData((Object)gd1);
        this.btnEditCurrent.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.setEditEnabled(true);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnEditCurrent.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected MassSpecCustomAnnotation getNewMassSpecCustomAnnotation() {
        return new MassSpecCustomAnnotation();
    }

    protected void addCreateNewItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnCreateNew = new Button(parent, 0);
        this.btnCreateNew.setText("Create New");
        this.btnCreateNew.setLayoutData((Object)gd1);
        this.btnCreateNew.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (MassSpecCustomAnnotationsPreferenceUI.this.cancelIfDirty()) {
                    return;
                }
                MassSpecCustomAnnotationsPreferenceUI.this.setEditEnabled(true);
                MassSpecCustomAnnotationsPreferenceUI.this.btnExportXML.setEnabled(false);
                MassSpecCustomAnnotationsPreferenceUI.this.btnEditCurrent.setEnabled(false);
                MassSpecCustomAnnotationsPreferenceUI.this.clearValues();
                MassSpecCustomAnnotationsPreferenceUI.this.currentCustomAnnotation = MassSpecCustomAnnotationsPreferenceUI.this.getNewMassSpecCustomAnnotation();
                MassSpecCustomAnnotationsPreferenceUI.this.setResetEnabled();
                MassSpecCustomAnnotationsPreferenceUI.this.setRemoveAllRowsEnabled();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnCreateNew.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected void addSeparatorLine1(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, false, 6, 1);
        this.lblSeparator = new Label(parent, 258);
        this.lblSeparator.setLayoutData((Object)gd1);
    }

    protected void setCurrentAnnotationValues(MassSpecCustomAnnotation selAnnot) {
        if (selAnnot == null) {
            return;
        }
        this.currentCustomAnnotation = selAnnot;
        this.txtAnnotationName.setText(selAnnot.getAnnotationName());
        this.txtDescription.setText(selAnnot.getDescription());
        this.txtMassTolerance.setText(selAnnot.getMassTolerance().toString());
        if (selAnnot.getIsPPM().booleanValue()) {
            this.btnTolerancePPM.setSelection(true);
        } else {
            this.btnToleranceDalton.setSelection(true);
        }
        this.initPeakListValues(selAnnot, -1, -1);
        this.setIsDirty(false);
    }

    public void setEditEnabled(boolean _bVal) {
        this.btnDeleteCurrent.setEnabled(_bVal);
        this.btnExportXML.setEnabled(_bVal);
        this.btnEditCurrent.setEnabled(_bVal);
        this.lblAnnotatioName.setEnabled(_bVal);
        this.txtAnnotationName.setEnabled(_bVal);
        this.lblDescription.setEnabled(_bVal);
        this.txtDescription.setEnabled(_bVal);
        this.lblMassTolerance.setEnabled(_bVal);
        this.lblToleranceType.setEnabled(_bVal);
        this.btnTolerancePPM.setEnabled(_bVal);
        this.btnToleranceDalton.setEnabled(_bVal);
        this.txtMassTolerance.setEnabled(_bVal);
        this.gridSpecialPeaksGrid.setEnabled(_bVal);
        this.lblAddAnnotationsFromFile.setEnabled(_bVal);
        this.btnAddAnnotationsFromFile.setEnabled(_bVal);
        this.gridSpecialPeaksGrid.redraw();
    }

    public void setResetEnabled() {
        this.btnResetCurrent.setEnabled(this.cmbSelectAnnotation.getText().trim().endsWith(" (differs from preferences)"));
    }

    public void clearValues() {
        this.txtAnnotationName.setText("");
        this.txtDescription.setText("");
        this.txtMassTolerance.setText("");
        this.gridSpecialPeaksGrid.clearAll(true);
        this.txtAddAnnotationsFromFile.setText("<Please Browse for your file>");
        this.cmbSelectAnnotation.select(0);
        this.btnRemoveSelected.setEnabled(false);
        this.btnRemoveAllRows.setEnabled(false);
        this.setIsDirty(false);
    }

    protected void addAnnotationNameItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.lblAnnotatioName = new Label(parent, 0);
        this.lblAnnotatioName.setText("Name of Custom Annotation");
        this.lblAnnotatioName.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 5, 1);
        this.txtAnnotationName = new Text(parent, 2048);
        this.txtAnnotationName.setLayoutData((Object)gd2);
        this.txtAnnotationName.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.setIsDirty(true);
                if (MassSpecCustomAnnotationsPreferenceUI.this.isReadyToFinish()) {
                    MassSpecCustomAnnotationsPreferenceUI.this.setPageComplete(true);
                } else {
                    MassSpecCustomAnnotationsPreferenceUI.this.setPageComplete(false);
                }
            }
        });
        this.txtAnnotationName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected void addDescriptionItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 5);
        this.lblDescription = new Label(parent, 0);
        this.lblDescription.setText("Description");
        this.lblDescription.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true, 5, 5);
        this.txtDescription = new Text(parent, 2626);
        this.txtDescription.setText("");
        this.txtDescription.setLayoutData((Object)gd2);
        this.txtDescription.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.setIsDirty(true);
                if (MassSpecCustomAnnotationsPreferenceUI.this.isReadyToFinish()) {
                    MassSpecCustomAnnotationsPreferenceUI.this.setPageComplete(true);
                } else {
                    MassSpecCustomAnnotationsPreferenceUI.this.setPageComplete(false);
                }
            }
        });
        this.txtDescription.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    public void setIsDirty(boolean bIsDirty) {
        this.bIsDirty = bIsDirty;
    }

    protected void addMassToleranceItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.lblMassTolerance = new Label(parent, 0);
        this.lblMassTolerance.setText("Mass Tolerance to Match Peak");
        this.lblMassTolerance.setLayoutData((Object)gd1);
        GridData gd3 = new GridData(4, 4, false, false, 1, 1);
        this.txtMassTolerance = new Text(parent, 2048);
        this.txtMassTolerance.setLayoutData((Object)gd3);
        this.txtMassTolerance.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.setIsDirty(true);
                if (MassSpecCustomAnnotationsPreferenceUI.this.isReadyToFinish()) {
                    MassSpecCustomAnnotationsPreferenceUI.this.setPageComplete(true);
                } else {
                    MassSpecCustomAnnotationsPreferenceUI.this.setPageComplete(false);
                }
            }
        });
        this.txtMassTolerance.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
        GridData gd4 = new GridData(4, 4, false, false, 4, 1);
        Label dummy4 = new Label(parent, 0);
        dummy4.setLayoutData((Object)gd4);
    }

    protected void addToleranceTypeItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.lblToleranceType = new Label(parent, 0);
        this.lblToleranceType.setText("Tolerance Type");
        this.lblToleranceType.setLayoutData((Object)gd1);
        Composite cmp = new Composite(parent, 0);
        GridData cmpGD = new GridData(768);
        cmpGD.horizontalSpan = 4;
        cmp.setLayoutData((Object)cmpGD);
        cmp.setLayout((Layout)new RowLayout());
        this.btnTolerancePPM = new Button(cmp, 16);
        this.btnTolerancePPM.setText("PPM");
        this.btnTolerancePPM.setSelection(true);
        this.btnToleranceDalton = new Button(cmp, 16);
        this.btnToleranceDalton.setText("Dalton");
        GridData gd4 = new GridData(4, 4, false, false, 1, 1);
        Label dummy4 = new Label(parent, 0);
        dummy4.setLayoutData((Object)gd4);
        this.btnToleranceDalton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.setIsDirty(true);
                if (MassSpecCustomAnnotationsPreferenceUI.this.isReadyToFinish()) {
                    MassSpecCustomAnnotationsPreferenceUI.this.setPageComplete(true);
                } else {
                    MassSpecCustomAnnotationsPreferenceUI.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnToleranceDalton.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
        this.btnTolerancePPM.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.setIsDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnTolerancePPM.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected int getColNumberForGridColumn(GridColumn col) {
        int i = 0;
        while (i < this.getHeaderColumns().length) {
            if (col.getText().equals(this.getHeaderColumns()[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getRowNumberForItem(GridItem item) {
        int i = 0;
        while (i < this.gridSpecialPeaksGrid.getItems().length) {
            GridItem gi = this.gridSpecialPeaksGrid.getItem(i);
            if (gi.equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void addPeakListItem(Composite parent) {
        this.gridSpecialPeaksGrid = new Grid((Composite)this, 2816);
        this.gridSpecialPeaksGrid.setHeaderVisible(true);
        GridData gd_gridSpecialPeaksGrid = new GridData(4, 4, true, true, 6, 10);
        gd_gridSpecialPeaksGrid.heightHint = 150;
        this.gridSpecialPeaksGrid.setLayoutData((Object)gd_gridSpecialPeaksGrid);
        this.initGridColumns();
        this.initPeakListValues(null, -1, -1);
        this.editor = new GridEditor(this.gridSpecialPeaksGrid);
        this.gridSpecialPeaksGrid.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                super.mouseDown(e);
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
                MassSpecCustomAnnotationsPreferenceUI.this.setRemoveAllRowsEnabled();
                Point pt = new Point(e.x, e.y);
                GridColumn col = MassSpecCustomAnnotationsPreferenceUI.this.gridSpecialPeaksGrid.getColumn(pt);
                GridItem item = MassSpecCustomAnnotationsPreferenceUI.this.gridSpecialPeaksGrid.getItem(pt);
                if (item == null && col != null) {
                    int iColNum = MassSpecCustomAnnotationsPreferenceUI.this.getColNumberForGridColumn(col);
                    int iSortOrder = 128;
                    if (col.getSort() == 128) {
                        iSortOrder = 1024;
                    }
                    MassSpecCustomAnnotationsPreferenceUI.this.updateCurrentAnnotationPeakData();
                    MassSpecCustomAnnotationsPreferenceUI.this.initPeakListValues(MassSpecCustomAnnotationsPreferenceUI.this.currentCustomAnnotation, iColNum, iSortOrder);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.setIsDirty(true);
                MassSpecCustomAnnotationsPreferenceUI.this.bIsEditingTable = true;
                Control oldEditor = MassSpecCustomAnnotationsPreferenceUI.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                Point pt = new Point(e.x, e.y);
                final GridItem item = MassSpecCustomAnnotationsPreferenceUI.this.gridSpecialPeaksGrid.getItem(pt);
                final Point cell = MassSpecCustomAnnotationsPreferenceUI.this.gridSpecialPeaksGrid.getCell(pt);
                if (item == null || cell == null) {
                    return;
                }
                MassSpecCustomAnnotationsPreferenceUI.this.gridSpecialPeaksGrid.deselect(cell.y);
                final Text newEditor = new Text((Composite)MassSpecCustomAnnotationsPreferenceUI.this.gridSpecialPeaksGrid, 2052);
                String curText = item.getText(cell.x);
                newEditor.setText(curText);
                MassSpecCustomAnnotationsPreferenceUI.this.editor.setEditor((Control)newEditor, item, cell.x);
                MassSpecCustomAnnotationsPreferenceUI.this.editor.grabHorizontal = true;
                MassSpecCustomAnnotationsPreferenceUI.this.editor.grabVertical = true;
                newEditor.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                        item.setText(cell.x, newEditor.getText());
                        if (MassSpecCustomAnnotationsPreferenceUI.this.isValidCellValue(cell.x, newEditor.getText()) && MassSpecCustomAnnotationsPreferenceUI.this.isReadyToFinish()) {
                            MassSpecCustomAnnotationsPreferenceUI.this.setPageComplete(true);
                        } else {
                            MassSpecCustomAnnotationsPreferenceUI.this.setPageComplete(false);
                        }
                    }

                    public void keyPressed(KeyEvent e) {
                    }
                });
                newEditor.forceFocus();
                newEditor.setSelection(newEditor.getText().length());
                newEditor.selectAll();
                int iRowNum = MassSpecCustomAnnotationsPreferenceUI.this.getRowNumberForItem(item);
                if (iRowNum == MassSpecCustomAnnotationsPreferenceUI.this.gridSpecialPeaksGrid.getItemCount() - 1) {
                    MassSpecCustomAnnotationsPreferenceUI.this.addBlankRows(1);
                }
            }
        });
    }

    protected boolean isValidCellValue(int x, String sValue) {
        if (x == 0) {
            double dVal = -1.0;
            try {
                dVal = Double.parseDouble(sValue);
            }
            catch (NumberFormatException numberFormatException) {}
            if (dVal < 0.0) {
                this.setErrorMessage("m/z value must be a valid, positive double value");
                return false;
            }
        } else if (x == 1) {
            int iVal = -1;
            try {
                iVal = Integer.parseInt(sValue);
            }
            catch (NumberFormatException numberFormatException) {}
            if (iVal < 2) {
                this.setErrorMessage("MS level value must be a valid, positive integer > 1");
                return false;
            }
        }
        return true;
    }

    protected void disposeEditor() {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
            this.editor.setEditor(null);
            this.bIsEditingTable = false;
        }
    }

    protected void setDeleteSelectedEnabled() {
        GridItem item;
        if (this.gridSpecialPeaksGrid != null && this.gridSpecialPeaksGrid.getSelectionIndex() != -1 && (item = this.gridSpecialPeaksGrid.getItem(this.gridSpecialPeaksGrid.getSelectionIndex())) != null) {
            int iItemCnt = this.getHeaderColumns().length;
            int i = 0;
            while (i < iItemCnt) {
                if (!item.getText(i).equals("")) {
                    this.btnRemoveSelected.setEnabled(true);
                    return;
                }
                ++i;
            }
        }
        this.btnRemoveSelected.setEnabled(false);
    }

    protected void setRemoveAllRowsEnabled() {
        if (this.gridSpecialPeaksGrid != null && this.gridSpecialPeaksGrid.getItems().length > 0) {
            int i = 0;
            while (i < this.gridSpecialPeaksGrid.getItems().length) {
                GridItem item = this.gridSpecialPeaksGrid.getItem(i);
                if (!item.getText(0).trim().equals("")) {
                    this.btnRemoveAllRows.setEnabled(true);
                    return;
                }
                ++i;
            }
        }
        this.btnRemoveAllRows.setEnabled(false);
    }

    protected void addRemoveRowComponents(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnRemoveSelected = new Button(parent, 0);
        this.btnRemoveSelected.setText("Remove Selected Row");
        this.btnRemoveSelected.setLayoutData((Object)gd1);
        this.btnRemoveSelected.setEnabled(false);
        this.btnRemoveSelected.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int iSelRow = MassSpecCustomAnnotationsPreferenceUI.this.gridSpecialPeaksGrid.getSelectionIndex();
                if (iSelRow != -1) {
                    MassSpecCustomAnnotationsPreferenceUI.this.gridSpecialPeaksGrid.getItem(iSelRow);
                    MassSpecCustomAnnotationsPreferenceUI.this.gridItemsSpecialPeaks.remove(iSelRow);
                    MassSpecCustomAnnotationsPreferenceUI.this.gridSpecialPeaksGrid.remove(iSelRow);
                }
                MassSpecCustomAnnotationsPreferenceUI.this.setIsDirty(true);
                MassSpecCustomAnnotationsPreferenceUI.this.btnRemoveSelected.setEnabled(false);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnRemoveSelected.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
            }
        });
    }

    protected void addRemoveAllRowsComponents(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnRemoveAllRows = new Button(parent, 0);
        this.btnRemoveAllRows.setText("Remove All Rows");
        this.btnRemoveAllRows.setLayoutData((Object)gd1);
        GridData gd4 = new GridData(4, 4, true, false, 4, 1);
        Label dummy4 = new Label(parent, 0);
        dummy4.setLayoutData((Object)gd4);
        this.btnRemoveAllRows.setEnabled(false);
        this.btnRemoveAllRows.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int iVal = ErrorUtils.createMessageBoxReturn((Shell)MassSpecCustomAnnotationsPreferenceUI.this.getShell(), (String)"Confirmation", (String)"Are you sure?");
                if (iVal == 1) {
                    MassSpecCustomAnnotationsPreferenceUI.this.gridSpecialPeaksGrid.disposeAllItems();
                }
                MassSpecCustomAnnotationsPreferenceUI.this.setIsDirty(true);
                MassSpecCustomAnnotationsPreferenceUI.this.btnRemoveSelected.setEnabled(false);
                MassSpecCustomAnnotationsPreferenceUI.this.btnRemoveAllRows.setEnabled(false);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnRemoveSelected.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
            }
        });
    }

    protected void addAnnotationsFileItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.lblAddAnnotationsFromFile = new Label(parent, 0);
        this.lblAddAnnotationsFromFile.setText("Add Annotations From File");
        this.lblAddAnnotationsFromFile.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 4, 1);
        this.txtAddAnnotationsFromFile = new Text(parent, 2048);
        this.txtAddAnnotationsFromFile.setText("<Please Browse for your file>");
        this.txtAddAnnotationsFromFile.setLayoutData((Object)gd2);
        this.txtAddAnnotationsFromFile.setEnabled(false);
        GridData gd3 = new GridData(4, 4, false, false, 1, 1);
        this.btnAddAnnotationsFromFile = new Button(parent, 0);
        this.btnAddAnnotationsFromFile.setText("Browse");
        this.btnAddAnnotationsFromFile.setLayoutData((Object)gd3);
        this.btnAddAnnotationsFromFile.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FileDialog fd = new FileDialog(MassSpecCustomAnnotationsPreferenceUI.this.getShell(), 4096);
                fd.setText("Please select file for import");
                fd.setFilterNames(new String[]{"Tab-delimited (.txt)", "All files"});
                fd.setFilterExtensions(new String[]{"*.txt", "*.*"});
                String sPath = fd.open();
                if (sPath != null) {
                    MassSpecCustomAnnotationsPreferenceUI.this.readTxtFile(sPath);
                    MassSpecCustomAnnotationsPreferenceUI.this.initPeakListValues(MassSpecCustomAnnotationsPreferenceUI.this.currentCustomAnnotation, -1, -1);
                    MassSpecCustomAnnotationsPreferenceUI.this.txtAddAnnotationsFromFile.setText(sPath);
                    MassSpecCustomAnnotationsPreferenceUI.this.setRemoveAllRowsEnabled();
                    MassSpecCustomAnnotationsPreferenceUI.this.setIsDirty(true);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnAddAnnotationsFromFile.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected void readXMLFile(String sPath) {
        this.currentCustomAnnotation = MassSpecCustomAnnotationFile.readXMLFile(sPath);
    }

    protected void readTxtFile(String sPath) {
        MassSpecCustomAnnotationFile.readTxtFile(this.currentCustomAnnotation, sPath);
    }

    protected void addSaveSettingsItem(Composite parent, boolean bAddItem) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        if (bAddItem) {
            this.btnSaveAsDefault = new Button(parent, 32);
            this.btnSaveAsDefault.setText("Save in workspace preferences");
            this.btnSaveAsDefault.setLayoutData((Object)gd1);
            this.btnSaveAsDefault.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MassSpecCustomAnnotationsPreferenceUI.this.setIsDirty(true);
                    MassSpecCustomAnnotationsPreferenceUI.this.disposeEditor();
                    MassSpecCustomAnnotationsPreferenceUI.this.setDeleteSelectedEnabled();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        }
        GridData gd4 = new GridData(4, 4, true, false, 5, 1);
        Label dummy4 = new Label(parent, 0);
        dummy4.setLayoutData((Object)gd4);
    }

    protected void addBottomButtonsItem(Composite parent) {
    }

    protected MassSpecCustomAnnotationPeak getNewMassSpecCustomAnnotationPeak() {
        return new MassSpecCustomAnnotationPeak();
    }

    protected void updateCurrentAnnotationPeakData() {
        if (this.currentCustomAnnotation != null) {
            HashMap<Double, MassSpecCustomAnnotationPeak> annotatedPeaks = new HashMap<Double, MassSpecCustomAnnotationPeak>();
            int i = 0;
            while (i < this.gridSpecialPeaksGrid.getItems().length) {
                GridItem gi = this.gridSpecialPeaksGrid.getItem(i);
                if (!this.isBlankRow(gi)) {
                    MassSpecCustomAnnotationPeak peak = this.getNewMassSpecCustomAnnotationPeak();
                    try {
                        this.fillPeak(gi, peak);
                        Double dMz = Double.parseDouble(gi.getText(0).trim());
                        annotatedPeaks.put(dMz, peak);
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
            this.currentCustomAnnotation.setAnnotatedPeaks(annotatedPeaks);
        }
    }

    protected void addCurrentCustomAnnotation() {
        if (this.currentCustomAnnotation == null) {
            return;
        }
        MassSpecCustomAnnotation toDelete = null;
        int i = 0;
        while (i < this.getPreferenceCustomAnnotations(this.getLocalAnnotations()).size()) {
            MassSpecCustomAnnotation curAnnot = this.getPreferenceCustomAnnotations(this.getLocalAnnotations()).get(i);
            if (curAnnot.getAnnotationName().equals(this.currentCustomAnnotation.getAnnotationName())) {
                toDelete = curAnnot;
            }
            ++i;
        }
        if (toDelete != null) {
            this.getPreferenceCustomAnnotations(this.getLocalAnnotations()).remove(toDelete);
        }
        this.getPreferenceCustomAnnotations(this.getLocalAnnotations()).add(this.currentCustomAnnotation);
    }

    protected String[] getHeaderColumns() {
        return MassSpecCustomAnnotationFile.HEADER_COLUMN_LABELS;
    }

    protected void initGridColumns() {
        GridColumn[] cols = new GridColumn[this.getHeaderColumns().length];
        int i = 0;
        while (i < this.getHeaderColumns().length) {
            cols[i] = new GridColumn(this.gridSpecialPeaksGrid, 0);
            cols[i].setText(this.getHeaderColumns()[i]);
            cols[i].setWidth(this.getDefaultColumnWidth(i));
            ++i;
        }
        if (this.btnRemoveSelected != null) {
            this.btnRemoveSelected.setEnabled(false);
        }
    }

    protected int getDefaultColumnWidth(int _iColNum) {
        if (_iColNum == 0) {
            return 100;
        }
        if (_iColNum == 1) {
            return 100;
        }
        if (_iColNum == 2) {
            return 200;
        }
        return 50;
    }

    protected void fillRow(GridItem gi, MassSpecCustomAnnotationPeak peak) {
        int j = 0;
        try {
            if (peak == null || peak.getPeakMz() == null) {
                return;
            }
            gi.setText(j++, peak != null ? Double.toString(peak.getPeakMz()) : "");
            gi.setText(j++, peak != null ? Integer.toString(peak.getMSLevel()) : "");
            gi.setText(j++, peak != null ? peak.getPeakLabel() : "");
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected boolean isBlankRow(GridItem gi) {
        int i = 0;
        while (i < this.getHeaderColumns().length) {
            if (!gi.getText(i).equals("")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void fillPeak(GridItem gi, MassSpecCustomAnnotationPeak peak) {
        try {
            if (this.isBlankRow(gi)) {
                return;
            }
            int j = 0;
            peak.setPeakMz(Double.parseDouble(gi.getText(j++)));
            peak.setMSLevel(Integer.parseInt(gi.getText(j++)));
            peak.setPeakLabel(gi.getText(j++));
        }
        catch (NumberFormatException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected List<MassSpecCustomAnnotationPeak> getSortedPeaks(MassSpecCustomAnnotation customAnnotation, int iSortCol, int sortDir) {
        if (customAnnotation != null) {
            ArrayList<Double> sortNumericKeys = new ArrayList<Double>();
            ArrayList<String> sortStringKeys = new ArrayList<String>();
            Collection<MassSpecCustomAnnotationPeak> peakCollection = customAnnotation.getAnnotatedPeaks().values();
            for (MassSpecCustomAnnotationPeak peak : peakCollection) {
                if (iSortCol <= 0) {
                    sortNumericKeys.add(peak.getPeakMz());
                    continue;
                }
                if (iSortCol == 1) {
                    sortNumericKeys.add(Double.valueOf(peak.getMSLevel().intValue()));
                    continue;
                }
                sortStringKeys.add(peak.getPeakLabel());
            }
            if (iSortCol >= 0) {
                if (sortDir == 128) {
                    Collections.sort(sortNumericKeys);
                    Collections.sort(sortStringKeys);
                } else {
                    Collections.sort(sortNumericKeys, Collections.reverseOrder());
                    Collections.sort(sortStringKeys, Collections.reverseOrder());
                }
            }
            ArrayList<String> list = sortNumericKeys.isEmpty() ? sortStringKeys : sortNumericKeys;
            ArrayList<MassSpecCustomAnnotationPeak> sortedList = new ArrayList<MassSpecCustomAnnotationPeak>();
            int i = 0;
            while (i < list.size()) {
                Object oVal = list.get(i);
                for (MassSpecCustomAnnotationPeak peak : peakCollection) {
                    if (sortedList.contains(peak)) continue;
                    if (iSortCol <= 0) {
                        if ((Double)oVal != peak.getPeakMz()) continue;
                        sortedList.add(peak);
                        continue;
                    }
                    if (iSortCol == 1) {
                        if (((Double)oVal).intValue() != peak.getMSLevel().intValue()) continue;
                        sortedList.add(peak);
                        continue;
                    }
                    if (!((String)oVal).equals(peak.getPeakLabel())) continue;
                    sortedList.add(peak);
                }
                ++i;
            }
            return sortedList;
        }
        return null;
    }

    protected void initPeakListValues(MassSpecCustomAnnotation customAnnotation, int iSortCol, int iSortOrder) {
        if (this.gridItemsSpecialPeaks == null) {
            this.gridItemsSpecialPeaks = new ArrayList<GridItem>();
        }
        if (customAnnotation != null) {
            this.removeBlankRows();
            int i = 0;
            while (i < this.getHeaderColumns().length) {
                GridColumn col = this.gridSpecialPeaksGrid.getColumn(i);
                col.setSort(0);
                ++i;
            }
            List<MassSpecCustomAnnotationPeak> lSortedList = this.getSortedPeaks(customAnnotation, iSortCol, iSortOrder);
            int i2 = 0;
            while (i2 < lSortedList.size()) {
                GridItem gi = new GridItem(this.gridSpecialPeaksGrid, 0);
                MassSpecCustomAnnotationPeak peak = lSortedList.get(i2);
                this.fillRow(gi, peak);
                this.gridItemsSpecialPeaks.add(gi);
                ++i2;
            }
            if (iSortOrder >= 0) {
                this.gridSpecialPeaksGrid.getColumn(iSortCol).setSort(iSortOrder);
            }
        }
        this.addBlankRows(3);
    }

    protected void addBlankRows(int iNumRows) {
        int iStart = this.gridSpecialPeaksGrid.getItemCount();
        int iEnd = iStart + iNumRows;
        int i = iStart;
        while (i < iEnd) {
            GridItem gi = new GridItem(this.gridSpecialPeaksGrid, 0);
            this.fillRow(gi, null);
            this.gridItemsSpecialPeaks.add(gi);
            ++i;
        }
    }

    protected void removeBlankRows() {
        ArrayList<Integer> iBlankRows = new ArrayList<Integer>();
        int iEnd = this.gridSpecialPeaksGrid.getItemCount();
        int i = 0;
        while (i < iEnd) {
            GridItem gi = this.gridSpecialPeaksGrid.getItem(i);
            boolean bDone = false;
            int j = 0;
            while (j < this.getHeaderColumns().length) {
                String sVal = gi.getText(j);
                if (sVal != null && !sVal.trim().equals("")) {
                    bDone = true;
                    break;
                }
                ++j;
            }
            if (!bDone) {
                iBlankRows.add(i);
            }
            ++i;
        }
        if (!iBlankRows.isEmpty()) {
            int[] iRows = new int[iBlankRows.size()];
            int iCnt = 0;
            int i2 = 0;
            while (i2 < iBlankRows.size()) {
                iRows[iCnt++] = (Integer)iBlankRows.get(i2);
                ++i2;
            }
            this.gridSpecialPeaksGrid.remove(iRows);
        }
    }

    public void updateSettings() {
        this.disposeEditor();
        if (this.currentCustomAnnotation != null) {
            this.currentCustomAnnotation.setAnnotationName(this.sAnnotationName);
            this.currentCustomAnnotation.setDescription(this.sDescription);
            this.currentCustomAnnotation.setMassTolerance(this.dMassTolerance);
            this.currentCustomAnnotation.setIsPPM(this.bIsPPM);
            this.updateCurrentAnnotationPeakData();
        }
    }

    public void updatePreferences() {
        if (this.currentCustomAnnotation != null) {
            this.addCurrentCustomAnnotation();
        }
        this.setIsDirty(false);
    }

    public void updateUI() {
        this.initStoredAnnotationsList();
        this.setEditEnabled(false);
        if (this.cmbSelectAnnotation.getSelectionIndex() == -1) {
            this.cmbSelectAnnotation.select(this.cmbSelectAnnotation.getItemCount() - 1);
        } else {
            this.cmbSelectAnnotation.select(this.cmbSelectAnnotation.getSelectionIndex());
        }
        this.btnEditCurrent.setEnabled(true);
        this.btnExportXML.setEnabled(true);
        this.btnDeleteCurrent.setEnabled(true);
        this.setDeleteSelectedEnabled();
        this.setRemoveAllRowsEnabled();
        this.setResetEnabled();
    }

    protected void handleEdit() {
        if (this.gridSpecialPeaksGrid.getSelectionIndices().length > 1) {
            this.setErrorMessage("You can edit only one specialPeak at a time");
            return;
        }
        if (this.isReadyToFinish()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    protected boolean isReadyToFinish() {
        this.sAnnotationName = null;
        this.sDescription = null;
        this.sMSLevel = null;
        this.dMassTolerance = null;
        this.bIsPPM = null;
        if (this.txtAnnotationName.getText().trim().equals("")) {
            this.setErrorMessage("Annotation name cannot be empty");
            return false;
        }
        this.sAnnotationName = this.txtAnnotationName.getText().trim();
        this.sDescription = this.txtDescription.getText().trim();
        boolean bPass = true;
        if (!this.txtMassTolerance.getText().trim().equals("")) {
            try {
                this.dMassTolerance = Double.parseDouble(this.txtMassTolerance.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                bPass = false;
            }
            if (this.dMassTolerance <= 0.0) {
                bPass = false;
            }
        } else {
            bPass = false;
        }
        if (!bPass) {
            this.setErrorMessage("Mass tolerance must be a valid, positive number");
            return false;
        }
        this.bIsPPM = this.btnTolerancePPM.getSelection() ? Boolean.TRUE : Boolean.FALSE;
        if (this.gridItemsSpecialPeaks == null || this.gridItemsSpecialPeaks.isEmpty()) {
            this.setErrorMessage("No peaks specified!");
            return false;
        }
        int i = 0;
        while (i < this.gridSpecialPeaksGrid.getItems().length) {
            GridItem gi = this.gridSpecialPeaksGrid.getItem(i);
            if (!this.isBlankRow(gi)) {
                int j = 0;
                while (j < this.getHeaderColumns().length) {
                    String sText = gi.getText(j);
                    if (!this.isValidCellValue(j, sText)) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setPageComplete(boolean isComplete) {
        PropertyChangeEvent e = new PropertyChangeEvent((Object)this, PAGE_COMPLETE_PROPERTY, (Object)this.isComplete, (Object)isComplete);
        this.isComplete = isComplete;
        this.listener.propertyChange(e);
    }

    public boolean isPageCompete() {
        return this.isComplete;
    }

    public class CustomAnnotationPaintListener
    implements PaintListener {
        MassSpecCustomAnnotationsPreferenceUI parent = null;

        public CustomAnnotationPaintListener(MassSpecCustomAnnotationsPreferenceUI parent) {
            this.parent = parent;
        }

        public void paintControl(PaintEvent e) {
            Entry entry = MassSpecCustomAnnotationsPreferenceUI.this.getEntryForCurrentViewer();
            if (entry != null && !entry.equals(this.parent.getEntry())) {
                this.parent.setEntry(entry);
                this.parent.initLocalAnnotations();
                this.parent.initStoredAnnotationsList();
            }
        }
    }
}

