/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.dialog;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ModalDialog;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.entry.ms.adaptor.MassSpecExportFileAdapter;

public class MassSpecExportDialog
extends ModalDialog {
    private String[] downloadOptions = new String[]{"Export Mass Spec CSV file", "Export GRITS XML file", "Export Excel file"};
    private Button OKbutton;
    private Entry msEntry;
    private List downloadlist;
    private MassSpecExportFileAdapter msExportFileAdapter;
    private MassSpecTableDataObject tableDataObject = null;
    SelectionListener downloadlistListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            MassSpecExportDialog.this.OKbutton.setEnabled(true);
            if (MassSpecExportDialog.this.downloadlist.getSelectionIndex() == 0) {
                MassSpecExportDialog.this.msExportFileAdapter.setFileName(".csv");
            } else if (MassSpecExportDialog.this.downloadlist.getSelectionIndex() == 1) {
                MassSpecExportDialog.this.msExportFileAdapter.setFileName(".xml");
            } else if (MassSpecExportDialog.this.downloadlist.getSelectionIndex() == 2) {
                MassSpecExportDialog.this.msExportFileAdapter.setFileName(".xls");
                MassSpecExportDialog.this.msExportFileAdapter.setCopy(false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public MassSpecExportDialog(Shell parentShell, MassSpecExportFileAdapter msAnnotationExportFileAdapter) {
        super(parentShell);
        this.msExportFileAdapter = msAnnotationExportFileAdapter;
    }

    public void create() {
        super.create();
        this.setTitle("Export");
        this.setMessage("Export a csv, xml, or excel file");
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.verticalSpacing = 10;
        parent.setLayout((Layout)gridLayout);
        this.createList(parent);
        this.createButtonCancel(parent);
        this.createButtonOK(parent);
        return parent;
    }

    private void createList(Composite parent2) {
        this.downloadlist = new List(parent2, 4);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        this.downloadlist.setLayoutData((Object)gridData);
        this.downloadlist.add(this.downloadOptions[0]);
        this.downloadlist.add(this.downloadOptions[1]);
        this.downloadlist.add(this.downloadOptions[2]);
        this.downloadlist.addSelectionListener(this.downloadlistListener);
    }

    protected Button createButtonOK(Composite parent2) {
        GridData okData = new GridData(128);
        okData.horizontalSpan = 2;
        okData.widthHint = 100;
        this.OKbutton = new Button(parent2, 8);
        this.OKbutton.setText("Export");
        this.msExportFileAdapter.setShell(parent2.getShell());
        this.msExportFileAdapter.setMassSpecEntry(this.msEntry);
        this.msExportFileAdapter.setTableDataObject(this.tableDataObject);
        this.msExportFileAdapter.setFileName("");
        this.OKbutton.addSelectionListener((SelectionListener)this.msExportFileAdapter);
        this.OKbutton.setLayoutData((Object)okData);
        this.OKbutton.setEnabled(false);
        return this.OKbutton;
    }

    protected boolean isValidInput() {
        return true;
    }

    protected Entry createEntry() {
        return this.msEntry;
    }

    public void setMassSpecEntry(Entry msAnnotationEntry) {
        this.msEntry = msAnnotationEntry;
    }

    public void setTableDataObject(MassSpecTableDataObject tableDataObject) {
        this.tableDataObject = tableDataObject;
    }

    public MassSpecTableDataObject getTableDataObject() {
        return this.tableDataObject;
    }
}

