/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.dialog;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.entry.ms.dialog.MassSpecViewerDialog;
import org.grits.toolbox.entry.ms.preference.IMSPreferenceWithCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.MassSpecCustomAnnotationsPreferenceUI;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MassSpecCustomAnnotationModifyDialog
extends MassSpecViewerDialog
implements IPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MassSpecCustomAnnotationModifyDialog.class);
    protected final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private boolean paramsOk = false;
    private String sSelectedAnnotation = null;
    private MassSpecCustomAnnotationsPreferenceUI customAnnotUI = null;
    protected IMSPreferenceWithCustomAnnotation localAnnotations = null;
    protected IMSPreferenceWithCustomAnnotation entryAnnotations = null;
    public static final String PROPERTY_LOCAL_CHANGE = "Local changes";
    public static final String PROPERTY_PREFERENCE_CHANGE = "Apply pressed";
    public static final String PROPERTY_CLOSE = "Window Closed";

    public MassSpecCustomAnnotationModifyDialog(Shell parentShell, MassSpecMultiPageViewer contextViewer) {
        super(parentShell, contextViewer);
        this.setShellStyle(18544);
    }

    public void setLocalAnnotations(IMSPreferenceWithCustomAnnotation preferences) {
        this.localAnnotations = preferences;
    }

    public IMSPreferenceWithCustomAnnotation getLocalAnnotations() {
        return this.localAnnotations;
    }

    public IMSPreferenceWithCustomAnnotation getEntryAnnotations() {
        return this.entryAnnotations;
    }

    public void setEntryAnnotations(IMSPreferenceWithCustomAnnotation entryAnnotations) {
        this.entryAnnotations = entryAnnotations;
    }

    public int open() {
        Entry entry = this.getEntryForCurrentViewer();
        if (entry == null) {
            return -1;
        }
        this.setMassSpecEntry(entry);
        super.create();
        this.getShell().open();
        this.getShell().layout();
        this.getShell().pack();
        this.getButton(0).setEnabled(false);
        this.customAnnotUI.setSelectedItem(this.getSelectedAnnotation());
        return this.getReturnCode();
    }

    protected boolean isResizable() {
        return true;
    }

    protected String getFormTitle() {
        return "Modify Mass Spec Custom Annotations";
    }

    protected MassSpecCustomAnnotationsPreferenceUI getNewMassSpecCustomAnnotationsPreferenceUI(Composite container) {
        return new MassSpecCustomAnnotationsPreferenceUI(container, 2048, this, true);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.getFormTitle());
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Monitor primary = this.getShell().getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.getShell().getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.getShell().setLocation(x, y);
        container.setLayout((Layout)new FillLayout());
        this.customAnnotUI = this.getNewMassSpecCustomAnnotationsPreferenceUI(container);
        this.customAnnotUI.setContextViewer(this.getContextViewer());
        this.customAnnotUI.setLocalAnnotations(this.getLocalAnnotations());
        this.customAnnotUI.setEntryAnnotations(this.getEntryAnnotations());
        this.customAnnotUI.setEntry(this.getMassSpecEntry());
        this.customAnnotUI.initComponents();
        return area;
    }

    public String getSelectedAnnotation() {
        return this.sSelectedAnnotation;
    }

    public void setSelectedAnnotation(String sSelectedAnnotation) {
        this.sSelectedAnnotation = sSelectedAnnotation;
    }

    public void validateInput() {
        if (this.paramsOk) {
            this.setErrorMessage(null);
            this.getButton(0).setEnabled(true);
            this.getButton(16).setEnabled(true);
        } else {
            this.setErrorMessage(this.customAnnotUI.getErrorMessage());
            this.getButton(0).setEnabled(false);
            this.getButton(16).setEnabled(false);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("Page Complete") && event.getNewValue() instanceof Boolean) {
            this.paramsOk = (Boolean)event.getNewValue();
            this.validateInput();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 16, "Apply", false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (16 == buttonId) {
            this.applyPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void apply() {
        try {
            this.customAnnotUI.updateSettings();
            this.customAnnotUI.updatePreferences();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void applyPressed() {
        this.apply();
        if (this.customAnnotUI.getSaveAsDefault()) {
            this.customAnnotUI.save();
        }
        if (this.getListeners() != null) {
            for (IPropertyChangeListener listener : this.getListeners()) {
                if (!this.customAnnotUI.getSaveAsDefault()) {
                    listener.propertyChange(new PropertyChangeEvent((Object)this, PROPERTY_LOCAL_CHANGE, (Object)Boolean.FALSE, (Object)Boolean.TRUE));
                    continue;
                }
                listener.propertyChange(new PropertyChangeEvent((Object)this, PROPERTY_PREFERENCE_CHANGE, (Object)Boolean.FALSE, (Object)Boolean.TRUE));
            }
        }
        this.customAnnotUI.initStoredAnnotationsList();
        this.customAnnotUI.setResetEnabled();
    }

    protected void okPressed() {
        this.applyPressed();
        super.okPressed();
    }

    public boolean close() {
        if (this.getListeners() != null) {
            for (IPropertyChangeListener listener : this.getListeners()) {
                listener.propertyChange(new PropertyChangeEvent((Object)this, PROPERTY_CLOSE, (Object)Boolean.FALSE, (Object)Boolean.TRUE));
            }
        }
        return super.close();
    }
}

