/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.report.handler;

import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.MSGlycanAnnotationTableDataObject;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.adaptor.MSAnnotationExportFileAdapter;
import org.grits.toolbox.entry.ms.annotation.glycan.report.adapter.MSGlycanAnnotationReportExportFileAdapter;
import org.grits.toolbox.entry.ms.annotation.glycan.report.dialog.MSGlycanReportAnnotationExportDialog;
import org.grits.toolbox.entry.ms.annotation.glycan.report.views.MSGlycanAnnotationReportMultiPageViewer;

public class MSGlycanAnnotationReportExportCommand {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationReportExportCommand.class);
    private Entry entry = null;
    private MSGlycanAnnotationTableDataObject tableDataObject = null;
    private int m_lastVisibleColInx = -1;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell, EPartService partService) {
        if (this.initialize(part, partService)) {
            this.createSimianExportDialog(shell);
        } else {
            logger.warn((Object)"An MS Annotation Merge entry must be open and active in order to export.");
            ErrorUtils.createWarningMessageBox((Shell)shell, (String)"Invalid Entry", (String)"An MS Annotation Merge entry must be open and active in order to export.");
        }
    }

    protected void createSimianExportDialog(Shell activeShell) {
        MSGlycanAnnotationReportExportFileAdapter adapter = new MSGlycanAnnotationReportExportFileAdapter();
        MSGlycanReportAnnotationExportDialog dialog = new MSGlycanReportAnnotationExportDialog(PropertyHandler.getModalDialog((Shell)activeShell), (MSAnnotationExportFileAdapter)adapter);
        dialog.setMSAnnotationEntry(this.entry);
        dialog.setTableDataObject((MSAnnotationTableDataObject)this.tableDataObject);
        dialog.setLastVisibleColInx(this.m_lastVisibleColInx);
        dialog.open();
    }

    protected boolean initialize(MPart part, EPartService partService) {
        MSGlycanAnnotationTableDataObject data;
        MSGlycanAnnotationReportMultiPageViewer viewer;
        block8: {
            block7: {
                try {
                    viewer = null;
                    if (part != null && part.getObject() instanceof MSGlycanAnnotationReportMultiPageViewer) {
                        viewer = (MSGlycanAnnotationReportMultiPageViewer)((Object)part.getObject());
                    } else {
                        for (MPart mPart : partService.getParts()) {
                            if (!(mPart.getObject() instanceof MSGlycanAnnotationReportMultiPageViewer) || !mPart.equals(mPart.getParent().getSelectedElement())) continue;
                            viewer = (MSGlycanAnnotationReportMultiPageViewer)((Object)mPart.getObject());
                            break;
                        }
                    }
                    if (viewer != null) break block7;
                    return false;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            this.entry = viewer.getEntry();
            if (viewer.getResultsView() != null && viewer.getResultsView().getViewBase() != null && viewer.getResultsView().getViewBase().getNatTable() != null) break block8;
            return false;
        }
        this.tableDataObject = data = (MSGlycanAnnotationTableDataObject)viewer.getResultsView().getViewBase().getNatTable().getGRITSTableDataObject();
        TableDataProcessor processor = viewer.getResultsView().getViewBase().getNatTable().getTableDataProcessor();
        this.m_lastVisibleColInx = processor.getLastVisibleCol();
        return true;
    }

    @CanExecute
    public boolean isEnabled(@Named(value="e4ActivePart") MPart part, EPartService partService) {
        return this.initialize(part, partService);
    }
}

