/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.MolecularEntity;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.BcsdbImporter;
import org.eurocarbdb.resourcesdb.io.CarbbankImporter;
import org.eurocarbdb.resourcesdb.io.CfgImporter;
import org.eurocarbdb.resourcesdb.io.GlycoCTExporter;
import org.eurocarbdb.resourcesdb.io.GlycoCTImporter;
import org.eurocarbdb.resourcesdb.monosaccharide.Anomer;
import org.eurocarbdb.resourcesdb.monosaccharide.Basetype;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Modification;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideDataBuilder;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideLinkingPosition;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideSynonym;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideValidation;
import org.eurocarbdb.resourcesdb.monosaccharide.Ringtype;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.monosaccharide.SubstituentAlias;
import org.eurocarbdb.resourcesdb.monosaccharide.SubstituentSubpartTreeNode;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.representation.ResidueRepresentation;
import org.eurocarbdb.resourcesdb.representation.ResidueRepresentationFormat;
import org.eurocarbdb.resourcesdb.representation.ResidueRepresentationType;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplateContainer;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;
import org.eurocarbdb.resourcesdb.template.TrivialnameTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Monosaccharide
extends MolecularEntity {
    private Basetype basetype;
    private List<Substitution> substitutions;
    private List<MonosaccharideSynonym> synonyms;
    private List<MonosaccharideLinkingPosition> possibleLinkingPositions;
    private boolean fuzzy;
    private boolean orientationChanged = false;
    private boolean checkPositionsOnTheFly = false;
    private int modificationIndex = 0;
    private int dbId;

    public Monosaccharide() {
        this((Config)null, (TemplateContainer)null);
    }

    public Monosaccharide(TemplateContainer container) {
        this((Config)null, container);
    }

    public Monosaccharide(Config conf, TemplateContainer container) {
        this.setConfig(conf);
        this.setTemplateContainer(container);
        this.init();
    }

    public Monosaccharide(Basetype bt) {
        this.setConfig(bt.getConfig());
        this.setTemplateContainer(bt.getTemplateContainer());
        this.init(bt);
    }

    public Monosaccharide(GlycanNamescheme scheme, String name) throws ResourcesDbException {
        this(scheme, name, null);
    }

    public Monosaccharide(GlycanNamescheme scheme, String name, TemplateContainer container) throws ResourcesDbException {
        this(scheme, name, container, null);
    }

    public Monosaccharide(GlycanNamescheme scheme, String name, TemplateContainer container, Config conf) throws ResourcesDbException {
        this.setTemplateContainer(container);
        this.setConfig(conf);
        if (GlycanNamescheme.CARBBANK.equals((Object)scheme.getBaseScheme())) {
            CarbbankImporter parser = new CarbbankImporter(scheme, this.getConfig(), this.getTemplateContainer());
            parser.parseMsString(name, this);
        } else if (GlycanNamescheme.GLYCOCT.equals((Object)scheme.getBaseScheme())) {
            GlycoCTImporter parser = new GlycoCTImporter(scheme, this.getConfig(), this.getTemplateContainer());
            parser.parseMsString(name, this);
        } else if (GlycanNamescheme.BCSDB.equals((Object)scheme.getBaseScheme())) {
            BcsdbImporter parser = new BcsdbImporter(this.getConfig(), this.getTemplateContainer());
            parser.parseMsString(name, this);
        } else if (GlycanNamescheme.CFG.equals((Object)scheme.getBaseScheme())) {
            CfgImporter parser = new CfgImporter(this.getConfig(), this.getTemplateContainer());
            parser.parseMsString(name, this);
        } else {
            throw new ResourcesDbException("GlycanNamescheme " + scheme.getNameStr() + " not supported in monosaccharide constructor");
        }
    }

    public int getRingStart() {
        return this.getBasetype().getRingStart();
    }

    public void setRingStart(int position) throws MonosaccharideException {
        if (this.isCheckPositionsOnTheFly() && (position < -1 || position > this.getSize())) {
            throw new MonosaccharideException("Ring start out of range: " + position);
        }
        this.getBasetype().setRingStart(position);
    }

    public void setRingStartNoAdjustment(int carbonylposition) throws MonosaccharideException {
        if (this.isCheckPositionsOnTheFly() && (carbonylposition < -1 || carbonylposition > this.getSize())) {
            throw new MonosaccharideException("Ring start out of range: " + carbonylposition);
        }
        this.getBasetype().setRingStartNoAdjustment(carbonylposition);
    }

    public int getRingEnd() {
        return this.getBasetype().getRingEnd();
    }

    public void setRingEnd(int ringEndPos) throws MonosaccharideException {
        if (this.isCheckPositionsOnTheFly()) {
            if (ringEndPos < -1) {
                throw new MonosaccharideException("Ring oxygen may not be smaller than -1");
            }
            if (ringEndPos > this.getSize()) {
                throw new MonosaccharideException("Ring oxygen out of range: " + ringEndPos);
            }
        }
        this.getBasetype().setRingEnd(ringEndPos);
    }

    public void setDefaultCarbonylPosition(int position) {
        this.getBasetype().setDefaultCarbonylPosition(position);
    }

    public int getDefaultCarbonylPosition() {
        return this.getBasetype().getDefaultCarbonylPosition();
    }

    public int getSize() {
        return this.getBasetype().getSize();
    }

    public void setSize(int size) {
        this.getBasetype().setSize(size);
    }

    public Anomer getAnomer() {
        return this.getBasetype().getAnomer();
    }

    public void setAnomer(Anomer anomer) {
        this.getBasetype().setAnomer(anomer);
    }

    public void setAnomer(String anomerStr) throws MonosaccharideException {
        this.getBasetype().setAnomer(Anomer.forNameOrSymbol(anomerStr));
    }

    public StereoConfiguration getConfiguration() {
        return this.getBasetype().getConfiguration();
    }

    public void setConfiguration(StereoConfiguration configuration) {
        this.getBasetype().setConfiguration(configuration);
    }

    public void setConfiguration(String configStr) throws MonosaccharideException {
        this.getBasetype().setConfiguration(StereoConfiguration.forNameOrSymbol(configStr));
    }

    public void setRingtype(Ringtype type) throws MonosaccharideException {
        this.getBasetype().setRingtype(type);
    }

    public Ringtype getRingtype() {
        return this.getBasetype().getRingtype();
    }

    public String getRingtypeSymbol() {
        return this.getBasetype().getRingtypeSymbol();
    }

    public boolean isAlditol() {
        return this.getBasetype().isAlditol();
    }

    public void setAlditol(boolean alditol) throws MonosaccharideException {
        this.getBasetype().setAlditol(alditol);
    }

    public int getNextModificationId() {
        return ++this.modificationIndex;
    }

    public Basetype getBasetype() {
        return this.basetype;
    }

    public void setBasetype(Basetype bt) {
        this.basetype = bt;
    }

    public boolean isCheckPositionsOnTheFly() {
        return this.checkPositionsOnTheFly;
    }

    public void setCheckPositionsOnTheFly(boolean ignoreRingoxygenPositionCheck) {
        this.checkPositionsOnTheFly = ignoreRingoxygenPositionCheck;
    }

    public boolean isOrientationChanged() {
        return this.orientationChanged;
    }

    private void setOrientationChanged(boolean orientationChanged) {
        this.orientationChanged = orientationChanged;
    }

    private void invertOrientationChanged() {
        this.orientationChanged = !this.orientationChanged;
    }

    public boolean isFuzzy() {
        return this.fuzzy;
    }

    public void setFuzzy(boolean fuzzy) {
        this.fuzzy = fuzzy;
    }

    public int getDbId() {
        return this.dbId;
    }

    public void setDbId(int dbId) {
        this.dbId = dbId;
    }

    public Stereocode getStereocode() {
        return this.getBasetype().getStereocode();
    }

    public void setStereocode(Stereocode stereocode) {
        this.getBasetype().setStereocode(stereocode);
    }

    public String getStereoStr() {
        return this.getBasetype().getStereoStr();
    }

    public void setStereoStr(String stereoStr) {
        this.getBasetype().setStereoStr(stereoStr);
    }

    public String getStereoStrWithoutAnomeric() throws ResourcesDbException {
        return this.getBasetype().getStereoStrWithoutAnomeric();
    }

    public void setAnomerInStereocode() throws ResourcesDbException {
        this.getBasetype().setAnomerInStereocode();
    }

    public StereoConfiguration getAnomericReferenceConfiguration() throws ResourcesDbException {
        return this.getBasetype().getAnomericReferenceConfiguration();
    }

    public String getExtendedStereocodeStr() throws ResourcesDbException {
        if (this.hasUncertainCoremodificationPosition()) {
            throw new MonosaccharideException("Cannot generate extended stereocode for monosaccharide with uncertain core modification positions.");
        }
        String extStereo = this.getStereoStr();
        for (int pos = 1; pos <= extStereo.length(); ++pos) {
            if (!extStereo.substring(pos - 1, pos).equals(Character.valueOf('0'))) continue;
            ArrayList<CoreModificationTemplate> coreModList = this.getCoreModificationTemplatesByPosition(pos);
            if (coreModList.contains((Object)CoreModificationTemplate.ACID)) {
                Stereocode.setPositionInStereoString(extStereo, 'a', pos);
                continue;
            }
            if (coreModList.contains((Object)CoreModificationTemplate.SP2)) {
                Stereocode.setPositionInStereoString(extStereo, 's', pos);
                continue;
            }
            if (coreModList.contains((Object)CoreModificationTemplate.YN)) {
                Stereocode.setPositionInStereoString(extStereo, 'y', pos);
                continue;
            }
            if (coreModList.contains((Object)CoreModificationTemplate.EN) || coreModList.contains((Object)CoreModificationTemplate.ENX)) {
                if (coreModList.contains((Object)CoreModificationTemplate.DEOXY)) {
                    Stereocode.setPositionInStereoString(extStereo, 'e', pos);
                    continue;
                }
                if (coreModList.contains((Object)CoreModificationTemplate.EN) || MonosaccharideValidation.enDeoxyStatusPositionConfident(this, pos)) {
                    Stereocode.setPositionInStereoString(extStereo, 'n', pos);
                    continue;
                }
                Stereocode.setPositionInStereoString(extStereo, 'E', pos);
                continue;
            }
            if (coreModList.contains((Object)CoreModificationTemplate.DEOXY)) {
                Stereocode.setPositionInStereoString(extStereo, 'd', pos);
                continue;
            }
            if (pos == this.getRingStart() || coreModList.contains((Object)CoreModificationTemplate.KETO)) {
                Stereocode.setPositionInStereoString(extStereo, 'o', pos);
                continue;
            }
            if (pos == 1 || pos == this.getSize()) {
                Stereocode.setPositionInStereoString(extStereo, 'h', pos);
                continue;
            }
            throw new MonosaccharideException("extended stereocode builder: cannot resolve source of loss of stereochemistry at position " + pos);
        }
        return extStereo;
    }

    public List<CoreModification> getCoreModifications() {
        return this.getBasetype().getCoreModifications();
    }

    public boolean checkModificationPosition(CoreModification mod) throws MonosaccharideException {
        return this.getBasetype().checkModificationPosition(mod);
    }

    public boolean addCoreModification(CoreModification mod) throws MonosaccharideException {
        boolean valid = true;
        if (this.isCheckPositionsOnTheFly()) {
            valid = this.checkModificationPosition(mod);
        }
        if (valid) {
            this.getBasetype().addCoreModification(mod);
        }
        return valid;
    }

    public void deleteCoreModification(String name, int position) throws MonosaccharideException {
        this.getBasetype().deleteCoreModification(name, position);
    }

    public void deleteCoreModification(CoreModification mod) throws MonosaccharideException {
        this.getBasetype().deleteCoreModification(mod);
    }

    public void initCoreModifications() {
        this.getBasetype().initCoreModifications();
    }

    public List<Substitution> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(List<Substitution> substList) {
        this.substitutions = substList;
    }

    public void addSubstitution(String name, int position) throws ResourcesDbException {
        Substitution subst = new Substitution(name, position, this.getTemplateContainer());
        this.addSubstitution(subst);
    }

    public void addSubstitution(String name, int position1, int position2) throws ResourcesDbException {
        Substitution subst = new Substitution(name, position1, position2, this.getTemplateContainer());
        this.addSubstitution(subst);
    }

    public void addSubstitution(Substitution subst) throws MonosaccharideException {
        if (this.isCheckPositionsOnTheFly()) {
            for (Integer posInt : subst.getPositions()) {
                if (MonosaccharideValidation.isSubstitutable(this, posInt, subst.getLinkagetype1())) continue;
                if (posInt.intValue() == this.getRingEnd() && subst.getTemplate().isCanReplaceRingOxygen()) {
                    if (this.getSubstitutionsByPosition(posInt).size() <= 0) continue;
                    throw new MonosaccharideException("Cannot add substitution " + posInt + subst.getName() + ": position not subsitutable");
                }
                throw new MonosaccharideException("Cannot add substitution " + posInt + subst.getName() + ": position not subsitutable");
            }
        }
        subst.setModificationId(this.getNextModificationId());
        this.getSubstitutions().add(subst);
        this.sortSubstitutions();
    }

    public void addSeparateDisplaySubstitution(Substitution subst, GlycanNamescheme scheme, SubstituentTemplateContainer stContainer, boolean nameBasedMerge) throws ResourcesDbException {
        boolean substMerged = false;
        if (subst.getIntValuePosition1() == 0) {
            if (subst.getPosition1().size() > 1) {
                for (Integer posInt : subst.getPosition1()) {
                    if (this.getSubstitution(null, posInt, subst.getLinkagetype1()) == null) continue;
                    throw new MonosaccharideException("Cannot add separate substitutent with uncertain position to a residue, which is already substituted");
                }
            }
        } else {
            Integer posInt = subst.getPosition1().get(0);
            Substitution presentSubst = this.getSubstitution(null, posInt, subst.getLinkagetype1());
            if (presentSubst == null) {
                LinkageType linktype = null;
                if (subst.getLinkagetype1().equals((Object)LinkageType.H_AT_OH)) {
                    linktype = LinkageType.DEOXY;
                }
                if (linktype != null) {
                    presentSubst = this.getSubstitution(null, posInt, linktype);
                }
            }
            if (presentSubst != null) {
                if (presentSubst != null && presentSubst.isHasSeparateDisplayPart()) {
                    throw new MonosaccharideException("Cannot add separate display substituent at a position, which holds already a separate display substituent");
                }
                if (nameBasedMerge) {
                    String presentSubstName = presentSubst.getSourceName();
                    String separateSubstName = subst.getSourceName();
                    if (!scheme.isCaseSensitive()) {
                        presentSubstName = presentSubstName.toLowerCase();
                        separateSubstName = separateSubstName.toLowerCase();
                    }
                    for (SubstituentTemplate substTmpl : stContainer.getTemplateList()) {
                        for (SubstituentAlias substAlias : substTmpl.getAliasList(scheme, presentSubst.getLinkagetype1())) {
                            String aliasSeparateName;
                            String aliasIncludedName = substAlias.getResidueIncludedName();
                            if (aliasIncludedName == null || (aliasSeparateName = substAlias.getSeparateDisplayName()) == null) continue;
                            if (!scheme.isCaseSensitive()) {
                                aliasIncludedName = aliasIncludedName.toLowerCase();
                                aliasSeparateName = aliasSeparateName.toLowerCase();
                            }
                            if (!aliasIncludedName.equals(presentSubstName) || !aliasSeparateName.equals(separateSubstName)) continue;
                            presentSubst.setTemplate(substAlias.getPrimaryTemplate());
                            presentSubst.setHasSeparateDisplayPart(true);
                            substMerged = true;
                            break;
                        }
                        if (!substMerged) continue;
                        break;
                    }
                } else {
                    for (SubstituentTemplate substTmpl : stContainer.getTemplateList()) {
                        if (substTmpl.getSubparts() == null) continue;
                        SubstituentSubpartTreeNode subpartsRoot = substTmpl.getSubparts();
                        SubstituentTemplate rootTmpl = subpartsRoot.getSubstTmpl(stContainer);
                        if (rootTmpl == null) {
                            throw new ResourcesDbException("Error in subparts of substTemplate " + substTmpl.getName() + ": cannot assign template for subpart " + subpartsRoot.getName());
                        }
                        if (!rootTmpl.equals(presentSubst.getTemplate()) || subpartsRoot.getChildCount() != 1) continue;
                        SubstituentSubpartTreeNode subpartsNode = (SubstituentSubpartTreeNode)subpartsRoot.getFirstChild();
                        SubstituentTemplate nodeTmpl = subpartsNode.getSubstTmpl(stContainer);
                        if (nodeTmpl == null) {
                            throw new ResourcesDbException("Error in subparts of substTemplate " + substTmpl.getName() + ": cannot assign template for subpart " + subpartsNode.getName());
                        }
                        if (!nodeTmpl.equals(subst.getTemplate()) || subpartsNode.getChildCount() != 0) continue;
                        presentSubst.setTemplate(substTmpl);
                        presentSubst.setHasSeparateDisplayPart(true);
                        substMerged = true;
                        break;
                    }
                }
                if (!substMerged) {
                    throw new MonosaccharideException("Cannot add separate display substitution: position already substituted and substituents cannot be merged");
                }
            }
        }
        if (!substMerged) {
            subst.setHasSeparateDisplayPart(true);
            this.addSubstitution(subst);
        }
        this.sortSubstitutions();
    }

    public Modification getModificationById(int modId) throws MonosaccharideException {
        for (CoreModification mod : this.getCoreModifications()) {
            if (mod.getModificationId() != modId) continue;
            return mod;
        }
        for (Substitution subst : this.getSubstitutions()) {
            if (subst.getModificationId() != modId) continue;
            return subst;
        }
        throw new MonosaccharideException("modification id " + modId + " not found.");
    }

    public void sortModifications() {
        this.sortCoreModifications();
        this.sortSubstitutions();
    }

    public void sortSubstitutions() {
        List<Substitution> substList = this.getSubstitutions();
        for (int i = 0; i < substList.size(); ++i) {
            for (int j = substList.size() - 1; j > 0; --j) {
                if (substList.get(j).makeCmpString().compareTo(substList.get(j - 1).makeCmpString()) >= 0) continue;
                Substitution tmpMod = substList.get(j - 1);
                substList.set(j - 1, substList.get(j));
                substList.set(j, tmpMod);
            }
        }
    }

    public void sortCoreModifications() {
        if (this.getBasetype() != null) {
            this.getBasetype().sortCoreModifications();
        }
    }

    public void setUronic() throws MonosaccharideException {
        CoreModification mod = new CoreModification();
        mod.setModification(CoreModificationTemplate.ACID, this.getSize());
        this.addCoreModification(mod);
    }

    public boolean isUronic() {
        return this.getBasetype().isUronic();
    }

    public void setAldonic() throws MonosaccharideException {
        this.getBasetype().setAldonic();
    }

    public boolean isAldonic() {
        return this.getBasetype().isAldonic();
    }

    public void setAldaric() throws MonosaccharideException {
        this.getBasetype().setAldaric();
    }

    public boolean isAldaric() {
        return this.getBasetype().isAldaric();
    }

    public boolean hasDoubleBond(int pos) {
        return this.getBasetype().hasDoubleBond(pos);
    }

    public int countSubstitutions() {
        return this.getSubstitutions().size();
    }

    public int countCoreModifications() {
        return this.getBasetype().countCoreModifications();
    }

    public int countCoreModifications(String name) {
        return this.getBasetype().countCoreModifications(name);
    }

    public int countCoreModifications(CoreModificationTemplate tmpl) {
        return this.getBasetype().countCoreModifications(tmpl);
    }

    public int countSubstitutions(String name) {
        int count = 0;
        for (Substitution subst : this.getSubstitutions()) {
            if (!subst.getName().equals(name)) continue;
            ++count;
        }
        return count;
    }

    public ArrayList<Integer> getStereolossPositions() {
        List<CoreModification> modifications = this.getCoreModifications();
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int i = 0; i < modifications.size(); ++i) {
            CoreModification mod = modifications.get(i);
            if (!mod.getTemplate().isStereoLoss() || mod.getTemplate().equals((Object)CoreModificationTemplate.DEOXY) && this.getSubstitution(null, mod.getIntValuePosition1(), LinkageType.H_LOSE) != null) continue;
            ArrayList<Integer> modPositions = mod.getPositions();
            for (int p = 0; p < modPositions.size(); ++p) {
                Integer pos = modPositions.get(p);
                if (positions.contains(pos)) continue;
                positions.add(pos);
            }
        }
        Collections.sort(positions);
        return positions;
    }

    public boolean isStereolossPosition(int pos) {
        return this.getBasetype().isStereolossPosition(pos);
    }

    public boolean isStereolossPositionWithIgnoreType(int pos, CoreModificationTemplate ignoreTemplate) {
        return this.getBasetype().isStereolossPositionWithIgnoreType(pos, ignoreTemplate);
    }

    public ArrayList<Substitution> getSubstitutionsByPosition(int position) {
        List<Substitution> substitutions = this.getSubstitutions();
        ArrayList<Substitution> substOut = new ArrayList<Substitution>();
        if (substitutions != null) {
            Integer positionInt = new Integer(position);
            for (Substitution subst : substitutions) {
                if (!subst.getPositions().contains(positionInt)) continue;
                substOut.add(subst);
            }
        }
        return substOut;
    }

    public Substitution getSubstitution(String name, int position, LinkageType linktype) {
        for (Substitution subst : this.getSubstitutions()) {
            if (name != null && !subst.getName().equals(name)) continue;
            if (subst.containsPosition1(position) && (linktype == null || subst.getLinkagetype1().equals((Object)linktype))) {
                return subst;
            }
            if (!subst.containsPosition2(position) || linktype != null && !subst.getLinkagetype2().equals((Object)linktype)) continue;
            return subst;
        }
        return null;
    }

    public ArrayList<CoreModification> getCoreModificationsByPosition(int position) {
        return this.getBasetype().getCoreModificationsByPosition(position);
    }

    public ArrayList<CoreModificationTemplate> getCoreModificationTemplatesByPosition(int position) {
        return this.getBasetype().getCoreModificationTemplatesByPosition(position);
    }

    public ArrayList<Modification> getModifications(int position) {
        ArrayList<Modification> outList = new ArrayList<Modification>();
        ArrayList<Substitution> substList = this.getSubstitutionsByPosition(position);
        for (Substitution subst : substList) {
            outList.add(subst);
        }
        ArrayList<CoreModification> coremodList = this.getCoreModificationsByPosition(position);
        for (CoreModification mod : coremodList) {
            outList.add(mod);
        }
        return outList;
    }

    public ArrayList<CoreModification> getCoreModifications(String name) {
        return this.getBasetype().getCoreModifications(name);
    }

    public ArrayList<CoreModification> getCoreModifications(CoreModificationTemplate tmpl) {
        return this.getBasetype().getCoreModifications(tmpl);
    }

    public CoreModification getCoreModification(String name, int position) {
        return this.getBasetype().getCoreModification(name, position);
    }

    public CoreModification getCoreModification(CoreModificationTemplate tmpl, int position) {
        return this.getBasetype().getCoreModification(tmpl, position);
    }

    public ArrayList<CoreModification> getEnModifications() {
        return this.getBasetype().getEnModifications();
    }

    public boolean hasCoreModification(CoreModification mod) {
        return this.getBasetype().hasCoreModification(mod);
    }

    public boolean hasCoreModification(CoreModificationTemplate tmpl, int position) {
        return this.getBasetype().hasCoreModification(tmpl, position);
    }

    public boolean hasCoreModification(CoreModificationTemplate tmpl) {
        return this.getBasetype().hasCoreModification(tmpl);
    }

    public boolean hasSubstitution(Substitution subst) {
        for (Substitution presentSubst : this.getSubstitutions()) {
            if (!presentSubst.equals(subst)) continue;
            return true;
        }
        return false;
    }

    public boolean hasUncertainModificationPosition() {
        return this.hasUncertainCoremodificationPosition() || this.hasUncertainSubstitutionPosition();
    }

    public boolean hasUncertainCoremodificationPosition() {
        return this.getBasetype().hasUncertainCoremodificationPosition();
    }

    public boolean hasUncertainSubstitutionPosition() {
        for (Substitution subst : this.getSubstitutions()) {
            if (!subst.hasUncertainLinkagePosition()) continue;
            return true;
        }
        return false;
    }

    public void mirrorCoreModificationPositions() {
        this.getBasetype().mirrorCoreModificationPositions();
    }

    public void mirrorSubstitutionPositions() {
        for (Substitution subst : this.getSubstitutions()) {
            ArrayList<Integer> positions1 = subst.getPosition1();
            for (int i = 0; i < positions1.size(); ++i) {
                int pos = positions1.get(i);
                if (pos <= 0) continue;
                pos = this.getSize() + 1 - pos;
                positions1.set(i, new Integer(pos));
            }
            ArrayList<Integer> positions2 = subst.getPosition2();
            for (int i = 0; i < positions2.size(); ++i) {
                int pos = positions2.get(i);
                if (pos <= 0) continue;
                pos = this.getSize() + 1 - pos;
                positions2.set(i, new Integer(pos));
            }
            subst.setPosition1(positions1);
            subst.setPosition2(positions2);
            subst.sortPositions();
        }
    }

    public ArrayList<Integer> getExtendablePositions() {
        ArrayList<Integer> extPosList = new ArrayList<Integer>();
        for (int i = 1; i <= this.getSize(); ++i) {
            if (!MonosaccharideValidation.isSubstitutable(this, i, LinkageType.H_AT_OH)) continue;
            extPosList.add(new Integer(i));
        }
        return extPosList;
    }

    public void rotateAlditol() {
        this.getStereocode().rotate();
        this.mirrorCoreModificationPositions();
        this.mirrorSubstitutionPositions();
        this.setConfiguration(Stereocode.getConfigurationFromStereoString(this.getStereoStr()));
        this.invertOrientationChanged();
    }

    public boolean isSuperclass() {
        try {
            for (StereoConfiguration stereoConf : this.getStereocode().toConfigurationList()) {
                if (stereoConf == StereoConfiguration.Unknown || stereoConf == StereoConfiguration.Nonchiral) continue;
                return false;
            }
        }
        catch (ResourcesDbException rex) {
            return false;
        }
        if (!this.getAnomer().equals((Object)Anomer.UNKNOWN)) {
            return false;
        }
        return this.getRingStart() == 0 && this.getRingEnd() == 0;
    }

    public void setPossibleLinkingPositions(List<MonosaccharideLinkingPosition> posList) {
        this.possibleLinkingPositions = posList;
    }

    public List<MonosaccharideLinkingPosition> getPossibleLinkingPositions() {
        if (this.possibleLinkingPositions == null) {
            this.setPossibleLinkingPositions(MonosaccharideDataBuilder.buildPossibleLinkagePositions(this));
        }
        return this.possibleLinkingPositions;
    }

    public List<MonosaccharideSynonym> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(List<MonosaccharideSynonym> synonymsList) {
        this.synonyms = synonymsList;
    }

    public boolean addSynonym(MonosaccharideSynonym alias) {
        return this.addSynonym(alias, false);
    }

    public boolean addSynonym(MonosaccharideSynonym alias, boolean replacePrimary) {
        if (this.getSynonyms() == null) {
            this.setSynonyms(new ArrayList<MonosaccharideSynonym>());
        }
        for (int i = 0; i < this.getSynonyms().size(); ++i) {
            MonosaccharideSynonym exstAlias = this.getSynonyms().get(i);
            if (!exstAlias.getNamescheme().equals((Object)alias.getNamescheme())) continue;
            if (exstAlias.equals(alias)) {
                System.out.println("Monosaccharide.addSynonym(): Alias already present.");
                return false;
            }
            if (!alias.isPrimary()) continue;
            if (exstAlias.isPrimary()) {
                if (replacePrimary) {
                    this.getSynonyms().set(i, alias);
                    return true;
                }
                System.out.println("Warning: Could not add primary alias for name scheme " + alias.getNameschemeStr() + " to " + this.getName() + " - primary alias already present (1).");
                System.out.println("  exst: " + exstAlias.toString());
                System.out.println("  new:  " + alias.toString());
                return false;
            }
            if (!alias.equalsIgnoreBooleans(exstAlias)) continue;
            if (this.hasPrimaryAlias(alias.getNamescheme())) {
                if (replacePrimary) {
                    int k = i + 1;
                    if (k >= this.getSynonyms().size()) continue;
                    if (this.getSynonyms().get(k).isPrimary()) {
                        this.getSynonyms().get(k).setIsPrimary(false);
                    }
                    this.getSynonyms().set(i, alias);
                    return true;
                }
                System.out.println("Warning: Could not add primary alias for name scheme " + alias.getNameschemeStr() + " to " + this.getName() + " - primary alias already present (2).");
                return false;
            }
            this.getSynonyms().set(i, alias);
            return true;
        }
        this.getSynonyms().add(alias);
        return true;
    }

    public void addSynonyms(List<MonosaccharideSynonym> aliasList, boolean replacePrimary) {
        if (aliasList != null) {
            for (MonosaccharideSynonym alias : aliasList) {
                if (alias == null) continue;
                this.addSynonym(alias, replacePrimary);
            }
        }
    }

    public boolean hasPrimaryAlias(GlycanNamescheme scheme) {
        if (this.getSynonyms() != null) {
            for (MonosaccharideSynonym alias : this.getSynonyms()) {
                if (!alias.getNamescheme().equals((Object)scheme) || !alias.isPrimary()) continue;
                return true;
            }
        }
        return false;
    }

    public void buildName() throws ResourcesDbException {
        this.getBasetype().buildName();
        GlycoCTExporter msdbexp = new GlycoCTExporter(GlycanNamescheme.MONOSACCHARIDEDB, this.getConfig(), this.getTemplateContainer());
        this.setName(msdbexp.export(this));
    }

    public void initSynonyms() {
        if (this.getSynonyms() == null) {
            this.setSynonyms(new ArrayList<MonosaccharideSynonym>());
        } else {
            this.getSynonyms().clear();
        }
    }

    public String getPrimaryAliasName(GlycanNamescheme scheme) throws ResourcesDbException {
        return this.getPrimaryAliasObject(scheme).getName();
    }

    public MonosaccharideSynonym getPrimaryAliasObject(GlycanNamescheme scheme) throws ResourcesDbException {
        if (this.getSynonyms() == null) {
            MonosaccharideDataBuilder.buildSynonyms(this, this.getTemplateContainer());
        }
        if (this.getSynonyms() == null) {
            throw new MonosaccharideException("Cannot build monosaccharide synonyms.");
        }
        for (MonosaccharideSynonym alias : this.getSynonyms()) {
            if (!alias.getNamescheme().equals((Object)scheme) || !alias.isPrimary()) continue;
            return alias;
        }
        throw new MonosaccharideException("No primary monosaccharide alias defined for notation scheme " + scheme.getNameStr());
    }

    public MonosaccharideSynonym getCarbbankAlias() {
        try {
            return this.getPrimaryAliasObject(GlycanNamescheme.CARBBANK);
        }
        catch (ResourcesDbException me) {
            return null;
        }
    }

    public boolean hasAliasWithResidueExcludedSubst() {
        if (this.getSynonyms() != null) {
            for (MonosaccharideSynonym alias : this.getSynonyms()) {
                if (alias.getExternalSubstList().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public void buildSynonyms() {
        MonosaccharideDataBuilder.buildSynonyms(this, this.getTemplateContainer());
    }

    public void calculateMassesFromComposition() throws ResourcesDbException {
        if (this.getComposition() == null) {
            MonosaccharideDataBuilder.buildComposition(this);
        }
        this.setMonoMass(this.getComposition().getMonoMass());
        this.setAvgMass(this.getComposition().getAvgMass());
    }

    public void buildRepresentations() {
        if (this.getRingtype().equals((Object)Ringtype.OPEN)) {
            MonosaccharideDataBuilder.addFischerRepresentations(this);
        } else {
            MonosaccharideDataBuilder.addHaworthRepresentations(this);
        }
    }

    public void updateRepresentations() {
        if (this.getRingtype().equals((Object)Ringtype.OPEN)) {
            MonosaccharideDataBuilder.updateFischerRepresentations(this);
        } else {
            MonosaccharideDataBuilder.updateHaworthRepresentations(this);
        }
    }

    public int getHaworthImageId(ResidueRepresentationFormat format) {
        ResidueRepresentation monoRep = null;
        monoRep = this.getRepresentation(ResidueRepresentationType.HAWORTH, format);
        if (monoRep != null) {
            return monoRep.getDbId();
        }
        return 0;
    }

    public boolean hasHaworth(ResidueRepresentationFormat format) {
        ResidueRepresentation monoRep = this.getRepresentation(ResidueRepresentationType.HAWORTH, format);
        return monoRep != null;
    }

    public boolean hasHaworth() {
        return this.hasHaworth(null);
    }

    public int getFischerImageId(ResidueRepresentationFormat format) {
        ResidueRepresentation monoRep = null;
        monoRep = this.getRepresentation(ResidueRepresentationType.FISCHER, format);
        if (monoRep != null) {
            return monoRep.getDbId();
        }
        return 0;
    }

    public boolean hasFischer(ResidueRepresentationFormat format) {
        ResidueRepresentation monoRep = this.getRepresentation(ResidueRepresentationType.FISCHER, format);
        return monoRep != null;
    }

    public boolean hasFischer() {
        return this.hasFischer(null);
    }

    public int getCfgImageId(ResidueRepresentationFormat format) {
        ResidueRepresentation monoRep = null;
        monoRep = this.getRepresentation(ResidueRepresentationType.CFG_SYMBOL, format);
        if (monoRep != null) {
            return monoRep.getDbId();
        }
        return 0;
    }

    public int getCfgBwImageId(ResidueRepresentationFormat format) {
        ResidueRepresentation monoRep = null;
        monoRep = this.getRepresentation(ResidueRepresentationType.CFG_SYMBOL_BW, format);
        if (monoRep != null) {
            return monoRep.getDbId();
        }
        return 0;
    }

    public int getOxfordImageId(ResidueRepresentationFormat format) {
        ResidueRepresentation monoRep = null;
        monoRep = this.getRepresentation(ResidueRepresentationType.OXFORD_SYMBOL, format);
        if (monoRep != null) {
            return monoRep.getDbId();
        }
        return 0;
    }

    public boolean hasRepresentation(ResidueRepresentationType type, ResidueRepresentationFormat format) {
        for (ResidueRepresentation monoRep : this.getRepresentations()) {
            if (type != null && !type.equals((Object)monoRep.getType()) || format != null && !format.equals((Object)monoRep.getFormat())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getImageId(ResidueRepresentationFormat format) {
        int imgId = 0;
        imgId = this.getHaworthImageId(format);
        if (imgId != 0) {
            return imgId;
        }
        imgId = this.getFischerImageId(format);
        if (imgId != 0) {
            return imgId;
        }
        imgId = this.getOxfordImageId(format);
        if (imgId != 0) {
            return imgId;
        }
        imgId = this.getCfgImageId(format);
        if (imgId != 0) {
            return imgId;
        }
        imgId = this.getCfgBwImageId(format);
        if (imgId != 0) {
            return imgId;
        }
        for (ResidueRepresentation rep : this.getRepresentations()) {
            if (!rep.getType().getFormatType().equals("graphic") || format != null && !format.equals((Object)rep.getFormat())) continue;
            return rep.getDbId();
        }
        return imgId;
    }

    public boolean hasFragmentData() {
        return false;
    }

    public boolean hasNmrData() {
        return false;
    }

    public void init(Basetype bt) {
        super.init();
        this.setBasetype(bt);
        this.setSubstitutions(new ArrayList<Substitution>());
        this.setFuzzy(false);
        this.setOrientationChanged(false);
    }

    @Override
    public void init() {
        this.init(new Basetype(this.getConfig(), this.getTemplateContainer()));
    }

    public void init(TrivialnameTemplate trivTmpl) throws MonosaccharideException {
        super.init();
        Anomer tmpAnom = this.getAnomer();
        List<CoreModification> tmpCoreMods = this.getCoreModifications();
        this.setBasetype(new Basetype(this.getConfig(), this.getTemplateContainer()));
        this.setSize(trivTmpl.getSize());
        this.setDefaultCarbonylPosition(trivTmpl.getCarbonylPosition());
        for (CoreModification coremod : trivTmpl.getCoreModifications()) {
            this.addCoreModification(coremod.clone());
        }
        this.setAnomer(tmpAnom);
        for (CoreModification mod : tmpCoreMods) {
            if (this.hasCoreModification(mod)) continue;
            this.addCoreModification(mod);
        }
        for (Substitution subst : trivTmpl.getSubstitutions()) {
            this.addSubstitution(subst.clone());
        }
    }

    public String toString() {
        String outStr = "";
        outStr = outStr + "[Name: " + this.getName() + "; ";
        String basetypeStr = "Basetype: null";
        if (this.getBasetype() != null) {
            basetypeStr = this.getBasetype().toString();
        }
        String substStr = "";
        if (this.getSubstitutions() != null) {
            for (Substitution subst : this.getSubstitutions()) {
                substStr = substStr + subst.toString();
            }
        }
        outStr = outStr + "" + basetypeStr + "; ";
        outStr = outStr + "Substitutions: [" + substStr + "]";
        outStr = outStr + "]";
        return outStr;
    }

    public boolean equals(Object anotherMs) {
        if (anotherMs == null) {
            return false;
        }
        if (!anotherMs.getClass().equals(Monosaccharide.class)) {
            return false;
        }
        Monosaccharide compareMs = (Monosaccharide)anotherMs;
        try {
            this.buildName();
            compareMs.buildName();
            if (!this.getName().equals(compareMs.getName())) {
                return false;
            }
        }
        catch (ResourcesDbException rEx) {
            return false;
        }
        return true;
    }
}

