/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.applications.ms.glycopeakfinder.calculation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.ParameterException;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.AnnotationEntity;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationDerivatisation;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationFragment;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationIon;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationMolecule;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationParameter;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationPeak;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.PeakAnnotation;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.ResidueSpecial;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.Scan;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.SpectraType;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.util.ComparatorCalculationPeak;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.util.ComparatorMolecule;

public class GlycoPeakfinder {
    double m_dNonReducingFragmentAbzug = 0.0;
    double m_dMassExchangeIon = 0.0;
    double m_dMinResidueMass = 0.0;
    double m_dChargeCount = 1.0;
    int m_iMaxChargeCount = 0;
    int m_iMaxExchangeCount = 0;
    int m_iMaxFragmentCount = 0;
    int m_iMaxAnnotationCount = 0;
    CalculationParameter m_objParameter = null;
    double m_dErgaenzungRed = 0.0;
    double m_dErgaenzungNonRed = 0.0;
    double m_dMassShift = 0.0;
    ArrayList<CalculationDerivatisation> m_aDerivates = null;
    ArrayList<ResidueSpecial> m_aResidues = null;
    ArrayList<CalculationIon> m_aIons = null;
    ArrayList<CalculationIon> m_aExchangeIons = null;
    ArrayList<CalculationFragment> m_aFragmentsRed = null;
    ArrayList<CalculationFragment> m_aFragmentsNonRed = null;
    ArrayList<CalculationMolecule> m_aGain = null;
    ArrayList<CalculationMolecule> m_aLoss = null;
    ArrayList<CalculationPeak> m_aPeakListFragmented = new ArrayList();
    ArrayList<CalculationPeak> m_aPeakListProfile = new ArrayList();
    ArrayList<CalculationPeak> m_aPeakListCalculation = new ArrayList();
    boolean[] m_bIons = null;
    boolean[] m_bFragments = null;
    boolean[] m_bIonExchange = null;
    PeakAnnotation m_objAnnotation = new PeakAnnotation();
    ArrayList<String> m_aGainIDs = new ArrayList();
    int m_iMinResidueCount = 0;
    private boolean m_bLowestDeviation = false;
    private boolean m_bNegativeResidueMass = false;
    private double m_dMaxPeakMass = 0.0;

    public void setStoreOnlyLowestDeviation(boolean bl) {
        this.m_bLowestDeviation = bl;
    }

    public boolean getStoreOnlyLowestDeviation() {
        return this.m_bLowestDeviation;
    }

    protected void testParameter() throws ParameterException {
        int n;
        this.m_dMassExchangeIon = this.m_objParameter.getExchangeIonMass();
        this.m_dNonReducingFragmentAbzug = this.m_objParameter.getNonReducingDifference();
        this.m_dErgaenzungRed = this.m_objParameter.getCompletionRed();
        this.m_dErgaenzungNonRed = this.m_objParameter.getCompletionNonRed();
        this.m_dMassShift = this.m_objParameter.getMassShift();
        this.m_iMaxAnnotationCount = this.m_objParameter.getMaxAnnotationPerPeak();
        this.m_aDerivates = this.m_objParameter.getDerivatisation();
        if (this.m_aDerivates == null) {
            throw new ParameterException("Modification at the reducing end must be given.");
        }
        if (this.m_aDerivates.size() == 0) {
            throw new ParameterException("Modification at the reducing end must be given.");
        }
        this.m_bNegativeResidueMass = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.m_aResidues = new ArrayList();
        for (CalculationMolecule calculationMolecule : this.m_objParameter.getResidues()) {
            if (calculationMolecule.getMin() < 0 || calculationMolecule.getMax() <= 0) {
                throw new ParameterException("Min and Max of residue " + calculationMolecule.getId() + " must be larger than 0.");
            }
            if (calculationMolecule.getMin() > calculationMolecule.getMax()) {
                throw new ParameterException("Min of residue " + calculationMolecule.getId() + " must be larger than Max.");
            }
            if (arrayList2.contains(calculationMolecule.getId())) {
                throw new ParameterException("Duplicated residue id : " + calculationMolecule.getId() + ".");
            }
            if (calculationMolecule.getMass() < 0.0) {
                this.m_bNegativeResidueMass = true;
            }
            arrayList2.add(calculationMolecule.getId());
            ResidueSpecial object2 = new ResidueSpecial(calculationMolecule);
            object2.m_iCurrent = object2.getMin();
            this.m_aResidues.add(object2);
        }
        if (this.m_aResidues.size() == 0) {
            throw new ParameterException("At least one residue must be set.");
        }
        ComparatorMolecule comparatorMolecule = new ComparatorMolecule();
        Collections.sort(this.m_aResidues, comparatorMolecule);
        arrayList.clear();
        for (CalculationIon calculationIon : this.m_objParameter.getIons()) {
            if (calculationIon.getCharge() < 1) {
                throw new ParameterException("Charge of ion " + calculationIon.getId() + "must be greater than 0.");
            }
            if (arrayList.contains(calculationIon.getId())) {
                throw new ParameterException("Duplicated ion id : " + calculationIon.getId() + ".");
            }
            if (calculationIon.getMass() < -1.5) {
                throw new ParameterException("Mass of ion " + calculationIon.getId() + " must be greater than -1.5.");
            }
            arrayList.add(calculationIon.getId());
        }
        this.m_aIons = this.m_objParameter.getIons();
        if (this.m_aIons.size() == 0) {
            throw new ParameterException("At least one ion must be set.");
        }
        arrayList.clear();
        for (CalculationIon calculationIon : this.m_objParameter.getIonExchangeIon()) {
            if (calculationIon.getCharge() < 1) {
                throw new ParameterException("Charge of ion exchange ion " + calculationIon.getId() + "must be greater than 0.");
            }
            if (arrayList.contains(calculationIon.getId())) {
                throw new ParameterException("Duplicated ion exchange ion id : " + calculationIon.getId() + ".");
            }
            if (calculationIon.getMass() <= 0.0) {
                throw new ParameterException("Mass of ion exchange ion " + calculationIon.getId() + " must be greater than 0.");
            }
            arrayList.add(calculationIon.getId());
        }
        this.m_aExchangeIons = this.m_objParameter.getIonExchangeIon();
        if (this.m_objParameter.getSpectraType() != SpectraType.Profile) {
            this.m_iMaxFragmentCount = n = this.m_objParameter.getMaxFragments();
            if (n <= 0) {
                throw new ParameterException("Fragmentation level must be set (1-...).");
            }
            this.m_bFragments = new boolean[n + 1];
            for (Integer n2 : this.m_objParameter.getMultiFragments()) {
                if (n2 > 0) {
                    this.m_bFragments[n2.intValue()] = true;
                    continue;
                }
                throw new ParameterException("Number of fragmentation must be larger than 0.");
            }
        }
        if ((n = this.m_objParameter.getMaxCharges()) <= 0) {
            throw new ParameterException("Charge state must be set (1-...).");
        }
        this.m_iMaxChargeCount = n;
        this.m_bIons = new boolean[n + 1];
        for (Integer n2 : this.m_objParameter.getCharges()) {
            if (n2 > 0) {
                this.m_bIons[n2.intValue()] = true;
                continue;
            }
            throw new ParameterException("Number of charges must be larger than 0.");
        }
        if (this.m_aExchangeIons.size() != 0) {
            n = this.m_objParameter.getMaxIonExchange();
            if (n <= 0) {
                throw new ParameterException("Number of ion exchanges must be largen than 0.");
            }
            this.m_iMaxExchangeCount = n;
            this.m_bIonExchange = new boolean[n + 1];
            for (Integer n2 : this.m_objParameter.getIonExchangeCount()) {
                if (n2 > 0) {
                    this.m_bIonExchange[n2.intValue()] = true;
                    continue;
                }
                throw new ParameterException("Number of ion exchanges must be larger than 0.");
            }
        }
        arrayList.clear();
        for (CalculationMolecule calculationMolecule : this.m_objParameter.getGainMolecules()) {
            if (calculationMolecule.getMin() < 0 || calculationMolecule.getMax() <= 0) {
                throw new ParameterException("Min and Max of gain molecule " + calculationMolecule.getId() + " must be larger than 0.");
            }
            if (calculationMolecule.getMin() > calculationMolecule.getMax()) {
                throw new ParameterException("Min of gain molecule " + calculationMolecule.getId() + " must be larger than Max.");
            }
            if (calculationMolecule.getMass() <= 0.0) {
                throw new ParameterException("Mass of gain molecule " + calculationMolecule.getId() + " must be larger than 0.");
            }
            if (arrayList.contains(calculationMolecule.getId())) {
                throw new ParameterException("Duplicated gain molecule id : " + calculationMolecule.getId() + ".");
            }
            arrayList.add(calculationMolecule.getId());
        }
        this.m_aGain = this.m_objParameter.getGainMolecules();
        arrayList.clear();
        for (CalculationMolecule calculationMolecule : this.m_objParameter.getLossMolecules()) {
            if (calculationMolecule.getMin() < 0 || calculationMolecule.getMax() <= 0) {
                throw new ParameterException("Min and Max of loss molecule " + calculationMolecule.getId() + " must be larger than 0.");
            }
            if (calculationMolecule.getMin() > calculationMolecule.getMax()) {
                throw new ParameterException("Min of loss molecule " + calculationMolecule.getId() + " must be larger than Max.");
            }
            if (calculationMolecule.getMass() <= 0.0) {
                throw new ParameterException("Mass of loss molecule " + calculationMolecule.getId() + " must be larger than 0.");
            }
            if (arrayList.contains(calculationMolecule.getId())) {
                throw new ParameterException("Duplicated loss molecule id : " + calculationMolecule.getId() + ".");
            }
            arrayList.add(calculationMolecule.getId());
        }
        this.m_aLoss = this.m_objParameter.getLossMolecules();
        if (this.m_objParameter.getSpectraType() != SpectraType.Profile) {
            arrayList.clear();
            for (CalculationFragment calculationFragment : this.m_objParameter.getFragmentsNonRed()) {
                if (arrayList.contains(calculationFragment.getId())) {
                    throw new ParameterException("Duplicated fragment id : " + calculationFragment.getId() + ".");
                }
                arrayList.add(calculationFragment.getId());
                if (calculationFragment.getResidueId() == null || arrayList2.contains(calculationFragment.getResidueId())) continue;
                throw new ParameterException("Residue for fragment : " + calculationFragment.getId() + " is not part of the residue list.");
            }
            this.m_aFragmentsNonRed = this.m_objParameter.getFragmentsNonRed();
            arrayList.clear();
            for (CalculationFragment calculationFragment : this.m_objParameter.getFragmentsRed()) {
                if (arrayList.contains(calculationFragment.getId())) {
                    throw new ParameterException("Duplicated fragment id : " + calculationFragment.getId() + ".");
                }
                arrayList.add(calculationFragment.getId());
                if (calculationFragment.getResidueId() == null || arrayList2.contains(calculationFragment.getResidueId())) continue;
                throw new ParameterException("Residue for fragment : " + calculationFragment.getId() + " is not part of the residue list.");
            }
            this.m_aFragmentsRed = this.m_objParameter.getFragmentsRed();
            if (this.m_aFragmentsNonRed.size() == 0 && this.m_aFragmentsRed.size() == 0) {
                throw new ParameterException("No fragments given.");
            }
        }
        if (this.m_objParameter.getAccuracy() < 0.0) {
            throw new ParameterException("Accuracy must be larger than 0.");
        }
        this.m_aPeakListFragmented = new ArrayList();
        this.m_aPeakListProfile = new ArrayList();
        if (this.m_objParameter.getSpectraType() == SpectraType.Profile) {
            if (this.m_objParameter.getScan().getSubScan().size() > 0) {
                throw new ParameterException("For spectrum type profile no sub scans are allowed.");
            }
            this.addScan(this.m_objParameter.getScan(), 1);
        } else if (this.m_objParameter.getSpectraType() == SpectraType.MS2) {
            if (this.m_objParameter.getScan().getPrecusorMass() == null) {
                throw new ParameterException("For spectrum type ms2 precursor mass has to be set.");
            }
            this.addScan(this.m_objParameter.getScan(), 2);
        } else if (this.m_objParameter.getSpectraType() == SpectraType.Fragmented) {
            this.addScan(this.m_objParameter.getScan(), 3);
        } else if (this.m_objParameter.getSpectraType() == SpectraType.MSxMS) {
            this.addScan(this.m_objParameter.getScan(), 1);
        }
        ComparatorCalculationPeak comparatorCalculationPeak = new ComparatorCalculationPeak();
        Collections.sort(this.m_aPeakListFragmented, comparatorCalculationPeak);
        Collections.sort(this.m_aPeakListProfile, comparatorCalculationPeak);
        if (this.m_aPeakListFragmented.size() == 0 && this.m_aPeakListProfile.size() == 0) {
            throw new ParameterException("At least one peak must be given.");
        }
        this.m_iMinResidueCount = 0;
        for (ResidueSpecial residueSpecial : this.m_aResidues) {
            this.m_dMinResidueMass += (double)residueSpecial.getMin() * residueSpecial.getMass();
            residueSpecial.m_iCurrent = residueSpecial.getMin();
            this.m_iMinResidueCount += residueSpecial.getMin();
            residueSpecial.m_iFragment = 0;
        }
    }

    private void addScan(Scan scan, int n) {
        if (this.m_objParameter.getAccuracyPpm()) {
            for (CalculationPeak calculationPeak : scan.getPeaks()) {
                calculationPeak.setAnnotation(new ArrayList<PeakAnnotation>());
                calculationPeak.calculateDeviationPpm(this.m_objParameter.getAccuracy());
                if (this.m_dMaxPeakMass < calculationPeak.maxMz()) {
                    this.m_dMaxPeakMass = calculationPeak.maxMz();
                }
                if (n == 1) {
                    this.m_aPeakListProfile.add(calculationPeak);
                    continue;
                }
                if (n == 2) {
                    this.m_aPeakListProfile.add(calculationPeak);
                    this.m_aPeakListFragmented.add(calculationPeak);
                    continue;
                }
                this.m_aPeakListFragmented.add(calculationPeak);
            }
        } else {
            for (CalculationPeak calculationPeak : scan.getPeaks()) {
                calculationPeak.setAnnotation(new ArrayList<PeakAnnotation>());
                calculationPeak.calculateDeviationU(this.m_objParameter.getAccuracy());
                if (this.m_dMaxPeakMass < calculationPeak.maxMz()) {
                    this.m_dMaxPeakMass = calculationPeak.maxMz();
                }
                if (n == 1) {
                    this.m_aPeakListProfile.add(calculationPeak);
                    continue;
                }
                if (n == 2 && calculationPeak.getMz() == scan.getPrecusorMass().doubleValue()) {
                    this.m_aPeakListProfile.add(calculationPeak);
                    continue;
                }
                this.m_aPeakListFragmented.add(calculationPeak);
            }
        }
        if (scan.getSubScan() != null) {
            Iterator<Object> iterator = scan.getSubScan().iterator();
            while (iterator.hasNext()) {
                this.addScan((Scan)iterator.next(), n + 1);
            }
        }
    }

    public CalculationParameter calculate(CalculationParameter calculationParameter) throws ParameterException {
        this.m_objParameter = calculationParameter;
        this.testParameter();
        this.m_objAnnotation = new PeakAnnotation();
        if (this.m_aPeakListProfile.size() > 0) {
            this.m_aPeakListCalculation = this.m_aPeakListProfile;
            this.calcDericatisation(this.m_dErgaenzungRed + this.m_dErgaenzungNonRed + this.m_dMassShift);
        }
        if (this.m_aPeakListFragmented.size() > 0) {
            this.m_aPeakListCalculation = this.m_aPeakListFragmented;
            this.calcFragmentReducing(this.m_dMassShift);
        }
        if (this.m_objParameter.getSpectraType() == SpectraType.MS2) {
            this.postProcessPreCursor(this.m_objParameter.getScan());
        } else if (this.m_objParameter.getSpectraType() == SpectraType.MSxMS) {
            Iterator<Scan> iterator = this.m_objParameter.getScan().getSubScan().iterator();
            while (iterator.hasNext()) {
                this.postProcessPreCursor(iterator.next());
            }
        }
        return this.m_objParameter;
    }

    private void postProcessPreCursor(Scan scan) {
        HashMap hashMap = new HashMap();
        for (CalculationPeak calculationPeak : scan.getPeaks()) {
            if (calculationPeak.getMz() != scan.getPrecusorMass().doubleValue()) continue;
            for (PeakAnnotation peakAnnotation : calculationPeak.getAnnotation()) {
                if (!peakAnnotation.profileAnnotation()) continue;
                hashMap.put(this.createCompositionString(peakAnnotation), null);
            }
        }
        for (CalculationPeak calculationPeak : scan.getPeaks()) {
            ArrayList arrayList = new ArrayList();
            for (PeakAnnotation peakAnnotation : calculationPeak.getAnnotation()) {
                if (!peakAnnotation.profileAnnotation() || hashMap.containsKey(this.createCompositionString(peakAnnotation))) continue;
                arrayList.add(peakAnnotation);
            }
            ArrayList<PeakAnnotation> arrayList2 = calculationPeak.getAnnotation();
            Iterator<PeakAnnotation> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                arrayList2.remove(iterator.next());
            }
        }
    }

    private String createCompositionString(PeakAnnotation peakAnnotation) {
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AnnotationEntity annotationEntity : peakAnnotation.getResidues()) {
            arrayList.add(String.format("%d%s", annotationEntity.getNumber(), annotationEntity.getId()));
        }
        Collections.sort(arrayList);
        Iterator<AnnotationEntity> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            string = string + (String)((Object)iterator.next());
        }
        return string;
    }

    private void calcDericatisation(double d) {
        for (CalculationDerivatisation calculationDerivatisation : this.m_aDerivates) {
            this.m_objAnnotation.setDerivatisation(calculationDerivatisation.getId());
            this.calcIon(d + calculationDerivatisation.getMass(), 0, 0, new ArrayList<AnnotationEntity>());
        }
        this.m_objAnnotation.setDerivatisation(null);
    }

    private void calcFragmentReducing(double d) throws ParameterException {
        ArrayList<AnnotationEntity> arrayList = new ArrayList<AnnotationEntity>();
        this.calcFragmentNonReducing(d, 0, 0, arrayList, 0);
        for (int i = 0; i < this.m_aFragmentsRed.size(); ++i) {
            CalculationFragment calculationFragment = this.m_aFragmentsRed.get(i);
            AnnotationEntity annotationEntity = new AnnotationEntity();
            annotationEntity.setId(calculationFragment.getId());
            annotationEntity.setNumber(1);
            arrayList.add(annotationEntity);
            if (calculationFragment.getResidueId() != null) {
                ResidueSpecial residueSpecial = this.findResidue(calculationFragment.getResidueId());
                ++residueSpecial.m_iCurrent;
                ++residueSpecial.m_iFragment;
                this.finishFragments(d + calculationFragment.getMass(), 1, 0, arrayList);
                this.calcFragmentNonReducing(d + calculationFragment.getMass(), 0, 1, arrayList, 0);
                --residueSpecial.m_iCurrent;
                --residueSpecial.m_iFragment;
            } else {
                this.finishFragments(d + calculationFragment.getMass(), 1, 0, arrayList);
                this.calcFragmentNonReducing(d + calculationFragment.getMass(), 0, 1, arrayList, 0);
            }
            arrayList.remove(annotationEntity);
        }
    }

    private void calcFragmentNonReducing(double d, int n, int n2, ArrayList<AnnotationEntity> arrayList, int n3) throws ParameterException {
        AnnotationEntity annotationEntity = new AnnotationEntity();
        if (n2 < this.m_iMaxFragmentCount && n < this.m_aFragmentsNonRed.size()) {
            double d2 = d;
            int n4 = n3;
            CalculationFragment calculationFragment = this.m_aFragmentsNonRed.get(n);
            this.calcFragmentNonReducing(d2, n + 1, n2, arrayList, n4);
            arrayList.add(annotationEntity);
            annotationEntity.setId(calculationFragment.getId());
            if (calculationFragment.getResidueId() == null) {
                for (int i = n2 + 1; i <= this.m_iMaxFragmentCount; ++i) {
                    annotationEntity.setNumber(i - n2);
                    this.calcFragmentNonReducing(d2 += calculationFragment.getMass(), n + 1, i, arrayList, ++n4);
                    this.finishFragments(d2, i, n4, arrayList);
                }
            } else {
                ResidueSpecial residueSpecial = this.findResidue(calculationFragment.getResidueId());
                int n5 = residueSpecial.m_iCurrent;
                int n6 = residueSpecial.m_iFragment;
                for (int i = n2 + 1; i <= this.m_iMaxFragmentCount; ++i) {
                    ++residueSpecial.m_iCurrent;
                    ++residueSpecial.m_iFragment;
                    annotationEntity.setNumber(i - n2);
                    this.calcFragmentNonReducing(d2 += calculationFragment.getMass(), n + 1, i, arrayList, ++n4);
                    this.finishFragments(d2, i, n4, arrayList);
                }
                residueSpecial.m_iCurrent = n5;
                residueSpecial.m_iFragment = n6;
            }
            arrayList.remove(annotationEntity);
        }
    }

    private void finishFragments(double d, int n, int n2, ArrayList<AnnotationEntity> arrayList) {
        if (n > 0 && n <= this.m_iMaxFragmentCount && this.m_bFragments[n]) {
            double d2 = d;
            if (n == n2) {
                d2 += this.m_dErgaenzungRed;
            } else if (n2 == 0) {
                d2 += this.m_dErgaenzungNonRed;
            }
            if (n2 > 0) {
                d2 -= (double)(n2 - 1) * this.m_dNonReducingFragmentAbzug;
            }
            this.m_objAnnotation.setFragments(arrayList);
            if (n == n2) {
                this.calcDericatisation(d2);
            } else {
                this.calcIon(d2, 0, 0, new ArrayList<AnnotationEntity>());
            }
            this.m_objAnnotation.setFragments(new ArrayList<AnnotationEntity>());
        }
    }

    private void calcIon(double d, int n, int n2, ArrayList<AnnotationEntity> arrayList) {
        if (n2 < this.m_iMaxChargeCount && n < this.m_aIons.size()) {
            double d2 = d;
            CalculationIon calculationIon = this.m_aIons.get(n);
            this.calcIon(d2, n + 1, n2, arrayList);
            AnnotationEntity annotationEntity = new AnnotationEntity();
            annotationEntity.setId(calculationIon.getId());
            arrayList.add(annotationEntity);
            int n3 = n2;
            int n4 = 0;
            while (n3 <= this.m_iMaxChargeCount) {
                annotationEntity.setNumber(++n4);
                this.calcIon(d2 += calculationIon.getMass(), n + 1, n3 += calculationIon.getCharge().intValue(), arrayList);
                this.finishIons(d2, n3, arrayList);
            }
            arrayList.remove(annotationEntity);
        }
    }

    private void finishIons(double d, int n, ArrayList<AnnotationEntity> arrayList) {
        if (n > 0 && n <= this.m_iMaxChargeCount && this.m_bIons[n]) {
            this.m_dChargeCount = n;
            this.m_objAnnotation.setIons(arrayList);
            this.startCalcResidue(d + this.m_dMinResidueMass);
            this.calcGain(d + this.m_dMinResidueMass, 0, new ArrayList<AnnotationEntity>(), new ArrayList<String>());
            this.m_aGainIDs.clear();
            this.calcLoss(d + this.m_dMinResidueMass, 0, new ArrayList<AnnotationEntity>());
            this.calcIonExchange(d, 0, 0, new ArrayList<AnnotationEntity>());
        }
        this.m_objAnnotation.setIons(new ArrayList<AnnotationEntity>());
    }

    private void calcIonExchange(double d, int n, int n2, ArrayList<AnnotationEntity> arrayList) {
        if (n2 < this.m_iMaxExchangeCount && n < this.m_aExchangeIons.size()) {
            double d2 = d;
            CalculationIon calculationIon = this.m_aExchangeIons.get(n);
            this.calcIonExchange(d2, n + 1, n2, arrayList);
            AnnotationEntity annotationEntity = new AnnotationEntity();
            annotationEntity.setId(calculationIon.getId());
            arrayList.add(annotationEntity);
            for (int i = n2 + 1; i <= this.m_iMaxExchangeCount; ++i) {
                annotationEntity.setNumber(i - n2);
                this.calcIonExchange(d2 += calculationIon.getMass(), n + 1, i, arrayList);
                this.finishIonExchange(d2, i, arrayList);
            }
            arrayList.remove(annotationEntity);
        }
    }

    private void finishIonExchange(double d, int n, ArrayList<AnnotationEntity> arrayList) {
        if (n > 0 && n <= this.m_iMaxExchangeCount && this.m_bIonExchange[n]) {
            this.m_objAnnotation.setIonExchange(arrayList);
            this.startCalcResidue(d - (double)n * this.m_dMassExchangeIon + this.m_dMinResidueMass);
            this.calcGain(d - (double)n * this.m_dMassExchangeIon + this.m_dMinResidueMass, 0, new ArrayList<AnnotationEntity>(), new ArrayList<String>());
            this.calcLoss(d - (double)n * this.m_dMassExchangeIon + this.m_dMinResidueMass, 0, new ArrayList<AnnotationEntity>());
            this.m_objAnnotation.setIonExchange(new ArrayList<AnnotationEntity>());
        }
    }

    private void calcGain(double d, int n, ArrayList<AnnotationEntity> arrayList, ArrayList<String> arrayList2) {
        if (n < this.m_aGain.size()) {
            double d2 = d;
            CalculationMolecule calculationMolecule = this.m_aGain.get(n);
            this.calcGain(d2, n + 1, arrayList, arrayList2);
            int n2 = calculationMolecule.getMax() + 1;
            int n3 = calculationMolecule.getMin();
            if (n3 == 0) {
                n3 = 1;
            }
            AnnotationEntity annotationEntity = new AnnotationEntity();
            annotationEntity.setId(calculationMolecule.getId());
            arrayList2.add(calculationMolecule.getId());
            arrayList.add(annotationEntity);
            for (int i = n3; i < n2; ++i) {
                annotationEntity.setNumber(i);
                d2 = d + (double)i * calculationMolecule.getMass();
                this.finishGain(d2, arrayList, arrayList2);
                this.calcGain(d2, n + 1, arrayList, arrayList2);
            }
            arrayList2.remove(calculationMolecule.getId());
            arrayList.remove(annotationEntity);
        }
    }

    private void finishGain(double d, ArrayList<AnnotationEntity> arrayList, ArrayList<String> arrayList2) {
        if (arrayList.size() > 0) {
            this.m_objAnnotation.setGain(arrayList);
            this.startCalcResidue(d);
            this.m_aGainIDs = arrayList2;
            this.calcLoss(d, 0, new ArrayList<AnnotationEntity>());
            this.m_objAnnotation.setGain(new ArrayList<AnnotationEntity>());
            this.m_aGainIDs = new ArrayList();
        }
    }

    private void calcLoss(double d, int n, ArrayList<AnnotationEntity> arrayList) {
        if (n < this.m_aLoss.size()) {
            double d2 = d;
            CalculationMolecule calculationMolecule = this.m_aLoss.get(n);
            this.calcLoss(d2, n + 1, arrayList);
            if (!this.m_aGainIDs.contains(calculationMolecule.getId())) {
                int n2 = calculationMolecule.getMax() + 1;
                int n3 = calculationMolecule.getMin();
                if (n3 == 0) {
                    n3 = 1;
                }
                AnnotationEntity annotationEntity = new AnnotationEntity();
                annotationEntity.setId(calculationMolecule.getId());
                arrayList.add(annotationEntity);
                for (int i = n3; i < n2; ++i) {
                    annotationEntity.setNumber(i);
                    d2 = d - (double)i * calculationMolecule.getMass();
                    this.finishLoss(d2, arrayList);
                    this.calcLoss(d2, n + 1, arrayList);
                }
                arrayList.remove(annotationEntity);
            }
        }
    }

    private void finishLoss(double d, ArrayList<AnnotationEntity> arrayList) {
        if (arrayList.size() > 0) {
            this.m_objAnnotation.setLoss(arrayList);
            this.startCalcResidue(d);
            this.m_objAnnotation.setLoss(new ArrayList<AnnotationEntity>());
        }
    }

    private void startCalcResidue(double d) {
        if (this.m_iMinResidueCount > 0) {
            if (this.m_bNegativeResidueMass) {
                this.finishResultWithNegativ(d, 0, -1.0);
            } else {
                this.finishResult(d, 0);
            }
        }
        this.calcResidue(d, 0, 0);
    }

    private void calcResidue(double d, int n, int n2) {
        if (n < this.m_aResidues.size()) {
            int n3 = n2;
            double d2 = d;
            ResidueSpecial residueSpecial = this.m_aResidues.get(n);
            int n4 = residueSpecial.getMax();
            int n5 = residueSpecial.m_iCurrent;
            this.calcResidue(d2, n + 1, n3);
            for (int i = residueSpecial.m_iCurrent + 1; i <= n4; ++i) {
                ++residueSpecial.m_iCurrent;
                n3 = this.m_bNegativeResidueMass ? this.finishResultWithNegativ(d2, n3, residueSpecial.getMass()) : this.finishResult(d2 += residueSpecial.getMass(), n3);
                if (n3 == -1) {
                    i = n4 + 1;
                    continue;
                }
                this.calcResidue(d2, n + 1, n3);
            }
            residueSpecial.m_iCurrent = n5;
        }
    }

    private int finishResult(double d, int n) {
        double d2 = d / this.m_dChargeCount;
        int n2 = n;
        int n3 = this.m_aPeakListCalculation.size();
        for (int i = n2; i < n3; ++i) {
            PeakAnnotation peakAnnotation;
            CalculationPeak calculationPeak = this.m_aPeakListCalculation.get(i);
            double d3 = calculationPeak.minMz();
            if (d3 > d2) {
                i = n3;
                continue;
            }
            double d4 = calculationPeak.maxMz();
            if (d4 < d2) {
                n2 = i + 1;
                continue;
            }
            if (calculationPeak.getCharge() != null) {
                if (calculationPeak.getCharge() != (int)this.m_dChargeCount) continue;
                if (this.m_iMaxAnnotationCount > 0) {
                    if (this.m_iMaxAnnotationCount > calculationPeak.getAnnotationCount()) {
                        peakAnnotation = this.createAnnotation(d2, calculationPeak.getMz());
                        calculationPeak.addAnnotation(peakAnnotation);
                        calculationPeak.incrementAnnotationCount();
                        continue;
                    }
                    if (this.m_bLowestDeviation) {
                        peakAnnotation = this.createAnnotation(d2, calculationPeak.getMz());
                        this.replaceAnnotation(calculationPeak, peakAnnotation);
                    }
                    calculationPeak.incrementAnnotationCount();
                    continue;
                }
                peakAnnotation = this.createAnnotation(d2, calculationPeak.getMz());
                calculationPeak.addAnnotation(peakAnnotation);
                calculationPeak.incrementAnnotationCount();
                continue;
            }
            if (this.m_iMaxAnnotationCount > 0) {
                if (this.m_iMaxAnnotationCount > calculationPeak.getAnnotationCount()) {
                    peakAnnotation = this.createAnnotation(d2, calculationPeak.getMz());
                    calculationPeak.addAnnotation(peakAnnotation);
                    calculationPeak.incrementAnnotationCount();
                    continue;
                }
                if (this.m_bLowestDeviation) {
                    peakAnnotation = this.createAnnotation(d2, calculationPeak.getMz());
                    this.replaceAnnotation(calculationPeak, peakAnnotation);
                }
                calculationPeak.incrementAnnotationCount();
                continue;
            }
            peakAnnotation = this.createAnnotation(d2, calculationPeak.getMz());
            calculationPeak.addAnnotation(peakAnnotation);
            calculationPeak.incrementAnnotationCount();
        }
        if (n2 >= n3) {
            return -1;
        }
        return n2;
    }

    private int finishResultWithNegativ(double d, int n, double d2) {
        double d3 = d / this.m_dChargeCount;
        double d4 = 0.0;
        for (CalculationPeak calculationPeak : this.m_aPeakListCalculation) {
            PeakAnnotation peakAnnotation;
            double d5 = calculationPeak.minMz();
            if (!(d5 <= d3) || !((d4 = calculationPeak.maxMz()) >= d3)) continue;
            if (calculationPeak.getCharge() != null) {
                if (calculationPeak.getCharge() != (int)this.m_dChargeCount) continue;
                if (this.m_iMaxAnnotationCount > 0) {
                    if (this.m_iMaxAnnotationCount > calculationPeak.getAnnotationCount()) {
                        peakAnnotation = this.createAnnotation(d3, calculationPeak.getMz());
                        calculationPeak.addAnnotation(peakAnnotation);
                        calculationPeak.incrementAnnotationCount();
                        continue;
                    }
                    if (this.m_bLowestDeviation) {
                        peakAnnotation = this.createAnnotation(d3, calculationPeak.getMz());
                        this.replaceAnnotation(calculationPeak, peakAnnotation);
                    }
                    calculationPeak.incrementAnnotationCount();
                    continue;
                }
                peakAnnotation = this.createAnnotation(d3, calculationPeak.getMz());
                calculationPeak.addAnnotation(peakAnnotation);
                calculationPeak.incrementAnnotationCount();
                continue;
            }
            if (this.m_iMaxAnnotationCount > 0) {
                if (this.m_iMaxAnnotationCount > calculationPeak.getAnnotationCount()) {
                    peakAnnotation = this.createAnnotation(d3, calculationPeak.getMz());
                    calculationPeak.addAnnotation(peakAnnotation);
                    calculationPeak.incrementAnnotationCount();
                    continue;
                }
                if (this.m_bLowestDeviation) {
                    peakAnnotation = this.createAnnotation(d3, calculationPeak.getMz());
                    this.replaceAnnotation(calculationPeak, peakAnnotation);
                }
                calculationPeak.incrementAnnotationCount();
                continue;
            }
            peakAnnotation = this.createAnnotation(d3, calculationPeak.getMz());
            calculationPeak.addAnnotation(peakAnnotation);
            calculationPeak.incrementAnnotationCount();
        }
        if (this.m_dMaxPeakMass < d3 && d2 > 0.0) {
            return -1;
        }
        return 0;
    }

    private void replaceAnnotation(CalculationPeak calculationPeak, PeakAnnotation peakAnnotation) {
        PeakAnnotation peakAnnotation2 = null;
        PeakAnnotation peakAnnotation32 = null;
        for (PeakAnnotation peakAnnotation32 : calculationPeak.getAnnotation()) {
            if (peakAnnotation2 == null) {
                peakAnnotation2 = peakAnnotation32;
                continue;
            }
            if (!(peakAnnotation2.getDivValue() < peakAnnotation32.getDivValue())) continue;
            peakAnnotation2 = peakAnnotation32;
        }
        if (peakAnnotation2 != null && peakAnnotation2.getDivValue() > peakAnnotation.getDivValue()) {
            calculationPeak.getAnnotation().remove(peakAnnotation2);
            calculationPeak.addAnnotation(peakAnnotation);
        }
    }

    private PeakAnnotation createAnnotation(double d, double d2) {
        PeakAnnotation peakAnnotation = new PeakAnnotation();
        ArrayList<AnnotationEntity> arrayList = new ArrayList<AnnotationEntity>();
        for (ResidueSpecial residueSpecial : this.m_aResidues) {
            if (residueSpecial.m_iCurrent - residueSpecial.m_iFragment == 0) continue;
            AnnotationEntity annotationEntity = new AnnotationEntity();
            annotationEntity.setId(residueSpecial.getId());
            annotationEntity.setNumber(residueSpecial.m_iCurrent - residueSpecial.m_iFragment);
            arrayList.add(annotationEntity);
        }
        peakAnnotation.setResidues(arrayList);
        arrayList = new ArrayList();
        Iterator<Object> iterator = this.m_objAnnotation.getFragments().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((AnnotationEntity)iterator.next()).copy());
        }
        peakAnnotation.setFragments(arrayList);
        arrayList = new ArrayList();
        iterator = this.m_objAnnotation.getIons().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((AnnotationEntity)iterator.next()).copy());
        }
        peakAnnotation.setIons(arrayList);
        arrayList = new ArrayList();
        iterator = this.m_objAnnotation.getIonExchange().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((AnnotationEntity)iterator.next()).copy());
        }
        peakAnnotation.setIonExchange(arrayList);
        peakAnnotation.setDerivatisation(this.m_objAnnotation.getDerivatisation());
        peakAnnotation.setMass(d);
        double d3 = (d2 - d) * 1000000.0 / d2;
        if (d3 < 0.0) {
            peakAnnotation.setDivValue(d3 * -1.0);
        } else {
            peakAnnotation.setDivValue(d3);
        }
        arrayList = new ArrayList();
        Iterator<AnnotationEntity> iterator2 = this.m_objAnnotation.getGain().iterator();
        while (iterator2.hasNext()) {
            arrayList.add(iterator2.next().copy());
        }
        peakAnnotation.setGain(arrayList);
        arrayList = new ArrayList();
        iterator2 = this.m_objAnnotation.getLoss().iterator();
        while (iterator2.hasNext()) {
            arrayList.add(iterator2.next().copy());
        }
        peakAnnotation.setLoss(arrayList);
        return peakAnnotation;
    }

    private ResidueSpecial findResidue(String string) throws ParameterException {
        for (ResidueSpecial residueSpecial : this.m_aResidues) {
            if (!residueSpecial.getId().equals(string)) continue;
            return residueSpecial;
        }
        throw new ParameterException("Residue " + string + " for A/X fragment is missing.");
    }
}

