/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.dialog.labelprovider;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.entry.sample.config.ImageRegistry;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.property.SampleProperty;

public class ChooseComponentTreeLabelProvider
implements ILabelProvider {
    private Image sampleImage = null;
    private Image componentImage = null;

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.sampleImage != null) {
            this.sampleImage.dispose();
        }
        if (this.componentImage != null) {
            this.componentImage.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        if (element instanceof Entry) {
            Entry entry = (Entry)element;
            if (entry.getProperty() instanceof SampleProperty) {
                this.sampleImage = this.sampleImage == null ? ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.SAMPLE_ICON_SMALL).createImage() : this.sampleImage;
                return this.sampleImage;
            }
            return entry.getProperty().getImage().createImage();
        }
        if (element instanceof Component) {
            this.componentImage = this.componentImage == null ? ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.COMPONENT_ICON).createImage() : this.componentImage;
            return this.componentImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof Entry) {
            return ((Entry)element).getDisplayName();
        }
        if (element instanceof Component) {
            return ((Component)element).getLabel();
        }
        return null;
    }
}

