/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.spectrafiltering.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MassIntensityListUtils {
    public static double[][] addMassIntensityListForProfile(double[][] dMassIntenListRef, double[][] dMassIntenListToAdd) {
        int nMass = dMassIntenListToAdd[0].length;
        double dMaxInterval = -1.0;
        double dMinInterval = Double.MAX_VALUE;
        for (int j = 1; j < nMass; ++j) {
            if (dMassIntenListToAdd[1][j] == 0.0 && dMassIntenListToAdd[1][j - 1] == 0.0) continue;
            double dInterval = dMassIntenListToAdd[0][j] - dMassIntenListToAdd[0][j - 1];
            dMaxInterval = Math.max(dMaxInterval, dInterval);
            dMinInterval = Math.min(dMinInterval, dInterval);
        }
        ArrayList<double[]> lMassIntenNew = new ArrayList<double[]>();
        HashSet<Integer> lUsedIndexes = new HashSet<Integer>();
        int nRef = dMassIntenListRef[0].length;
        int j = 0;
        for (int i = 0; i < nRef; ++i) {
            double dMassRef = dMassIntenListRef[0][i];
            double dIntenRef = dMassIntenListRef[1][i];
            while (j < nMass && dMassRef > dMassIntenListToAdd[0][j]) {
                ++j;
            }
            boolean bNoHigh = true;
            boolean bNoLow = true;
            double dMassHigh = -1.0;
            double dIntenHigh = 0.0;
            double dMassLow = -1.0;
            double dIntenLow = 0.0;
            if (j < nMass && Math.abs(dMassIntenListToAdd[0][j] - dMassRef) <= dMaxInterval) {
                bNoHigh = false;
                dMassHigh = dMassIntenListToAdd[0][j];
                dIntenHigh = dMassIntenListToAdd[1][j];
                if (!lUsedIndexes.contains(j)) {
                    lUsedIndexes.add(j);
                }
            }
            if (dMassRef == dMassHigh) {
                lMassIntenNew.add(new double[]{dMassRef, dIntenRef + dIntenHigh});
                continue;
            }
            if (j > 0 && Math.abs(dMassIntenListToAdd[0][j - 1] - dMassRef) <= dMaxInterval) {
                bNoLow = false;
                dMassLow = dMassIntenListToAdd[0][j - 1];
                dIntenLow = dMassIntenListToAdd[1][j - 1];
                if (!lUsedIndexes.contains(j - 1)) {
                    lUsedIndexes.add(j - 1);
                }
            }
            if (dMassRef == dMassLow) {
                lMassIntenNew.add(new double[]{dMassRef, dIntenRef + dIntenLow});
                continue;
            }
            if (bNoHigh && bNoLow) {
                lMassIntenNew.add(new double[]{dMassRef, dIntenRef});
                continue;
            }
            if (!bNoHigh && bNoLow) {
                dMassLow = dMassHigh - dMaxInterval;
            }
            if (bNoHigh && !bNoLow) {
                dMassHigh = dMassLow + dMaxInterval;
            }
            lMassIntenNew.add(new double[]{dMassRef, dIntenRef += (dIntenHigh - dIntenLow) / (dMassHigh - dMassLow) * (dMassRef - dMassLow) + dIntenLow});
        }
        for (j = 0; j < nMass; ++j) {
            if (lUsedIndexes.contains(j)) continue;
            lMassIntenNew.add(new double[]{dMassIntenListToAdd[0][j], dMassIntenListToAdd[1][j]});
        }
        MassIntensityListUtils.sortMassIntenList(lMassIntenNew);
        return MassIntensityListUtils.convertMassIntensityList(lMassIntenNew);
    }

    public static double[][] addMassIntensityListForCentroid(double[][] dMassIntenListRef, double[][] dMassIntenListToAdd, double dAcc, boolean bIsPPM) {
        int nMass_i = dMassIntenListRef[0].length;
        int nMass_j = dMassIntenListToAdd[0].length;
        HashMap mapIToJ = new HashMap();
        mapIToJ.put(0, new ArrayList());
        HashMap mapJToI = new HashMap();
        int i = 0;
        int j = 0;
        while (i < nMass_i && j < nMass_j) {
            if (dMassIntenListRef[1][i] == 0.0) {
                mapIToJ.put(++i, new ArrayList());
                continue;
            }
            double dMass_i = dMassIntenListRef[0][i];
            double dMass_j = dMassIntenListToAdd[0][j];
            if (MassIntensityListUtils.isSamePeaks(dMass_i, dMass_j, dAcc, bIsPPM)) {
                ((List)mapIToJ.get(i)).add(j);
                if (!mapJToI.containsKey(j)) {
                    mapJToI.put(j, new ArrayList());
                }
                ((List)mapJToI.get(j)).add(i);
                ++j;
                continue;
            }
            if (dMass_i < dMass_j) {
                mapIToJ.put(++i, new ArrayList());
                if (((List)mapIToJ.get(i)).isEmpty()) continue;
                j = (Integer)((List)mapIToJ.get(i)).get(0);
                continue;
            }
            if (!(dMass_i > dMass_j)) continue;
            ++j;
        }
        HashMap<String, Double> mapIndexToWeight = new HashMap<String, Double>();
        Iterator iterator = mapJToI.keySet().iterator();
        while (iterator.hasNext()) {
            int I;
            int J = (Integer)iterator.next();
            List lIs = (List)mapJToI.get(J);
            if (lIs.size() == 1) continue;
            HashMap<Integer, Double> mapIToWeight = new HashMap<Integer, Double>();
            double dTotWeights = 0.0;
            double dMass_j = dMassIntenListToAdd[0][J];
            Iterator iterator2 = lIs.iterator();
            while (iterator2.hasNext()) {
                I = (Integer)iterator2.next();
                double dMass_i = dMassIntenListRef[0][I];
                double dDist = Math.abs(dMass_i - dMass_j);
                double dWeight = Math.exp(-dDist);
                mapIToWeight.put(I, dWeight);
                dTotWeights += dWeight;
            }
            iterator2 = lIs.iterator();
            while (iterator2.hasNext()) {
                I = (Integer)iterator2.next();
                mapIndexToWeight.put(I + "-" + J, (Double)mapIToWeight.get(I) / dTotWeights);
            }
        }
        ArrayList<double[]> lMassIntenNew = new ArrayList<double[]>();
        for (i = 0; i < nMass_i; ++i) {
            double dMass_i = dMassIntenListRef[0][i];
            double dInten_i = dMassIntenListRef[1][i];
            List lJs = (List)mapIToJ.get(i);
            if (lJs == null || lJs.isEmpty()) {
                lMassIntenNew.add(new double[]{dMass_i, dInten_i});
                continue;
            }
            Iterator iterator3 = lJs.iterator();
            while (iterator3.hasNext()) {
                int J = (Integer)iterator3.next();
                double dMass_j = dMassIntenListToAdd[0][J];
                double dInten_j = dMassIntenListToAdd[1][J];
                if (mapIndexToWeight.containsKey(i + "-" + J)) {
                    dInten_j *= ((Double)mapIndexToWeight.get(i + "-" + J)).doubleValue();
                }
                double dIntenTot = dInten_i + dInten_j;
                dMass_i = dMass_i * dInten_i / dIntenTot + dMass_j * dInten_j / dIntenTot;
                dInten_i = dIntenTot;
            }
            lMassIntenNew.add(new double[]{dMass_i, dInten_i});
        }
        for (j = 0; j < nMass_j; ++j) {
            if (mapJToI.containsKey(j)) continue;
            lMassIntenNew.add(new double[]{dMassIntenListToAdd[0][j], dMassIntenListToAdd[1][j]});
        }
        MassIntensityListUtils.sortMassIntenList(lMassIntenNew);
        return MassIntensityListUtils.convertMassIntensityList(lMassIntenNew);
    }

    private static void sortMassIntenList(List<double[]> lMassIntenList) {
        Collections.sort(lMassIntenList, new Comparator<double[]>(){

            @Override
            public int compare(double[] o1, double[] o2) {
                if (o1[0] < o2[0]) {
                    return -1;
                }
                if (o1[0] > o2[0]) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private static double[][] convertMassIntensityList(List<double[]> lMassIntenList) {
        int nNewMass = lMassIntenList.size();
        double[][] dNewMassIntensityList = new double[2][nNewMass];
        for (int i = 0; i < nNewMass; ++i) {
            double[] dMassInten = lMassIntenList.get(i);
            dNewMassIntensityList[0][i] = dMassInten[0];
            dNewMassIntensityList[1][i] = dMassInten[1];
        }
        return dNewMassIntensityList;
    }

    public static boolean isSamePeaks(double dMz1, double dMz2, double accValue, boolean bIsPPM) {
        if (bIsPPM) {
            accValue = (dMz1 + dMz2) / 2.0 / 1000000.0 * accValue;
        }
        return Math.abs(dMz1 - dMz2) <= accValue;
    }

    public static double[][] sortMassIntensityListWithMz(final double[][] dMassIntenList) {
        int n = dMassIntenList[0].length;
        ArrayList<Integer> lIndexes = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            lIndexes.add(i);
        }
        Collections.sort(lIndexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (dMassIntenList[0][o1] < dMassIntenList[0][o2]) {
                    return -1;
                }
                if (dMassIntenList[0][o1] > dMassIntenList[0][o2]) {
                    return 1;
                }
                return 0;
            }
        });
        double[][] dMassIntenNew = new double[2][n];
        for (int i = 0; i < n; ++i) {
            dMassIntenNew[0][i] = dMassIntenList[0][(Integer)lIndexes.get(i)];
            dMassIntenNew[1][i] = dMassIntenList[1][(Integer)lIndexes.get(i)];
        }
        return dMassIntenNew;
    }

    public static double[][] eliminateSequentialZeroIntensities(double[][] dMassIntenList) {
        ArrayList<Integer> lIds = new ArrayList<Integer>();
        int n = dMassIntenList[0].length;
        for (int i = 0; i < n; ++i) {
            if (dMassIntenList[1][i] == 0.0 && i > 0 && dMassIntenList[1][i - 1] == 0.0 && i < n - 1 && dMassIntenList[1][i + 1] == 0.0) continue;
            lIds.add(i);
        }
        double[][] dMassIntenNew = new double[2][lIds.size()];
        for (int i = 0; i < lIds.size(); ++i) {
            dMassIntenNew[0][i] = dMassIntenList[0][(Integer)lIds.get(i)];
            dMassIntenNew[1][i] = dMassIntenList[1][(Integer)lIds.get(i)];
        }
        return dMassIntenNew;
    }

    public static double[][] normalizeIntensities(double[][] dMassIntenList, float fToDevide) {
        int n = dMassIntenList[0].length;
        double[][] dMassIntenNew = new double[2][n];
        for (int i = 0; i < n; ++i) {
            dMassIntenNew[0][i] = dMassIntenList[0][i];
            dMassIntenNew[1][i] = dMassIntenList[1][i];
            if (dMassIntenNew[1][i] == 0.0) continue;
            double[] dArray = dMassIntenNew[1];
            int n2 = i;
            dArray[n2] = dArray[n2] / (double)fToDevide;
        }
        return dMassIntenNew;
    }

    public static double[][] extractHighestPeaks(double[][] dMassIntenList, int nPeaks) {
        int nMass = dMassIntenList[0].length;
        ArrayList<Integer> lHighestIndexes = new ArrayList<Integer>();
        for (int i = 0; i < nMass; ++i) {
            if (lHighestIndexes.size() < nPeaks) {
                lHighestIndexes.add(i);
                continue;
            }
            Integer iLowest = (Integer)lHighestIndexes.get(0);
            for (Integer j : lHighestIndexes) {
                if (j == iLowest || !(dMassIntenList[1][iLowest] > dMassIntenList[1][j])) continue;
                iLowest = j;
            }
            if (dMassIntenList[1][iLowest] >= dMassIntenList[1][i]) continue;
            lHighestIndexes.remove(iLowest);
            lHighestIndexes.add(i);
        }
        double[][] dHighestPeaks = new double[2][nPeaks];
        for (int i = 0; i < lHighestIndexes.size(); ++i) {
            int iOld = (Integer)lHighestIndexes.get(i);
            dHighestPeaks[0][i] = dMassIntenList[0][iOld];
            dHighestPeaks[1][i] = dMassIntenList[1][iOld];
        }
        return dHighestPeaks;
    }

    public static double[][] extractPeaksNearToTheHighestPeak(double[][] dMassIntenList, double interval) {
        int i;
        int nMass = dMassIntenList[0].length;
        int iHighest = 0;
        for (int i2 = 0; i2 < nMass; ++i2) {
            if (!(dMassIntenList[1][iHighest] < dMassIntenList[1][i2])) continue;
            iHighest = i2;
        }
        double dHighestMz = dMassIntenList[0][iHighest];
        int iMax = iHighest;
        int iMin = iHighest;
        if (iHighest > 1) {
            i = iHighest - 1;
            while (i >= 0 && dMassIntenList[1][i] != 0.0 && !(Math.abs(dHighestMz - dMassIntenList[0][i]) > interval)) {
                iMin = i--;
            }
        }
        if (iHighest < nMass - 1) {
            i = iHighest + 1;
            while (i < nMass && dMassIntenList[1][i] != 0.0 && !(Math.abs(dHighestMz - dMassIntenList[0][i]) > interval)) {
                iMax = i++;
            }
        }
        nMass = iMax - iMin + 1;
        double[][] dHighestPeaks = new double[2][nMass];
        for (int i3 = 0; i3 < nMass; ++i3) {
            int iOld = i3 + iMin;
            dHighestPeaks[0][i3] = dMassIntenList[0][iOld];
            dHighestPeaks[1][i3] = dMassIntenList[1][iOld];
        }
        return dHighestPeaks;
    }

    public static double getMinimumInterval(double[] lMzValues) {
        double dMinInterval = Double.MAX_VALUE;
        double dCurrent = lMzValues[0];
        for (int i = 1; i < lMzValues.length; ++i) {
            double dNext = lMzValues[i];
            double dInterval = dNext - dCurrent;
            if (dInterval < 0.0) {
                System.err.println("The masses are not sorted.");
                return -1.0;
            }
            dMinInterval = Math.min(dMinInterval, dInterval);
            dCurrent = dNext;
        }
        return dMinInterval;
    }
}

