/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRTable;
import org.grits.toolbox.entry.qrtpcr.model.xml.IntegerQrtPCRTableMapAdapter;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRPreferencePage;

@XmlRootElement(name="qrtPCR")
public class QrtPCRRun {
    public static final String CURRENT_VERSION = "1.0";
    String geneListFile;
    Integer runId = -1;
    Map<Integer, QrtPCRTable> runIdTableMap;
    Double threshold = QrtPCRPreferencePage.THRESHOLD_PREFERENCE;
    Double stDevCutOff = QrtPCRPreferencePage.STDEVCUTOFF_PREFERENCE;

    @XmlAttribute
    public Double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    @XmlAttribute
    public Double getStDevCutOff() {
        return this.stDevCutOff;
    }

    public void setStDevCutOff(Double stDevCutOff) {
        this.stDevCutOff = stDevCutOff;
    }

    @XmlJavaTypeAdapter(value=IntegerQrtPCRTableMapAdapter.class)
    public Map<Integer, QrtPCRTable> getRunIdTableMap() {
        return this.runIdTableMap;
    }

    public void setRunIdTableMap(Map<Integer, QrtPCRTable> runIdTableMap) {
        this.runIdTableMap = runIdTableMap;
    }

    @XmlAttribute
    public String getGeneListFile() {
        return this.geneListFile;
    }

    public void setGeneListFile(String geneListFile) {
        this.geneListFile = geneListFile;
    }

    @XmlAttribute
    public Integer getRunId() {
        return this.runId;
    }

    public void setRunId(Integer r) {
        this.runId = r;
    }

    public void addRun(QrtPCRTable table) {
        if (this.runIdTableMap == null) {
            this.runIdTableMap = new HashMap<Integer, QrtPCRTable>();
        }
        this.runId = this.runId + 1;
        this.runIdTableMap.put(this.runId, table);
    }

    public QrtPCRTable getRun(int run) {
        if (this.runIdTableMap != null) {
            return this.runIdTableMap.get(run);
        }
        return null;
    }

    public QrtPCRTable getFirstRun() {
        if (this.runIdTableMap != null) {
            return this.runIdTableMap.get(0);
        }
        return null;
    }

    public QrtPCRTable getLastRun() {
        if (this.runIdTableMap != null) {
            return this.runIdTableMap.get(this.runId);
        }
        return null;
    }

    public static List<Gene> generateMasterTable(QrtPCRTable qrtPCRTable) {
        ArrayList<Gene> geneList = new ArrayList<Gene>();
        for (String plateId : qrtPCRTable.getPlateDataMap().keySet()) {
            QrtPCRData data = qrtPCRTable.getData(plateId);
            geneList.addAll(data.getGenes());
        }
        return geneList;
    }
}

