/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.editor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.forms.widgets.Section;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.ReportsProperty;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.ImageRegistry;
import org.grits.toolbox.entry.qrtpcr.editor.IQrtPCRPart;
import org.grits.toolbox.entry.qrtpcr.editor.dialogs.GeneSelectionDialog;
import org.grits.toolbox.entry.qrtpcr.model.ChartData;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;
import org.grits.toolbox.entry.qrtpcr.model.merge.MergeData;
import org.grits.toolbox.entry.qrtpcr.model.merge.MergedQrtPCR;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRPreference;
import org.grits.toolbox.entry.qrtpcr.property.QrtPCRMergeProperty;
import org.grits.toolbox.entry.qrtpcr.table.QrtPCRNatTable;
import org.grits.toolbox.entry.qrtpcr.table.merge.MergeNatTable;
import org.grits.toolbox.entry.qrtpcr.table.merge.MergeReportTableBase;
import org.grits.toolbox.entry.qrtpcr.view.HistogramView;

public class MergeReportEditor
implements IQrtPCRPart {
    private static final Logger logger = Logger.getLogger(MergeReportEditor.class);
    @Inject
    private EPartService partService;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;
    private String fileLocation;
    MergedQrtPCR mergeData;
    private GeneList pathway;
    MergeNatTable table;
    String partName;

    public String getPartName() {
        return this.partName;
    }

    @Inject
    public MergeReportEditor(@Named(value="org.eclipse.ui.selection") Entry entry, @Named(value="e4ActivePart") MPart part, @Named(value="workspace_location") String workspaceLocation) {
        try {
            Entry projectEntry = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project");
            String qrtPCRFolderLocation = String.valueOf(workspaceLocation) + projectEntry.getDisplayName() + File.separator + ReportsProperty.getFolder() + File.separator + "qrtPCR";
            QrtPCRMergeProperty qPCRProperty = (QrtPCRMergeProperty)entry.getProperty();
            String fileName = qPCRProperty.getFilename();
            this.fileLocation = String.valueOf(qrtPCRFolderLocation) + File.separator + fileName;
            File mergeFile = new File(this.fileLocation);
            FileInputStream inputStream = new FileInputStream(mergeFile.getAbsolutePath());
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MergedQrtPCR.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            this.mergeData = (MergedQrtPCR)unmarshaller.unmarshal((Reader)reader);
            reader.close();
            inputStream.close();
            part.setLabel(entry.getDisplayName());
            this.partName = part.getLabel();
        }
        catch (IOException e) {
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot load the merge QrtPCR Table", (Exception)e);
            logger.error((Object)"org.grits.toolbox.entry.qrtpcr Cannot create the merge QrtPCR Table", (Throwable)e);
        }
        catch (JAXBException e) {
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot load the merge QrtPCR Table", (Exception)((Object)e));
            logger.warn((Object)"org.grits.toolbox.entry.qrtpcr Cannot load the merge QrtPCR Table", (Throwable)e);
        }
    }

    @PostConstruct
    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite composite = new Composite(parent, 0);
        this.initializeComponents(composite);
    }

    @Persist
    protected void updateProjectProperty() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MergedQrtPCR.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)this.mergeData, (OutputStream)os);
            FileWriter fileWriter = new FileWriter(this.fileLocation);
            fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
            fileWriter.close();
            os.close();
        }
        catch (IOException e) {
            logger.error((Object)"The changes made could not be written to the file.", (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Writing File", (String)"The changes made could not be written to the file.");
        }
        catch (JAXBException e) {
            logger.error((Object)"The changes made could not be serialized as xml.", (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Parsing File", (String)"The changes made could not be serialized to xml.");
        }
    }

    protected void initializeComponents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite sectionParentComposite = new Composite(parent, 4);
        sectionParentComposite.setLayout((Layout)new FillLayout());
        Section section = new Section(sectionParentComposite, 320);
        section.setText("Data");
        Composite client = new Composite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        ToolBarManager toolBarManager = new ToolBarManager();
        Action chartAction = new Action("Histogram"){

            public void run() {
                ChartData[][] dataList = new ChartData[MergeReportEditor.this.mergeData.getQrtPCRGeneListMap().size()][MergeReportEditor.this.mergeData.getAliasList().size()];
                String secondaryId = MergeReportEditor.this.getPartName();
                MPart part = MergeReportEditor.this.partService.createPart("qrtPCR-histogram");
                part.setLabel(secondaryId);
                List stacks = MergeReportEditor.this.modelService.findElements((MUIElement)MergeReportEditor.this.application, "org.grits.toolbox.core.partstack.histogramview", MPartStack.class, null);
                if (stacks.size() < 1) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error ", (String)"Part stack not found. Is the following ID correct?org.grits.toolbox.core.partstack.histogramview");
                    return;
                }
                ((MPartStack)stacks.get(0)).getChildren().add(part);
                ((MPartStack)stacks.get(0)).setVisible(true);
                MergeReportEditor.this.partService.showPart(part, EPartService.PartState.ACTIVATE);
                HistogramView view = (HistogramView)part.getObject();
                int i = 0;
                if (MergeReportEditor.this.pathway != null) {
                    i = MergeReportEditor.this.getGenesInPathwayOrder(dataList, null);
                } else {
                    for (Gene gene : MergeReportEditor.this.mergeData.getQrtPCRGeneListMap().keySet()) {
                        if (!MergeReportEditor.this.isSelected(gene)) continue;
                        List<MergeData> mergeDataList = MergeReportEditor.this.mergeData.getQrtPCRGeneListMap().get(gene);
                        int j = 0;
                        if (mergeDataList.size() != MergeReportEditor.this.mergeData.getAliasList().size()) continue;
                        for (MergeData mergeData2 : mergeDataList) {
                            ChartData data = new ChartData();
                            data.setGeneIdentifier(gene.getGeneIdentifier());
                            data.setGeneSymbol(gene.getGeneSymbol());
                            data.setValue(mergeData2.getAverage());
                            data.setError(mergeData2.getStDev());
                            dataList[i][j] = data;
                            ++j;
                        }
                        ++i;
                    }
                }
                view.setPartName(MergeReportEditor.this.getPartName());
                if (i == 0) {
                    ErrorUtils.createWarningMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"No Data", (String)"You haven't selected any data for the histogram!");
                } else {
                    ChartData[][] newDataList = (ChartData[][])Arrays.copyOf(dataList, i);
                    view.initializeChart(MergeReportEditor.this.mergeData.getAliasList().values().toArray(new String[MergeReportEditor.this.mergeData.getAliasList().size()]), newDataList, "Average", true);
                }
            }

            public String getToolTipText() {
                return "Show average values in a histogram";
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.HISTOGRAM_ICON);
            }
        };
        Action foldChangeChartAction = new Action("Fold Change"){

            public void run() {
                Object[] result;
                ListDialog dialog = new ListDialog(Display.getCurrent().getActiveShell());
                dialog.setAddCancelButton(true);
                dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                dialog.setLabelProvider((ILabelProvider)new LabelProvider());
                dialog.setInput(MergeReportEditor.this.mergeData.getAliasList().values());
                dialog.setTitle("Select the control experiment for Fold Change chart");
                if (dialog.open() == 0) {
                    result = dialog.getResult();
                    if (result == null || result.length == 0) {
                        return;
                    }
                } else {
                    return;
                }
                String controlAlias = (String)result[0];
                MergeReportEditor.this.mergeData.setControlAlias(controlAlias);
                int controlIndex = 0;
                controlAlias = MergeReportEditor.this.mergeData.getControlAlias();
                if (controlAlias != null) {
                    int k = 0;
                    for (String alias : MergeReportEditor.this.mergeData.getAliasList().values()) {
                        if (alias.equals(controlAlias)) {
                            controlIndex = k;
                            break;
                        }
                        ++k;
                    }
                } else {
                    controlAlias = MergeReportEditor.this.mergeData.getAliasList().values().iterator().next();
                }
                ChartData[][] dataList = new ChartData[MergeReportEditor.this.mergeData.getQrtPCRGeneListMap().size()][MergeReportEditor.this.mergeData.getAliasList().size() - 1];
                String secondaryId = MergeReportEditor.this.getPartName();
                MPart part = MergeReportEditor.this.partService.createPart("qrtPCR-histogram");
                part.setLabel(String.valueOf(secondaryId) + "Fold Change");
                List stacks = MergeReportEditor.this.modelService.findElements((MUIElement)MergeReportEditor.this.application, "org.grits.toolbox.core.partstack.histogramview", MPartStack.class, null);
                if (stacks.size() < 1) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error ", (String)"Part stack not found. Is the following ID correct?org.grits.toolbox.core.partstack.histogramview");
                    return;
                }
                ((MPartStack)stacks.get(0)).getChildren().add(part);
                ((MPartStack)stacks.get(0)).setVisible(true);
                MergeReportEditor.this.partService.showPart(part, EPartService.PartState.ACTIVATE);
                HistogramView view = (HistogramView)part.getObject();
                int i = 0;
                if (MergeReportEditor.this.pathway != null) {
                    i = MergeReportEditor.this.getGenesInPathwayOrder(dataList, controlIndex);
                } else {
                    for (Gene gene : MergeReportEditor.this.mergeData.getQrtPCRGeneListMap().keySet()) {
                        if (!MergeReportEditor.this.isSelected(gene)) continue;
                        List<MergeData> mergeDataList = MergeReportEditor.this.mergeData.getQrtPCRGeneListMap().get(gene);
                        int j = 0;
                        int dataIndex = 0;
                        if (mergeDataList.size() != MergeReportEditor.this.mergeData.getAliasList().size()) continue;
                        for (MergeData mergeData : mergeDataList) {
                            if (j != controlIndex) {
                                ChartData data = new ChartData();
                                data.setGeneIdentifier(gene.getGeneIdentifier());
                                data.setGeneSymbol(gene.getGeneSymbol());
                                data.setValue(MergeReportEditor.this.calculateFoldChange(mergeData, mergeDataList.get(controlIndex)));
                                data.setError(MergeReportEditor.this.calculateFoldChangeError(mergeData, mergeDataList.get(controlIndex)));
                                dataList[i][dataIndex] = data;
                                ++dataIndex;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                view.setPartName(String.valueOf(MergeReportEditor.this.getPartName()) + "-Fold Change");
                if (i == 0) {
                    ErrorUtils.createWarningMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"No Data", (String)"You haven't selected any data for the histogram!");
                } else {
                    ChartData[][] newDataList = (ChartData[][])Arrays.copyOf(dataList, i);
                    HashMap<String, String> newAliasList = new HashMap<String, String>();
                    for (Map.Entry<String, String> aliasEntry : MergeReportEditor.this.mergeData.getAliasList().entrySet()) {
                        if (aliasEntry.getValue().equals(controlAlias)) continue;
                        newAliasList.put(aliasEntry.getKey(), aliasEntry.getValue());
                    }
                    view.initializeChart(newAliasList.values().toArray(new String[newAliasList.size()]), newDataList, "Fold Change", false);
                }
            }

            public String getToolTipText() {
                return "Show average values as a fold change graph";
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.FOLDCHANGE_ICON);
            }
        };
        Action selectAllAction = new Action("Select All"){

            public void run() {
                if (MergeReportEditor.this.table != null) {
                    GeneSelectionDialog dialog = new GeneSelectionDialog(Display.getCurrent().getActiveShell(), MergeReportEditor.this);
                    dialog.open();
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.SELECT_ICON);
            }

            public String getToolTipText() {
                return "Select genes for the graph";
            }
        };
        toolBarManager.add((IAction)selectAllAction);
        toolBarManager.add((IAction)chartAction);
        toolBarManager.add((IAction)foldChangeChartAction);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        section.setTextClient((Control)toolbar);
        MergeReportTableBase myTable = new MergeReportTableBase(this);
        myTable.setMergeData(this.mergeData);
        this.table = (MergeNatTable)myTable.createControl(client);
        this.table.setLayoutData(new GridData(4, 4, true, true, 1, 20));
        section.setClient((Control)client);
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.verticalSpan = 1;
        compositeLayoutData.horizontalSpan = 1;
        sectionParentComposite.setLayoutData((Object)compositeLayoutData);
    }

    private int getGenesInPathwayOrder(ChartData[][] dataList, Integer controlIndex) {
        int i = 0;
        for (Gene gene : this.pathway.getGenes()) {
            boolean found = false;
            for (Gene gene2 : this.mergeData.getQrtPCRGeneListMap().keySet()) {
                if (!gene.getGeneIdentifier().equals(gene2.getGeneIdentifier())) continue;
                List<MergeData> mergeDataList = this.mergeData.getQrtPCRGeneListMap().get(gene2);
                int j = 0;
                int dataIndex = 0;
                if (mergeDataList.size() != this.mergeData.getAliasList().size()) continue;
                for (MergeData mergeData2 : mergeDataList) {
                    ChartData data;
                    if (controlIndex == null) {
                        data = new ChartData();
                        data.setGeneIdentifier(gene.getGeneIdentifier());
                        data.setGeneSymbol(gene.getGeneSymbol());
                        data.setValue(mergeData2.getAverage());
                        data.setError(mergeData2.getStDev());
                        dataList[i][j] = data;
                        ++j;
                        continue;
                    }
                    if (j != controlIndex) {
                        data = new ChartData();
                        data.setGeneIdentifier(gene.getGeneIdentifier());
                        data.setGeneSymbol(gene.getGeneSymbol());
                        data.setValue(mergeData2.getAverage());
                        data.setError(mergeData2.getStDev());
                        dataList[i][dataIndex] = data;
                        ++dataIndex;
                    }
                    ++j;
                }
                found = true;
                break;
            }
            if (!found) continue;
            ++i;
        }
        return i;
    }

    protected Double calculateFoldChangeError(MergeData mergeData, MergeData mergeDataControl) {
        Double foldChange = mergeData.getStDev() / mergeDataControl.getStDev();
        if (foldChange < 1.0) {
            foldChange = -1.0 * (mergeDataControl.getStDev() / mergeData.getStDev());
        }
        return foldChange;
    }

    protected Double calculateFoldChange(MergeData mergeData, MergeData mergeDataControl) {
        Double foldChange = mergeData.getAverage() / mergeDataControl.getAverage();
        if (foldChange < 1.0) {
            foldChange = -1.0 * (mergeDataControl.getAverage() / mergeData.getAverage());
        }
        return foldChange;
    }

    public void selectAll() {
        if (this.table != null) {
            this.table.selectAll();
        }
    }

    boolean isSelected(Gene gene) {
        boolean selected = false;
        if (this.table != null) {
            selected = this.table.isSelected(gene);
        }
        return selected;
    }

    @Focus
    public void setFocus() {
        if (this.table != null) {
            this.table.setFocus();
        }
    }

    public void clearSelection() {
        if (this.table != null) {
            this.table.deSelectAll();
        }
    }

    public void setGeneList(GeneList inputList) {
        this.pathway = inputList;
    }

    public void selectGene(Gene gene) {
        if (this.table != null) {
            this.table.selectGene(gene);
        }
    }

    public void updateColumnPreferences(QrtPCRPreference updatePref) {
        this.updateColumnPreferences(this.table, (QrtPCRPreference)this.table.getTablePreference(), updatePref);
    }

    protected void updateColumnPreferences(QrtPCRNatTable table, QrtPCRPreference curPref, QrtPCRPreference updatePref) {
        if (((Object)((Object)curPref)).getClass().equals(((Object)((Object)updatePref)).getClass()) && !updatePref.getColumnSettings().equals(curPref.getColumnSettings())) {
            table.setTablePreference(updatePref);
            table.updateViewFromPreferenceSettings();
        }
    }
}

